/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.performance;

import com.sysuptime.common.performance.Metrics;
import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.performance.PerformanceGraph;
import com.sysuptime.common.performance.PerformanceGraph$ResultType;
import com.sysuptime.common.performance.TargetFactory;
import com.sysuptime.server.performance.DependencyReader;
import com.sysuptime.server.performance.DependencyWriter;
import com.sysuptime.server.performance.ExecutorHelper;
import com.sysuptime.server.performance.MonitorCache;
import com.sysuptime.server.performance.MonitorReader;
import com.sysuptime.server.performance.MonitorWriter;
import com.sysuptime.server.performance.ha.PMDBSingletonScheduleProviderMBean;
import com.sysuptime.server.util.DefaultConnection;
import com.sysuptime.server.util.MBeanManager;
import com.sysuptime.server.util.MBeanUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.log4j.Logger;

public class MonitorProcessor {
    private static Logger _logger = Logger.getLogger((String)MonitorProcessor.class.getName());

    private MonitorProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setSuspended(int n2, boolean bl2, long l2) throws SQLException {
        boolean bl3 = false;
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            MonitorWriter.setSuspended(connection, n2, bl2, l2);
            bl3 = true;
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setExpiring(int n2, boolean bl2) throws SQLException {
        boolean bl3 = false;
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            MonitorWriter.setExpiring(connection, n2, bl2);
            bl3 = true;
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
        return bl3;
    }

    public static List getScheduleNameList() throws SQLException {
        List list = null;
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            list = MonitorReader.getScheduleNameList(connection);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getScheduleNameList(long l2) throws SQLException {
        List list = null;
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            list = MonitorReader.getScheduleNameList(connection, l2);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
        return list;
    }

    public static List getScheduleIdList() throws SQLException {
        List list = null;
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            list = MonitorReader.getScheduleIdList(connection);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
        return list;
    }

    public static List getScheduleDataList() throws SQLException {
        return MonitorProcessor.getScheduleDataList(-1L, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Monitor> getScheduleDataList(long l2, int n2) throws SQLException {
        List<Monitor> list = null;
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            list = MonitorReader.getScheduleDataList(connection, l2, n2);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
        return list;
    }

    public static int getScheduleId(String string) throws SQLException {
        Connection connection = null;
        int n2 = -1;
        try {
            connection = DefaultConnection.getConnection();
            n2 = MonitorReader.getScheduleId(connection, string);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
        return n2;
    }

    public static String getScheduleName(int n2) {
        Monitor monitor = MonitorCache.getMonitor(n2);
        if (monitor == null) {
            return null;
        }
        return monitor.getScheduleName();
    }

    public static Monitor getScheduleDataById(int n2) {
        return MonitorCache.getMonitor(n2);
    }

    public static void deleteAllSchedule() throws SQLException {
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            MonitorWriter.deleteAllSchedule(connection);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void deleteSchedules(List list) throws SQLException {
        Connection connection = null;
        int n2 = ExecutorHelper.c();
        try {
            connection = DefaultConnection.getConnection();
            int n3 = list.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                try {
                    MonitorWriter.deleteSchedule(connection, ((Number)list.get(i2)).intValue());
                    if (n2 != 0) return;
                    if (n2 == 0) continue;
                    return;
                }
                catch (SQLException sQLException) {
                    throw MonitorProcessor.a(sQLException);
                    return;
                }
            }
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
    }

    public static void deleteScheduleByProbe(long l2) throws Exception {
        Connection connection = DefaultConnection.getConnection();
        List<Long> list = MonitorReader.getMonitorIDsByProbe(connection, l2);
        String[] stringArray = new String[]{List.class.getName()};
        Object[] objectArray = new Object[]{list};
        ObjectName objectName = MBeanUtil.create("nMaster:service=PMDBSingletonScheduleProvider");
        MBeanManager.getInstance().invoke(objectName, "removeMonitors", objectArray, stringArray);
    }

    public static void deleteSchedule(int n2) throws SQLException {
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            MonitorWriter.deleteSchedule(connection, n2);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
    }

    public static void deleteSchedule(String string) throws SQLException {
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            MonitorWriter.deleteSchedule(connection, string);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
    }

    public static int getScheduleCount() throws SQLException {
        Connection connection = null;
        int n2 = -1;
        try {
            connection = DefaultConnection.getConnection();
            n2 = MonitorReader.getScheduleCount(connection);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
        return n2;
    }

    public static Map getScheduleNameToId() throws SQLException {
        Connection connection = null;
        Map map = null;
        try {
            connection = DefaultConnection.getConnection();
            map = MonitorReader.getScheduleNameToId(connection);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
        return map;
    }

    public static Map getScheduleNameToIdFromProbe(int n2) throws SQLException {
        Connection connection = null;
        Map map = null;
        try {
            connection = DefaultConnection.getConnection();
            map = MonitorReader.getScheduleNameToIdFromProbe(connection, n2);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
        return map;
    }

    public static boolean isDependencyPermitted(int n2) throws SQLException {
        Connection connection = null;
        boolean bl2 = false;
        try {
            connection = DefaultConnection.getConnection();
            bl2 = DependencyReader.isDependencyPermitted(connection, n2);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
        return bl2;
    }

    public static List getAllDependencies() throws SQLException {
        Connection connection = null;
        List list = null;
        try {
            connection = DefaultConnection.getConnection();
            list = DependencyReader.getAllDependencies(connection);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getDisableDependencies(int n2) throws SQLException {
        Connection connection = null;
        ArrayList arrayList = new ArrayList();
        try {
            connection = DefaultConnection.getConnection();
            HashSet hashSet = new HashSet();
            hashSet.addAll(DependencyReader.getInverseDependencies(connection, n2));
            hashSet.addAll(DependencyReader.getOtherDependencies(connection, n2));
            arrayList.addAll(hashSet);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
        return arrayList;
    }

    public static List getInverseDependencies(int n2) throws SQLException {
        Connection connection = null;
        List list = null;
        try {
            connection = DefaultConnection.getConnection();
            list = DependencyReader.getInverseDependencies(connection, n2);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
        return list;
    }

    public static boolean resetDependency(int n2) throws SQLException {
        boolean bl2 = false;
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            DependencyWriter.resetDependency(connection, n2);
            bl2 = true;
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
        return bl2;
    }

    public static boolean removeAllSchedules() {
        boolean bl2 = false;
        try {
            Boolean bl3 = (Boolean)MBeanManager.getInstance().invoke(PMDBSingletonScheduleProviderMBean.OBJECT_NAME, "removeAllSchedules", null, null);
            bl2 = bl3;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            _logger.error((Object)instanceNotFoundException);
        }
        catch (MBeanException mBeanException) {
            _logger.error((Object)mBeanException);
        }
        catch (ReflectionException reflectionException) {
            _logger.error((Object)reflectionException);
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
        }
        return bl2;
    }

    public static PerformanceGraph getGraphData(int n2) {
        Monitor monitor = MonitorCache.getMonitor(n2);
        int n3 = monitor.getMetricsListSize();
        int n4 = ExecutorHelper.b();
        ArrayList<PerformanceGraph$ResultType> arrayList = new ArrayList<PerformanceGraph$ResultType>(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            Metrics metrics = monitor.getMetrics(i2);
            arrayList.add(new PerformanceGraph$ResultType(metrics.getResultTypeId(), metrics.getFixedStatisticalId() != 0));
            if (n4 != 0) continue;
        }
        return TargetFactory.getPeformanceGraph(n2, monitor.getScheduleHostList(), arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getMonitorIds(long l2) throws SQLException {
        List list = null;
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            list = MonitorReader.getMonitorIds(connection, l2);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateGroup(long l2, long l3) throws SQLException {
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            MonitorWriter.updateGroup(connection, l2, l3);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
    }

    private static SQLException a(SQLException sQLException) {
        return sQLException;
    }
}

