/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.performance;

import com.openapi.performance.IExecutorParameter;
import com.openapi.performance.IQueryExecutor;
import com.openapi.performance.ResultTypeValue;
import com.sysuptime.common.performance.QueryParameter;
import com.sysuptime.common.performance.ResultValue;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.server.performance.AbstractExecutor;
import com.sysuptime.server.performance.ExecutorHelper;
import com.sysuptime.server.performance.PerformanceServerUtil;
import com.sysuptime.server.performance.QueryFactory;
import com.sysuptime.server.performance.RemoteHostProcessor;
import com.sysuptime.server.util.ServerBundle;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.InitialLdapContext;
import org.apache.log4j.Logger;

public class LdapExecutor
extends AbstractExecutor
implements IQueryExecutor {
    protected static Logger _logger = Logger.getLogger((String)LdapExecutor.class.getName());
    private static final long LDAP_SEARCH_ERROR = ServerBundle.getParsedMessage("LDAP_SEARCH_ERROR");
    private static int LDAP_RTT;
    private static int LDAP_CONTENT_MATCH;

    @Override
    public ResultValue[] startExecuting(IExecutorParameter iExecutorParameter) {
        QueryParameter queryParameter = iExecutorParameter.getQueryParameter();
        List<ResultTypeValue> list = iExecutorParameter.getResultTypeValues();
        int n2 = iExecutorParameter.getMonitorId();
        int[] nArray = PerformanceServerUtil.getResultTypes(list);
        try {
            if (PerformanceServerUtil.isOurCategory(nArray, new int[]{LDAP_RTT, LDAP_CONTENT_MATCH})) {
                return this.a(queryParameter, list, nArray, n2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LdapExecutor.a(illegalArgumentException);
        }
        throw new IllegalArgumentException("No such result types " + nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected ResultValue[] a(QueryParameter var1_1, List var2_2, int[] var3_3, int var4_4) {
        block36: {
            var6_5 = null;
            var5_6 = ExecutorHelper.c();
            try {
                var7_7 = Long.parseLong(var1_1.get(0).toString());
                var6_5 = RemoteHostProcessor.getRemoteHostByHostId(var7_7);
            }
            catch (Exception var7_8) {
                LdapExecutor._logger.error((Object)var7_8);
            }
            try {
                if (var6_5 == null) {
                    throw new IllegalArgumentException("Ldap remote host is not found, please validate the pm_remote_host table");
                }
            }
            catch (Exception v0) {
                throw LdapExecutor.a(v0);
            }
            var7_9 = new Hashtable<String, Object>();
            var7_9.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            var7_9.put("java.naming.security.authentication", "simple");
            var7_9.put("java.naming.provider.url", var6_5.getHostName());
            var7_9.put("java.naming.security.principal", var6_5.getUser());
            var7_9.put("java.naming.security.credentials", var6_5.getValue("security_credentials"));
            var8_10 = new HashMap<Integer, ResultValue>();
            var9_11 = null;
            var10_12 = new StringBuffer();
            try {
                block35: {
                    block33: {
                        block34: {
                            var11_13 = System.currentTimeMillis();
                            var9_11 = new InitialLdapContext(var7_9, null);
                            var13_17 = new SearchControls();
                            var14_18 = 0;
                            var15_19 = var1_1.get(3).toString();
                            if (!"OBJECT_SCOPE".equalsIgnoreCase(var15_19)) ** GOTO lbl39
                            var14_18 = 0;
                            try {
                                if (var5_6 == 0) break block33;
lbl39:
                                // 2 sources

                                if (!"ONELEVEL_SCOPE".equalsIgnoreCase(var15_19)) break block34;
                            }
                            catch (Exception v1) {
                                throw LdapExecutor.a(v1);
                            }
                            var14_18 = 1;
                            if (var5_6 == 0) break block33;
                        }
                        var14_18 = 2;
                    }
                    var13_17.setSearchScope(var14_18);
                    var16_20 = var1_1.get(4);
                    if (var16_20 == null) break block35;
                    try {
                        block37: {
                            if (var16_20.toString().length() == 0) break block35;
                            break block37;
                            catch (Exception v2) {
                                throw LdapExecutor.a(v2);
                            }
                        }
                        var13_17.setReturningAttributes(StringUtil.split2(var16_20.toString(), " ;"));
                    }
                    catch (Exception v3) {
                        throw LdapExecutor.a(v3);
                    }
                }
                var17_21 = var9_11.search(var1_1.get(1).toString(), var1_1.get(2).toString(), var13_17);
                block23: while (true) {
                    v4 = var17_21;
                    block24: while (v4.hasMoreElements()) {
                        var18_22 = var17_21.next();
                        var19_23 = var18_22.getAttributes();
                        try {
                            v5 /* !! */  = var19_23;
                            if (var5_6 != 0) break block36;
                            if (v5 /* !! */  == null) continue block23;
                        }
                        catch (Exception v6) {
                            throw LdapExecutor.a(v6);
                        }
                        var20_24 = var19_23.getAll();
                        block25: while (var20_24.hasMore()) {
                            var21_25 = var20_24.next();
                            var22_26 = var21_25.getID();
                            v4 = var21_25.getAll();
                            if (var5_6 != 0) continue block24;
                            var23_27 = v4;
                            while (var23_27.hasMore()) {
                                var10_12.append(var22_26).append(": ").append(var23_27.next()).append("\n");
                                if (var5_6 != 0) continue block25;
                                if (var5_6 == 0) continue;
                            }
                            if (var5_6 == 0) continue;
                        }
                        if (var5_6 == 0) continue block23;
                    }
                    break;
                }
                var8_10.put(LdapExecutor.LDAP_RTT, QueryFactory.createResultValueObject(LdapExecutor.LDAP_RTT, "N", System.currentTimeMillis() - var11_13));
                v5 /* !! */  = var8_10.put(LdapExecutor.LDAP_CONTENT_MATCH, QueryFactory.createResultValueObject(LdapExecutor.LDAP_CONTENT_MATCH, "N", var10_12.toString()));
            }
            catch (Exception var11_15) {
                LdapExecutor._logger.error((Object)"Problem searching directory: ", (Throwable)var11_15);
                this._errorbuf.append(var11_15);
                PerformanceServerUtil.putErrors(var8_10, var3_3, LdapExecutor.LDAP_SEARCH_ERROR);
            }
            finally {
                if (var9_11 != null) {
                    try {
                        var9_11.close();
                    }
                    catch (Exception var11_16) {}
                }
            }
        }
        return PerformanceServerUtil.getResultValues(var3_3, var8_10);
    }

    static {
        try {
            LDAP_RTT = ExecutorHelper.getId("LDAP_RTT");
            LDAP_CONTENT_MATCH = ExecutorHelper.getId("LDAP_CONTENT_MATCH");
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
        }
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

