/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.discovery;

import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import com.sysuptime.common.discovery.IPRange;
import com.sysuptime.common.discovery.NodeOption;
import com.sysuptime.common.discovery.SubnetOption;
import com.sysuptime.common.graph.GraphID;
import com.sysuptime.common.graph.GraphModelXMLReader;
import com.sysuptime.common.graph.LineLayoutAlgorithm;
import com.sysuptime.common.graph.NetworkGraphModel;
import com.sysuptime.common.graph.SubnetGraphModel;
import com.sysuptime.common.graph.TopologyGraphModel;
import com.sysuptime.common.model.DeviceBean;
import com.sysuptime.common.model.DeviceNode;
import com.sysuptime.common.model.ModelUtil;
import com.sysuptime.common.model.NetworkNode;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.common.model.Path;
import com.sysuptime.common.model.Subnet;
import com.sysuptime.common.model.TopologyData;
import com.sysuptime.common.util.callback.CallbackServer;
import com.sysuptime.server.discovery.DiscoveryOptions;
import com.sysuptime.server.discovery.GraphDao;
import com.sysuptime.server.discovery.NodeUpdater;
import com.sysuptime.server.discovery.SubnetUpdater$DiscoveryThread;
import com.sysuptime.server.util.SystemStatus;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SubnetUpdater
implements NodeUpdater {
    private static final Logger _logger = Logger.getLogger((String)SubnetUpdater.class.getName());
    private Map<GraphID, TopologyGraphModel> _models = new HashMap<GraphID, TopologyGraphModel>();

    @Override
    public boolean update(NodeOption nodeOption) {
        SubnetOption subnetOption = (SubnetOption)nodeOption;
        String string = subnetOption.getSubnet();
        _logger.info((Object)("subnetIP:" + string));
        IPRange iPRange = new IPRange();
        iPRange.addExpression(string);
        Iterator iterator = iPRange.iterator();
        Map<String, NetworkNodeBean> map = this.a(iterator, subnetOption);
        TopologyData topologyData = GraphDao.createData();
        _logger.info((Object)("@@@@@@@@@@@ topology data:" + topologyData));
        boolean bl2 = this.a(topologyData, map, subnetOption);
        this.a((SubnetOption)nodeOption, bl2);
        GraphDao.saveData(topologyData);
        CallbackServer.getInstance().notifyAllClients(SystemStatus.getCurrentClient(), "GraphLoaderProxy", "askToLoadNewData", null, null);
        return true;
    }

    private Map<String, NetworkNodeBean> a(Iterator<String> iterator, SubnetOption subnetOption) {
        Hashtable<String, NetworkNodeBean> hashtable;
        block6: {
            hashtable = new Hashtable<String, NetworkNodeBean>();
            PooledExecutor pooledExecutor = new PooledExecutor();
            boolean bl2 = DiscoveryOptions.c();
            try {
                for (int i2 = 0; i2 < subnetOption.getThreadsNum(); ++i2) {
                    try {
                        pooledExecutor.execute((Runnable)new SubnetUpdater$DiscoveryThread(iterator, subnetOption, hashtable));
                        if (bl2) {
                            if (bl2) continue;
                            break;
                        }
                        break block6;
                    }
                    catch (Exception exception) {
                        throw SubnetUpdater.a(exception);
                    }
                }
                pooledExecutor.shutdownAfterProcessingCurrentlyQueuedTasks();
                pooledExecutor.awaitTerminationAfterShutdown();
            }
            catch (Exception exception) {
                _logger.error((Object)"", (Throwable)exception);
            }
        }
        return hashtable;
    }

    private void a(SubnetOption subnetOption, boolean bl2) {
        Iterator<Map.Entry<GraphID, TopologyGraphModel>> iterator = this._models.entrySet().iterator();
        boolean bl3 = DiscoveryOptions.c();
        while (iterator.hasNext()) {
            NetworkGraphModel networkGraphModel;
            block6: {
                block5: {
                    Map.Entry<GraphID, TopologyGraphModel> entry;
                    Map.Entry<GraphID, TopologyGraphModel> entry2 = entry = iterator.next();
                    networkGraphModel = entry2.getValue();
                    if (!subnetOption.isCleanDiscovery()) break block5;
                    if (!(networkGraphModel instanceof SubnetGraphModel)) break block6;
                    LineLayoutAlgorithm.lineLayout(networkGraphModel);
                    if (bl3) break block6;
                }
                if (!bl2) {
                    LineLayoutAlgorithm.lineLayout(networkGraphModel);
                }
            }
            GraphDao.saveGraph(networkGraphModel, ModelUtil.getGraphType(networkGraphModel));
            if (bl3) continue;
        }
    }

    private boolean a(TopologyData topologyData, Map<String, NetworkNodeBean> map, SubnetOption subnetOption) {
        boolean bl2;
        block7: {
            Path path = new Path(String.valueOf(subnetOption.getProbeID()));
            boolean bl3 = DiscoveryOptions.c();
            path.setLeafID(subnetOption.getSubnet());
            _logger.info((Object)("updateNodes. path = " + path));
            Subnet subnet = (Subnet)topologyData.getNode(path).getBean();
            boolean bl4 = bl3;
            Set set = topologyData.getBeansInGraph(subnet.getSubGraphID());
            boolean bl5 = set != null && !set.isEmpty();
            for (Object e10 : set) {
                block9: {
                    NetworkNode networkNode;
                    TopologyGraphModel topologyGraphModel;
                    NetworkNodeBean networkNodeBean;
                    block10: {
                        block8: {
                            networkNodeBean = (NetworkNodeBean)e10;
                            bl2 = map.containsKey(networkNodeBean.getID());
                            if (!bl4) break block7;
                            if (!bl2) break block8;
                            this.a(topologyData, networkNodeBean, map.remove(networkNodeBean.getID()), subnetOption);
                            if (bl4) break block9;
                        }
                        topologyGraphModel = this.a(topologyData, subnet.getSubGraphID(), subnetOption);
                        networkNode = topologyGraphModel.getNodeByBean(networkNodeBean);
                        if (!subnetOption.isCleanDiscovery()) break block10;
                        if (networkNode != null) {
                            topologyGraphModel.remove(new Object[]{networkNode});
                        }
                        topologyData.removeNode(topologyGraphModel.getNodePath(networkNodeBean));
                        if (bl4) break block9;
                    }
                    if (!networkNodeBean.isManuallyAdded()) {
                        if (networkNode != null) {
                            topologyGraphModel.remove(new Object[]{networkNode});
                        }
                        topologyData.removeNode(topologyGraphModel.getNodePath(networkNodeBean));
                    }
                }
                if (bl4) continue;
            }
            this.a(topologyData, map, subnet.getSubGraphID(), subnetOption);
            bl2 = bl5;
        }
        return bl2;
    }

    private void a(TopologyData topologyData, Map<String, NetworkNodeBean> map, GraphID graphID, SubnetOption subnetOption) {
        Iterator<NetworkNodeBean> iterator = map.values().iterator();
        boolean bl2 = DiscoveryOptions.c();
        while (iterator.hasNext()) {
            block3: {
                NetworkNodeBean networkNodeBean;
                block4: {
                    networkNodeBean = iterator.next();
                    if (topologyData.getBean(networkNodeBean.getID()) != null) break block3;
                    TopologyGraphModel topologyGraphModel = this.a(topologyData, graphID, subnetOption);
                    NetworkNode networkNode = new NetworkNode(networkNodeBean);
                    topologyGraphModel.insert(new Object[]{networkNode}, null, null, null, null);
                    networkNodeBean.addTopoGraph(graphID);
                    Path path = topologyGraphModel.getNodePath(networkNodeBean);
                    if (topologyData.getNode(path) != null) break block4;
                    DeviceNode deviceNode = new DeviceNode((DeviceBean)networkNodeBean);
                    topologyData.addNode(deviceNode, path);
                    if (bl2) break block3;
                }
                topologyData.setBean(networkNodeBean);
            }
            if (bl2) continue;
        }
    }

    private void a(TopologyData topologyData, NetworkNodeBean networkNodeBean, NetworkNodeBean networkNodeBean2, SubnetOption subnetOption) {
        this.b(topologyData, networkNodeBean, networkNodeBean2, subnetOption);
        if (!subnetOption.isCleanDiscovery()) {
            ModelUtil.updateBean(networkNodeBean, networkNodeBean2);
        }
        topologyData.setBean(networkNodeBean2);
    }

    private NetworkGraphModel[] b(TopologyData topologyData, NetworkNodeBean networkNodeBean, NetworkNodeBean networkNodeBean2, SubnetOption subnetOption) {
        int n2 = networkNodeBean.getTopoGraphCount();
        List<GraphID> list = networkNodeBean.getAttachedGraphs();
        NetworkGraphModel[] networkGraphModelArray = new NetworkGraphModel[n2];
        boolean bl2 = DiscoveryOptions.c();
        int n3 = networkGraphModelArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            GraphID graphID = list.get(i2);
            networkNodeBean2.addTopoGraph(graphID);
            TopologyGraphModel topologyGraphModel = this.a(topologyData, graphID, subnetOption);
            NetworkNode networkNode = new NetworkNode(networkNodeBean2);
            NetworkNode networkNode2 = topologyGraphModel.getNodeByBean(networkNodeBean);
            if (networkNode2 != null) {
                ModelUtil.updateConnections(topologyGraphModel, networkNode2, networkNodeBean2);
                topologyGraphModel.remove(new Object[]{networkNode2});
                if (!subnetOption.isCleanDiscovery()) {
                    networkNode.setAttributes(networkNode2.getAttributes());
                    networkNode.setCurrentDefaultIcon(networkNode2.getCurrentDefaultIcon());
                }
            }
            topologyGraphModel.insert(new Object[]{networkNode}, null, null, null, null);
            networkGraphModelArray[i2] = topologyGraphModel;
            if (bl2) continue;
        }
        return networkGraphModelArray;
    }

    private TopologyGraphModel a(TopologyData topologyData, GraphID graphID, SubnetOption subnetOption) {
        TopologyGraphModel topologyGraphModel;
        block2: {
            block4: {
                block3: {
                    topologyGraphModel = this._models.get(graphID);
                    boolean bl2 = DiscoveryOptions.d();
                    if (topologyGraphModel != null) break block2;
                    String string = GraphDao.getGraph(graphID);
                    if (string == null) break block3;
                    topologyGraphModel = (TopologyGraphModel)GraphModelXMLReader.read(string, topologyData);
                    if (!bl2) break block4;
                }
                topologyGraphModel = new SubnetGraphModel(topologyData, graphID, null, null);
                topologyGraphModel.setParentGraph(subnetOption.getParentID());
            }
            topologyGraphModel.setID(graphID);
            this._models.put(graphID, topologyGraphModel);
        }
        return topologyGraphModel;
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

