/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.discovery;

import com.sysuptime.common.graph.GraphID;
import com.sysuptime.common.graph.GraphModelXMLReader;
import com.sysuptime.common.graph.GraphXMLReader;
import com.sysuptime.common.graph.IGraphParameters;
import com.sysuptime.common.graph.IconJarData;
import com.sysuptime.common.graph.LineLayoutAlgorithm;
import com.sysuptime.common.graph.NetworkGraphModel;
import com.sysuptime.common.model.CustomerNode;
import com.sysuptime.common.model.Subnet;
import com.sysuptime.common.model.TopologyData;
import com.sysuptime.common.util.AppUtil;
import com.sysuptime.common.util.FileUtil;
import com.sysuptime.server.discovery.DiscoveryData;
import com.sysuptime.server.discovery.DiscoveryOptions;
import com.sysuptime.server.discovery.GraphDao;
import com.sysuptime.server.discovery.Topology;
import com.sysuptime.server.util.DefaultConnection;
import com.sysuptime.server.util.ServerConfig;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GraphDataProxy {
    private static final Logger _logger = Logger.getLogger((String)GraphDataProxy.class.getName());
    private static final GraphDataProxy _instance = new GraphDataProxy();
    private static final String IMAGE_DIR = AppUtil.getClientHomeDirectory() + "/images/topology";
    private static final String IMAGE_JAR = AppUtil.getClientHomeDirectory() + "/images/topology.jar";

    private GraphDataProxy() {
    }

    public static GraphDataProxy getInstance() {
        return _instance;
    }

    public void updateGraphData(boolean bl2, DiscoveryData discoveryData) {
        this.a(bl2, discoveryData);
        this.a();
        this.b();
    }

    public void updateIconJar() {
        this.c();
        this.d();
    }

    private void a(boolean bl2, DiscoveryData discoveryData) {
        Topology topology = discoveryData.createTopology();
        TopologyData topologyData = topology.getTopologyData();
        TopologyData topologyData2 = GraphDao.createData();
        CustomerNode customerNode = topologyData.getCustomer(ServerConfig.getCustomerID());
        GraphDao.updateMasterGraph(topologyData, customerNode);
        this.b(topologyData2, topology, bl2);
        this.a(topologyData2, topology, bl2);
        _logger.info((Object)"topology data :::::::::::::::::::::::::::");
        _logger.info((Object)topologyData);
        this.a(customerNode, bl2);
    }

    private void a(TopologyData topologyData, Topology topology, boolean bl2) {
        Object object;
        Object object2;
        boolean bl3;
        Object object3;
        boolean bl4;
        ArrayList<GraphID> arrayList;
        block7: {
            arrayList = new ArrayList<GraphID>();
            List list = topology.createSubnetGraphs();
            bl4 = DiscoveryOptions.c();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                object3 = (NetworkGraphModel)((Object)list.get(i2));
                bl3 = bl2;
                if (bl4) {
                    if (!bl3 && (object2 = GraphDao.getGraph(((NetworkGraphModel)((Object)object3)).getID())) != null) {
                        object = GraphModelXMLReader.read((String)object2, topologyData);
                        ((NetworkGraphModel)((Object)object3)).keepOld((NetworkGraphModel)((Object)object));
                        List list2 = ((NetworkGraphModel)((Object)object)).getManuallyAddedNodes();
                        object3.insert(list2.toArray(), null, null, null, null);
                    }
                    LineLayoutAlgorithm.lineLayout((NetworkGraphModel)((Object)object3));
                    GraphDao.saveGraph((NetworkGraphModel)((Object)object3), "s");
                    arrayList.add(((NetworkGraphModel)((Object)object3)).getID());
                    if (bl4) continue;
                }
                break block7;
            }
            bl3 = bl2;
        }
        if (!bl3) {
            TopologyData topologyData2 = topology.getTopologyData();
            CustomerNode customerNode = topologyData2.getCustomer(ServerConfig.getCustomerID());
            object3 = NetworkGraphModel.getManuallyAddedSubnets(customerNode);
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (Subnet)object2.next();
                arrayList.add(new GraphID(ServerConfig.getCustomerID(), ((Subnet)object).getIpAddress()));
                if (bl4) {
                    if (bl4) continue;
                }
                break;
            }
        } else {
            arrayList.add(new GraphID(ServerConfig.getCustomerID(), "customer"));
            arrayList.add(new GraphID(ServerConfig.getCustomerID(), "nodes"));
            GraphDao.deleteNotIn(arrayList);
        }
    }

    private void a(CustomerNode customerNode, boolean bl2) {
        GraphID graphID;
        String string;
        if (!bl2 && (string = GraphDao.getGraph(graphID = new GraphID(ServerConfig.getCustomerID(), "beans"))) != null) {
            CustomerNode customerNode2 = GraphXMLReader.fromNodesXML(string);
            TopologyData.update(customerNode, customerNode2);
        }
        GraphDao.saveLocalBeans(customerNode);
    }

    private void b(TopologyData topologyData, Topology topology, boolean bl2) {
        String string;
        NetworkGraphModel networkGraphModel = topology.createCustomerGraph();
        if (!bl2 && (string = GraphDao.getGraph(new GraphID(ServerConfig.getCustomerID(), "customer"))) != null) {
            NetworkGraphModel networkGraphModel2 = GraphModelXMLReader.read(string, topologyData);
            networkGraphModel.keepOld(networkGraphModel2);
            List list = networkGraphModel2.getManuallyAddedNodes();
            networkGraphModel.insert(list.toArray(), null, null, null, null);
        }
        this.a(networkGraphModel);
        networkGraphModel.setParentGraph(IGraphParameters.MASTER_MASTER);
        GraphDao.saveGraph(networkGraphModel, "c");
    }

    private void a(NetworkGraphModel networkGraphModel) {
        try {
            LineLayoutAlgorithm.lineLayout(networkGraphModel);
        }
        catch (Throwable throwable) {
            _logger.error((Object)"", throwable);
        }
    }

    private boolean a() {
        String string = "" + System.currentTimeMillis();
        return ServerConfig.updateProperty("topology.timeStamp", string);
    }

    private boolean b() {
        String string = "" + System.currentTimeMillis();
        return ServerConfig.updateProperty("discovery.timeStamp", string);
    }

    private void c() {
        try {
            AppUtil.zip(IMAGE_DIR, IMAGE_JAR);
        }
        catch (Exception exception) {
            _logger.error((Object)"", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void d() {
        Connection connection = DefaultConnection.getConnection();
        PreparedStatement preparedStatement = null;
        boolean bl2 = DiscoveryOptions.d();
        ResultSet resultSet = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            block18: {
                block17: {
                    bufferedInputStream = FileUtil.getInputStream(IMAGE_JAR);
                    preparedStatement = connection.prepareStatement("SELECT data_c FROM topo_iconjar");
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) break block17;
                    preparedStatement.close();
                    preparedStatement = connection.prepareStatement("UPDATE topo_iconjar SET data_c=?");
                    if (!bl2) break block18;
                }
                preparedStatement.close();
                preparedStatement = connection.prepareStatement("INSERT INTO topo_iconjar (data_c) VALUES(?)");
            }
            preparedStatement.setBinaryStream(1, (InputStream)bufferedInputStream, ((InputStream)bufferedInputStream).available());
            preparedStatement.executeUpdate();
            String string = "" + System.currentTimeMillis();
            ServerConfig.updateProperty("iconJar.timeStamp", string);
        }
        catch (Exception exception) {
            try {
                _logger.error((Object)"", (Throwable)exception);
            }
            catch (Throwable throwable) {
                DefaultConnection.closeConnection(connection, preparedStatement, resultSet, "closing error when save jar to db! ");
                if (bufferedInputStream != null) {
                    try {
                        ((InputStream)bufferedInputStream).close();
                        bufferedInputStream = null;
                    }
                    catch (IOException iOException) {
                        _logger.warn((Object)"saveJarToDb", (Throwable)iOException);
                    }
                }
                throw throwable;
            }
            DefaultConnection.closeConnection(connection, preparedStatement, resultSet, "closing error when save jar to db! ");
            if (bufferedInputStream != null) {
                try {
                    ((InputStream)bufferedInputStream).close();
                    bufferedInputStream = null;
                }
                catch (IOException iOException) {
                    _logger.warn((Object)"saveJarToDb", (Throwable)iOException);
                }
            }
        }
        DefaultConnection.closeConnection(connection, preparedStatement, resultSet, "closing error when save jar to db! ");
        if (bufferedInputStream != null) {
            try {
                ((InputStream)bufferedInputStream).close();
                bufferedInputStream = null;
            }
            catch (IOException iOException) {
                _logger.warn((Object)"saveJarToDb", (Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IconJarData getIconJarData(String string) {
        IconJarData iconJarData = null;
        Connection connection = DefaultConnection.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String string2 = ServerConfig.getProperty("iconJar.timeStamp");
            if (string2 == null) {
                this.updateIconJar();
                string2 = ServerConfig.getProperty("iconJar.timeStamp");
            }
            if (!string.equals(string2) && (resultSet = (statement = connection.createStatement()).executeQuery("SELECT data_c FROM topo_iconjar")).next()) {
                byte[] byArray = resultSet.getBytes(1);
                iconJarData = new IconJarData(string2, byArray);
            }
            DefaultConnection.closeConnection(connection, statement, resultSet);
        }
        catch (Exception exception) {
            _logger.error((Object)"", (Throwable)exception);
        }
        finally {
            DefaultConnection.closeConnection(connection, statement, resultSet);
        }
        return iconJarData;
    }

    public boolean graphDataChanged(String string) {
        String string2 = ServerConfig.getProperty("topology.timeStamp");
        return !string.equals(string2);
    }

    public void addIconFiles(Map map) {
        block3: {
            boolean bl2 = DiscoveryOptions.d();
            if (!map.isEmpty()) {
                Set set = map.entrySet();
                for (Map.Entry entry : set) {
                    String string = (String)entry.getKey();
                    byte[] byArray = (byte[])entry.getValue();
                    AppUtil.bytes2File(byArray, IMAGE_DIR + File.separator + string);
                    if (!bl2) {
                        if (!bl2) continue;
                    }
                    break block3;
                }
                this.updateIconJar();
            }
        }
    }

    public String getServerTopoTimeStamp() {
        return ServerConfig.getProperty("topology.timeStamp");
    }

    public static long getTopologyTimeStamp() {
        long l2 = -1L;
        String string = ServerConfig.getProperty("topology.timeStamp");
        if (string != null) {
            l2 = Long.parseLong(string);
        }
        return l2;
    }

    public static long getDiscoveryTimeStamp() {
        long l2 = -1L;
        String string = ServerConfig.getProperty("discovery.timeStamp");
        if (string != null) {
            l2 = Long.parseLong(string);
        }
        return l2;
    }
}

