/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.discovery;

import com.sysuptime.common.graph.GrantedView;
import com.sysuptime.common.graph.GraphData;
import com.sysuptime.common.graph.GraphID;
import com.sysuptime.common.graph.GraphModelXMLReader;
import com.sysuptime.common.graph.GraphModelXMLWriter;
import com.sysuptime.common.graph.GraphXMLReader;
import com.sysuptime.common.graph.GraphXMLWriter;
import com.sysuptime.common.graph.IGraphParameters;
import com.sysuptime.common.graph.LineLayoutAlgorithm;
import com.sysuptime.common.graph.MasterGraphModel;
import com.sysuptime.common.graph.NetworkGraphModel;
import com.sysuptime.common.model.Customer;
import com.sysuptime.common.model.CustomerNode;
import com.sysuptime.common.model.NetworkNode;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.common.model.Path;
import com.sysuptime.common.model.TopologyData;
import com.sysuptime.common.msp.Probe;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.common.util.callback.CallbackServer;
import com.sysuptime.server.discovery.DiscoveryOptions;
import com.sysuptime.server.login.OrgViewRelationDao;
import com.sysuptime.server.util.DefaultConnection;
import com.sysuptime.server.util.ServerConfig;
import com.sysuptime.server.util.ServerPropertiesFile;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class GraphDao {
    private static final Logger _logger = Logger.getLogger((String)GraphDao.class.getName());
    private static long _lastModify = -1L;
    private static TopologyData _data;

    private GraphDao() {
    }

    public static void deleteNotIn(List list) {
        List list2 = GraphDao.a(ServerConfig.getCustomerID());
        boolean bl2 = DiscoveryOptions.d();
        list2.removeAll(list);
        for (Object e10 : list2) {
            GraphID graphID = (GraphID)e10;
            GraphDao.delete(graphID);
            if (!bl2) continue;
        }
    }

    public static List getAllTopologyIDs() {
        return GraphDao.b("c");
    }

    public static List getAllSubnetIDs() {
        return GraphDao.b("s");
    }

    private static List a(String string) {
        return GraphDao.a("s", string);
    }

    public static List getAllViewIDs() {
        List list = GraphDao.b("v");
        list.add(0, IGraphParameters.MASTER_MASTER);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List b(String string) {
        ArrayList<GraphID> arrayList;
        block9: {
            arrayList = null;
            Connection connection = DefaultConnection.getConnection();
            PreparedStatement preparedStatement = null;
            boolean bl2 = DiscoveryOptions.d();
            ResultSet resultSet = null;
            try {
                String string2 = "SELECT domain_c, name_c FROM topo_graphdata WHERE type_c=?";
                preparedStatement = connection.prepareStatement(string2);
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                arrayList = new ArrayList<GraphID>();
                while (resultSet.next()) {
                    try {
                        arrayList.add(new GraphID(resultSet.getString("domain_c"), resultSet.getString("name_c")));
                        if (!bl2) {
                            if (!bl2) continue;
                            break;
                        }
                        break block9;
                    }
                    catch (SQLException sQLException) {
                        throw GraphDao.a(sQLException);
                    }
                }
                DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
            }
            catch (SQLException sQLException) {
                _logger.error((Object)sQLException.getMessage(), (Throwable)sQLException);
            }
            finally {
                DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List a(String string, String string2) {
        ArrayList<GraphID> arrayList;
        block9: {
            arrayList = null;
            boolean bl2 = DiscoveryOptions.d();
            Connection connection = DefaultConnection.getConnection();
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                String string3 = "SELECT domain_c, name_c FROM topo_graphdata WHERE type_c=? AND domain_c=?";
                preparedStatement = connection.prepareStatement(string3);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                resultSet = preparedStatement.executeQuery();
                arrayList = new ArrayList<GraphID>();
                while (resultSet.next()) {
                    try {
                        arrayList.add(new GraphID(resultSet.getString("domain_c"), resultSet.getString("name_c")));
                        if (!bl2) {
                            if (!bl2) continue;
                            break;
                        }
                        break block9;
                    }
                    catch (SQLException sQLException) {
                        throw GraphDao.a(sQLException);
                    }
                }
                DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
            }
            catch (SQLException sQLException) {
                _logger.error((Object)sQLException.getMessage(), (Throwable)sQLException);
            }
            finally {
                DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllGrantedViews() {
        ArrayList<GrantedView> arrayList;
        block9: {
            arrayList = null;
            boolean bl2 = DiscoveryOptions.d();
            Connection connection = DefaultConnection.getConnection();
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                String string = "SELECT domain_c, name_c FROM topo_graphdata WHERE type_c=?";
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setString(1, "v");
                resultSet = preparedStatement.executeQuery();
                arrayList = new ArrayList<GrantedView>();
                while (resultSet.next()) {
                    String string2 = resultSet.getString("domain_c");
                    String string3 = resultSet.getString("name_c");
                    GraphID graphID = new GraphID(string2, string3);
                    List list = OrgViewRelationDao.getOrgsByViewID(string3);
                    try {
                        arrayList.add(new GrantedView(graphID, list));
                        if (!bl2) {
                            if (!bl2) continue;
                            break;
                        }
                        break block9;
                    }
                    catch (SQLException sQLException) {
                        throw GraphDao.a(sQLException);
                    }
                }
                DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
            }
            catch (SQLException sQLException) {
                _logger.error((Object)sQLException.getMessage(), (Throwable)sQLException);
            }
            finally {
                DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllGraphDatas() {
        ArrayList<GraphData> arrayList;
        block8: {
            arrayList = null;
            Connection connection = DefaultConnection.getConnection();
            Statement statement = null;
            ResultSet resultSet = null;
            boolean bl2 = DiscoveryOptions.d();
            try {
                String string = "SELECT * FROM topo_graphdata";
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string);
                arrayList = new ArrayList<GraphData>();
                while (resultSet.next()) {
                    String string2 = resultSet.getString("domain_c");
                    String string3 = resultSet.getString("name_c");
                    InputStream inputStream = resultSet.getBinaryStream("data_c");
                    String string4 = StringUtil.getString(inputStream, "UTF-8");
                    String string5 = resultSet.getString("type_c");
                    Timestamp timestamp = resultSet.getTimestamp("timestamp_c");
                    GraphData graphData = new GraphData(new GraphID(string2, string3), string4, string5, timestamp);
                    try {
                        arrayList.add(graphData);
                        if (!bl2) {
                            if (!bl2) continue;
                            break;
                        }
                        break block8;
                    }
                    catch (Exception exception) {
                        throw GraphDao.a(exception);
                    }
                }
            }
            catch (Exception exception) {
                try {
                    _logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
                catch (Throwable throwable) {
                    DefaultConnection.closeConnection(connection, statement, resultSet);
                    throw throwable;
                }
                DefaultConnection.closeConnection(connection, statement, resultSet);
            }
            DefaultConnection.closeConnection(connection, statement, resultSet);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getGraphDatasByType(String string) {
        ArrayList<GraphData> arrayList;
        block9: {
            arrayList = null;
            boolean bl2 = DiscoveryOptions.d();
            Connection connection = DefaultConnection.getConnection();
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                String string2 = "SELECT * FROM topo_graphdata WHERE type_c=?";
                preparedStatement = connection.prepareStatement(string2);
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                arrayList = new ArrayList<GraphData>();
                while (resultSet.next()) {
                    String string3 = resultSet.getString("domain_c");
                    String string4 = resultSet.getString("name_c");
                    InputStream inputStream = resultSet.getBinaryStream("data_c");
                    String string5 = StringUtil.getString(inputStream, "UTF-8");
                    String string6 = resultSet.getString("type_c");
                    Timestamp timestamp = resultSet.getTimestamp("timestamp_c");
                    GraphData graphData = new GraphData(new GraphID(string3, string4), string5, string6, timestamp);
                    try {
                        arrayList.add(graphData);
                        if (!bl2) {
                            if (!bl2) continue;
                            break;
                        }
                        break block9;
                    }
                    catch (Exception exception) {
                        throw GraphDao.a(exception);
                    }
                }
                DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
            }
            catch (Exception exception) {
                _logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
            finally {
                DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasGraphView(GraphID graphID) {
        Connection connection = DefaultConnection.getConnection();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string = "SELECT name_c FROM topo_graphdata WHERE domain_c=? AND name_c=?";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setString(1, graphID.getCustomerID());
            preparedStatement.setString(2, graphID.getGraphName());
            resultSet = preparedStatement.executeQuery();
            boolean bl2 = resultSet.next();
            DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
            return bl2;
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        finally {
            DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getViewIDsByUser(String string) {
        ArrayList<GraphID> arrayList;
        block9: {
            _logger.info((Object)("graphs for user " + string));
            arrayList = null;
            Connection connection = DefaultConnection.getConnection();
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            boolean bl2 = DiscoveryOptions.d();
            try {
                String string2 = "SELECT name_c,domain_c FROM topo_graphdata WHERE name_c in (SELECT view_id_c FROM org_view_relation WHERE org_name_c in (SELECT org_name_c FROM user_org_relation WHERE username_c=?))";
                preparedStatement = connection.prepareStatement(string2);
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                arrayList = new ArrayList<GraphID>();
                while (resultSet.next()) {
                    String string3 = resultSet.getString("name_c");
                    String string4 = resultSet.getString("domain_c");
                    GraphID graphID = new GraphID(string4, string3);
                    try {
                        _logger.info((Object)("graphID = " + string3));
                        arrayList.add(graphID);
                        if (!bl2) {
                            if (!bl2) continue;
                            break;
                        }
                        break block9;
                    }
                    catch (Exception exception) {
                        throw GraphDao.a(exception);
                    }
                }
                DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
            }
            catch (Exception exception) {
                _logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
            finally {
                DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static List getViewsByUser(String var0) {
        block12: {
            GraphDao._logger.info((Object)("graphs for user " + var0));
            var2_1 = null;
            var3_2 = DefaultConnection.getConnection();
            var1_3 = DiscoveryOptions.c();
            var4_4 = null;
            var5_5 = null;
            try {
                var6_6 = "SELECT * FROM topo_graphdata WHERE name_c in (SELECT view_id_c FROM org_view_relation WHERE org_name_c in (SELECT org_name_c FROM user_org_relation WHERE username_c=?))";
                var4_4 = var3_2.prepareStatement(var6_6);
                var4_4.setString(1, var0);
                var5_5 = var4_4.executeQuery();
                var2_1 = new ArrayList<GraphData>();
                var2_1.addAll(GraphDao.getGraphDatasByType("b"));
                while (var5_5.next()) {
                    block13: {
                        block14: {
                            var7_8 = var5_5.getString("name_c");
                            var8_9 = var5_5.getString("domain_c");
                            var9_10 = new GraphID(var8_9, var7_8);
                            GraphDao._logger.info((Object)("graphID = " + var7_8));
                            var10_11 = var5_5.getBinaryStream("data_c");
                            var11_12 = StringUtil.getString(var10_11, "UTF-8");
                            var12_13 = var5_5.getString("type_c");
                            var13_14 = var5_5.getTimestamp("timestamp_c");
                            var14_15 = new GraphData(var9_10, var11_12, var12_13, var13_14);
                            if (!var1_3) break block12;
                            if (!IGraphParameters.MASTER_MASTER.equals(var9_10)) ** GOTO lbl40
                            break block14;
                            catch (Exception v0) {
                                throw GraphDao.a(v0);
                            }
                        }
                        try {
                            block15: {
                                var2_1.addAll(GraphDao.c());
                                if (var1_3) break block13;
                                break block15;
                                catch (Exception v1) {
                                    throw GraphDao.a(v1);
                                }
                            }
                            var2_1.add(var14_15);
                        }
                        catch (Exception v2) {
                            throw GraphDao.a(v2);
                        }
                    }
                    if (var1_3) continue;
                }
                DefaultConnection.closeConnection(var3_2, var4_4, var5_5);
            }
            catch (Exception var6_7) {
                GraphDao._logger.error((Object)var6_7.getMessage(), (Throwable)var6_7);
            }
            finally {
                DefaultConnection.closeConnection(var3_2, var4_4, var5_5);
            }
        }
        return var2_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getUsersByView(String string) {
        ArrayList<String> arrayList;
        block9: {
            arrayList = null;
            Connection connection = DefaultConnection.getConnection();
            PreparedStatement preparedStatement = null;
            boolean bl2 = DiscoveryOptions.c();
            ResultSet resultSet = null;
            try {
                String string2 = "SELECT username_c FROM user_org_relation WHERE org_name_c in (SELECT org_name_c FROM org_view_relation WHERE view_id_c=?)";
                preparedStatement = connection.prepareStatement(string2);
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                arrayList = new ArrayList<String>();
                while (resultSet.next()) {
                    String string3 = resultSet.getString("username_c");
                    try {
                        arrayList.add(string3);
                        if (bl2) {
                            if (bl2) continue;
                            break;
                        }
                        break block9;
                    }
                    catch (Exception exception) {
                        throw GraphDao.a(exception);
                    }
                }
                DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
            }
            catch (Exception exception) {
                _logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
            finally {
                DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getUsersInSameOrgs(String string) {
        ArrayList<String> arrayList;
        block9: {
            arrayList = null;
            Connection connection = DefaultConnection.getConnection();
            boolean bl2 = DiscoveryOptions.d();
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                String string2 = "SELECT username_c FROM user_org_relation WHERE org_name_c in (SELECT org_name_c FROM user_org_relation WHERE username_c=?)";
                preparedStatement = connection.prepareStatement(string2);
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                arrayList = new ArrayList<String>();
                while (resultSet.next()) {
                    String string3 = resultSet.getString("username_c");
                    try {
                        arrayList.add(string3);
                        if (!bl2) {
                            if (!bl2) continue;
                            break;
                        }
                        break block9;
                    }
                    catch (Exception exception) {
                        throw GraphDao.a(exception);
                    }
                }
                DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
            }
            catch (Exception exception) {
                _logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
            finally {
                DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
            }
        }
        return arrayList;
    }

    public static boolean saveLocalBeans(CustomerNode customerNode) {
        String string = GraphXMLWriter.asBeansXML(customerNode);
        if (string != null) {
            GraphID graphID = new GraphID(ServerConfig.getCustomerID(), "beans");
            GraphData graphData = new GraphData(graphID, string, "b", null);
            String string2 = GraphDao.getGraph(graphID);
            if (string2 != null) {
                return GraphDao.b(graphData);
            }
            if (!ServerPropertiesFile.isMaster()) {
                GraphDao.delete(new GraphID("-1", graphData.getGraphID().getGraphName()));
            }
            return GraphDao.a(graphData);
        }
        return false;
    }

    public static boolean saveBeans(CustomerNode customerNode) {
        String string = GraphXMLWriter.asBeansXML(customerNode);
        if (string != null) {
            GraphID graphID = new GraphID(customerNode.getCustomerID(), "beans");
            GraphData graphData = new GraphData(graphID, string, "b", null);
            String string2 = GraphDao.getGraph(graphID);
            if (string2 != null) {
                return GraphDao.b(graphData);
            }
            return GraphDao.a(graphData);
        }
        return false;
    }

    public static boolean saveData(TopologyData topologyData) {
        List list = topologyData.getCustomers();
        boolean bl2 = true;
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            CustomerNode customerNode = (CustomerNode)list.get(i2);
            bl2 = bl2 && GraphDao.saveBeans(customerNode);
        }
        return bl2;
    }

    public static boolean saveGraph(NetworkGraphModel networkGraphModel, String string) {
        String string2 = GraphModelXMLWriter.asViewXML(networkGraphModel);
        if (string2 != null) {
            String string3 = GraphDao.getGraph(networkGraphModel.getID());
            GraphData graphData = new GraphData(networkGraphModel.getID(), string2, string, null);
            if (string3 != null) {
                return GraphDao.b(graphData);
            }
            if (!ServerPropertiesFile.isMaster()) {
                GraphDao.delete(new GraphID("-1", graphData.getGraphID().getGraphName()));
            }
            return GraphDao.a(graphData);
        }
        return false;
    }

    public static boolean saveGraph(GraphData graphData) {
        String string = GraphDao.getGraph(graphData.getGraphID());
        if (string != null) {
            return GraphDao.b(graphData);
        }
        return GraphDao.a(graphData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean a(GraphData graphData) {
        Connection connection = DefaultConnection.getConnection();
        PreparedStatement preparedStatement = null;
        try {
            String string = "INSERT INTO topo_graphdata VALUES(?,?,?,?,?)";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setString(1, graphData.getGraphID().getCustomerID());
            preparedStatement.setString(2, graphData.getGraphID().getGraphName());
            String string2 = graphData.getContent();
            byte[] byArray = string2.getBytes("UTF-8");
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray));
            preparedStatement.setBinaryStream(3, (InputStream)bufferedInputStream, ((InputStream)bufferedInputStream).available());
            preparedStatement.setString(4, graphData.getType());
            preparedStatement.setTimestamp(5, GraphDao.a());
            preparedStatement.executeUpdate();
            ((InputStream)bufferedInputStream).close();
        }
        catch (Exception exception) {
            _logger.error((Object)"insert", (Throwable)exception);
            boolean bl2 = false;
            return bl2;
        }
        finally {
            DefaultConnection.closeConnection(connection, preparedStatement, null, "in update method");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean b(GraphData graphData) {
        Connection connection = DefaultConnection.getConnection();
        PreparedStatement preparedStatement = null;
        try {
            String string = graphData.getContent();
            byte[] byArray = string.getBytes("UTF-8");
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray));
            String string2 = "UPDATE topo_graphdata SET data_c=?,timestamp_c=? WHERE domain_c=? AND name_c=?";
            preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setBinaryStream(1, (InputStream)bufferedInputStream, ((InputStream)bufferedInputStream).available());
            preparedStatement.setTimestamp(2, GraphDao.a());
            preparedStatement.setString(3, graphData.getGraphID().getCustomerID());
            preparedStatement.setString(4, graphData.getGraphID().getGraphName());
            preparedStatement.executeUpdate();
            ((InputStream)bufferedInputStream).close();
            DefaultConnection.closeConnection(connection, preparedStatement, null, "in update method");
        }
        catch (Exception exception) {
            _logger.error((Object)"update", (Throwable)exception);
            boolean bl2 = false;
            return bl2;
        }
        finally {
            DefaultConnection.closeConnection(connection, preparedStatement, null, "in update method");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean delete(GraphID graphID) {
        boolean bl2 = false;
        Connection connection = DefaultConnection.getConnection();
        PreparedStatement preparedStatement = null;
        try {
            String string = "DELETE FROM topo_graphdata WHERE domain_c=? AND name_c=?";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setString(1, graphID.getCustomerID());
            preparedStatement.setString(2, graphID.getGraphName());
            preparedStatement.executeUpdate();
            bl2 = true;
        }
        catch (SQLException sQLException) {
            try {
                _logger.error((Object)"delete", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                DefaultConnection.closeConnection(connection, preparedStatement);
                throw throwable;
            }
            DefaultConnection.closeConnection(connection, preparedStatement);
        }
        DefaultConnection.closeConnection(connection, preparedStatement);
        _lastModify = System.currentTimeMillis();
        return bl2;
    }

    public static String getGraph(GraphID graphID) {
        return GraphDao.getGraph(graphID, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGraph(GraphID graphID, boolean bl2) {
        String string;
        try {
            string = bl2 ? "topo_baseline_t" : "topo_graphdata";
        }
        catch (Exception exception) {
            throw GraphDao.a(exception);
        }
        String string2 = string;
        Connection connection = DefaultConnection.getConnection();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string3 = "SELECT data_c FROM " + string2 + " WHERE domain_c=? AND name_c=?";
            preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setString(1, graphID.getCustomerID());
            preparedStatement.setString(2, graphID.getGraphName());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string4;
                InputStream inputStream = resultSet.getBinaryStream("data_c");
                String string5 = string4 = StringUtil.getString(inputStream, "UTF-8");
                DefaultConnection.closeConnection(connection, preparedStatement, resultSet, "in update method");
                return string5;
            }
            DefaultConnection.closeConnection(connection, preparedStatement, resultSet, "in update method");
        }
        catch (Exception exception) {
            _logger.error((Object)"getGraph", (Throwable)exception);
        }
        finally {
            DefaultConnection.closeConnection(connection, preparedStatement, resultSet, "in update method");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GraphData getGraphData(GraphID graphID) {
        Connection connection = DefaultConnection.getConnection();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string = "SELECT * FROM topo_graphdata WHERE domain_c=? AND name_c=?";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setString(1, graphID.getCustomerID());
            preparedStatement.setString(2, graphID.getGraphName());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string2 = resultSet.getString("name_c");
                InputStream inputStream = resultSet.getBinaryStream("data_c");
                String string3 = StringUtil.getString(inputStream, "UTF-8");
                String string4 = resultSet.getString("type_c");
                Timestamp timestamp = resultSet.getTimestamp("timestamp_c");
                GraphData graphData = new GraphData(graphID, string3, string4, timestamp);
                try {
                    if (string2.equals(IGraphParameters.TOPOLOGY_VIEW)) {
                        graphData.setSubGraphs(GraphDao.getGraphDatasByType("s"));
                    }
                }
                catch (Exception exception) {
                    throw GraphDao.a(exception);
                }
                GraphData graphData2 = graphData;
                DefaultConnection.closeConnection(connection, preparedStatement, resultSet, "in update method");
                return graphData2;
            }
            DefaultConnection.closeConnection(connection, preparedStatement, resultSet, "in update method");
        }
        catch (Exception exception) {
            _logger.error((Object)"getGraphData", (Throwable)exception);
        }
        finally {
            DefaultConnection.closeConnection(connection, preparedStatement, resultSet, "in update method");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasTopologyData() {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block4: {
            boolean bl2;
            connection = DefaultConnection.getConnection();
            preparedStatement = null;
            resultSet = null;
            try {
                String string = "SELECT * FROM topo_graphdata";
                preparedStatement = connection.prepareStatement(string);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block4;
                bl2 = true;
            }
            catch (Exception exception) {
                try {
                    _logger.error((Object)"hasTopologyData", (Throwable)exception);
                }
                catch (Throwable throwable) {
                    DefaultConnection.closeConnection(connection, preparedStatement, resultSet, "in update method");
                    throw throwable;
                }
                DefaultConnection.closeConnection(connection, preparedStatement, resultSet, "in update method");
            }
            DefaultConnection.closeConnection(connection, preparedStatement, resultSet, "in update method");
            return bl2;
        }
        DefaultConnection.closeConnection(connection, preparedStatement, resultSet, "in update method");
        return false;
    }

    private static Timestamp a() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static List getCustomerIDs() {
        return GraphDao.getCustomerIDs(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getCustomerIDs(boolean bl2) {
        ArrayList<String> arrayList;
        block11: {
            String string;
            boolean bl3 = DiscoveryOptions.c();
            try {
                string = bl2 ? "topo_baseline_t" : "topo_graphdata";
            }
            catch (Exception exception) {
                throw GraphDao.a(exception);
            }
            String string2 = string;
            arrayList = new ArrayList<String>();
            Connection connection = DefaultConnection.getConnection();
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                String string3 = "SELECT * FROM " + string2 + " WHERE name_c=? AND type_c=?";
                preparedStatement = connection.prepareStatement(string3);
                preparedStatement.setString(1, "beans");
                preparedStatement.setString(2, "b");
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String string4 = resultSet.getString("domain_c");
                    try {
                        arrayList.add(string4);
                        if (bl3) {
                            if (bl3) continue;
                            break;
                        }
                        break block11;
                    }
                    catch (Exception exception) {
                        throw GraphDao.a(exception);
                    }
                }
                DefaultConnection.closeConnection(connection, preparedStatement, resultSet, "in update method");
            }
            catch (Exception exception) {
                _logger.error((Object)"hasTopologyData", (Throwable)exception);
            }
            finally {
                DefaultConnection.closeConnection(connection, preparedStatement, resultSet, "in update method");
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getProbeGraphDatas(String string) {
        ArrayList<GraphData> arrayList;
        block9: {
            arrayList = new ArrayList<GraphData>();
            boolean bl2 = DiscoveryOptions.c();
            Connection connection = DefaultConnection.getConnection();
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                String string2 = "SELECT * FROM topo_graphdata WHERE domain_c=?";
                preparedStatement = connection.prepareStatement(string2);
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String string3 = resultSet.getString("domain_c");
                    String string4 = resultSet.getString("name_c");
                    InputStream inputStream = resultSet.getBinaryStream("data_c");
                    String string5 = StringUtil.getString(inputStream, "UTF-8");
                    String string6 = resultSet.getString("type_c");
                    Timestamp timestamp = resultSet.getTimestamp("timestamp_c");
                    GraphData graphData = new GraphData(new GraphID(string3, string4), string5, string6, timestamp);
                    try {
                        arrayList.add(graphData);
                        if (bl2) {
                            if (bl2) continue;
                            break;
                        }
                        break block9;
                    }
                    catch (Exception exception) {
                        throw GraphDao.a(exception);
                    }
                }
                DefaultConnection.closeConnection(connection, preparedStatement, resultSet, "in update method");
            }
            catch (Exception exception) {
                _logger.error((Object)"getProbeGraphDatas", (Throwable)exception);
            }
            finally {
                DefaultConnection.closeConnection(connection, preparedStatement, resultSet, "in update method");
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteGraphDataByProbe(long l2) {
        NetworkGraphModel networkGraphModel = GraphDao.getModel(IGraphParameters.MASTER_MASTER);
        NetworkNode networkNode = networkGraphModel.getNodeByBean(networkGraphModel.getBean(new Path(String.valueOf(l2))));
        networkGraphModel.remove(new Object[]{networkNode});
        GraphDao.saveData(networkGraphModel.getData());
        GraphDao.saveGraph(networkGraphModel, networkGraphModel.getGraphType());
        Connection connection = DefaultConnection.getConnection();
        PreparedStatement preparedStatement = null;
        try {
            String string = "DELETE FROM topo_graphdata WHERE domain_c=?";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setString(1, String.valueOf(l2));
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            try {
                _logger.error((Object)"deleteGraphByProbe:", (Throwable)exception);
            }
            catch (Throwable throwable) {
                DefaultConnection.closeConnection(connection, preparedStatement);
                throw throwable;
            }
            DefaultConnection.closeConnection(connection, preparedStatement);
        }
        DefaultConnection.closeConnection(connection, preparedStatement);
    }

    public static TopologyData createData() {
        long l2 = GraphDao.getLastModify();
        boolean bl2 = DiscoveryOptions.d();
        if (_data == null || l2 > _data.getTime()) {
            block3: {
                List list = GraphDao.getCustomerIDs();
                ArrayList<String> arrayList = new ArrayList<String>();
                int n2 = list.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string = (String)list.get(i2);
                    String string2 = GraphDao.getGraph(new GraphID(string, "beans"));
                    arrayList.add(string2);
                    if (!bl2) {
                        if (!bl2) continue;
                    }
                    break block3;
                }
                _data = GraphXMLReader.fromNodesXML(arrayList);
            }
            _data.setTime(l2);
        }
        return _data;
    }

    public static TopologyData createBaselineData() {
        ArrayList<String> arrayList;
        block2: {
            List list = GraphDao.getCustomerIDs(true);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            int n2 = list.size();
            boolean bl2 = DiscoveryOptions.c();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = (String)list.get(i2);
                String string2 = GraphDao.getGraph(new GraphID(string, "beans"), true);
                arrayList = arrayList2;
                if (bl2) {
                    arrayList.add(string2);
                    if (bl2) continue;
                }
                break block2;
            }
            arrayList = arrayList2;
        }
        return GraphXMLReader.fromNodesXML(arrayList);
    }

    public static void updateMasterGraph(TopologyData topologyData, CustomerNode customerNode) {
        NetworkGraphModel networkGraphModel = null;
        String string = GraphDao.getGraph(IGraphParameters.MASTER_MASTER);
        if (string != null) {
            networkGraphModel = GraphModelXMLReader.read(string, GraphDao.createData());
            networkGraphModel.insert(new Object[]{new NetworkNode(customerNode.getBean())}, null, null, null, null);
            LineLayoutAlgorithm.lineLayout(networkGraphModel);
        } else {
            HashMap<NetworkNodeBean, NetworkNode> hashMap = new HashMap<NetworkNodeBean, NetworkNode>();
            NetworkNodeBean networkNodeBean = customerNode.getBean();
            hashMap.put(networkNodeBean, new NetworkNode(networkNodeBean));
            networkGraphModel = new MasterGraphModel(topologyData, IGraphParameters.MASTER_MASTER, hashMap, null);
            LineLayoutAlgorithm.lineLayout(networkGraphModel);
        }
        GraphDao.saveGraph(networkGraphModel, "m");
    }

    public static String[] getIPsInSubnet(String string, String string2) {
        String[] stringArray = null;
        boolean bl2 = DiscoveryOptions.c();
        NetworkGraphModel networkGraphModel = GraphDao.getModel(new GraphID(string, string2));
        if (networkGraphModel != null) {
            ArrayList<String> arrayList;
            block3: {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                List list = networkGraphModel.getBeans();
                int n2 = list.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    NetworkNodeBean networkNodeBean = (NetworkNodeBean)list.get(i2);
                    String string3 = networkNodeBean.getIPInSubnet(string2);
                    arrayList = arrayList2;
                    if (bl2) {
                        arrayList.add(string3);
                        if (bl2) continue;
                    }
                    break block3;
                }
                arrayList = arrayList2;
            }
            stringArray = StringUtil.toStringArray(arrayList.toArray());
        }
        return stringArray;
    }

    public static NetworkGraphModel getModel(GraphID graphID) {
        String string = GraphDao.getGraph(graphID);
        if (string != null) {
            NetworkGraphModel networkGraphModel = GraphModelXMLReader.read(string, GraphDao.createData());
            networkGraphModel.setID(graphID);
            return networkGraphModel;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastModify() {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block4: {
            long l2;
            connection = DefaultConnection.getConnection();
            preparedStatement = null;
            resultSet = null;
            try {
                Timestamp timestamp;
                String string = "SELECT max(timestamp_c) FROM topo_graphdata";
                preparedStatement = connection.prepareStatement(string);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next() || (timestamp = resultSet.getTimestamp(1)) == null) break block4;
                l2 = timestamp.getTime();
            }
            catch (Exception exception) {
                try {
                    _logger.error((Object)"", (Throwable)exception);
                }
                catch (Throwable throwable) {
                    DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
                    throw throwable;
                }
                DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
            }
            DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
            return l2;
        }
        DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
        return _lastModify;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAsBaseLine() {
        Connection connection = DefaultConnection.getConnection();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string = "DELETE FROM topo_baseline_t";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.executeUpdate();
            string = "INSERT INTO topo_baseline_t SELECT * FROM topo_graphdata";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            _logger.error((Object)"", (Throwable)exception);
        }
        finally {
            DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
        }
    }

    public static Map<GraphID, NetworkGraphModel> getBaselineGraphs() {
        return GraphDao.getGraphs(true);
    }

    public static Map<GraphID, NetworkGraphModel> getGraphs() {
        return GraphDao.getGraphs(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Map<GraphID, NetworkGraphModel> getGraphs(boolean bl2) {
        HashMap<GraphID, NetworkGraphModel> hashMap;
        block13: {
            TopologyData topologyData;
            String string;
            boolean bl3 = DiscoveryOptions.c();
            try {
                string = bl2 ? "topo_baseline_t" : "topo_graphdata";
            }
            catch (Exception exception) {
                throw GraphDao.a(exception);
            }
            String string2 = string;
            hashMap = new HashMap<GraphID, NetworkGraphModel>();
            try {
                topologyData = bl2 ? GraphDao.createBaselineData() : GraphDao.createData();
            }
            catch (Exception exception) {
                throw GraphDao.a(exception);
            }
            TopologyData topologyData2 = topologyData;
            Statement statement = null;
            ResultSet resultSet = null;
            Connection connection = DefaultConnection.getConnection();
            try {
                String string3 = "SELECT * FROM " + string2;
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string3);
                while (resultSet.next()) {
                    block14: {
                        String string4 = resultSet.getString("domain_c");
                        String string5 = resultSet.getString("name_c");
                        InputStream inputStream = resultSet.getBinaryStream("data_c");
                        String string6 = StringUtil.getString(inputStream, "UTF-8");
                        String string7 = resultSet.getString("type_c");
                        if (!bl3) break block13;
                        try {
                            block15: {
                                if ("v".equals(string7)) break block14;
                                break block15;
                                catch (Exception exception) {
                                    throw GraphDao.a(exception);
                                }
                            }
                            if ("b".equals(string7)) break block14;
                        }
                        catch (Exception exception) {
                            throw GraphDao.a(exception);
                        }
                        GraphID graphID = new GraphID(string4, string5);
                        if (string6 == null) break block14;
                        NetworkGraphModel networkGraphModel = GraphModelXMLReader.read(string6, topologyData2);
                        networkGraphModel.setID(graphID);
                        hashMap.put(graphID, networkGraphModel);
                    }
                    if (bl3) continue;
                }
            }
            catch (Exception exception) {
                try {
                    _logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
                catch (Throwable throwable) {
                    DefaultConnection.closeConnection(connection, statement, resultSet);
                    throw throwable;
                }
                DefaultConnection.closeConnection(connection, statement, resultSet);
            }
            DefaultConnection.closeConnection(connection, statement, resultSet);
        }
        return hashMap;
    }

    private static TopologyData b() {
        TopologyData topologyData = new TopologyData();
        Customer customer = new Customer(ServerConfig.getCustomerID());
        customer.setDisplayName(ServerConfig.getCustomerName());
        customer.addTopoGraph(IGraphParameters.MASTER_MASTER);
        topologyData.addCustomer(new CustomerNode(customer));
        GraphDao.saveData(topologyData);
        NetworkNode networkNode = new NetworkNode(customer);
        HashMap<Customer, NetworkNode> hashMap = new HashMap<Customer, NetworkNode>();
        hashMap.put(customer, networkNode);
        MasterGraphModel masterGraphModel = new MasterGraphModel(topologyData, IGraphParameters.MASTER_MASTER, hashMap, null);
        LineLayoutAlgorithm.lineLayout(masterGraphModel);
        GraphDao.saveGraph(masterGraphModel, ((NetworkGraphModel)masterGraphModel).getGraphType());
        return topologyData;
    }

    public static void addCustomer(Probe probe) {
        String string = String.valueOf(probe.getId());
        TopologyData topologyData = GraphDao.createData();
        if (topologyData.getCustomer(string) == null) {
            Customer customer = new Customer(String.valueOf(probe.getId()));
            customer.setDisplayName(probe.getName());
            customer.addTopoGraph(IGraphParameters.MASTER_MASTER);
            CustomerNode customerNode = new CustomerNode(customer);
            topologyData.addCustomer(customerNode);
            GraphDao.saveData(topologyData);
            GraphDao.updateMasterGraph(topologyData, customerNode);
            CallbackServer.getInstance().notifyAllClients(null, "GraphLoaderProxy", "updateGraphs", null, null);
        }
    }

    public static void syncGraphData(List<GraphData> list) {
        Iterator<GraphData> iterator = list.iterator();
        boolean bl2 = DiscoveryOptions.d();
        while (iterator.hasNext()) {
            GraphData graphData = iterator.next();
            GraphDao.saveGraph(graphData);
            if (!bl2) continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<GraphData> c() {
        ArrayList<GraphData> arrayList;
        block9: {
            arrayList = null;
            Connection connection = DefaultConnection.getConnection();
            boolean bl2 = DiscoveryOptions.c();
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                String string = "SELECT * FROM topo_graphdata WHERE type_c<>?";
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setString(1, "v");
                resultSet = preparedStatement.executeQuery();
                arrayList = new ArrayList<GraphData>();
                while (resultSet.next()) {
                    String string2 = resultSet.getString("domain_c");
                    String string3 = resultSet.getString("name_c");
                    InputStream inputStream = resultSet.getBinaryStream("data_c");
                    String string4 = StringUtil.getString(inputStream, "UTF-8");
                    String string5 = resultSet.getString("type_c");
                    Timestamp timestamp = resultSet.getTimestamp("timestamp_c");
                    GraphData graphData = new GraphData(new GraphID(string2, string3), string4, string5, timestamp);
                    try {
                        arrayList.add(graphData);
                        if (bl2) {
                            if (bl2) continue;
                            break;
                        }
                        break block9;
                    }
                    catch (Exception exception) {
                        throw GraphDao.a(exception);
                    }
                }
                DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
            }
            catch (Exception exception) {
                _logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
            finally {
                DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
            }
        }
        return arrayList;
    }

    static {
        if (!GraphDao.hasTopologyData()) {
            _data = GraphDao.b();
            _data.setTime(GraphDao.getLastModify());
        }
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

