/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.discovery;

import com.sysuptime.common.model.DeviceBean;
import com.sysuptime.common.model.EthernetInterface;
import com.sysuptime.common.model.GenericNode;
import com.sysuptime.common.model.Host;
import com.sysuptime.common.model.ModelUtil;
import com.sysuptime.common.model.NetworkConnection;
import com.sysuptime.common.model.NetworkInterface;
import com.sysuptime.common.model.NetworkNode;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.common.model.RrpConnection;
import com.sysuptime.common.model.RrpInterface;
import com.sysuptime.common.model.Subnet;
import com.sysuptime.common.model.VirtualEthernetInterface;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.common.util.net.NetworkUtils;
import com.sysuptime.server.discovery.DiscoveryOptions;
import com.sysuptime.server.util.JNbtstat;
import com.sysuptime.server.util.NbInfo;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public final class DiscoveryUtil {
    public static NetworkConnection createConnection(NetworkInterface networkInterface, NetworkNodeBean networkNodeBean, String string) {
        NetworkInterface networkInterface2 = ModelUtil.getInterfaceByIp(networkNodeBean, string);
        if (networkInterface != null && networkInterface2 != null) {
            NetworkConnection networkConnection = null;
            networkConnection = networkInterface.getDedicated() == RrpInterface.DEDICATED ? new RrpConnection((EthernetInterface)networkInterface2, (RrpInterface)networkInterface) : (networkInterface2.getDedicated() == RrpInterface.DEDICATED ? new RrpConnection((EthernetInterface)networkInterface, (RrpInterface)networkInterface2) : new NetworkConnection(networkInterface2, networkInterface));
            return networkConnection;
        }
        return null;
    }

    public static NetworkConnection createConnection(NetworkNodeBean networkNodeBean, String string, NetworkNodeBean networkNodeBean2, String string2) {
        if (networkNodeBean instanceof DeviceBean && StringUtil.equals(string, string2)) {
            return null;
        }
        NetworkInterface networkInterface = ModelUtil.getInterfaceByIp(networkNodeBean, string);
        NetworkInterface networkInterface2 = ModelUtil.getInterfaceByIp(networkNodeBean2, string2);
        if (networkInterface == null || networkInterface2 == null) {
            return null;
        }
        NetworkConnection networkConnection = null;
        networkConnection = networkInterface.getDedicated() == RrpInterface.DEDICATED ? new RrpConnection((EthernetInterface)networkInterface2, (RrpInterface)networkInterface) : (networkInterface2.getDedicated() == RrpInterface.DEDICATED ? new RrpConnection((EthernetInterface)networkInterface, (RrpInterface)networkInterface2) : new NetworkConnection(networkInterface, networkInterface2));
        return networkConnection;
    }

    public static void getNbInfo(String string, NetworkNodeBean networkNodeBean, int n2) {
        block5: {
            DeviceBean deviceBean;
            NbInfo nbInfo;
            block6: {
                long l2 = System.currentTimeMillis();
                boolean bl2 = DiscoveryOptions.c();
                if (!(networkNodeBean instanceof Host) && !ModelUtil.isGenericNode(networkNodeBean) || (nbInfo = DiscoveryUtil.a(string, n2)) == null) break block5;
                NetworkInterface networkInterface = ModelUtil.getInterfaceByIp(networkNodeBean, string);
                if (networkInterface != null && ((EthernetInterface)networkInterface).getMacAddress().equals("")) {
                    ((EthernetInterface)networkInterface).setMacAddress(nbInfo.getMacAddress());
                }
                if (!(networkNodeBean instanceof Host)) break block6;
                deviceBean = (Host)networkNodeBean;
                deviceBean.setNetBiosName(nbInfo.getNbName());
                if (bl2) break block5;
            }
            if (ModelUtil.isGenericNode(networkNodeBean)) {
                deviceBean = (GenericNode)networkNodeBean;
                deviceBean.setNetBiosName(nbInfo.getNbName());
            }
        }
    }

    private static NbInfo a(String string, int n2) {
        ArrayList arrayList = JNbtstat.getNbInfo(string, n2);
        if (arrayList != null && arrayList.size() > 0) {
            return (NbInfo)arrayList.get(0);
        }
        return null;
    }

    public static boolean isInSubnet(Subnet subnet, NetworkNodeBean networkNodeBean) {
        String string = subnet.getIpAddress();
        NetworkInterface[] networkInterfaceArray = networkNodeBean.getInterfaces();
        boolean bl2 = DiscoveryOptions.d();
        for (int i2 = 0; i2 < networkInterfaceArray.length; ++i2) {
            String string2;
            if (networkInterfaceArray[i2].getDedicated() != EthernetInterface.DEDICATED || !NetworkUtils.isInSubnet(string2 = ((EthernetInterface)networkInterfaceArray[i2]).getIpAddress(), "255.255.255.0", string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInSubnet(NetworkConnection networkConnection, Subnet subnet) {
        NetworkInterface networkInterface = networkConnection.getNetworkInterface1();
        NetworkInterface networkInterface2 = networkConnection.getNetworkInterface2();
        if (networkInterface instanceof VirtualEthernetInterface && networkInterface2 instanceof EthernetInterface) {
            VirtualEthernetInterface virtualEthernetInterface = (VirtualEthernetInterface)networkInterface;
            EthernetInterface ethernetInterface = (EthernetInterface)networkInterface2;
            String string = subnet.getIpAddress();
            return virtualEthernetInterface.getIpAddress().equals(string) && NetworkUtils.isInSubnet(ethernetInterface.getIpAddress(), "255.255.255.0", string);
        }
        if (networkInterface instanceof EthernetInterface && networkInterface2 instanceof VirtualEthernetInterface) {
            EthernetInterface ethernetInterface = (EthernetInterface)networkInterface;
            VirtualEthernetInterface virtualEthernetInterface = (VirtualEthernetInterface)networkInterface2;
            String string = subnet.getIpAddress();
            return virtualEthernetInterface.getIpAddress().equals(string) && NetworkUtils.isInSubnet(ethernetInterface.getIpAddress(), "255.255.255.0", string);
        }
        return false;
    }

    public static Map createNodesAndMap(List list) {
        Hashtable<NetworkNodeBean, NetworkNode> hashtable;
        Hashtable<NetworkNodeBean, NetworkNode> hashtable2 = new Hashtable<NetworkNodeBean, NetworkNode>();
        boolean bl2 = DiscoveryOptions.c();
        if (list != null) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                NetworkNodeBean networkNodeBean = (NetworkNodeBean)list.get(i2);
                NetworkNode networkNode = new NetworkNode(networkNodeBean);
                hashtable = hashtable2;
                if (bl2) {
                    hashtable.put(networkNodeBean, networkNode);
                    if (bl2) continue;
                }
                break;
            }
        } else {
            hashtable = hashtable2;
        }
        return hashtable;
    }

    public static NetworkConnection[] list2ConnectionArray(List list) {
        NetworkConnection[] networkConnectionArray;
        NetworkConnection[] networkConnectionArray2 = null;
        boolean bl2 = DiscoveryOptions.c();
        if (list != null) {
            networkConnectionArray2 = new NetworkConnection[list.size()];
            for (int i2 = 0; i2 < networkConnectionArray2.length; ++i2) {
                networkConnectionArray = networkConnectionArray2;
                if (bl2) {
                    networkConnectionArray[i2] = (NetworkConnection)list.get(i2);
                    if (bl2) continue;
                }
                break;
            }
        } else {
            networkConnectionArray = networkConnectionArray2;
        }
        return networkConnectionArray;
    }
}

