/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.discovery;

import com.sysuptime.common.discovery.CreationOptions;
import com.sysuptime.common.discovery.DiscoveryFilter;
import com.sysuptime.common.discovery.DiscoveryOptionsData;
import com.sysuptime.common.discovery.IPRange;
import com.sysuptime.common.discovery.PortInfo;
import com.sysuptime.common.discovery.ReadCommunity;
import com.sysuptime.common.discovery.SshData;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.common.util.net.NetworkUtils;
import com.sysuptime.server.msp.Command;
import com.sysuptime.server.util.ServerConfig;
import java.lang.invoke.StringConcatFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DiscoveryOptions
implements CreationOptions {
    private static final Logger _logger = Logger.getLogger((String)DiscoveryOptions.class.getName());
    private static final DiscoveryOptions _instance;
    private String _seed;
    private boolean _discoveryPublic;
    private int _hops;
    private int _timeout = 800;
    private int _threads = 11;
    private boolean _ignoreNonSnmp;
    private boolean _cleanDiscovery = true;
    private boolean _scanServicesEnabled;
    private List _scanServices;
    private ReadCommunity[] _readCommunities;
    private HashMap _ipCommunities = new HashMap();
    private HashSet _wildCommunities = new HashSet();
    private List _filters;
    private Set _ignoreFilters = new HashSet();
    private Set _mustFilters = new HashSet();
    private static boolean a;

    private DiscoveryOptions() {
    }

    public static DiscoveryOptions getInstance() {
        return _instance;
    }

    public void synchronize() {
        String string;
        this._seed = ServerConfig.getProperty("discovery.seed");
        boolean bl2 = DiscoveryOptions.d();
        if (this._seed == null) {
            this.saveDiscoveryOptions(null, DiscoveryOptions.getDefaultOptions());
        }
        String string2 = ServerConfig.getProperty("discovery.discoverPublic");
        this._discoveryPublic = Boolean.TRUE.toString().equalsIgnoreCase(string2);
        String string3 = ServerConfig.getProperty("discovery.hops");
        if (string3 != null) {
            this._hops = Integer.parseInt(string3);
        }
        if ((string = ServerConfig.getProperty("discovery.timeout")) != null) {
            this._timeout = Integer.parseInt(string);
        }
        String string4 = ServerConfig.getProperty("discovery.threads");
        if (string != null) {
            this._threads = Integer.parseInt(string4);
        }
        String string5 = ServerConfig.getProperty("discovery.ignoreNonSnmp");
        this._ignoreNonSnmp = Boolean.TRUE.toString().equalsIgnoreCase(string5);
        String string6 = ServerConfig.getProperty("discovery.cleanDiscovery");
        this._cleanDiscovery = Boolean.TRUE.toString().equalsIgnoreCase(string6);
        this._scanServicesEnabled = Boolean.valueOf(ServerConfig.getProperty("discovery.scanServicesEnabled"));
        this._scanServices = PortInfo.asList(ServerConfig.getProperty("discovery.scanServices"));
        this.a();
        String string7 = ServerConfig.getProperty("discovery.filters");
        this._filters = this.a(string7);
        this._ignoreFilters.clear();
        this._mustFilters.clear();
        if (this._filters != null) {
            for (int i2 = 0; i2 < this._filters.size(); ++i2) {
                DiscoveryFilter discoveryFilter = (DiscoveryFilter)this._filters.get(i2);
                if (discoveryFilter.getMode().equals("IGNORE")) {
                    this._ignoreFilters.add(discoveryFilter);
                    if (!bl2) continue;
                }
                if (!discoveryFilter.getMode().equals("MUST")) continue;
                this._mustFilters.add(discoveryFilter);
                if (!bl2) continue;
            }
        }
    }

    private void a() {
        String string = ServerConfig.getProperty("discovery.readCommunities");
        boolean bl2 = DiscoveryOptions.d();
        this._readCommunities = ReadCommunity.asReadCommunities(string);
        this._ipCommunities.clear();
        this._wildCommunities.clear();
        if (this._readCommunities != null) {
            for (int i2 = 0; i2 < this._readCommunities.length; ++i2) {
                if (this._readCommunities[i2].isWild()) {
                    this._wildCommunities.add(this._readCommunities[i2]);
                    if (!bl2) continue;
                }
                this._ipCommunities.put(this._readCommunities[i2].getIpAddress(), this._readCommunities[i2]);
                if (!bl2) continue;
            }
        }
    }

    public boolean saveSshHosts(String string, String string2) {
        return ServerConfig.updateProperty("ssh.data:" + string, string2);
    }

    public boolean saveReadCommunities(ReadCommunity[] readCommunityArray) {
        String string = ReadCommunity.asXML(readCommunityArray);
        boolean bl2 = ServerConfig.updateProperty("discovery.readCommunities", string);
        this.a();
        return bl2;
    }

    public ReadCommunity[] getReadCommunities() {
        this.a();
        return this._readCommunities;
    }

    public DiscoveryOptionsData getDiscoveryOptionsData(String string) {
        this.synchronize();
        if (this._seed != null) {
            String string2 = ServerConfig.getProperty("ssh.data:" + string);
            SshData sshData = null;
            if (string2 != null) {
                sshData = new SshData(string2);
            }
            return new DiscoveryOptionsData(this._seed, this._discoveryPublic, this._hops, this._timeout, this._threads, this._readCommunities, this._ignoreNonSnmp, this._cleanDiscovery, this._scanServicesEnabled, this._scanServices, this._filters, sshData);
        }
        return DiscoveryOptions.getDefaultOptions();
    }

    public static DiscoveryOptionsData getDefaultOptions() {
        String string = NetworkUtils.getDefaultGateway();
        if (string == null) {
            string = "";
        }
        return new DiscoveryOptionsData(string, false, 2, 2000, 30, null, false, false, false, null, null, null);
    }

    public boolean saveDiscoveryOptions(String string, DiscoveryOptionsData discoveryOptionsData) {
        String string2 = discoveryOptionsData.getSeed();
        boolean bl2 = DiscoveryOptions.c();
        if (string2 == null || string2.length() == 0) {
            string2 = NetworkUtils.getDefaultGateway();
        }
        boolean bl3 = discoveryOptionsData.isDiscoverPublic();
        int n2 = discoveryOptionsData.getHops();
        int n3 = discoveryOptionsData.getTimeout();
        int n4 = discoveryOptionsData.getTheadsNumber();
        boolean bl4 = discoveryOptionsData.ignoreNonSnmp();
        boolean bl5 = discoveryOptionsData.cleanDiscovery();
        boolean bl6 = discoveryOptionsData.scanServicesEnabled();
        ReadCommunity[] readCommunityArray = discoveryOptionsData.getReadCommunities();
        String string3 = ReadCommunity.asXML(readCommunityArray);
        List list = discoveryOptionsData.getFilters();
        String string4 = this.a(list);
        boolean bl7 = ServerConfig.updateProperty("discovery.seed", string2);
        bl7 = bl7 && ServerConfig.updateProperty("discovery.discoverPublic", "" + bl3);
        bl7 = bl7 && ServerConfig.updateProperty("discovery.hops", "" + n2);
        bl7 = bl7 && ServerConfig.updateProperty("discovery.timeout", "" + n3);
        bl7 = bl7 && ServerConfig.updateProperty("discovery.threads", "" + n4);
        bl7 = bl7 && ServerConfig.updateProperty("discovery.readCommunities", string3);
        bl7 = bl7 && ServerConfig.updateProperty("discovery.ignoreNonSnmp", "" + bl4);
        bl7 = bl7 && ServerConfig.updateProperty("discovery.cleanDiscovery", "" + bl5);
        bl7 = bl7 && ServerConfig.updateProperty("discovery.scanServicesEnabled", "" + bl6);
        bl7 = bl7 && ServerConfig.updateProperty("discovery.scanServices", PortInfo.asXML(discoveryOptionsData.getScanServices()));
        boolean bl8 = bl7 = bl7 && ServerConfig.updateProperty("discovery.filters", string4);
        if (string != null && discoveryOptionsData.getSshData() != null) {
            boolean bl9 = bl7 = bl7 && this.saveSshHosts(string, discoveryOptionsData.getSshData().toString());
        }
        if (!bl2) {
            Command.b(new int[2]);
        }
        return bl7;
    }

    /*
     * Loose catch block
     */
    private String a(List list) {
        String string;
        block9: {
            Document document;
            block12: {
                document = DocumentHelper.createDocument();
                boolean bl2 = DiscoveryOptions.c();
                Element element = document.addElement("filters");
                if (list == null) break block12;
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    Object object;
                    String string2;
                    DiscoveryFilter discoveryFilter;
                    block11: {
                        block10: {
                            discoveryFilter = (DiscoveryFilter)list.get(i2);
                            string2 = discoveryFilter.getIpRange();
                            try {
                                string = string2;
                                if (!bl2) break block9;
                                if (!string.equals("*")) break block10;
                            }
                            catch (UnknownHostException unknownHostException) {
                                throw DiscoveryOptions.a(unknownHostException);
                            }
                            string2 = "";
                        }
                        if (string2.length() <= 0) break block11;
                        try {
                            block13: {
                                if (StringUtil.isValidIpRange(string2)) break block11;
                                break block13;
                                catch (UnknownHostException unknownHostException) {
                                    throw DiscoveryOptions.a(unknownHostException);
                                }
                            }
                            if (StringUtil.isValidIPSegment(string2)) break block11;
                        }
                        catch (UnknownHostException unknownHostException) {
                            throw DiscoveryOptions.a(unknownHostException);
                        }
                        try {
                            object = InetAddress.getByName(string2);
                            string2 = ((InetAddress)object).getHostAddress();
                        }
                        catch (UnknownHostException unknownHostException) {
                            if (bl2) continue;
                        }
                    }
                    object = element.addElement("filter");
                    Element element2 = object.addElement("ipRange");
                    element2.addCDATA(string2);
                    element2 = object.addElement("systemName");
                    element2.addCDATA(discoveryFilter.getSysName());
                    element2 = object.addElement("description");
                    element2.addCDATA(discoveryFilter.getSysDescr());
                    element2 = object.addElement("systemType");
                    element2.addCDATA(StringUtil.asString(discoveryFilter.getSystemTypes(), ","));
                    element2 = object.addElement("mode");
                    element2.addCDATA(discoveryFilter.getMode());
                    if (bl2) continue;
                }
            }
            string = document.asXML();
        }
        return string;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List a(String string) {
        boolean bl2;
        block11: {
            bl2 = DiscoveryOptions.c();
            if (string == null) return null;
            try {
                if (string.length() != 0) break block11;
                return null;
                catch (DocumentException documentException) {
                    throw DiscoveryOptions.a((Exception)((Object)documentException));
                }
            }
            catch (DocumentException documentException) {
                throw DiscoveryOptions.a((Exception)((Object)documentException));
            }
        }
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)string);
        }
        catch (DocumentException documentException) {
            _logger.error((Object)"string2Filters", (Throwable)documentException);
            return null;
        }
        Element element = document.getRootElement();
        int n2 = element.nodeCount();
        try {
            if (n2 == 0) {
                return null;
            }
        }
        catch (DocumentException documentException) {
            throw DiscoveryOptions.a((Exception)((Object)documentException));
        }
        ArrayList<DiscoveryFilter> arrayList = new ArrayList<DiscoveryFilter>();
        for (int i2 = 0; i2 < n2; ++i2) {
            Element element2 = (Element)element.node(i2);
            Object object = ((Element)element2.node(0)).getData().toString();
            if (((String)object).endsWith(".0")) {
                object = ((String)object).substring(0, ((String)object).lastIndexOf(46) + 1) + "*";
            }
            String string2 = ((Element)element2.node(1)).getData().toString();
            String string3 = ((Element)element2.node(2)).getData().toString();
            String[] stringArray = StringUtil.split(((Element)element2.node(3)).getData().toString(), ",");
            String string4 = ((Element)element2.node(4)).getData().toString();
            arrayList.add(new DiscoveryFilter((String)object, string2, string3, stringArray, string4));
            if (bl2) continue;
        }
        return arrayList;
    }

    public String getSeed() {
        return this._seed;
    }

    public boolean isDiscoveryPublic() {
        return this._discoveryPublic;
    }

    public int getHops() {
        return this._hops;
    }

    @Override
    public int getTimeout() {
        return this._timeout;
    }

    public int getThreads() {
        return this._threads;
    }

    public HashSet getWildCommunities() {
        return this._wildCommunities;
    }

    public HashMap getIpCommunities() {
        return this._ipCommunities;
    }

    public boolean ignoreNonSnmp() {
        return this._ignoreNonSnmp;
    }

    public boolean cleanDiscovery() {
        return this._cleanDiscovery;
    }

    @Override
    public boolean isScanServicesEnabled() {
        return this._scanServicesEnabled;
    }

    @Override
    public List getScanServices() {
        return this.b();
    }

    private List b() {
        ArrayList<PortInfo> arrayList;
        block2: {
            ArrayList<PortInfo> arrayList2 = new ArrayList<PortInfo>();
            boolean bl2 = DiscoveryOptions.c();
            int n2 = this._scanServices.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList = arrayList2;
                if (bl2) {
                    arrayList.add(((PortInfo)this._scanServices.get(i2)).copy());
                    if (bl2) continue;
                }
                break block2;
            }
            arrayList = arrayList2;
        }
        return arrayList;
    }

    public boolean isValidIP(String string, boolean bl2) {
        boolean bl3;
        block7: {
            Iterator iterator = null;
            boolean bl4 = DiscoveryOptions.c();
            if (bl2) {
                if (this._mustFilters == null) {
                    return false;
                }
                iterator = this._mustFilters.iterator();
            } else {
                if (this._ignoreFilters == null) {
                    return true;
                }
                iterator = this._ignoreFilters.iterator();
            }
            while (iterator.hasNext()) {
                DiscoveryFilter discoveryFilter = (DiscoveryFilter)iterator.next();
                bl3 = discoveryFilter.onlyFilterIP();
                if (bl4) {
                    if (bl3 && discoveryFilter.isValidIp(string)) {
                        return bl2;
                    }
                    if (bl4) continue;
                }
                break block7;
            }
            bl3 = true;
        }
        return bl3;
    }

    public boolean isValid(String string, String string2, String[] stringArray, String string3, boolean bl2) {
        boolean bl3;
        block7: {
            Iterator iterator = null;
            boolean bl4 = DiscoveryOptions.c();
            if (bl2) {
                if (this._mustFilters == null) {
                    return false;
                }
                iterator = this._mustFilters.iterator();
            } else {
                if (this._ignoreFilters == null) {
                    return true;
                }
                iterator = this._ignoreFilters.iterator();
            }
            while (iterator.hasNext()) {
                DiscoveryFilter discoveryFilter = (DiscoveryFilter)iterator.next();
                bl3 = discoveryFilter.match(string, string2, stringArray, string3);
                if (bl4) {
                    if (bl3) {
                        return bl2;
                    }
                    if (bl4) continue;
                }
                break block7;
            }
            bl3 = bl2;
        }
        return !bl3;
    }

    public IPRange getMustIpRange() {
        IPRange iPRange;
        block2: {
            IPRange iPRange2 = new IPRange();
            boolean bl2 = DiscoveryOptions.c();
            for (Object e10 : this._mustFilters) {
                DiscoveryFilter discoveryFilter = (DiscoveryFilter)e10;
                String string = discoveryFilter.getIpRange();
                iPRange = iPRange2;
                if (bl2) {
                    iPRange.addExpression(string);
                    if (bl2) continue;
                }
                break block2;
            }
            iPRange = iPRange2;
        }
        return iPRange;
    }

    public boolean isValidMust(String string, String string2, String[] stringArray, String string3) {
        boolean bl2;
        block2: {
            boolean bl3 = DiscoveryOptions.d();
            for (int i2 = 0; i2 < this._filters.size(); ++i2) {
                DiscoveryFilter discoveryFilter = (DiscoveryFilter)this._filters.get(i2);
                bl2 = discoveryFilter.getMode().equals("MUST");
                if (!bl3) {
                    if (!bl2 || !discoveryFilter.match(string, string2, stringArray, string3)) continue;
                    return true;
                }
                break block2;
            }
            bl2 = false;
        }
        return bl2;
    }

    public String toString() {
        StringBuffer stringBuffer;
        block14: {
            block15: {
                stringBuffer = new StringBuffer();
                stringBuffer.append("seed = ");
                boolean bl2 = DiscoveryOptions.c();
                stringBuffer.append(this._seed);
                stringBuffer.append("\ndiscoverPublic = ");
                stringBuffer.append(this._discoveryPublic);
                stringBuffer.append("\nhops = ");
                stringBuffer.append(this._hops);
                stringBuffer.append("\ntimeout = ");
                stringBuffer.append(this._timeout);
                stringBuffer.append("\nwild communities: ");
                boolean bl3 = bl2;
                if (this._wildCommunities != null) {
                    Iterator<Object> iterator = this._wildCommunities.iterator();
                    while (iterator.hasNext()) {
                        stringBuffer.append("\n");
                        stringBuffer.append(iterator.next());
                        if (bl3) {
                            if (bl3) continue;
                        }
                        break;
                    }
                } else {
                    stringBuffer.append("\nip communities: ");
                }
                if (this._ipCommunities != null) {
                    for (Object object : this._ipCommunities.keySet()) {
                        stringBuffer.append("\nip = ");
                        stringBuffer.append(object);
                        if (bl3) {
                            if (bl3) continue;
                        }
                        break;
                    }
                } else {
                    stringBuffer.append("\nignore non-snmp: ");
                    stringBuffer.append(this._ignoreNonSnmp);
                    stringBuffer.append("\nclean discovery: ");
                    stringBuffer.append(this._cleanDiscovery);
                }
                if (this._filters == null) break block15;
                stringBuffer.append("\nfilters: ");
                for (int i2 = 0; i2 < this._filters.size(); ++i2) {
                    Object object;
                    object = (DiscoveryFilter)this._filters.get(i2);
                    stringBuffer.append("\n");
                    stringBuffer.append(object);
                    if (bl3) {
                        if (bl3) continue;
                    }
                    break block14;
                }
                if (bl3) break block14;
            }
            stringBuffer.append((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\nfilters = null"})));
        }
        return stringBuffer.toString();
    }

    public void addMustFilter(DiscoveryFilter discoveryFilter) {
        this._mustFilters.add(discoveryFilter);
    }

    static {
        DiscoveryOptions.b(true);
        _instance = new DiscoveryOptions();
    }

    public static void b(boolean bl2) {
        a = bl2;
    }

    public static boolean c() {
        return a;
    }

    public static boolean d() {
        boolean bl2 = DiscoveryOptions.c();
        return !bl2;
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

