/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.tree;

import com.jgoodies.looks.plastic.PlasticTreeUI;
import com.sysuptime.common.graph.GraphID;
import com.sysuptime.common.graph.IGraphParameters;
import com.sysuptime.common.graph.NetworkGraphModel;
import com.sysuptime.common.model.NetworkConnection;
import com.sysuptime.common.model.NetworkNode;
import com.sysuptime.mainframe.AlarmViewController;
import com.sysuptime.mainframe.ConsoleComponent;
import com.sysuptime.mainframe.ViewComponent;
import com.sysuptime.mainframe.actions.ToBackAction;
import com.sysuptime.mainframe.graph.NetworkGraph;
import com.sysuptime.mainframe.nodes.BeanTreeNode;
import com.sysuptime.mainframe.nodes.NetConnectionNode;
import com.sysuptime.mainframe.nodes.TreeNode;
import com.sysuptime.mainframe.tree.TreeManager;
import com.sysuptime.server.msp.Command;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import org.apache.log4j.Logger;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.netbeans.core.NbSheet;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;

public abstract class ExplorerTreeView
extends BeanTreeView
implements TreeSelectionListener,
GraphModelListener {
    private static final Logger _logger = Logger.getLogger((String)ExplorerTreeView.class.getName());
    private NetworkGraph _graph;
    private ExplorerManager _explorerManager;
    protected TreeNode _rootNode;
    private TreeManager _treeManager;
    protected transient Map _connectionNodes = new Hashtable();
    private transient Node[] _selectedNodes;

    public ExplorerTreeView(ExplorerManager explorerManager, NetworkGraph networkGraph, TreeNode treeNode) {
        this._graph = networkGraph;
        this._explorerManager = explorerManager;
        this._rootNode = treeNode;
        this.tree.setUI((TreeUI)new PlasticTreeUI());
        this.tree.addTreeSelectionListener(this);
        this.createTree(this._graph);
    }

    private void a() {
        block2: {
            Iterator iterator = this._connectionNodes.values().iterator();
            boolean bl2 = TreeManager.c();
            while (iterator.hasNext()) {
                AlarmViewController.INSTANCE.removePropertyChangeListener((NetConnectionNode)iterator.next());
                if (!bl2) {
                    if (!bl2) continue;
                }
                break block2;
            }
            this._connectionNodes.clear();
        }
    }

    public void createTree(NetworkGraph networkGraph) {
        block6: {
            block5: {
                boolean bl2 = TreeManager.c();
                this.a();
                boolean bl3 = bl2;
                if (networkGraph == null) {
                    return;
                }
                this._graph = networkGraph;
                this.clearSelection();
                this._rootNode.removeAllChildren();
                if (this._graph.isTopology()) break block5;
                this._rootNode.setDisplayName(this._graph.getGraphID().getGraphName());
                if (!bl3) break block6;
            }
            this._rootNode.setDisplayName(IGraphParameters.TOPOLOGY_VIEW);
        }
        this._treeManager = this.a(this._graph);
        this._treeManager.createTree();
        if (this._rootNode.getChildren() != null && this._rootNode.getChildren().getNodes() != null && this._rootNode.getChildren().getNodes().length > 0) {
            this.expandNode(this._rootNode.getChildren().getNodes()[0]);
        }
        this.updateStatus();
    }

    protected abstract TreeManager a(NetworkGraph var1);

    public void selectTreeNodeByGraphVertexes(Object[] objectArray) {
        Node[] nodeArray;
        block10: {
            block11: {
                Object object;
                boolean bl2;
                int n2;
                block9: {
                    int n3;
                    NetConnectionNode netConnectionNode;
                    Node[] nodeArray2;
                    block8: {
                        nodeArray2 = new Node[objectArray.length];
                        netConnectionNode = null;
                        n2 = 0;
                        bl2 = TreeManager.c();
                        for (int i2 = 0; i2 < objectArray.length; ++i2) {
                            n3 = objectArray[i2] instanceof NetworkNode;
                            if (!bl2) {
                                if (n3 != 0) {
                                    object = this._treeManager.getTreeNode((NetworkNode)objectArray[i2], (NetworkGraphModel)this._graph.getModel());
                                    if (object instanceof Node) {
                                        nodeArray2[n2] = (Node)object;
                                        ++n2;
                                    }
                                    if (!bl2) continue;
                                    Command.b(new int[5]);
                                }
                                if (!(objectArray[i2] instanceof NetworkConnection) || netConnectionNode != null || (netConnectionNode = (NetConnectionNode)this._connectionNodes.get(object = (NetworkConnection)objectArray[i2])) != null) continue;
                                netConnectionNode = new NetConnectionNode((NetworkConnection)objectArray[i2]);
                                AlarmViewController.INSTANCE.addPropertyChangeListener(netConnectionNode);
                                this._connectionNodes.put(object, netConnectionNode);
                                if (!bl2) continue;
                            }
                            break block8;
                        }
                        n3 = n2;
                    }
                    nodeArray = new Node[n3];
                    System.arraycopy(nodeArray2, 0, nodeArray, 0, n2);
                    object = NbSheet.findDefault();
                    object.setVisible(true);
                    if (n2 != 0 || netConnectionNode == null) break block9;
                    this._selectedNodes = new Node[]{netConnectionNode};
                    object.setNodes(this._selectedNodes);
                    if (!bl2) break block10;
                }
                if (n2 <= 0) break block11;
                Node node = nodeArray[n2 - 1];
                object.setNodes(new Node[]{node});
                this._selectedNodes = null;
                if (!bl2) break block10;
            }
            NbSheet.findDefault().setNodes(nodeArray);
            this._selectedNodes = null;
        }
        this.setSelectedTreeNodes(nodeArray);
    }

    public void setSelectedTreeNodes(Node[] nodeArray) {
        try {
            this._explorerManager.setSelectedNodes(nodeArray);
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    public Node[] getSelectedNodes() {
        Node[] nodeArray = this._explorerManager.getSelectedNodes();
        if (nodeArray == null || nodeArray.length == 0) {
            nodeArray = this._selectedNodes;
        }
        return nodeArray;
    }

    public void clearSelection() {
        Node[] nodeArray = new Node[]{};
        this.setSelectedTreeNodes(nodeArray);
        NbSheet.findDefault().setNodes(nodeArray);
    }

    public void selectRoot() {
        this.setSelectedTreeNodes(new Node[]{this._rootNode});
    }

    public TreeNode findTreeNodeByGraphNode(NetworkNode networkNode) {
        return this._treeManager.getTreeNode(networkNode, (NetworkGraphModel)this._graph.getModel());
    }

    public TreeNode getRootNode() {
        return this._rootNode;
    }

    public void clearTree() {
        this._rootNode.removeAllChildren();
        this._rootNode.setDisplayName("");
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.a(this._explorerManager.getSelectedNodes());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void a(Node[] nodeArray) {
        block3: {
            GraphID graphID;
            boolean bl2;
            ViewComponent viewComponent;
            block4: {
                viewComponent = ConsoleComponent.getInstance().getCurrentComponent();
                bl2 = TreeManager.c();
                NetworkGraph networkGraph = ConsoleComponent.getInstance().getCurrentGraph();
                if (networkGraph == null) return;
                graphID = networkGraph.getGraphID();
                if (networkGraph.isView() || nodeArray.length <= 0) break block3;
                if (nodeArray[nodeArray.length - 1] != this._explorerManager.getRootContext()) break block4;
                if (networkGraph.isMaster()) break block3;
                ((ToBackAction)SystemAction.get(ToBackAction.class)).updateBackAction(viewComponent.getViewID());
                viewComponent.loadGraph(IGraphParameters.MASTER_MASTER, false);
                if (!bl2) break block3;
            }
            for (int i2 = nodeArray.length - 1; i2 >= 0; --i2) {
                if (bl2) return;
                if (!(nodeArray[i2] instanceof BeanTreeNode)) continue;
                GraphID graphID2 = ((BeanTreeNode)nodeArray[i2]).getGraphID();
                if (graphID2 == null || graphID2.equals(graphID)) break;
                ((ToBackAction)SystemAction.get(ToBackAction.class)).updateBackAction(viewComponent.getViewID());
                viewComponent.loadGraph(graphID2, false);
                if (!bl2) break;
                if (!bl2) continue;
            }
        }
        this.b(nodeArray);
    }

    private void b(Node[] nodeArray) {
        boolean bl2;
        ArrayList<NetworkNode> arrayList;
        NetworkGraph networkGraph;
        block3: {
            networkGraph = ConsoleComponent.getInstance().getCurrentGraph();
            arrayList = new ArrayList<NetworkNode>();
            boolean bl3 = TreeManager.c();
            for (int i2 = 0; i2 < nodeArray.length; ++i2) {
                bl2 = nodeArray[i2] instanceof BeanTreeNode;
                if (!bl3) {
                    if (!bl2) continue;
                    BeanTreeNode beanTreeNode = (BeanTreeNode)nodeArray[i2];
                    NetworkGraphModel networkGraphModel = (NetworkGraphModel)networkGraph.getModel();
                    NetworkNode networkNode = networkGraphModel.getNodeByBean(beanTreeNode.getBean());
                    if (networkNode == null) continue;
                    arrayList.add(networkNode);
                    if (!bl3) continue;
                }
                break block3;
            }
            bl2 = arrayList.isEmpty();
        }
        if (!bl2) {
            networkGraph.scrollCellToVisible(arrayList.get(0));
            networkGraph.setSelectionCells(arrayList.toArray());
        }
    }

    public void updateStatus() {
        if (this._treeManager != null) {
            this._treeManager.updateStatus();
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public void graphChanged(GraphModelEvent graphModelEvent) {
        block11: {
            NetworkNode networkNode;
            int n2;
            boolean bl2;
            Object[] objectArray;
            block10: {
                int n3;
                GraphModelEvent.GraphModelChange graphModelChange = graphModelEvent.getChange();
                Object[] objectArray2 = graphModelChange.getInserted();
                objectArray = graphModelChange.getRemoved();
                bl2 = TreeManager.b();
                if (objectArray2 != null) {
                    for (n2 = 0; n2 < objectArray2.length; ++n2) {
                        n3 = objectArray2[n2] instanceof NetworkNode;
                        if (bl2) {
                            if (n3 == 0) continue;
                            networkNode = (NetworkNode)objectArray2[n2];
                            this._treeManager.insert(networkNode, (NetworkGraphModel)this._graph.getModel());
                            if (bl2) continue;
                        }
                        break block10;
                    }
                }
                if (objectArray == null) break block11;
                n3 = n2 = 0;
            }
            while (n2 < objectArray.length) {
                if (objectArray[n2] instanceof NetworkNode) {
                    networkNode = (NetworkNode)objectArray[n2];
                    this._treeManager.remove(networkNode, (NetworkGraphModel)this._graph.getModel());
                }
                ++n2;
                if (bl2) continue;
            }
        }
    }
}

