/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.performance.Timebucket;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.DialogProvider;
import com.sysuptime.mainframe.performance.MonitorBroker;
import com.sysuptime.mainframe.performance.OperationDialog;
import com.sysuptime.mainframe.performance.PerformanceUIUtil;
import com.sysuptime.mainframe.performance.ReadOnlyTableModel;
import com.sysuptime.mainframe.performance.SelectionValidator;
import com.sysuptime.mainframe.performance.SingletonScheduleBroker;
import com.sysuptime.mainframe.performance.SingletonValidator;
import com.sysuptime.mainframe.performance.TimebucketListTableCell;
import com.sysuptime.mainframe.util.SwingUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;

public class TimebucketListDialog
extends OperationDialog {
    private static final String MESSAGE_PUT_TIMEBUCKET = _bundle.getString("message_puttimebucket");
    private static final String MESSAGE_REMOVE_TIMEBUCKET = _bundle.getString("message_removetimebucket");
    private static final String[] COLUMNS = new String[]{DialogConstants.LABEL_NAME, DialogConstants.LABEL_IN_USE};
    private JTable _timebucketListTable;
    private ReadOnlyTableModel _timebucketListModel;
    private List _timebucketList = new ArrayList();
    private List _addTimebucketList = new ArrayList();
    private List _removeIdList = new ArrayList();
    private List _modifyTimebucketList = new ArrayList();
    private static final String TITLE_CONFIG_TIMEBUCKET = _bundle.getString("title_configtimebucket");

    public TimebucketListDialog(Dialog dialog, boolean bl2) {
        super(dialog, TITLE_CONFIG_TIMEBUCKET, bl2);
        this.initTimebucketList();
        this.initComponents();
        this.initUserData();
    }

    public TimebucketListDialog(JFrame jFrame, boolean bl2) {
        super(jFrame, TITLE_CONFIG_TIMEBUCKET, bl2);
        this.initTimebucketList();
        this.initComponents();
        this.initUserData();
    }

    private void initTimebucketList() {
        this._timebucketList.addAll(MonitorBroker.getNoUseStateTimebuckets());
    }

    private void initComponents() {
        Container container = this.getContentPane();
        container.add((Component)this.getBodyPanel(), "Center");
        container.add((Component)this.getConfirmPanel(), "South");
        this.pack();
    }

    private JPanel getBodyPanel() {
        FormLayout formLayout = new FormLayout("p:g,5dlu,p", "p,5dlu,p:g");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        this._timebucketListModel = new ReadOnlyTableModel(null, COLUMNS);
        this._timebucketListTable = SwingUtil.createJTable(this._timebucketListModel);
        PerformanceUIUtil.setGraceHeader(this._timebucketListTable);
        this._timebucketListTable.setSelectionMode(0);
        ListSelectionModel listSelectionModel = this._timebucketListTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new TimebucketListSelection());
        this._timebucketListTable.setPreferredScrollableViewportSize(new Dimension(250, 200));
        JScrollPane jScrollPane = new JScrollPane(this._timebucketListTable);
        panelBuilder.add((Component)jScrollPane, cellConstraints.xywh(1, 1, 1, 3));
        panelBuilder.add((Component)this.getOperationPanel(false, true), cellConstraints.xy(3, 1));
        this.getAddButton().setPreferredSize(DialogConstants.LONG_SIZE);
        this.getRemoveButton().setPreferredSize(DialogConstants.LONG_SIZE);
        this.getModifyButton().setPreferredSize(DialogConstants.LONG_SIZE);
        return panelBuilder.getPanel();
    }

    private void initUserData() {
        List list = SingletonScheduleBroker.getUsedTimebucketIdList();
        this._timebucketListTable.getColumnModel().getColumn(0).setCellRenderer(new TimebucketListNameRenderer());
        int n2 = this._timebucketList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Timebucket timebucket = (Timebucket)this._timebucketList.get(i2);
            boolean bl2 = false;
            bl2 = "7*24".equalsIgnoreCase(timebucket.getTimebucketName()) ? true : this.comparedTimebuckets(timebucket, list);
            this._timebucketListModel.addRow(new Object[]{new TimebucketListTableCell(timebucket, true, false), bl2 ? ICommonBundle.YES : ICommonBundle.NO});
        }
    }

    private boolean comparedTimebuckets(Timebucket timebucket, List list) {
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Long l2 = (Long)list.get(i2);
            if (l2.longValue() != timebucket.getTimebucketId()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void addItem() {
        DialogProvider.createTimebucketDialog(this, DialogConstants.BUTTON_NEW, this._timebucketListModel, -1);
    }

    @Override
    protected void removeItem() {
        String[] stringArray;
        int n2;
        int n3 = this._timebucketListTable.getSelectedRow();
        Object object = SingletonValidator.checkAllDialog(this, DialogConstants.MESSAGE_ONE_ROW, n3, SelectionValidator.CLASS);
        if (object != null && (n2 = JOptionPane.showOptionDialog(this, MESSAGE_REMOVE_TIMEBUCKET, "", 0, 2, null, DialogConstants.YES_NO_OPTION, (stringArray = new String[]{DialogConstants.BUTTON_YES, DialogConstants.BUTTON_NO})[1])) == 0) {
            TimebucketListTableCell timebucketListTableCell = (TimebucketListTableCell)this._timebucketListModel.getValueAt(n3, 0);
            Timebucket timebucket = timebucketListTableCell.getTimebucket();
            long l2 = timebucket.getTimebucketId();
            if (l2 != -1L) {
                this._removeIdList.add(l2);
            }
            PerformanceUIUtil.removeRow(this._timebucketListTable, this._timebucketListModel, n3);
        }
    }

    @Override
    protected void modifyItem() {
        int n2 = this._timebucketListTable.getSelectedRow();
        Object object = SingletonValidator.checkAllDialog(this, DialogConstants.MESSAGE_ONE_ROW, n2, SelectionValidator.CLASS);
        if (object != null) {
            DialogProvider.createTimebucketDialog(this, DialogConstants.BUTTON_MODIFY, this._timebucketListModel, n2);
        }
    }

    @Override
    protected void okDialog() {
        int n2 = this._timebucketListModel.getRowCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            TimebucketListTableCell timebucketListTableCell = (TimebucketListTableCell)this._timebucketListModel.getValueAt(i2, 0);
            Timebucket timebucket = timebucketListTableCell.getTimebucket();
            if (!timebucketListTableCell.isExisted()) {
                this._addTimebucketList.add(timebucket);
                continue;
            }
            if (!timebucketListTableCell.isChanged()) continue;
            this._modifyTimebucketList.add(timebucket);
        }
        if (!this.putTimebucket()) {
            JOptionPane.showMessageDialog(this, MESSAGE_PUT_TIMEBUCKET);
        }
        this.dispose();
    }

    private boolean putTimebucket() {
        try {
            return ClientProxy.getInstance().putTimebucketBulk(this._removeIdList, this._addTimebucketList, this._modifyTimebucketList);
        }
        catch (Exception exception) {
            this._logger.error((Object)"TimebucketListDialog putTimebucketBulk", (Throwable)exception);
            return false;
        }
    }

    private class TimebucketListSelection
    implements ListSelectionListener {
        private TimebucketListSelection() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (!listSelectionModel.isSelectionEmpty()) {
                int n2 = listSelectionModel.getMinSelectionIndex();
                String string = (String)TimebucketListDialog.this._timebucketListModel.getValueAt(n2, 1);
                if (string.equals(ICommonBundle.YES)) {
                    TimebucketListDialog.this.getRemoveButton().setEnabled(false);
                } else {
                    TimebucketListDialog.this.getRemoveButton().setEnabled(true);
                }
            }
        }
    }

    private class TimebucketListNameRenderer
    extends JLabel
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            if (object instanceof TimebucketListTableCell) {
                TimebucketListTableCell timebucketListTableCell = (TimebucketListTableCell)object;
                Timebucket timebucket = timebucketListTableCell.getTimebucket();
                this.setText(timebucket.getTimebucketName());
            } else {
                this.setText("");
            }
            this.setOpaque(true);
            if (bl2) {
                this.setForeground(jTable.getSelectionForeground());
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            return this;
        }
    }
}

