/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.performance.TargetFactory;
import com.sysuptime.common.performance.Timebucket;
import com.sysuptime.common.performance.TimebucketItem;
import com.sysuptime.mainframe.performance.ConfirmDialog;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.HourValidator;
import com.sysuptime.mainframe.performance.MinuteValidator;
import com.sysuptime.mainframe.performance.ReadOnlyTableModel;
import com.sysuptime.mainframe.performance.SingletonValidator;
import com.sysuptime.mainframe.performance.TimebucketFormatter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TimebucketItemDialog
extends ConfirmDialog {
    private JComboBox _startDay;
    private JTextField _startHour;
    private JTextField _startMinute;
    private JComboBox _endDay;
    private JTextField _endHour;
    private JTextField _endMinute;
    private String[] _columnData;
    private int _checkedStartTime;
    private int _checkedEndTime;
    private short _checkedStartDayId;
    private short _checkedEndDayId;
    private Timebucket _timebucket;
    private TimebucketItem _timebucketItem;
    private int _nonComparedIndex;
    private ReadOnlyTableModel _timebucketModel;

    public TimebucketItemDialog(Dialog dialog, String string, boolean bl2, Timebucket timebucket, ReadOnlyTableModel readOnlyTableModel, int n2) {
        super(dialog, string, bl2);
        this.initTimebucketItem(timebucket, readOnlyTableModel, n2);
        this.initComponents();
        this.initUserData();
    }

    private void initTimebucketItem(Timebucket timebucket, ReadOnlyTableModel readOnlyTableModel, int n2) {
        this._timebucket = timebucket;
        this._timebucketModel = readOnlyTableModel;
        this._nonComparedIndex = n2;
    }

    private void initComponents() {
        this.setResizable(false);
        Container container = this.getContentPane();
        container.add((Component)this.getBodyPanel(), "Center");
        container.add((Component)this.getConfirmPanel(), "South");
        this.pack();
    }

    private JPanel getBodyPanel() {
        FormLayout formLayout = new FormLayout("l:p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p", "p,3dlu,p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel(DialogConstants.LABEL_START_TIME, cellConstraints.xy(1, 1));
        this._startDay = new JComboBox<String>(DialogConstants.COMBOBOX_DAY);
        this._startDay.setPreferredSize(DialogConstants.OPERATE_SIZE);
        panelBuilder.add((Component)this._startDay, cellConstraints.xy(3, 1));
        this._startHour = new JTextField("0");
        this._startHour.setPreferredSize(DialogConstants.LONG_SIZE);
        panelBuilder.add((Component)this._startHour, cellConstraints.xy(5, 1));
        panelBuilder.addLabel(DialogConstants.LABEL_HOUR, cellConstraints.xy(7, 1));
        this._startMinute = new JTextField("0");
        this._startMinute.setPreferredSize(DialogConstants.LONG_SIZE);
        panelBuilder.add((Component)this._startMinute, cellConstraints.xy(9, 1));
        panelBuilder.addLabel(DialogConstants.LABEL_MINUTE, cellConstraints.xy(11, 1));
        panelBuilder.addLabel(DialogConstants.LABEL_END_TIME, cellConstraints.xy(1, 3));
        this._endDay = new JComboBox<String>(DialogConstants.COMBOBOX_DAY);
        this._endDay.setPreferredSize(DialogConstants.OPERATE_SIZE);
        panelBuilder.add((Component)this._endDay, cellConstraints.xy(3, 3));
        this._endHour = new JTextField("23");
        this._endHour.setPreferredSize(DialogConstants.LONG_SIZE);
        panelBuilder.add((Component)this._endHour, cellConstraints.xy(5, 3));
        panelBuilder.addLabel(DialogConstants.LABEL_HOUR, cellConstraints.xy(7, 3));
        this._endMinute = new JTextField("59");
        this._endMinute.setPreferredSize(DialogConstants.LONG_SIZE);
        panelBuilder.add((Component)this._endMinute, cellConstraints.xy(9, 3));
        panelBuilder.addLabel(DialogConstants.LABEL_MINUTE, cellConstraints.xy(11, 3));
        return panelBuilder.getPanel();
    }

    private void initUserData() {
        if (this._nonComparedIndex != -1) {
            this._timebucketItem = this._timebucket.getTimebucketItem(this._nonComparedIndex);
            this._startDay.setSelectedIndex(this._timebucketItem.getStartDayId() - 1);
            int n2 = this._timebucketItem.getStartTime();
            int n3 = n2 / 3600;
            this._startHour.setText(String.valueOf(n3));
            int n4 = n2 % 3600 / 60;
            this._startMinute.setText(String.valueOf(n4));
            this._endDay.setSelectedIndex(this._timebucketItem.getEndDayId() - 1);
            int n5 = this._timebucketItem.getEndTime();
            int n6 = n5 / 3600;
            this._endHour.setText(String.valueOf(n6));
            int n7 = n5 % 3600 / 60;
            this._endMinute.setText(String.valueOf(n7));
        } else {
            this._timebucketItem = TargetFactory.getTimebucketItem();
        }
    }

    @Override
    protected void okDialog() {
        if (this.checkTimebucketItem()) {
            this.setTimebucketItem();
            this.operateTimebucketItem();
            this.dispose();
        }
    }

    private void operateTimebucketItem() {
        if (this._nonComparedIndex != -1) {
            int n2 = this._timebucketModel.getColumnCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                this._timebucketModel.setValueAt(this._columnData[i2], this._nonComparedIndex, i2);
            }
        } else {
            this._timebucketModel.addRow(this._columnData);
            this._timebucket.addTimebucketItem(this._timebucketItem);
        }
    }

    private void setTimebucketItem() {
        this._timebucketItem.setStartDayId(this._checkedStartDayId);
        this._timebucketItem.setStartTime(this._checkedStartTime);
        this._timebucketItem.setEndDayId(this._checkedEndDayId);
        this._timebucketItem.setEndTime(this._checkedEndTime);
    }

    private boolean checkTimebucketItem() {
        int n2;
        Integer n3 = (Integer)SingletonValidator.checkAllDialog(this, DialogConstants.LABEL_HOUR, this._startHour.getText(), HourValidator.CLASS);
        if (n3 == null) {
            return false;
        }
        Integer n4 = (Integer)SingletonValidator.checkAllDialog(this, DialogConstants.LABEL_MINUTE, this._startMinute.getText(), MinuteValidator.CLASS);
        if (n4 == null) {
            return false;
        }
        Integer n5 = (Integer)SingletonValidator.checkAllDialog(this, DialogConstants.LABEL_HOUR, this._endHour.getText(), HourValidator.CLASS);
        if (n5 == null) {
            return false;
        }
        Integer n6 = (Integer)SingletonValidator.checkAllDialog(this, DialogConstants.LABEL_MINUTE, this._endMinute.getText(), MinuteValidator.CLASS);
        if (n6 == null) {
            return false;
        }
        int n7 = this._startDay.getSelectedIndex();
        if (n7 > (n2 = this._endDay.getSelectedIndex())) {
            JOptionPane.showMessageDialog(this, DialogConstants.MESSAGE_START_END);
            return false;
        }
        int n8 = n3;
        int n9 = n5;
        int n10 = n4;
        int n11 = n6;
        if (n7 == n2) {
            if (n8 > n9) {
                JOptionPane.showMessageDialog(this, DialogConstants.MESSAGE_START_END);
                return false;
            }
            if (n8 == n9 && n10 >= n11) {
                JOptionPane.showMessageDialog(this, DialogConstants.MESSAGE_START_END);
                return false;
            }
        }
        this._checkedStartDayId = (short)(n7 + 1);
        this._checkedEndDayId = (short)(n2 + 1);
        this._checkedStartTime = this.getTime(n8, n10);
        this._checkedEndTime = this.getTime(n9, n11);
        String string = (String)this._startDay.getItemAt(n7);
        String string2 = TimebucketFormatter.getTime(string, n8, n10);
        String string3 = (String)this._endDay.getItemAt(n2);
        String string4 = TimebucketFormatter.getTime(string3, n9, n11);
        this._columnData = new String[]{string2, string4};
        if (this.isLapped()) {
            JOptionPane.showMessageDialog(this, DialogConstants.MESSAGE_TIMEBUCKET_LAP);
            return false;
        }
        return true;
    }

    private int getTime(int n2, int n3) {
        return n2 * 3600 + n3 * 60;
    }

    private boolean isLapped() {
        for (int i2 = 0; i2 < this._timebucket.getTimebucketItemListSize(); ++i2) {
            TimebucketItem timebucketItem;
            if (i2 == this._nonComparedIndex || !this.isItemLapped(timebucketItem = this._timebucket.getTimebucketItem(i2))) continue;
            return true;
        }
        return false;
    }

    private boolean isItemLapped(TimebucketItem timebucketItem) {
        if (this._checkedEndDayId < timebucketItem.getStartDayId() || this._checkedEndDayId == timebucketItem.getStartDayId() && this._checkedEndTime < timebucketItem.getStartTime()) {
            return false;
        }
        return this._checkedStartDayId <= timebucketItem.getEndDayId() && (this._checkedStartDayId != timebucketItem.getEndDayId() || this._checkedStartTime <= timebucketItem.getEndTime());
    }
}

