/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.sysuptime.common.performance.Timebucket;
import com.sysuptime.mainframe.performance.ConfirmDialog;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.DialogProvider;
import com.sysuptime.mainframe.performance.MonitorBroker;
import com.sysuptime.mainframe.performance.TimebucketDialog;
import java.awt.Dialog;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public abstract class TimebucketActionDialog
extends ConfirmDialog {
    private JComboBox _timebucketBox;
    private DefaultComboBoxModel _timebucketModel;
    protected Map _timebucketNameToObject = MonitorBroker.getTimebucketNameToObject();

    public TimebucketActionDialog(Dialog dialog, String string, boolean bl2) {
        super(dialog, string, bl2);
        this._timebucketModel = new DefaultComboBoxModel();
        this._timebucketModel.addElement(_bundle.getString("label_newtimebucket"));
        Object[] objectArray = this._timebucketNameToObject.keySet().toArray();
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this._timebucketModel.addElement(objectArray[i2]);
        }
        this._timebucketBox = new JComboBox(this._timebucketModel);
        this._timebucketBox.setPreferredSize(DialogConstants.XLONG_SIZE);
        this._timebucketBox.setSelectedItem("7*24");
        TimebucketListener timebucketListener = new TimebucketListener();
        this._timebucketBox.addItemListener(timebucketListener);
    }

    protected String getConfigLabel() {
        return DialogConstants.LABEL_TIMEBUCKET;
    }

    protected JComboBox getConfigBox() {
        return this._timebucketBox;
    }

    protected JComboBox getTimebucketBox() {
        return this._timebucketBox;
    }

    private class TimebucketListener
    implements ItemListener {
        private TimebucketListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1 && TimebucketActionDialog.this._timebucketBox.getSelectedIndex() == 0) {
                TimebucketDialog timebucketDialog = DialogProvider.createTimebucketDialog(TimebucketActionDialog.this, DialogConstants.BUTTON_NEW, null, -1);
                if (timebucketDialog.isPut()) {
                    Timebucket timebucket = timebucketDialog.getNewTimebucket();
                    if (timebucket != null) {
                        TimebucketActionDialog.this._timebucketNameToObject.put(timebucket.getTimebucketName(), timebucket);
                        TimebucketActionDialog.this._timebucketModel.addElement(timebucket.getTimebucketName());
                        TimebucketActionDialog.this._timebucketBox.setSelectedItem(timebucket.getTimebucketName());
                    } else {
                        TimebucketActionDialog.this._timebucketBox.setSelectedItem("7*24");
                    }
                } else {
                    TimebucketActionDialog.this._timebucketBox.setSelectedItem("7*24");
                }
            }
        }
    }
}

