/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.util.CommonUtil;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.mainframe.performance.CalendarDialog;
import com.sysuptime.mainframe.performance.DialogProvider;
import com.sysuptime.mainframe.util.FormUtils;
import com.sysuptime.mainframe.util.SwingUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openide.util.NbBundle;

public class TimePeriodDialog
extends JDialog
implements ActionListener {
    private JButton _okButton;
    private JButton _cancelButton;
    private JTextField _fromField;
    private JTextField _toField;
    private JButton _fromButton;
    private JButton _toButton;
    private long _fromTime;
    private long _toTime;
    private boolean _isOk;

    public TimePeriodDialog(Frame frame, String string, boolean bl2) {
        super(frame, string, bl2);
        this.init();
    }

    private void init() {
        Container container = this.getContentPane();
        container.add((Component)this.createContentPane(), "Center");
        container.add((Component)this.createOKPane(), "South");
        this._okButton.addActionListener(this);
        this._cancelButton.addActionListener(this);
        this._fromButton.addActionListener(this);
        this._toButton.addActionListener(this);
    }

    private JPanel createContentPane() {
        JPanel jPanel = new JPanel();
        FormLayout formLayout = new FormLayout("FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:150PX:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE", "CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE");
        CellConstraints cellConstraints = new CellConstraints();
        jPanel.setLayout((LayoutManager)formLayout);
        JLabel jLabel = new JLabel();
        jLabel.setText(NbBundle.getMessage(TimePeriodDialog.class, (String)"TimePeriodDialog_label_from"));
        jPanel.add((Component)jLabel, cellConstraints.xy(3, 3));
        this._fromField = new JTextField();
        jPanel.add((Component)this._fromField, cellConstraints.xy(5, 3));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(NbBundle.getMessage(TimePeriodDialog.class, (String)"TimePeriodDialog_label_to"));
        jPanel.add((Component)jLabel2, cellConstraints.xy(3, 5));
        this._toField = new JTextField();
        jPanel.add((Component)this._toField, cellConstraints.xy(5, 5));
        this._fromButton = new JButton(SwingUtil.getImage("jdaychoosercolor16.gif"));
        jPanel.add((Component)this._fromButton, cellConstraints.xy(6, 3));
        this._toButton = new JButton(SwingUtil.getImage("jdaychoosercolor16.gif"));
        jPanel.add((Component)this._toButton, cellConstraints.xy(6, 5));
        FormUtils.addFillComponents(jPanel, new int[]{1, 2, 3, 4, 5, 6, 7, 8}, new int[]{1, 2, 3, 4, 5, 6});
        return jPanel;
    }

    private JPanel createOKPane() {
        this._okButton = new JButton(ICommonBundle.OK);
        this._cancelButton = new JButton(ICommonBundle.CANCEL);
        this._okButton.setPreferredSize(new Dimension(70, 25));
        this._cancelButton.setPreferredSize(new Dimension(70, 25));
        JPanel jPanel = new JPanel();
        jPanel.add(this._okButton);
        jPanel.add(this._cancelButton);
        return jPanel;
    }

    public void showOut() {
        this.pack();
        SwingUtil.centerOnFrame(this.getOwner(), this);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._okButton) {
            this.doOK();
        } else if (object == this._cancelButton) {
            this._isOk = false;
            this.dispose();
        } else if (object == this._fromButton) {
            this.doFrom();
        } else if (object == this._toButton) {
            this.doTo();
        }
    }

    private void doFrom() {
        Date date = this.getTime();
        if (date != null) {
            long l2 = date.getTime();
            if (this._toTime != 0L && l2 > this._toTime) {
                JOptionPane.showMessageDialog(this, NbBundle.getMessage(this.getClass(), (String)"TimePeriodDialog_msg_notValid"));
                return;
            }
            this._fromTime = l2;
            this._fromField.setText(this.getTimeText(date));
        }
    }

    private void doTo() {
        Date date = this.getTime();
        if (date != null) {
            long l2 = date.getTime();
            if (this._fromTime != 0L && l2 < this._fromTime) {
                JOptionPane.showMessageDialog(this, NbBundle.getMessage(this.getClass(), (String)"TimePeriodDialog_msg_notValid"));
                return;
            }
            this._toField.setText(this.getTimeText(date));
            this._toTime = l2;
        }
    }

    private void doOK() {
        if (this._fromField.getText().length() == 0 || this._toField.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, NbBundle.getMessage(this.getClass(), (String)"TimePeriodDialog_msg_selectPrompt"));
            return;
        }
        this._isOk = true;
        this.dispose();
    }

    private Date getTime() {
        CalendarDialog calendarDialog = (CalendarDialog)DialogProvider.createCalendarDialog(this);
        if (calendarDialog.isPut()) {
            return calendarDialog.getDate();
        }
        return null;
    }

    private String getTimeText(Date date) {
        SimpleDateFormat simpleDateFormat = CommonUtil.getDateFormat();
        return simpleDateFormat.format(date);
    }

    public boolean isOK() {
        return this._isOk;
    }

    public long getFromTime() {
        return this._fromTime;
    }

    public long getToTime() {
        return this._toTime;
    }
}

