/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.ireasoning.app.mibbrowser.SnmpUtil;
import com.ireasoning.protocol.snmp.SnmpOID;
import com.ireasoning.protocol.snmp.SnmpTableModel;
import com.ireasoning.util.AgentProperties;
import com.ireasoning.util.FormUtil;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.performance.MonitorCheckBox;
import com.sysuptime.mainframe.performance.MonitorCheckBoxListener;
import com.sysuptime.mainframe.performance.MonitorTextField;
import com.sysuptime.mainframe.performance.SnmpDevicesMonitorPane;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openide.util.NbBundle;

public class SnmpPortMonitorPane
extends SnmpDevicesMonitorPane {
    private Map _ifIndex2IfSpeedMap;

    public SnmpPortMonitorPane(AgentProperties agentProperties) throws Exception {
        this.initPortComponent(agentProperties);
    }

    public void initPortComponent(AgentProperties agentProperties) throws Exception {
        SnmpTableModel snmpTableModel = null;
        SnmpTableModel snmpTableModel2 = null;
        String string = SnmpUtil.getTableOID(new SnmpOID(".1.3.6.1.2.1.2.2.1"));
        String string2 = SnmpUtil.getTableOID(new SnmpOID(".1.3.6.1.2.1.4.20.1"));
        snmpTableModel = ClientProxy.getInstance().snmpGetTable(agentProperties, string, 30);
        snmpTableModel2 = ClientProxy.getInstance().snmpGetTable(agentProperties, string2, 30);
        Map map = null;
        if (snmpTableModel != null && snmpTableModel2 != null && snmpTableModel2.getColumnCount() > 0 && snmpTableModel.getColumnCount() > 0) {
            map = this.getIfIndex2DescrMap(snmpTableModel, snmpTableModel2);
            this._ifIndex2IfSpeedMap = this.getIfIndex2IfSpeedMap(snmpTableModel);
            if (!map.isEmpty()) {
                this.createComponent(map);
            }
        }
        if (map == null || map.isEmpty()) {
            throw new Exception(NbBundle.getMessage(SnmpPortMonitorPane.class, (String)"MSG_get_data_error"));
        }
    }

    private Map getIfIndex2DescrMap(SnmpTableModel snmpTableModel, SnmpTableModel snmpTableModel2) {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        for (int i2 = 0; i2 < snmpTableModel.getRowCount(); ++i2) {
            boolean bl2 = false;
            StringBuffer stringBuffer = new StringBuffer();
            Integer n2 = Integer.valueOf(String.valueOf(snmpTableModel.getValueAt(i2, 0)));
            String string = String.valueOf(snmpTableModel.getValueAt(i2, 1));
            for (int i3 = 0; i3 < snmpTableModel2.getRowCount(); ++i3) {
                Integer n3 = Integer.valueOf(String.valueOf(snmpTableModel2.getValueAt(i3, 1)));
                if (n3.intValue() != n2.intValue()) continue;
                String string2 = String.valueOf(snmpTableModel2.getValueAt(i3, 0));
                stringBuffer.append(string2).append(" ").append("(").append(" ");
                stringBuffer.append(string.trim()).append(" ").append(")");
                bl2 = true;
                break;
            }
            if (!bl2) {
                stringBuffer.append(string);
            }
            hashMap.put(n2, stringBuffer.toString());
        }
        return hashMap;
    }

    private Map getIfIndex2IfSpeedMap(SnmpTableModel snmpTableModel) {
        HashMap<Integer, Long> hashMap = new HashMap<Integer, Long>();
        for (int i2 = 0; i2 < snmpTableModel.getRowCount(); ++i2) {
            Integer n2 = Integer.valueOf(String.valueOf(snmpTableModel.getValueAt(i2, 0)));
            Long l2 = Long.valueOf(String.valueOf(snmpTableModel.getValueAt(i2, 4)));
            hashMap.put(n2, l2);
        }
        return hashMap;
    }

    @Override
    protected JPanel initDevicesPane(Map map) {
        ArrayList arrayList = new ArrayList(map.keySet());
        int n2 = arrayList.size();
        Collections.sort(arrayList);
        FormLayout formLayout = this.getFormLayout(n2);
        JPanel jPanel = new JPanel((LayoutManager)formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            Integer n4 = (Integer)arrayList.get(i2);
            String string = (String)map.get(n4);
            MonitorCheckBox monitorCheckBox = null;
            if (string.indexOf("(") != -1) {
                monitorCheckBox = new MonitorCheckBox(n4, string.substring(0, string.indexOf("(")));
                monitorCheckBox.setToolTipText(string.substring(string.indexOf("(") + 1, string.length() - 1));
            } else {
                monitorCheckBox = new MonitorCheckBox(n4, string);
                monitorCheckBox.setToolTipText(string);
            }
            monitorCheckBox.setSelected(true);
            MonitorTextField monitorTextField = new MonitorTextField(n4);
            long l2 = Long.parseLong(String.valueOf(this._ifIndex2IfSpeedMap.get(n4))) / 1000000L;
            monitorTextField.setText(String.valueOf(l2));
            FormLayout formLayout2 = new FormLayout("FILL:120PX:NONE,FILL:5PX:NONE,FILL:80PX:NONE,FILL:80PX:NONE,FILL:10PX:NONE,FILL:53PX:NONE,FILL:10PX:NONE", "CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE");
            JPanel jPanel2 = new JPanel((LayoutManager)formLayout2);
            jPanel2.add((Component)monitorCheckBox, cellConstraints.xy(1, 1));
            JLabel jLabel = new JLabel("( " + SnmpPortMonitorPane.fromBundle("Label_bandwidth_speed") + ": ");
            jPanel2.add((Component)jLabel, cellConstraints.xy(3, 1));
            jPanel2.add((Component)monitorTextField, cellConstraints.xy(4, 1));
            JLabel jLabel2 = new JLabel(SnmpPortMonitorPane.fromBundle("Label_bandwidth_speed_unit") + " )");
            jPanel2.add((Component)jLabel2, cellConstraints.xy(6, 1));
            FormUtil.addFillComponents(jPanel2, new int[]{1, 2, 3, 4, 5, 6, 7}, new int[]{1, 2});
            jPanel.add((Component)jPanel2, cellConstraints.xywh(1, ++n3, 2, 1));
            monitorCheckBox.addActionListener(new MonitorCheckBoxListener(monitorTextField));
        }
        this.fillComponents(jPanel, n2);
        return jPanel;
    }

    public Map getAllEnabledTextFieldText() {
        HashMap hashMap = new HashMap();
        this.handleAllIfSpeedString(this, hashMap);
        return hashMap;
    }

    private void handleAllIfSpeedString(JComponent jComponent, Map map) {
        for (int i2 = 0; i2 < jComponent.getComponentCount(); ++i2) {
            Component component = jComponent.getComponent(i2);
            if (!(component instanceof JComponent)) continue;
            if (component instanceof MonitorTextField) {
                MonitorTextField monitorTextField = (MonitorTextField)component;
                if (!monitorTextField.isEnabled()) continue;
                map.put(monitorTextField.getIfIndex(), monitorTextField.getText().trim());
                continue;
            }
            this.handleAllIfSpeedString((JComponent)component, map);
        }
    }

    @Override
    protected String getTitleBorderText() {
        return SnmpPortMonitorPane.fromBundle("Title_port");
    }

    private static String fromBundle(String string) {
        return NbBundle.getMessage(SnmpPortMonitorPane.class, (String)string);
    }
}

