/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.ireasoning.util.AgentProperties;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.openapi.performance.DefaultProtocolDialog;
import com.openapi.performance.QueryParameterElement;
import com.sysuptime.common.discovery.ReadCommunity;
import com.sysuptime.common.expression.IExpression;
import com.sysuptime.common.expression.IVarInfo;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.common.util.monitor.Snippet;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.expression.ExpressionOperations;
import com.sysuptime.mainframe.expression.IndexValueDialog;
import com.sysuptime.mainframe.expression.ManageExpressionDialog;
import com.sysuptime.mainframe.mibbrowser.SnmpBrowserDialog;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.performance.ComponentElement;
import com.sysuptime.mainframe.performance.ComponentProvider;
import com.sysuptime.mainframe.performance.DialogProvider;
import com.sysuptime.mainframe.performance.MonitorDialog;
import com.sysuptime.mainframe.performance.SingletonValidator;
import com.sysuptime.mainframe.util.SwingUtil;
import com.ultraswing.DropDownButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SnmpDialog
extends DefaultProtocolDialog {
    private static final String BUTTON_EXPRESSION = ICommonBundle.EXPRESSION;
    private static final String BUTTON_OID = _bundle.getString("button_oid");
    private static final String SNMPV3 = _bundle.getString("label_SNMPv3");
    private static final String OID = "oid";
    private static final String PORT = "port_number";
    private static final String COMMUNITY = "community";
    private static final String TIMEOUT = "timeout";
    private static final String RETRIES = "retries";
    private static final String VERSION = "version";
    private static final String USERNAME = "mib_user_name";
    private static final String AUTHALGORITHM = "auth_algorithm";
    private static final String AUTHPASSWORD = "auth_password";
    private static final String PRIVACYALGORITHM = "privacy_algorithm";
    private static final String PRIVACYPASSWORD = "privacy_password";
    private JMenuItem _expression;
    private JMenuItem _oid;
    private JTextField _oidComponent;
    private VersionAction _versionAction = new VersionAction();
    private MonitorDialog _owner;
    public static final String SNMP = "SNMP";
    public long _probeID = 0L;

    public SnmpDialog(JDialog jDialog, String string, boolean bl2) {
        super(jDialog, string, bl2);
        this._owner = (MonitorDialog)jDialog;
    }

    @Override
    protected void initBeforeUserData() {
        super.initBeforeUserData();
        JComboBox jComboBox = (JComboBox)this.getComponent(VERSION);
        jComboBox.setSelectedIndex(1);
        ReadCommunity readCommunity = this._owner.getCommunity();
        if (readCommunity != null) {
            JTextField jTextField = (JTextField)this.getComponent(COMMUNITY);
            jTextField.setText(readCommunity.getCommunity());
            int n2 = readCommunity.getVersion();
            if (n2 == 3) {
                JTextField jTextField2 = (JTextField)this.getComponent(USERNAME);
                JComboBox jComboBox2 = (JComboBox)this.getComponent(AUTHALGORITHM);
                JPasswordField jPasswordField = (JPasswordField)this.getComponent(AUTHPASSWORD);
                JComboBox jComboBox3 = (JComboBox)this.getComponent(PRIVACYALGORITHM);
                JTextField jTextField3 = (JTextField)this.getComponent(PRIVACYPASSWORD);
                jComboBox.setSelectedIndex(2);
                jTextField2.setText(readCommunity.getV3Params().getUserName());
                jComboBox2.setSelectedItem(readCommunity.getV3Params().getAuthProtocol());
                jPasswordField.setText(readCommunity.getV3Params().getAuthPassword());
                jComboBox3.setSelectedItem(readCommunity.getV3Params().getPrivProtocolView());
                jTextField3.setText(readCommunity.getV3Params().getPrivPassword());
            }
        }
    }

    @Override
    protected int appendParameterCompenent(DefaultFormBuilder defaultFormBuilder, CellConstraints cellConstraints, QueryParameterElement queryParameterElement, int n2) {
        String string = queryParameterElement.getName();
        String string2 = Snippet.getBundledString(string);
        JComponent jComponent = this.getParameterComponent(queryParameterElement, string2);
        if (string.equalsIgnoreCase(OID)) {
            this.appendOid(defaultFormBuilder, jComponent, string2);
        } else if (string.equalsIgnoreCase(VERSION)) {
            ((JComboBox)jComponent).addItemListener(this._versionAction);
            defaultFormBuilder.append(string2, (Component)jComponent);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.appendSeparator(SNMPV3);
        } else {
            defaultFormBuilder.append(string2, (Component)jComponent);
            defaultFormBuilder.append(this.getLineEnd(queryParameterElement));
        }
        return n2;
    }

    private void appendOid(DefaultFormBuilder defaultFormBuilder, JComponent jComponent, String string) {
        this._oidComponent = (JTextField)jComponent;
        defaultFormBuilder.append(string);
        defaultFormBuilder.append((Component)this._oidComponent);
        ImportAction importAction = new ImportAction();
        DropDownButton dropDownButton = new DropDownButton(ICommonBundle.BROWSE_3DOTS);
        dropDownButton.setSeparateButton(false);
        JPopupMenu jPopupMenu = new JPopupMenu();
        this._expression = new JMenuItem(BUTTON_EXPRESSION);
        this._expression.addActionListener(importAction);
        jPopupMenu.add(this._expression);
        this._oid = new JMenuItem(BUTTON_OID);
        this._oid.addActionListener(importAction);
        jPopupMenu.add(this._oid);
        dropDownButton.setPopupMenu(jPopupMenu);
        defaultFormBuilder.append((Component)dropDownButton);
    }

    private void handleExpression() {
        ManageExpressionDialog manageExpressionDialog;
        if (!ClientProxy.getInstance().isActive(this._probeID)) {
            return;
        }
        if (Startup.isMaster()) {
            ClientProxy.getInstance().setProbe(Startup.getProbeById(this._probeID));
        }
        if ((manageExpressionDialog = (ManageExpressionDialog)DialogProvider.createImportExpressionDialog(this)).isOk()) {
            boolean bl2 = true;
            IExpression iExpression = manageExpressionDialog.getSelectedExpression();
            Object object = iExpression.getExpressionName();
            List list = iExpression.getVarList();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                IVarInfo iVarInfo = (IVarInfo)list.get(i2);
                String string = iVarInfo.getOidName().trim();
                if (!string.endsWith(".")) continue;
                IndexValueDialog indexValueDialog = new IndexValueDialog(this, string.substring(0, string.length() - 1), this._owner.getHost(), this.getParams());
                if (!indexValueDialog.isOk()) {
                    bl2 = false;
                    break;
                }
                String string2 = indexValueDialog.getOid();
                if (string2.startsWith(".")) {
                    string2 = string2.substring(1);
                }
                object = (String)object + "." + string2;
                Vector vector = new Vector();
                for (int i3 = 0; i3 < list.size(); ++i3) {
                    IVarInfo iVarInfo2 = (IVarInfo)list.get(i3);
                    Object object2 = iVarInfo2.getOidName().trim();
                    String string3 = iVarInfo2.getVarName();
                    if (((String)object2).endsWith(".")) {
                        object2 = (String)object2 + string2;
                    }
                    Vector<Object> vector2 = new Vector<Object>();
                    vector2.add(string3);
                    vector2.add(object2);
                    vector.add(vector2);
                }
                IExpression iExpression2 = ExpressionOperations.updateExpression((String)object, iExpression.getExpression(), iExpression.getDescription(), vector);
                if (iExpression2 != null) break;
                bl2 = false;
                break;
            }
            if (bl2) {
                this._oidComponent.setText((String)object);
            }
        }
    }

    private void handleOid() {
        String string = this._owner.getHost();
        Object var2_2 = null;
        List list = this.getInputParametersValues(false);
        AgentProperties agentProperties = SnmpDialog.getAgentProperties(string, list);
        SnmpBrowserDialog snmpBrowserDialog = new SnmpBrowserDialog(Startup.getFrame(), true, agentProperties);
        snmpBrowserDialog.setTitle(_bundle.getString("title_choose_oid"));
        SwingUtil.centerOnFrame(Startup.getFrame(), snmpBrowserDialog);
        snmpBrowserDialog.setVisible(true);
        if (snmpBrowserDialog.isOK()) {
            this._oidComponent.setText(snmpBrowserDialog.getOIDValue());
        }
    }

    public static AgentProperties getAgentProperties(String string, List<String> list) {
        int n2 = Integer.parseInt(list.get(1));
        String string2 = list.get(2);
        int n3 = Integer.parseInt(list.get(3));
        int n4 = Integer.parseInt(list.get(4));
        int n5 = Integer.parseInt(list.get(5));
        AgentProperties agentProperties = new AgentProperties(string, n2, n5, string2, null);
        if (n5 == 3) {
            String string3 = list.get(6);
            String string4 = list.get(7);
            String string5 = list.get(8);
            String string6 = list.get(9);
            String string7 = list.get(10);
            agentProperties.setV3Params(string3, string4, string5, string6, string7, "");
        }
        return agentProperties;
    }

    private void setV3CompStates(boolean bl2) {
        this.getComponent(COMMUNITY).setEnabled(!bl2);
        this.getComponent(USERNAME).setEnabled(bl2);
        this.getComponent(AUTHALGORITHM).setEnabled(bl2);
        this.getComponent(AUTHPASSWORD).setEnabled(bl2);
        this.getComponent(PRIVACYALGORITHM).setEnabled(bl2);
        this.getComponent(PRIVACYPASSWORD).setEnabled(bl2);
    }

    private List getParams() {
        return this.getInputParametersValues(false);
    }

    private List getInputParametersValues(boolean bl2) {
        List list = this.getParameterValue();
        List list2 = this.getParameterName();
        ComponentProvider componentProvider = this.getComponentProvider();
        int n2 = list.size();
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        boolean bl3 = ((JComboBox)this.getComponent(VERSION)).getSelectedItem().equals("3");
        int n3 = n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            ComponentElement componentElement = (ComponentElement)list.get(i2);
            JComponent jComponent = componentElement.getComponent();
            String string = list2.get(i2).toString();
            if (string.equalsIgnoreCase(VERSION)) {
                n3 = i2;
            }
            if (bl3) {
                if (string.equalsIgnoreCase(COMMUNITY)) {
                    arrayList.add("");
                    continue;
                }
            } else if (i2 > n3) break;
            String string2 = componentProvider.getInput(componentElement.getName(), jComponent);
            String string3 = componentElement.getValidation();
            String string4 = componentElement.getLocaleName();
            if (bl2) {
                Object object = SingletonValidator.checkAllDialog(this, string4, string2, string3);
                if (object == null) {
                    return null;
                }
                arrayList.add(object);
                continue;
            }
            arrayList.add(string2);
        }
        return arrayList;
    }

    @Override
    protected List getValidatedParametersValues() {
        return this.getInputParametersValues(true);
    }

    @Override
    public boolean isAddHostFirst() {
        return true;
    }

    @Override
    public void setProbeID(long l2) {
        this._probeID = l2;
    }

    private class VersionAction
    implements ItemListener {
        private VersionAction() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Object object = ((JComboBox)SnmpDialog.this.getComponent(SnmpDialog.VERSION)).getSelectedItem();
                        SnmpDialog.this.setV3CompStates(object.equals("3"));
                    }
                });
            }
        }
    }

    private class ImportAction
    implements ActionListener {
        private ImportAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object.equals(SnmpDialog.this._expression)) {
                SnmpDialog.this.handleExpression();
            } else if (object.equals(SnmpDialog.this._oid)) {
                SnmpDialog.this.handleOid();
            }
        }
    }
}

