/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.sysuptime.common.performance.Group;
import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.performance.RemoteHost;
import com.sysuptime.common.performance.ScheduledDownTime;
import com.sysuptime.common.performance.TargetFactory;
import com.sysuptime.common.performance.Timebucket;
import com.sysuptime.common.util.RmiResponse;
import com.sysuptime.common.util.schedule.RealSchedule;
import com.sysuptime.mainframe.util.JNDIClient;
import com.sysuptime.mainframe.util.RMIAdaptor;
import com.sysuptime.server.util.MBeanUtil;
import java.util.List;
import javax.management.ObjectName;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class SingletonScheduleBroker {
    private static final Logger _logger = Logger.getLogger(SingletonScheduleBroker.class);
    private static final ObjectName SCHEDULE_OBJECT_NAME = MBeanUtil.create("nMaster:service=PMDBSingletonScheduleProvider");
    private static RMIAdaptor _rmiAdaptor;

    public static boolean putScheduleBulk(List list, List list2, List list3, List list4) throws Exception {
        boolean bl2 = false;
        Boolean bl3 = (Boolean)_rmiAdaptor.invoke(SCHEDULE_OBJECT_NAME, "dealScheduleBulk", new Object[]{list, list2, list3, list4}, new String[]{"java.util.List", "java.util.List", "java.util.List", "java.util.List"});
        bl2 = bl3;
        return bl2;
    }

    public static List addMonitorBulk(List list) throws Exception {
        Object[] objectArray = new Object[]{list};
        String[] stringArray = new String[]{List.class.getName()};
        return (List)_rmiAdaptor.invoke(SCHEDULE_OBJECT_NAME, "addScheduleBulk", objectArray, stringArray);
    }

    public static boolean putScheduleBulk(List list, List list2, List list3) throws Exception {
        Object[] objectArray = new Object[]{list, list2, list3};
        String[] stringArray = new String[]{List.class.getName(), List.class.getName(), List.class.getName()};
        return (Boolean)_rmiAdaptor.invoke(SCHEDULE_OBJECT_NAME, "dealScheduleBulk", objectArray, stringArray);
    }

    public static String getErrorMessage() throws Exception {
        return (String)_rmiAdaptor.invoke(SCHEDULE_OBJECT_NAME, "getErrorMessage", null, null);
    }

    public static boolean setSuspended(int n2, boolean bl2, long l2) {
        boolean bl3 = false;
        try {
            Boolean bl4 = (Boolean)_rmiAdaptor.invoke(SCHEDULE_OBJECT_NAME, "setSuspended", new Object[]{n2, bl2, l2}, new String[]{"int", "boolean", "long"});
            bl3 = bl4;
        }
        catch (Exception exception) {
            _logger.error((Object)"Set suspended flag ", (Throwable)exception);
        }
        return bl3;
    }

    public static Object modifySchedule(Monitor monitor) {
        Boolean bl2 = false;
        try {
            RmiResponse rmiResponse = (RmiResponse)_rmiAdaptor.invoke(SCHEDULE_OBJECT_NAME, "modifySchedule", new Object[]{monitor}, new String[]{RealSchedule.class.getName()});
            if (rmiResponse.getValue() instanceof Monitor) {
                return rmiResponse.getValue();
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"Modify a monitor ", (Throwable)exception);
        }
        return bl2;
    }

    public static boolean modifyScheduleAndRemoveResult(Monitor monitor) {
        boolean bl2 = false;
        try {
            Boolean bl3 = (Boolean)_rmiAdaptor.invoke(SCHEDULE_OBJECT_NAME, "modifyScheduleAndRemoveResults", new Object[]{monitor}, new String[]{Monitor.class.getName()});
            bl2 = bl3;
        }
        catch (Exception exception) {
            _logger.error((Object)"Modify a schedule ", (Throwable)exception);
        }
        return bl2;
    }

    public static Monitor addSchedule(Monitor monitor) {
        try {
            return (Monitor)_rmiAdaptor.invoke(SCHEDULE_OBJECT_NAME, "addRealSchedule", new Object[]{monitor}, new String[]{RealSchedule.class.getName()});
        }
        catch (Exception exception) {
            _logger.error((Object)"Add a schedule ", (Throwable)exception);
            return null;
        }
    }

    public static boolean removeSchedule(int n2) {
        boolean bl2 = false;
        try {
            Boolean bl3 = (Boolean)_rmiAdaptor.invoke(SCHEDULE_OBJECT_NAME, "removeRealSchedule", new Object[]{n2}, new String[]{"int"});
            bl2 = bl3;
        }
        catch (Exception exception) {
            _logger.error((Object)"Remove a schedule ", (Throwable)exception);
        }
        return bl2;
    }

    public static List getUsedTimebucketIdList() {
        List list = null;
        try {
            list = (List)_rmiAdaptor.invoke(SCHEDULE_OBJECT_NAME, "getUsedTimebucketIdList", null, null);
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
        }
        return list;
    }

    public static boolean putTimebucketBulk(List list, List list2, List list3) {
        boolean bl2 = false;
        try {
            Boolean bl3 = (Boolean)_rmiAdaptor.invoke(SCHEDULE_OBJECT_NAME, "dealTimebucketBulk", new Object[]{list, list2, list3}, new String[]{"java.util.List", "java.util.List", "java.util.List"});
            bl2 = bl3;
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
        }
        return bl2;
    }

    public static void addTimebucket(Timebucket timebucket) {
        try {
            _rmiAdaptor.invoke(SCHEDULE_OBJECT_NAME, "addTimebucketData", new Object[]{timebucket}, new String[]{Timebucket.class.getName()});
        }
        catch (Exception exception) {
            _logger.error((Object)"add timebucket", (Throwable)exception);
        }
    }

    public static boolean modifyGroupName(Group group) {
        boolean bl2 = false;
        try {
            Boolean bl3 = (Boolean)_rmiAdaptor.invoke(SCHEDULE_OBJECT_NAME, "modifyGroupName", new Object[]{group}, new String[]{Group.class.getName()});
            bl2 = bl3;
        }
        catch (Exception exception) {
            _logger.error((Object)"Modify group ", (Throwable)exception);
        }
        return bl2;
    }

    public static boolean modifyMonitorGroupId(long l2, long l3) {
        boolean bl2 = false;
        try {
            Boolean bl3 = (Boolean)_rmiAdaptor.invoke(SCHEDULE_OBJECT_NAME, "modifyMonitorGroupId", new Object[]{l2, l3}, new String[]{"long", "long"});
            bl2 = bl3;
        }
        catch (Exception exception) {
            _logger.error((Object)"Modify group ", (Throwable)exception);
        }
        return bl2;
    }

    public static List removeGroup(long l2) {
        List list = null;
        try {
            list = (List)_rmiAdaptor.invoke(SCHEDULE_OBJECT_NAME, "removeGroup", new Object[]{l2}, new String[]{"long"});
        }
        catch (Exception exception) {
            _logger.error((Object)"Remove a group ", (Throwable)exception);
        }
        return list;
    }

    public static boolean removeMonitors(List list) {
        boolean bl2 = false;
        try {
            bl2 = (Boolean)_rmiAdaptor.invoke(SCHEDULE_OBJECT_NAME, "removeMonitors", new Object[]{list}, new String[]{List.class.getName()});
        }
        catch (Exception exception) {
            _logger.error((Object)"Remove schedules ", (Throwable)exception);
        }
        return bl2;
    }

    public static long storeGroup(String string) {
        long l2 = -1L;
        try {
            Number number = (Number)_rmiAdaptor.invoke(SCHEDULE_OBJECT_NAME, "storeGroup", new Object[]{TargetFactory.getGroup(l2, string)}, new String[]{Group.class.getName()});
            l2 = number.longValue();
        }
        catch (Exception exception) {
            _logger.error((Object)"Store group ", (Throwable)exception);
        }
        return l2;
    }

    public static long storeGroup(Group group) {
        try {
            return ((Number)_rmiAdaptor.invoke(SCHEDULE_OBJECT_NAME, "storeGroup", new Object[]{group}, new String[]{Group.class.getName()})).longValue();
        }
        catch (Exception exception) {
            _logger.error((Object)"store group error ", (Throwable)exception);
            return -1L;
        }
    }

    public static long storeRemoteHost(RemoteHost remoteHost) {
        long l2 = -1L;
        try {
            Number number = (Number)_rmiAdaptor.invoke(SCHEDULE_OBJECT_NAME, "storeRemoteHost", new Object[]{remoteHost}, new String[]{RemoteHost.class.getName()});
            l2 = number.longValue();
        }
        catch (Exception exception) {
            _logger.error((Object)"Store remote host ", (Throwable)exception);
        }
        return l2;
    }

    public static boolean modifyRemoteHost(RemoteHost remoteHost) {
        boolean bl2 = false;
        try {
            Boolean bl3 = (Boolean)_rmiAdaptor.invoke(SCHEDULE_OBJECT_NAME, "modifyRemoteHost", new Object[]{remoteHost}, new String[]{RemoteHost.class.getName()});
            bl2 = bl3;
        }
        catch (Exception exception) {
            _logger.error((Object)"Modify remote host ", (Throwable)exception);
        }
        return bl2;
    }

    public static boolean removeRemoteHost(long l2) {
        boolean bl2 = false;
        try {
            Boolean bl3 = (Boolean)_rmiAdaptor.invoke(SCHEDULE_OBJECT_NAME, "removeRemoteHost", new Object[]{l2}, new String[]{"long"});
            bl2 = bl3;
        }
        catch (Exception exception) {
            _logger.error((Object)"Remove remote host ", (Throwable)exception);
        }
        return bl2;
    }

    public static boolean isMonitorXMLModified() {
        return false;
    }

    public static boolean resetDependency(int n2) {
        boolean bl2 = false;
        try {
            bl2 = (Boolean)_rmiAdaptor.invoke(SCHEDULE_OBJECT_NAME, "resetDependency", new Object[]{n2}, new String[]{"int"});
        }
        catch (Exception exception) {
            _logger.error((Object)"Reset dependency ", (Throwable)exception);
        }
        return bl2;
    }

    public static boolean resetDependency(List list) {
        boolean bl2 = false;
        try {
            bl2 = (Boolean)_rmiAdaptor.invoke(SCHEDULE_OBJECT_NAME, "resetDependency", new Object[]{list}, new String[]{List.class.getName()});
        }
        catch (Exception exception) {
            _logger.error((Object)"Reset dependencies ", (Throwable)exception);
        }
        return bl2;
    }

    public static RmiResponse loadDefaultActions() throws Exception {
        return (RmiResponse)_rmiAdaptor.invoke(SCHEDULE_OBJECT_NAME, "loadDefaultActions", null, null);
    }

    public static RmiResponse saveAsDefaultActions(String string) throws Exception {
        String[] stringArray = new String[]{String.class.getName()};
        Object[] objectArray = new Object[]{string};
        return (RmiResponse)_rmiAdaptor.invoke(SCHEDULE_OBJECT_NAME, "saveAsDefaultActions", objectArray, stringArray);
    }

    public static boolean modifyDirectDependency(List list) throws Exception {
        String[] stringArray = new String[]{List.class.getName()};
        Object[] objectArray = new Object[]{list};
        return (Boolean)_rmiAdaptor.invoke(SCHEDULE_OBJECT_NAME, "modifyDirectDependency", objectArray, stringArray);
    }

    public static ScheduledDownTime getScheduledDownTime() throws Exception {
        return (ScheduledDownTime)_rmiAdaptor.invoke(SCHEDULE_OBJECT_NAME, "getScheduledDownTime", null, null);
    }

    public static boolean updateScheduledDownTime(ScheduledDownTime scheduledDownTime) throws Exception {
        Object[] objectArray = new Object[]{scheduledDownTime};
        String[] stringArray = new String[]{ScheduledDownTime.class.getName()};
        return (Boolean)_rmiAdaptor.invoke(SCHEDULE_OBJECT_NAME, "updateScheduledDownTime", objectArray, stringArray);
    }

    static {
        try {
            _rmiAdaptor = JNDIClient.getSingletonRMIAdaptor(0, false, false);
        }
        catch (NamingException namingException) {
            _logger.error((Object)namingException);
        }
    }
}

