/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.openapi.performance.DefaultProtocolDialog;
import com.openapi.performance.QueryParameterElement;
import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.performance.QueryParameter;
import com.sysuptime.common.performance.ServiceNameElement;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.common.util.monitor.Snippet;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.PositiveIntValidator;
import com.sysuptime.mainframe.performance.SingletonValidator;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class PortDialog
extends DefaultProtocolDialog {
    private JComboBox _protocolBox = new JComboBox<String>(new String[]{Snippet.getBundledString("tcp"), Snippet.getBundledString("udp")});
    private static final String PORT = "port_number";
    private static final String SEND = "send";
    private JTextField _newPort = new JTextField();
    private JComboBox _portBox;
    private JPanel _portPanel;

    public PortDialog(JDialog jDialog, String string, boolean bl2) {
        super(jDialog, string, bl2);
    }

    @Override
    public void initProtocol(Monitor monitor, int n2, ServiceNameElement serviceNameElement, String string) {
        super.initProtocol(monitor, n2, serviceNameElement, string);
        this._portBox = (JComboBox)this.getComponent(PORT);
        this._portBox.addItemListener(new PortItem());
    }

    @Override
    protected int appendParameterCompenent(DefaultFormBuilder defaultFormBuilder, CellConstraints cellConstraints, QueryParameterElement queryParameterElement, int n2) {
        String string = queryParameterElement.getName();
        String string2 = Snippet.getBundledString(string);
        if (string.equalsIgnoreCase(SEND)) {
            defaultFormBuilder.append(string2);
            JScrollPane jScrollPane = new JScrollPane(this.getParameterComponent(queryParameterElement, string2));
            jScrollPane.setPreferredSize(DialogConstants.VIEW_LONG_SIZE);
            defaultFormBuilder.add((Component)jScrollPane, cellConstraints.xyw(defaultFormBuilder.getColumn(), defaultFormBuilder.getRow(), 3));
        } else {
            defaultFormBuilder.append(string2, (Component)this.getParameterComponent(queryParameterElement, string2));
            if (string.equalsIgnoreCase(PORT)) {
                this._portPanel = this.getPortPanel();
                defaultFormBuilder.append((Component)this._portPanel);
                this._portPanel.setVisible(false);
            } else {
                defaultFormBuilder.append(this.getLineEnd(queryParameterElement));
            }
        }
        return n2;
    }

    private JPanel getPortPanel() {
        FormLayout formLayout = new FormLayout("p,5dlu,p", "p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setBorder(null);
        CellConstraints cellConstraints = new CellConstraints();
        this._newPort.setPreferredSize(DialogConstants.OPERATE_SIZE);
        defaultFormBuilder.add((Component)this._newPort, cellConstraints.xy(1, 1));
        defaultFormBuilder.add((Component)this._protocolBox, cellConstraints.xy(3, 1));
        return defaultFormBuilder.getPanel();
    }

    @Override
    protected void initParameterData(QueryParameter queryParameter) {
        super.initParameterData(queryParameter);
        int n2 = Integer.parseInt(queryParameter.get(0).toString());
        if (n2 == -1) {
            this._newPort.setText(queryParameter.get(3).toString());
            this._protocolBox.setSelectedIndex(Integer.parseInt(queryParameter.get(4).toString()));
            this._portPanel.setVisible(true);
            this.setSize(this.getPreferredSize());
        }
    }

    @Override
    protected boolean checkParameter() {
        Object object;
        this._tmpParameters.clear();
        List list = this.getValidatedParametersValues();
        if (list == null) {
            return false;
        }
        Object e10 = list.get(2);
        if (e10 != null) {
            String string = e10.toString().toLowerCase();
            if (string.startsWith("0x")) {
                object = StringUtil.split2(string, " ");
                int n2 = ((String[])object).length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string2;
                    String string3 = string2 = object[i2].startsWith("0x") ? object[i2].substring(2) : object[i2];
                    if (string2.length() != 2) {
                        JOptionPane.showMessageDialog(this, DialogConstants.MESSAGE_INVALID_HEX);
                        return false;
                    }
                    if (StringUtil.isHex(string2)) continue;
                    JOptionPane.showMessageDialog(this, DialogConstants.MESSAGE_INVALID_HEX);
                    return false;
                }
            } else {
                string = e10.toString();
                if (string.indexOf(10) >= 0 && string.indexOf(13) < 0) {
                    string = StringUtil.replaceString(string, "\n", "\r\n");
                    list.set(2, string);
                }
            }
        }
        this._tmpParameters.addAll(list);
        int n3 = Integer.parseInt(list.get(0).toString());
        if (n3 == -1) {
            object = SingletonValidator.checkAllDialog(this, _bundle.getString("port"), this._newPort.getText(), PositiveIntValidator.CLASS);
            if (object == null) {
                return false;
            }
            this._tmpParameters.add(object);
            this._tmpParameters.add(String.valueOf(this._protocolBox.getSelectedIndex()));
        } else {
            this._tmpParameters.add(" ");
        }
        return true;
    }

    private class PortItem
    implements ItemListener {
        private PortItem() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            if (itemEvent.getStateChange() == 1 && itemSelectable.equals(PortDialog.this._portBox)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int n2 = PortDialog.this._portBox.getSelectedIndex();
                        if (n2 == PortDialog.this._portBox.getModel().getSize() - 1) {
                            PortDialog.this._portPanel.setVisible(true);
                        } else {
                            PortDialog.this._portPanel.setVisible(false);
                        }
                        PortDialog.this.setSize(PortDialog.this.getPreferredSize());
                    }
                });
            }
        }
    }
}

