/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.openapi.performance.QueryParameterElement;
import com.sysuptime.common.performance.Baseline;
import com.sysuptime.common.performance.ConfigThresholdElement;
import com.sysuptime.common.performance.FixedThreshold;
import com.sysuptime.common.performance.MetricsTimebucket;
import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.performance.MonitorHelper;
import com.sysuptime.common.performance.MonitorHost;
import com.sysuptime.common.performance.PerformanceGraph;
import com.sysuptime.common.performance.PerformanceGraph$ResultType;
import com.sysuptime.common.performance.PerformanceUtil;
import com.sysuptime.common.performance.QueryParameter;
import com.sysuptime.common.performance.RemoteHost;
import com.sysuptime.common.performance.ServiceNameElement;
import com.sysuptime.common.performance.SinglePerformance;
import com.sysuptime.common.performance.TargetFactory;
import com.sysuptime.common.performance.TwoDParameter;
import com.sysuptime.common.util.monitor.Snippet;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.MetricsChooser;
import com.sysuptime.mainframe.performance.MonitorBroker;
import com.sysuptime.mainframe.performance.MonitorGraphComponent;
import com.sysuptime.mainframe.util.SwingUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;

public class PerformanceUIUtil {
    private static final Logger _logger = Logger.getLogger((String)PerformanceUIUtil.class.getName());
    public static final String DEFAULT_DELIMITER = "$whitespace";

    private PerformanceUIUtil() {
    }

    public static void removeRow(JTable jTable, DefaultTableModel defaultTableModel, int n2) {
        DefaultCellEditor defaultCellEditor;
        if (jTable.getCellEditor() != null && jTable.getCellEditor() instanceof DefaultCellEditor && (defaultCellEditor = (DefaultCellEditor)jTable.getCellEditor()) != null) {
            defaultCellEditor.stopCellEditing();
        }
        defaultTableModel.removeRow(n2);
    }

    public static void createGraphChooser(JDialog jDialog, Monitor monitor) {
        try {
            int n2 = monitor.getScheduleId();
            PerformanceGraph performanceGraph = MonitorBroker.getPerformanceGraph(n2);
            List list = performanceGraph.getHosts();
            List list2 = performanceGraph.getResultTypes();
            if (list.size() > 1 || list2.size() > 1) {
                MetricsChooser metricsChooser = new MetricsChooser(jDialog, performanceGraph, monitor);
                metricsChooser.showOut();
            } else {
                ArrayList<SinglePerformance> arrayList = new ArrayList<SinglePerformance>();
                arrayList.add(new SinglePerformance((MonitorHost)list.get(0), (PerformanceGraph$ResultType)list2.get(0)));
                MonitorGraphComponent monitorGraphComponent = new MonitorGraphComponent(monitor, arrayList);
                Startup.addGraphTab(monitorGraphComponent);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"", (Throwable)exception);
        }
    }

    public static JDialog getProgressDialog(JDialog jDialog, String string, boolean bl2) {
        JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setIndeterminate(true);
        jProgressBar.setPreferredSize(new Dimension(300, 30));
        JDialog jDialog2 = PerformanceUIUtil.getSimpleDialog(jDialog, string, jProgressBar, bl2);
        jDialog2.getContentPane().setCursor(new Cursor(3));
        return jDialog2;
    }

    public static JDialog getSimpleDialog(JDialog jDialog, String string, JComponent jComponent, boolean bl2) {
        JDialog jDialog2 = new JDialog(jDialog, string, false);
        if (bl2) {
            jDialog2.setDefaultCloseOperation(2);
        } else {
            jDialog2.setDefaultCloseOperation(0);
        }
        jDialog2.setSize(jComponent.getPreferredSize());
        Container container = jDialog2.getContentPane();
        container.add((Component)jComponent, "Center");
        jDialog2.pack();
        SwingUtil.centerOnScreen(jDialog2);
        jDialog2.setVisible(true);
        return jDialog2;
    }

    public static long getHostId(List list, RemoteHost remoteHost) {
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            RemoteHost remoteHost2 = (RemoteHost)list.get(i2);
            if (!remoteHost2.equals(remoteHost)) continue;
            return remoteHost2.getHostId();
        }
        return -1L;
    }

    public static RemoteHost getHostById(List list, long l2) {
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            RemoteHost remoteHost = (RemoteHost)list.get(i2);
            if (remoteHost.getHostId() != l2) continue;
            return remoteHost;
        }
        return null;
    }

    public static void setGraceHeader(JTable jTable) {
        JTableHeader jTableHeader = jTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        TableCellRenderer tableCellRenderer = jTableHeader.getDefaultRenderer();
        if (tableCellRenderer instanceof DefaultTableCellRenderer) {
            DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)tableCellRenderer;
            defaultTableCellRenderer.setHorizontalAlignment(0);
        }
    }

    public static JComponent getGraceMessagePane(String string) {
        return PerformanceUIUtil.getGraceMessagePane(string, "text/html");
    }

    public static JComponent getGraceMessagePane(String string, String string2) {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setContentType(string2);
        jEditorPane.setText(string);
        jEditorPane.setCaretPosition(0);
        jEditorPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        jScrollPane.setPreferredSize(DialogConstants.VIEW_XLONG_SIZE);
        return jScrollPane;
    }

    public static JComponent getGraceMessagePane(String string, String string2, String string3) {
        FormLayout formLayout = new FormLayout("p", "p,3dlu,p,3dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setBorder(null);
        CellConstraints cellConstraints = new CellConstraints();
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setContentType("text/html");
        jEditorPane.setText(string);
        jEditorPane.setEditable(false);
        panelBuilder.add((Component)jEditorPane, cellConstraints.xy(1, 1));
        JLabel jLabel = new JLabel(string2);
        jLabel.setBackground(Color.GRAY);
        panelBuilder.add((Component)jLabel, cellConstraints.xy(1, 3));
        JEditorPane jEditorPane2 = new JEditorPane();
        jEditorPane2.setContentType("text/html");
        jEditorPane2.setText(string3);
        jEditorPane2.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jEditorPane2);
        jScrollPane.setPreferredSize(DialogConstants.VIEW_XLONG_SIZE);
        panelBuilder.add((Component)jScrollPane, cellConstraints.xy(1, 5));
        return panelBuilder.getPanel();
    }

    public static Long getHostId(QueryParameter queryParameter) {
        return Long.valueOf(queryParameter.get(0).toString());
    }

    public static boolean isTemplateMetrics(List list) {
        if (list.size() > 1) {
            return false;
        }
        ConfigThresholdElement configThresholdElement = (ConfigThresholdElement)list.get(0);
        String string = configThresholdElement.getValue();
        return string != null;
    }

    public static QueryParameter getTemplateProtocolParameter(ServiceNameElement serviceNameElement, String string) {
        List list = MonitorHelper.getMetricsParameters(serviceNameElement, string);
        int n2 = list.size();
        QueryParameter queryParameter = new QueryParameter();
        for (int i2 = 0; i2 < n2; ++i2) {
            QueryParameterElement queryParameterElement = (QueryParameterElement)list.get(i2);
            queryParameter.add(PerformanceUIUtil.getTemplateParaValue(queryParameterElement));
        }
        return queryParameter;
    }

    private static String getTemplateParaValue(QueryParameterElement queryParameterElement) {
        String string = queryParameterElement.getInput();
        String string2 = queryParameterElement.getValue();
        if (!string.equalsIgnoreCase("JComboBox")) {
            return string2;
        }
        List list = queryParameterElement.getItemList();
        int n2 = 0;
        if (string2 != null && string2.length() > 0) {
            n2 = Integer.parseInt(string2);
        }
        String string3 = queryParameterElement.getIdPostfix();
        String string4 = list.get(n2).toString();
        if (string3 == null) {
            return string4;
        }
        return Snippet.getBundledString(string4 + string3);
    }

    public static Baseline getTemplateMetrics(ConfigThresholdElement configThresholdElement) {
        Baseline baseline = TargetFactory.getBaseline();
        baseline.setResultTypeId(MonitorHelper.getConstantId(configThresholdElement.getName()));
        baseline.setParameters(PerformanceUIUtil.getTemplateParameter(configThresholdElement));
        MetricsTimebucket metricsTimebucket = PerformanceUIUtil.getTemplateTimebucket(configThresholdElement);
        baseline.addMetricsTimebucket(metricsTimebucket);
        return baseline;
    }

    private static QueryParameter getTemplateParameter(ConfigThresholdElement configThresholdElement) {
        if (configThresholdElement.metricsHasParameter()) {
            TwoDParameter twoDParameter = new TwoDParameter();
            ArrayList<String> arrayList = new ArrayList<String>(1);
            arrayList.add(String.valueOf(0));
            twoDParameter.add(arrayList);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add(String.valueOf(0));
            arrayList2.add(configThresholdElement.getLine() != null ? configThresholdElement.getLine() : "-1");
            arrayList2.add(configThresholdElement.getToken() != null ? configThresholdElement.getToken() : "-1");
            arrayList2.add(configThresholdElement.getDelimiter() != null ? configThresholdElement.getDelimiter() : DEFAULT_DELIMITER);
            twoDParameter.add(arrayList2);
            return twoDParameter;
        }
        return null;
    }

    private static MetricsTimebucket getTemplateTimebucket(ConfigThresholdElement configThresholdElement) {
        MetricsTimebucket metricsTimebucket = TargetFactory.getMetricsTimebucket();
        metricsTimebucket.setTimebucketId(-1L);
        metricsTimebucket.addThreshold(PerformanceUIUtil.getTemplateThreshold(configThresholdElement, true));
        metricsTimebucket.addThreshold(PerformanceUIUtil.getTemplateThreshold(configThresholdElement, false));
        return metricsTimebucket;
    }

    private static FixedThreshold getTemplateThreshold(ConfigThresholdElement configThresholdElement, boolean bl2) {
        FixedThreshold fixedThreshold = TargetFactory.getFixedThreshold();
        fixedThreshold.setClearAlarm(!bl2);
        String string = configThresholdElement.getCondition();
        if (string != null) {
            short s2 = PerformanceUtil.getFixedCondition(string);
            if (bl2) {
                fixedThreshold.setFixedConditionId(s2);
            } else {
                short s3 = (short)(9 - s2);
                fixedThreshold.setFixedConditionId(s3);
            }
        } else {
            fixedThreshold.setFixedConditionId((short)9);
        }
        fixedThreshold.setFixedThreshold(configThresholdElement.getValue());
        fixedThreshold.setSeverityId(bl2 ? (short)1 : 0);
        return fixedThreshold;
    }
}

