/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.performance.MonitorSnapshot;
import com.sysuptime.common.performance.ProtocolQueryResult;
import com.sysuptime.common.performance.ServiceNameElement;
import com.sysuptime.common.util.AppUtil;
import com.sysuptime.common.util.Device;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.common.util.Tokenizer;
import com.sysuptime.common.util.monitor.Snippet;
import com.sysuptime.mainframe.MainClient;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.performance.CheckMenuItem;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.DialogProvider;
import com.sysuptime.mainframe.performance.DoubleIdNameCell;
import com.sysuptime.mainframe.performance.IdNameRenderer;
import com.sysuptime.mainframe.performance.LongIdNameByNameCell;
import com.sysuptime.mainframe.performance.ManageMonitorDialog;
import com.sysuptime.mainframe.performance.MonitorBroker;
import com.sysuptime.mainframe.performance.PerformanceUIUtil;
import com.sysuptime.mainframe.performance.ReadOnlyTableModel;
import com.sysuptime.mainframe.performance.StringIdNameCell;
import com.sysuptime.mainframe.util.ClientConfig;
import com.sysuptime.mainframe.util.SwingUtil;
import com.sysuptime.mainframe.util.TableSorter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import no.uib.jsparklines.data.JSparklinesDataSeries;
import no.uib.jsparklines.data.JSparklinesDataset;
import no.uib.jsparklines.data.XYDataPoint;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesTableCellRenderer$PlotType;
import org.apache.log4j.Logger;
import org.jfree.chart.plot.PlotOrientation;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.pushingpixels.substance.api.SubstanceCortex;

public class MonitorsSnapshotViewer
extends TopComponent {
    private static final Logger _logger = Logger.getLogger((String)MonitorsSnapshotViewer.class.getName());
    protected static final ResourceBundle _bundle = NbBundle.getBundle(MonitorsSnapshotViewer.class);
    private static final String MONITORS_SNAPSHOT_ID = "MONITORS_SNAPSHOT_ID";
    private static final String MONITORS_SNAPSHOT_INTERVAL = "monitorSnapshotInterval";
    private static final String MONITORS_SNAPSHOT_RECENT = "monitorSnapshotTimespan";
    private static final String MONITORS_SNAPSHOT_GROUP = "monitorSnapshotGroup";
    private static MonitorsSnapshotViewer _instance;
    private JButton _apply;
    private static final int DEFAULT_INTERVAL = 0;
    private static final int DEFAULT_RECENT = 4;
    private ReadOnlyTableModel _model;
    private Timer _timer;
    private JMenuBar _typeCombo;
    private JTextField _ip = new JTextField();
    private JCheckBox _alarmOnly = new JCheckBox("Alarm Only");
    private JButton _refresh;
    private static int COL_RESULT_VALUE_INDEX;
    private static int COL_RESULT_MIN_VALUE_INDEX;
    private static int COL_RUN_DATETIME_INDEX;
    private static int COL_THRESHOLD_STATE_INDEX;
    private static int COL_ALARM_PERCENTAGE_INDEX;
    private static int COL_CHART_INDEX;
    int _filterProtocolType = -1;
    int _filterMetric = -1;
    String _filterIp;
    int[] _filterGroup = null;
    private static final Color BAR_COLOR;
    private static final Color BAR_COLOR2;
    private static final Color CHART_COLOR;
    JTable _table;
    public static final Color ROW_COLOR;

    private MonitorsSnapshotViewer() {
        this.setDisplayName(NbBundle.getMessage(MonitorsSnapshotViewer.class, (String)"MonitorsSnapshotViewer_title"));
        this.setLayout(new BorderLayout());
        this.add(this.createBody(), "Center");
        this.add(this.createTail(), "South");
    }

    private void updateSnapshot() {
        this._filterIp = this._ip.getText().trim();
        new Thread(() -> {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    this.setWaitState(true);
                    MainClient.getInstance().setStatus("Start to refresh at " + new Date());
                    this._model.getDataVector().clear();
                });
                List list = MonitorBroker.getRecentQueryResults(this._filterGroup, this._filterProtocolType, this._filterMetric, this._filterIp, 100, this._alarmOnly.isSelected());
                if (list == null) {
                    return;
                }
                SwingUtilities.invokeLater(() -> {
                    Serializable serializable;
                    double d10 = 0.0;
                    double d11 = 0.0;
                    int n2 = list.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        double d12;
                        serializable = (MonitorSnapshot)list.get(i2);
                        if ("N".equals(((ProtocolQueryResult)serializable).getErrorCode())) {
                            d12 = ((ProtocolQueryResult)serializable).getResultValue();
                            if (d12 > d10) {
                                d10 = d12;
                            }
                        } else {
                            d12 = -1.0;
                        }
                        double d13 = -2.147483648E9;
                        double d14 = 2.147483647E9;
                        double d15 = 0.0;
                        ArrayList<Double> arrayList = ((MonitorSnapshot)serializable).getValues();
                        for (Double d16 : arrayList) {
                            d15 += d16.doubleValue();
                            if (d16 > d13) {
                                d13 = d16;
                            }
                            if (!(d16 < d14)) continue;
                            d14 = d16;
                        }
                        if (d13 > d11) {
                            d11 = d13;
                        }
                        double d17 = 2.147483647E9;
                        if (arrayList.size() > 0) {
                            d17 = d15 / (double)arrayList.size();
                        }
                        if (d14 == 2.147483647E9) {
                            d14 = -1.0;
                        }
                        if (d13 == -2.147483648E9) {
                            d13 = -1.0;
                        }
                        if (d17 == 2.147483647E9) {
                            d17 = -1.0;
                        }
                        ((MonitorSnapshot)serializable).setValues(d14, d13, d17);
                        this._model.addRow(this.getRow((MonitorSnapshot)serializable, d12));
                    }
                    TableColumnModel tableColumnModel = this._table.getColumnModel();
                    TableColumn tableColumn = tableColumnModel.getColumn(COL_RESULT_VALUE_INDEX);
                    serializable = new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, (Double)0.0, d10, BAR_COLOR, BAR_COLOR2);
                    ((JSparklinesBarChartTableCellRenderer)serializable).showNumberAndChart(true, 50);
                    tableColumn.setCellRenderer((TableCellRenderer)((Object)serializable));
                    tableColumn = tableColumnModel.getColumn(COL_RESULT_MIN_VALUE_INDEX);
                    serializable = new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, (Double)0.0, d11, BAR_COLOR, BAR_COLOR2);
                    ((JSparklinesBarChartTableCellRenderer)serializable).showNumberAndChart(true, 50);
                    tableColumn.setCellRenderer((TableCellRenderer)((Object)serializable));
                    tableColumnModel.getColumn(COL_CHART_INDEX).setCellRenderer(new JSparklinesTableCellRenderer(JSparklinesTableCellRenderer$PlotType.areaChart, PlotOrientation.VERTICAL, 0.0, -1.0));
                    this._model.fireTableDataChanged();
                });
            }
            catch (Exception exception) {
                _logger.error((Object)exception);
            }
            finally {
                SwingUtilities.invokeLater(() -> {
                    MainClient.getInstance().setStatus("Refresh done at " + new Date());
                    this.setWaitState(false);
                });
            }
        }).start();
    }

    private JComponent createBody() {
        Serializable serializable;
        this._model = new ReadOnlyTableModel(null, this.getColumns()){

            public Class getColumnClass(int n2) {
                if (n2 == 0) {
                    return MonitorSnapshot.class;
                }
                if (n2 == COL_ALARM_PERCENTAGE_INDEX) {
                    return DoubleIdNameCell.class;
                }
                if (n2 == COL_RUN_DATETIME_INDEX) {
                    return LongIdNameByNameCell.class;
                }
                if (n2 == COL_THRESHOLD_STATE_INDEX) {
                    return StringIdNameCell.class;
                }
                if (n2 == COL_RESULT_VALUE_INDEX || n2 == COL_RESULT_MIN_VALUE_INDEX) {
                    return XYDataPoint.class;
                }
                if (n2 == COL_CHART_INDEX) {
                    return Object.class;
                }
                return String.class;
            }
        };
        TableSorter tableSorter = new TableSorter(this._model);
        tableSorter.setColumnComparator(LongIdNameByNameCell.class, TableSorter.COMPARABLE_COMAPRATOR);
        tableSorter.setColumnComparator(DoubleIdNameCell.class, TableSorter.COMPARABLE_COMAPRATOR);
        tableSorter.setColumnComparator(StringIdNameCell.class, TableSorter.COMPARABLE_COMAPRATOR);
        tableSorter.setColumnComparator(MonitorSnapshot.class, TableSorter.COMPARABLE_COMAPRATOR);
        JTable jTable = new JTable(tableSorter){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                Object var2_2 = null;
                Point point = mouseEvent.getPoint();
                int n2 = this.rowAtPoint(point);
                MonitorSnapshot monitorSnapshot = (MonitorSnapshot)this.getValueAt(n2, 0);
                String string = monitorSnapshot.getThresholdState();
                Object object = monitorSnapshot.getThresholdStateText();
                if (string.equals("A") || string.equals("E") || string.equals("B")) {
                    object = "<font color=red>" + (String)object + "</font>";
                }
                return "<html><table><tr><th>Name:</th><td> " + monitorSnapshot.getMonitorName() + "</td></tr><tr><th>Group:</th><td>" + monitorSnapshot.getGroupName() + "</td></tr><tr><th>Metric:</th><td>" + monitorSnapshot.getLocaleMetricsName() + "</td></tr><tr><th>State:</th><td>" + (String)object + "</td></tr></table></html>";
            }
        };
        jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                JTable jTable = (JTable)mouseEvent.getSource();
                Point point = mouseEvent.getPoint();
                int n2 = jTable.rowAtPoint(point);
                if (mouseEvent.getClickCount() == 2 && jTable.getSelectedRow() != -1) {
                    MonitorSnapshot monitorSnapshot = (MonitorSnapshot)MonitorsSnapshotViewer.this._table.getValueAt(n2, 0);
                    MonitorsSnapshotViewer.this.showMonitorGraph(monitorSnapshot.getScheduleId());
                }
            }
        });
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Show Graph");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n2 = MonitorsSnapshotViewer.this._table.getSelectedRow();
                MonitorSnapshot monitorSnapshot = (MonitorSnapshot)MonitorsSnapshotViewer.this._table.getValueAt(n2, 0);
                MonitorsSnapshotViewer.this.showMonitorGraph(monitorSnapshot.getScheduleId());
            }
        });
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Modify Monitor");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n2 = MonitorsSnapshotViewer.this._table.getSelectedRow();
                MonitorSnapshot monitorSnapshot = (MonitorSnapshot)MonitorsSnapshotViewer.this._table.getValueAt(n2, 0);
                Monitor monitor = MonitorBroker.getScheduleData(monitorSnapshot.getScheduleId());
                ServiceNameElement serviceNameElement = monitor.getTargetType();
                DialogProvider.createScheduleDialog((Frame)((Object)MainClient.getInstance()), DialogConstants.BUTTON_MODIFY + serviceNameElement.getLocale(), serviceNameElement, null, 0, monitor);
            }
        });
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete Monitor");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n2 = MonitorsSnapshotViewer.this._table.getSelectedRow();
                MonitorSnapshot monitorSnapshot = (MonitorSnapshot)MonitorsSnapshotViewer.this._table.getValueAt(n2, 0);
                Monitor monitor = MonitorBroker.getScheduleData(monitorSnapshot.getScheduleId());
                try {
                    int n3 = JOptionPane.showOptionDialog((Component)((Object)MainClient.getInstance()), DialogConstants.MESSAGE_REMOVE_SCHEDULE, ManageMonitorDialog.TITLE_REMOVE_MONITOR, 0, 2, null, DialogConstants.YES_NO_OPTION, DialogConstants.YES_NO_OPTION[1]);
                    if (n3 == 0 && ClientProxy.getInstance().removeMonitor(monitor.getScheduleId())) {
                        MonitorsSnapshotViewer.this.initUserData();
                    }
                }
                catch (Exception exception) {
                    _logger.error((Object)exception);
                }
            }
        });
        jPopupMenu.add(jMenuItem);
        jTable.setComponentPopupMenu(jPopupMenu);
        this._table = jTable;
        jTable.setRowHeight(35);
        PerformanceUIUtil.setGraceHeader(jTable);
        tableSorter.setTableHeader(jTable.getTableHeader());
        jTable.getTableHeader().setPreferredSize(new Dimension(50, 35));
        jTable.setSelectionMode(0);
        jTable.setMinimumSize(new Dimension(500, 300));
        jTable.setPreferredScrollableViewportSize(new Dimension(500, 300));
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        DefaultTableCellRenderer defaultTableCellRenderer = this.getRenderer();
        for (int i2 = 0; i2 < tableColumnModel.getColumnCount(); ++i2) {
            serializable = tableColumnModel.getColumn(i2);
            ((TableColumn)serializable).setCellRenderer(defaultTableCellRenderer);
        }
        IdNameRenderer idNameRenderer = this.getIdNameRenderer();
        idNameRenderer.setHorizontalAlignment(0);
        tableColumnModel.getColumn(COL_RUN_DATETIME_INDEX).setCellRenderer(idNameRenderer);
        tableColumnModel.getColumn(COL_THRESHOLD_STATE_INDEX).setCellRenderer(idNameRenderer);
        serializable = this.getIdNameRenderer();
        ((JLabel)serializable).setHorizontalAlignment(4);
        tableColumnModel.getColumn(COL_ALARM_PERCENTAGE_INDEX).setCellRenderer((TableCellRenderer)((Object)serializable));
        int n2 = MainClient.getInstance().getWidth();
        if (n2 < 100) {
            n2 = 1000;
        }
        jTable.getColumnModel().getColumn(0).setPreferredWidth((int)(0.12 * (double)n2));
        jTable.getColumnModel().getColumn(1).setPreferredWidth((int)(0.12 * (double)n2));
        jTable.getColumnModel().getColumn(2).setPreferredWidth((int)(0.12 * (double)n2));
        jTable.getColumnModel().getColumn(3).setPreferredWidth((int)(0.46 * (double)n2));
        jTable.getColumnModel().getColumn(4).setPreferredWidth((int)(0.06 * (double)n2));
        jTable.getColumnModel().getColumn(5).setPreferredWidth((int)(0.06 * (double)n2));
        jTable.getColumnModel().getColumn(6).setPreferredWidth((int)(0.03 * (double)n2));
        jTable.getColumnModel().getColumn(7).setPreferredWidth((int)(0.03 * (double)n2));
        jTable.getColumnModel().getColumn(6).setMinWidth(50);
        jTable.getColumnModel().getColumn(7).setMinWidth(50);
        return new JScrollPane(jTable);
    }

    private void showMonitorGraph(int n2) {
        Monitor monitor = MonitorBroker.getScheduleData(n2);
        PerformanceUIUtil.createGraphChooser(null, monitor);
    }

    private IdNameRenderer getIdNameRenderer() {
        return new IdNameRenderer(){

            @Override
            protected void setGround(JTable jTable, boolean bl2, int n2) {
                if (bl2) {
                    this.setForeground(jTable.getSelectionForeground());
                    this.setBackground(jTable.getSelectionBackground());
                } else {
                    this.setForeground(jTable.getForeground());
                    this.setBackground(n2 % 2 == 1 ? jTable.getBackground() : ROW_COLOR);
                }
            }
        };
    }

    private DefaultTableCellRenderer getRenderer() {
        return new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
                if (!bl2) {
                    this.setBackground(n2 % 2 == 1 ? jTable.getBackground() : ROW_COLOR);
                }
                return super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
            }
        };
    }

    private JPanel createTail() {
        FormLayout formLayout = new FormLayout("p,3dlu,p,3dlu,p,3dlu,p,10dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,p:g,p", "p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setBorder(null);
        CellConstraints cellConstraints = new CellConstraints();
        JMenuBar jMenuBar = this.createToolsMenu();
        defaultFormBuilder.add((Component)jMenuBar, cellConstraints.xy(1, 1));
        this._typeCombo = new JMenuBar();
        JLabel jLabel = new JLabel("<html><b> Table Filter : </b> ");
        jLabel.setForeground(new Color(0, 64, 0));
        defaultFormBuilder.add((Component)jLabel, cellConstraints.xy(3, 1));
        this.createFiltersMenu();
        defaultFormBuilder.add((Component)this._typeCombo, cellConstraints.xy(5, 1));
        defaultFormBuilder.addLabel("IP:", cellConstraints.xy(7, 1));
        this._ip.setPreferredSize(DialogConstants.LONG_SIZE);
        defaultFormBuilder.add((Component)this._ip, cellConstraints.xy(9, 1));
        this._alarmOnly.setPreferredSize(DialogConstants.LONG_SIZE);
        defaultFormBuilder.add((Component)this._alarmOnly, cellConstraints.xy(11, 1));
        this._apply = new JButton(_bundle.getString("apply") + " / Refresh");
        this._apply.addActionListener(actionEvent -> this.initUserData());
        defaultFormBuilder.add((Component)this._apply, cellConstraints.xy(13, 1));
        JPanel jPanel = defaultFormBuilder.getPanel();
        jPanel.setBorder(new EmptyBorder(2, 4, 2, 4));
        return jPanel;
    }

    private static void saveToImage(JTable jTable, JTableHeader jTableHeader) {
        boolean bl2 = Device.isOnRetinaDisplay(jTable);
        int n2 = 1;
        int n3 = Math.max(jTable.getWidth(), jTableHeader.getWidth());
        int n4 = jTable.getHeight() + jTableHeader.getHeight();
        if (bl2) {
            n2 = 2;
        }
        BufferedImage bufferedImage = new BufferedImage(n3 * n2, n4 * n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (n2 != 1) {
            graphics2D.scale(2.0, 2.0);
        }
        jTableHeader.paint(graphics2D);
        graphics2D.translate(0, jTableHeader.getHeight());
        jTable.paint(graphics2D);
        graphics2D.dispose();
        try {
            String string = System.getProperty("user.home");
            String string2 = string + "/Downloads/";
            File file = null;
            if (new File(string2).exists()) {
                string2 = string2 + "table_" + System.currentTimeMillis() + ".png";
                file = new File(string2);
            } else {
                file = new File(AppUtil.getClientSpecificDirectory("exports"));
                if (!file.exists()) {
                    file.mkdirs();
                }
                file = new File(file.getAbsolutePath() + "/table_" + System.currentTimeMillis() + ".png");
            }
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
            JButton jButton = MainClient.getInstance().setStatus("Saved table data to image file: " + file.getAbsolutePath());
            File file2 = file;
            jButton.addActionListener(actionEvent -> {
                try {
                    Desktop.getDesktop().open(file2.getAbsoluteFile());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        catch (Exception exception) {
            _logger.error((Object)"Export error:", (Throwable)exception);
        }
    }

    private JMenuBar createToolsMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Tools");
        jMenuBar.add(jMenu);
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Periodical Refresh");
        jCheckBoxMenuItem.addActionListener(actionEvent -> {
            if (jCheckBoxMenuItem.getState()) {
                String string;
                String string2 = ClientConfig.getProperty(MONITORS_SNAPSHOT_INTERVAL);
                if (string2 == null || !StringUtil.isDigit(string2)) {
                    string2 = "1";
                }
                if ((string = JOptionPane.showInputDialog((Component)((Object)MainClient.getInstance()), "Refresh Interval (in minutes): ", string2)) == null) {
                    jCheckBoxMenuItem.setState(false);
                    return;
                }
                ClientConfig.setProperty(MONITORS_SNAPSHOT_INTERVAL, string);
                this.initIntervalAndRecent();
                jCheckBoxMenuItem.setText("Refresh every " + string + " minute(s)");
            } else {
                jCheckBoxMenuItem.setText("Periodical Refresh");
                this.closeSnapshot();
            }
        });
        jMenu.add(jCheckBoxMenuItem);
        JMenuItem jMenuItem = new JMenuItem("Export to Image");
        jMenuItem.addActionListener(actionEvent -> MonitorsSnapshotViewer.saveToImage(this._table, this._table.getTableHeader()));
        jMenu.add(jMenuItem);
        return jMenuBar;
    }

    private void createFiltersMenu() {
        this._typeCombo = new JMenuBar();
    }

    private static String getTimespanString() {
        String string = ClientConfig.getProperty(MONITORS_SNAPSHOT_RECENT);
        if (string != null) {
            return string;
        }
        return "4";
    }

    private void updateInterval() {
    }

    public void refresh() {
        this.initUserData();
    }

    private void setWaitState(boolean bl2) {
        this.setCursor(bl2 ? new Cursor(3) : new Cursor(0));
    }

    private static void updateProperties(long l2, String string, String string2) {
        ClientConfig.setProperty(MONITORS_SNAPSHOT_GROUP, String.valueOf(l2));
        ClientConfig.setProperty(MONITORS_SNAPSHOT_INTERVAL, string);
        ClientConfig.setProperty(MONITORS_SNAPSHOT_RECENT, string2);
    }

    private void closeSnapshot() {
        if (this._timer != null) {
            this._timer.cancel();
        }
    }

    private synchronized void initUserData() {
        Map[] mapArray = MonitorBroker.getGroupFilterInfo();
        SwingUtilities.invokeLater(() -> {
            this._typeCombo.removeAll();
            this.initGroup(mapArray[0]);
            this.initMetrics(mapArray[1]);
            if (this._filterGroup != null) {
                JMenu jMenu = this._typeCombo.getMenu(0);
                block0: for (int i2 = 0; i2 < jMenu.getItemCount(); ++i2) {
                    CheckMenuItem checkMenuItem = (CheckMenuItem)jMenu.getItem(i2);
                    checkMenuItem.setState(false);
                    int n2 = checkMenuItem.getIDs()[0];
                    for (int i3 = 0; i3 < this._filterGroup.length; ++i3) {
                        if (this._filterGroup[i3] != n2) continue;
                        checkMenuItem.setState(true);
                        continue block0;
                    }
                }
            }
            this.updateSnapshot();
        });
    }

    private void resetMenuItems(JMenu jMenu) {
        for (Component component : jMenu.getMenuComponents()) {
            JMenuItem jMenuItem;
            if (component instanceof JMenu) {
                jMenuItem = (JMenu)component;
                for (int i2 = 0; i2 < ((JMenu)jMenuItem).getItemCount(); ++i2) {
                    JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)((JMenu)jMenuItem).getItem(i2);
                    jCheckBoxMenuItem.setState(false);
                }
                continue;
            }
            if (!(component instanceof JCheckBoxMenuItem)) continue;
            jMenuItem = (JCheckBoxMenuItem)component;
            ((JCheckBoxMenuItem)jMenuItem).setState(false);
        }
    }

    private void initMetrics(Map map) {
        JMenu jMenu = new JMenu("Metrics: All");
        this._typeCombo.add(jMenu);
        CheckMenuItem checkMenuItem = new CheckMenuItem("All", new int[]{-1, -1});
        checkMenuItem.addActionListener(actionEvent -> {
            jMenu.setText("Metrics: All");
            this._filterProtocolType = -1;
            this._filterMetric = -1;
            this.resetMenuItems(jMenu);
        });
        jMenu.add(checkMenuItem);
        if (this._filterProtocolType < 0) {
            checkMenuItem.setState(true);
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            String string = entry2.getKey().toString();
            _logger.info((Object)("initMetrics.key:<" + string + ">"));
            if (string.trim().length() == 0) continue;
            String[] stringArray = Tokenizer.parse(entry2.getValue().toString(), ',', true, true);
            String[] stringArray2 = Tokenizer.parse(string, ':', true, true);
            JMenu jMenu2 = new JMenu(Snippet.getBundledString(stringArray2[1]));
            jMenu.add(jMenu2);
            for (String string2 : stringArray) {
                String[] stringArray3 = Tokenizer.parse(string2, ':', true, true);
                CheckMenuItem checkMenuItem2 = new CheckMenuItem(Snippet.getBundledString(stringArray3[1]), new int[]{Integer.parseInt(stringArray2[0]), Integer.parseInt(stringArray3[0])});
                if (checkMenuItem2.getIDs()[0] == this._filterProtocolType && checkMenuItem2.getIDs()[1] == this._filterMetric) {
                    checkMenuItem2.setState(true);
                    jMenu.setText("Metrics: " + checkMenuItem2.getText());
                }
                checkMenuItem2.addActionListener(actionEvent -> {
                    CheckMenuItem checkMenuItem = (CheckMenuItem)actionEvent.getSource();
                    if (checkMenuItem.getState()) {
                        jMenu.setText("Metrics: " + checkMenuItem.getText());
                        this._filterProtocolType = checkMenuItem.getIDs()[0];
                        this._filterMetric = checkMenuItem.getIDs()[1];
                    }
                    checkMenuItem.setState(!checkMenuItem.getState());
                });
                jMenu2.add(checkMenuItem2);
            }
        }
    }

    private void initGroup(Map map) {
        JMenu jMenu = new JMenu("Group");
        this._typeCombo.add(jMenu);
        jMenu.setPreferredSize(DialogConstants.LONG_SIZE);
        CheckMenuItem checkMenuItem = new CheckMenuItem(_bundle.getString("allgroup"), new int[]{-2});
        checkMenuItem.setState(true);
        checkMenuItem.addActionListener(actionEvent -> {
            CheckMenuItem checkMenuItem = (CheckMenuItem)actionEvent.getSource();
            if (checkMenuItem.getState()) {
                this._filterGroup = null;
                this.resetMenuItems(jMenu);
                checkMenuItem.setState(true);
            }
        });
        jMenu.add(checkMenuItem);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            int n2 = ((Number)entry2.getKey()).intValue();
            CheckMenuItem checkMenuItem2 = new CheckMenuItem((String)entry2.getValue(), new int[]{n2});
            checkMenuItem2.addActionListener(actionEvent -> {
                Object object;
                CheckMenuItem checkMenuItem = (CheckMenuItem)actionEvent.getSource();
                if (checkMenuItem.getState()) {
                    if (this._filterGroup == null) {
                        this._filterGroup = new int[]{((CheckMenuItem)actionEvent.getSource()).getIDs()[0]};
                    } else {
                        object = new int[this._filterGroup.length + 1];
                        System.arraycopy(this._filterGroup, 0, object, 0, this._filterGroup.length);
                        object[this._filterGroup.length] = ((CheckMenuItem)actionEvent.getSource()).getIDs()[0];
                        this._filterGroup = (int[])object;
                    }
                }
                checkMenuItem.setState(!checkMenuItem.getState());
                object = new ArrayList();
                for (Component component : jMenu.getMenuComponents()) {
                    CheckMenuItem checkMenuItem2;
                    if (!(component instanceof CheckMenuItem) || !(checkMenuItem2 = (CheckMenuItem)component).getState() || checkMenuItem2.getIDs()[0] == -2) continue;
                    ((ArrayList)object).add(((CheckMenuItem)component).getIDs()[0]);
                }
                if (((ArrayList)object).size() > 0) {
                    this._filterGroup = new int[((ArrayList)object).size()];
                    for (int i2 = 0; i2 < this._filterGroup.length; ++i2) {
                        this._filterGroup[i2] = (Integer)((ArrayList)object).get(i2);
                    }
                    checkMenuItem.setState(false);
                } else {
                    checkMenuItem.setState(true);
                    this._filterGroup = null;
                }
            });
            jMenu.add(checkMenuItem2);
        }
    }

    private void initIntervalAndRecent() {
        String string = ClientConfig.getProperty(MONITORS_SNAPSHOT_INTERVAL);
        int n2 = 0;
        if (string != null) {
            n2 = Integer.parseInt(string);
        }
        String string2 = ClientConfig.getProperty(MONITORS_SNAPSHOT_RECENT);
        int n3 = 4;
        if (string2 != null) {
            n3 = Integer.parseInt(string2);
        }
        if (n2 > 0) {
            this._timer = new Timer();
            this._timer.schedule(this.getTimerTask(n3), new Date(), (long)(n2 * 60000));
        }
    }

    private TimerTask getTimerTask(int n2) {
        return new TimerTask(){

            @Override
            public void run() {
                MonitorsSnapshotViewer.this.initUserData();
            }
        };
    }

    public static synchronized MonitorsSnapshotViewer getInstance() {
        if (_instance == null) {
            if (SwingUtilities.isEventDispatchThread()) {
                _instance = (MonitorsSnapshotViewer)WindowManager.getDefault().findTopComponent(MONITORS_SNAPSHOT_ID);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            _instance = (MonitorsSnapshotViewer)WindowManager.getDefault().findTopComponent(MonitorsSnapshotViewer.MONITORS_SNAPSHOT_ID);
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (_instance == null) {
            _instance = new MonitorsSnapshotViewer();
        }
        return _instance;
    }

    public int getPersistenceType() {
        return 1;
    }

    public static void openSnapshot() {
        MonitorsSnapshotViewer monitorsSnapshotViewer = MonitorsSnapshotViewer.getInstance();
        JTabbedPane jTabbedPane = MainClient.getInstance().getTabbedPane();
        jTabbedPane.addTab("Monitors", SwingUtil.getImage("actions/discoveryreport.gif"), (Component)((Object)monitorsSnapshotViewer));
        int n2 = jTabbedPane.getTabCount() - 1;
        jTabbedPane.setToolTipTextAt(n2, "Overview of monitors with most recent 100 data");
        jTabbedPane.setSelectedIndex(jTabbedPane.getTabCount() - 1);
        SubstanceCortex.ComponentScope.setTabCloseButtonVisible((JComponent)((Object)monitorsSnapshotViewer), (Boolean)true);
        monitorsSnapshotViewer.componentOpened();
    }

    protected String preferredID() {
        return MONITORS_SNAPSHOT_ID;
    }

    protected void componentOpened() {
        SwingUtilities.invokeLater(() -> this.initUserData());
    }

    public void viewClosed() {
        this.closeSnapshot();
    }

    private String[] getColumns() {
        return new String[]{"<html><b>" + _bundle.getString("col_monitorname") + "</b></html>", "<html><font color=#3333FB><b>Latest Value</b></font> &amp;<br><font color=#6EC461><b>Average Value</b></font>", "<html><font color=#3333FB><b>Min Value</b></font> &amp;<br><font color=#6EC461><b>Max Value</b></font>", "<html><b>Chart ( last 100 data ) </b></html>", "<html><b>IP Address /<br>IP Range</b></html>", "<html><b>Query<br>Time</b></html>", "<html><b>Current<br>State</b></html>", "<html><b>Alarm<br> %</b></html>"};
    }

    private Object[] getRow(MonitorSnapshot monitorSnapshot, double d10) {
        ArrayList<Double> arrayList = monitorSnapshot.getValues();
        JSparklinesDataSeries jSparklinesDataSeries = new JSparklinesDataSeries(arrayList, CHART_COLOR, monitorSnapshot.getMonitorName());
        ArrayList<JSparklinesDataSeries> arrayList2 = new ArrayList<JSparklinesDataSeries>();
        arrayList2.add(jSparklinesDataSeries);
        JSparklinesDataset jSparklinesDataset = new JSparklinesDataset(arrayList2);
        String string = monitorSnapshot.getThresholdState();
        String string2 = monitorSnapshot.getThresholdStateText();
        if (string.equals("A") || string.equals("E") || string.equals("B")) {
            string2 = "<html><font color=red>Alarm</font></html>";
        }
        return new Object[]{monitorSnapshot, new XYDataPoint(d10, monitorSnapshot.getAvg()), new XYDataPoint(monitorSnapshot.getMin(), monitorSnapshot.getMax()), jSparklinesDataset, monitorSnapshot.getHostName(), new LongIdNameByNameCell(monitorSnapshot.getRunDateTime(), MonitorsSnapshotViewer.toDateHtml(monitorSnapshot.getRunDateTimeText())), new StringIdNameCell(string, string2), new DoubleIdNameCell(monitorSnapshot.getAlarmsPertentage(), monitorSnapshot.getAlarmsPertentageText())};
    }

    private static String toDateHtml(String string) {
        String[] stringArray = Tokenizer.parse(string, ' ', true, true);
        return "<html>" + stringArray[1] + "<br>" + stringArray[0];
    }

    static {
        COL_RESULT_VALUE_INDEX = 1;
        COL_RESULT_MIN_VALUE_INDEX = 2;
        COL_RUN_DATETIME_INDEX = 5;
        COL_THRESHOLD_STATE_INDEX = 6;
        COL_ALARM_PERCENTAGE_INDEX = 7;
        COL_CHART_INDEX = 3;
        BAR_COLOR = new Color(110, 196, 97);
        BAR_COLOR2 = new Color(51, 51, 251);
        CHART_COLOR = BAR_COLOR;
        ROW_COLOR = new Color(224, 224, 224);
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object.equals(MonitorsSnapshotViewer.this._apply)) {
                MonitorsSnapshotViewer.this.refresh();
            }
        }
    }

    private class GroupRenderer
    extends JLabel
    implements ListCellRenderer {
        public GroupRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            if (object instanceof LongIdNameByNameCell) {
                LongIdNameByNameCell longIdNameByNameCell = (LongIdNameByNameCell)object;
                this.setText(longIdNameByNameCell.getName());
            }
            if (bl2) {
                this.setForeground(jList.getSelectionForeground());
                this.setBackground(jList.getSelectionBackground());
            } else {
                this.setForeground(jList.getForeground());
                this.setBackground(jList.getBackground());
            }
            return this;
        }
    }
}

