/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.util.CommonUtil;
import com.sysuptime.mainframe.performance.DialogConstants;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.table.DefaultTableModel;

class MonitorTableModel
extends DefaultTableModel {
    private static final String[] COLUMNS = new String[]{DialogConstants.LABEL_GROUP, DialogConstants.LABEL_NAME, "Period (in seconds)"};
    protected Map _groupID2Name;
    protected List _monitors = new ArrayList();

    public MonitorTableModel(Map map) {
        this._groupID2Name = map;
    }

    public void setGroupID2Name(Map map) {
        this._groupID2Name.clear();
        this._groupID2Name.putAll(map);
    }

    public void addGroupId2Name(long l2, Object object) {
        this._groupID2Name.put(l2, object);
    }

    public void addMonitor(Monitor monitor) {
        this._monitors.add(monitor);
        this.fireTableDataChanged();
    }

    public void addMonitors(List list) {
        if (list == null) {
            return;
        }
        this._monitors.addAll(list);
        this.fireTableDataChanged();
    }

    public Monitor getMonitor(int n2) {
        return (Monitor)this._monitors.get(n2);
    }

    public void removeMonitor(Monitor monitor) {
        this._monitors.remove(monitor);
        this.fireTableDataChanged();
    }

    public void setMonitor(int n2, Monitor monitor) {
        this._monitors.set(n2, monitor);
        this.fireTableDataChanged();
    }

    public void clear() {
        this._monitors.clear();
        this.fireTableDataChanged();
    }

    public int getGroupColumnIndex() {
        return 0;
    }

    public int getNameColumnIndex() {
        return 1;
    }

    public int getSuspendColumnIndex() {
        return 2;
    }

    public int getResumeColumnIndex() {
        return 3;
    }

    public int getExpiredIndex() {
        return this.getColumnCount() - 1;
    }

    protected String[] getColumns() {
        return COLUMNS;
    }

    @Override
    public String getColumnName(int n2) {
        return this.getColumns()[n2];
    }

    @Override
    public int getColumnCount() {
        return this.getColumns().length;
    }

    @Override
    public int getRowCount() {
        return this._monitors == null ? 0 : this._monitors.size();
    }

    @Override
    public void setValueAt(Object object, int n2, int n3) {
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        Monitor monitor = (Monitor)this._monitors.get(n2);
        switch (n3) {
            case 0: {
                return this._groupID2Name.get(monitor.getGroupId());
            }
            case 1: {
                return monitor.getScheduleName();
            }
            case 2: {
                return monitor.getPeriod() / 1000L;
            }
        }
        return null;
    }

    protected String getFormattedResumeTime(Monitor monitor) {
        long l2 = monitor.getResumeTime();
        String string = null;
        if (l2 != 0L) {
            SimpleDateFormat simpleDateFormat = CommonUtil.getDateFormat();
            string = simpleDateFormat.format(new Date(monitor.getResumeTime()));
        } else {
            string = "";
        }
        return string;
    }

    @Override
    public boolean isCellEditable(int n2, int n3) {
        return false;
    }

    public Class getColumnClass(int n2) {
        return super.getColumnClass(n2);
    }
}

