/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.sysuptime.common.msp.Probe;
import com.sysuptime.common.performance.Monitor;
import com.sysuptime.mainframe.performance.ConfirmDialog;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.MonitorTableModel;
import java.util.List;
import java.util.Map;

public class MasterMonitorTableModel
extends MonitorTableModel {
    private static final String[] COLUMNS = new String[]{"Probe", DialogConstants.LABEL_GROUP, DialogConstants.LABEL_NAME, ConfirmDialog._bundle.getString("issuspended"), ConfirmDialog._bundle.getString("resumetime"), ConfirmDialog._bundle.getString("isexpiring")};
    private List _probes;

    public MasterMonitorTableModel(Map map, List list) {
        super(map);
        this._probes = list;
        this._probes.add(Probe.LOCAL_PROBE);
    }

    @Override
    protected String[] getColumns() {
        return COLUMNS;
    }

    @Override
    public int getGroupColumnIndex() {
        return 1;
    }

    @Override
    public int getNameColumnIndex() {
        return 2;
    }

    @Override
    public int getSuspendColumnIndex() {
        return 3;
    }

    @Override
    public int getResumeColumnIndex() {
        return 4;
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        Monitor monitor = (Monitor)this._monitors.get(n2);
        switch (n3) {
            case 0: {
                return this.getProbeName(monitor.getScheduleId());
            }
            case 1: {
                return this._groupID2Name.get(monitor.getGroupId());
            }
            case 2: {
                return monitor.getScheduleName();
            }
            case 3: {
                return monitor.isSuspended();
            }
            case 4: {
                return this.getFormattedResumeTime(monitor);
            }
            case 5: {
                return monitor.isExpired();
            }
        }
        return null;
    }

    private String getProbeName(int n2) {
        int n3 = Probe.getProbeID(n2);
        int n4 = this._probes.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            Probe probe = (Probe)this._probes.get(i2);
            if (probe.getId() != (long)n3) continue;
            return probe.getName();
        }
        return null;
    }
}

