/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.performance.Group;
import com.sysuptime.common.performance.TargetFactory;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.IdNameRenderer;
import com.sysuptime.mainframe.performance.LongIdNameByNameCell;
import com.sysuptime.mainframe.performance.ManageMonitorDialog;
import com.sysuptime.mainframe.performance.MonitorBroker;
import com.sysuptime.mainframe.performance.OperationDialog;
import com.sysuptime.mainframe.performance.PerformanceUIUtil;
import com.sysuptime.mainframe.performance.ReadOnlyTableModel;
import com.sysuptime.mainframe.performance.SelectionValidator;
import com.sysuptime.mainframe.performance.SingletonValidator;
import com.sysuptime.mainframe.util.SwingUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

public class ManageGroupDialog
extends OperationDialog {
    private static final String TITLE = _bundle.getString("title_group");
    private static final String BUTTON_REMOVE_GROUP = _bundle.getString("button_removegroup1");
    private static final String MESSAGE_MODIFY_GROUP = _bundle.getString("message_modifygroup");
    private static final String TITLE_REMOVE_GROUP = _bundle.getString("title_removegroup");
    private static final String MESSAGE_REMOVE_GROUP = "\n" + _bundle.getString("message_removegroup1") + "\n" + _bundle.getString("message_removegroup2") + "\n" + _bundle.getString("message_removegroup3") + "\n" + _bundle.getString("message_removegroup4");
    private static final String[] COLUMNS = new String[]{DialogConstants.LABEL_NAME};
    private JTable _groupListTable;
    private DefaultTableModel _groupListModel;
    private ManageMonitorDialog _monitorDialog;
    private static String[] OPTIONS = new String[]{BUTTON_REMOVE_GROUP, DialogConstants.BUTTON_REMOVE_DEPENDENCIES, DialogConstants.BUTTON_REMOVE_MONITORS, DialogConstants.BUTTON_QUIT};

    public ManageGroupDialog(Frame frame, boolean bl2) {
        super(frame, TITLE, bl2);
        this.initComponents();
        this.initUserData();
    }

    public ManageGroupDialog(JDialog jDialog, boolean bl2) {
        super(jDialog, TITLE, bl2);
        this._monitorDialog = (ManageMonitorDialog)jDialog;
        this.initComponents();
        this.initUserData();
    }

    private void initComponents() {
        this.setResizable(false);
        Container container = this.getContentPane();
        container.add((Component)this.getBodyPanel(), "Center");
        container.add((Component)this.getClosePanel(), "South");
        this.pack();
    }

    private JPanel getBodyPanel() {
        FormLayout formLayout = new FormLayout("p,5dlu,p", "p,3dlu,p:g");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        this._groupListModel = new ReadOnlyTableModel(null, COLUMNS);
        this._groupListTable = SwingUtil.createJTable(this._groupListModel);
        PerformanceUIUtil.setGraceHeader(this._groupListTable);
        this._groupListTable.setSelectionMode(0);
        this._groupListTable.setPreferredScrollableViewportSize(new Dimension(200, 150));
        JScrollPane jScrollPane = new JScrollPane(this._groupListTable);
        panelBuilder.add((Component)jScrollPane, cellConstraints.xywh(1, 1, 1, 3));
        panelBuilder.add((Component)this.getOperationPanel(false, true), cellConstraints.xy(3, 1));
        TableColumnModel tableColumnModel = this._groupListTable.getColumnModel();
        tableColumnModel.getColumn(0).setCellRenderer(new IdNameRenderer("Default"));
        this.getAddButton().setPreferredSize(DialogConstants.LONG_SIZE);
        this.getRemoveButton().setPreferredSize(DialogConstants.LONG_SIZE);
        this.getModifyButton().setPreferredSize(DialogConstants.LONG_SIZE);
        ListSelectionModel listSelectionModel = this._groupListTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new GroupListSelection());
        return panelBuilder.getPanel();
    }

    private void initUserData() {
        Map map = MonitorBroker.getGroupNameToId();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            long l2 = ((Number)entry2.getValue()).longValue();
            String string = entry2.getKey().toString();
            this._groupListModel.addRow(new Object[]{new LongIdNameByNameCell(l2, string)});
        }
    }

    @Override
    protected void addItem() {
        String string = JOptionPane.showInputDialog(this, (Object)DialogConstants.MESSAGE_ADD_GROUP);
        if (string != null && string.length() != 0) {
            if (this.isLapped(string)) {
                JOptionPane.showMessageDialog(this, DialogConstants.MESSAGE_NAME_LAP);
                return;
            }
            long l2 = -1L;
            try {
                l2 = ClientProxy.getInstance().storeGroup(new Group(l2, string));
            }
            catch (Exception exception) {
                this._logger.error((Object)"store group", (Throwable)exception);
            }
            if (l2 == -1L) {
                JOptionPane.showMessageDialog(this, DialogConstants.MESSAGE_NAME_LAP);
                return;
            }
            this._groupListModel.addRow(new Object[]{new LongIdNameByNameCell(l2, string)});
        }
    }

    private void removeRow(int n2) {
        PerformanceUIUtil.removeRow(this._groupListTable, this._groupListModel, n2);
    }

    @Override
    protected void removeItem() {
        int n2 = this._groupListTable.getSelectedRow();
        Object object = SingletonValidator.checkAllDialog(this, DialogConstants.MESSAGE_ONE_ROW, n2, SelectionValidator.CLASS);
        if (object != null) {
            try {
                int n3 = JOptionPane.showOptionDialog(this, MESSAGE_REMOVE_GROUP, TITLE_REMOVE_GROUP, 1, 2, null, OPTIONS, OPTIONS[3]);
                LongIdNameByNameCell longIdNameByNameCell = (LongIdNameByNameCell)this._groupListTable.getValueAt(n2, 0);
                switch (n3) {
                    case 0: {
                        if (ClientProxy.getInstance().modifyMonitorGroupId(longIdNameByNameCell.getId(), -1L)) {
                            if (this._monitorDialog != null) {
                                this._monitorDialog.modifyGroups(longIdNameByNameCell.getId(), -1L);
                            }
                            ClientProxy.getInstance().removeGroup(longIdNameByNameCell.getId(), n3);
                        }
                        this.removeRow(n2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        List list = ClientProxy.getInstance().removeGroup(longIdNameByNameCell.getId(), n3);
                        if (list != null && list.size() > 0 && this._monitorDialog != null) {
                            this._monitorDialog.removeMonitors(list);
                        }
                        this.removeRow(n2);
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
            }
            catch (Exception exception) {
                this._logger.error((Object)"modify monitor groupid", (Throwable)exception);
            }
        }
    }

    @Override
    protected void modifyItem() {
        LongIdNameByNameCell longIdNameByNameCell;
        String string;
        String string2;
        int n2 = this._groupListTable.getSelectedRow();
        Object object = SingletonValidator.checkAllDialog(this, DialogConstants.MESSAGE_ONE_ROW, n2, SelectionValidator.CLASS);
        if (object != null && (string2 = JOptionPane.showInputDialog(this, MESSAGE_MODIFY_GROUP, string = (longIdNameByNameCell = (LongIdNameByNameCell)this._groupListTable.getValueAt(n2, 0)).getName())) != null && string2.length() != 0) {
            try {
                if (string2.equalsIgnoreCase(string)) {
                    return;
                }
                if (this.isLapped(string2)) {
                    JOptionPane.showMessageDialog(this, DialogConstants.MESSAGE_NAME_LAP);
                    return;
                }
                if (!ClientProxy.getInstance().modifyGroupName(TargetFactory.getGroup(longIdNameByNameCell.getId(), string2))) {
                    JOptionPane.showMessageDialog(this, DialogConstants.MESSAGE_NAME_LAP);
                    return;
                }
                LongIdNameByNameCell longIdNameByNameCell2 = new LongIdNameByNameCell(longIdNameByNameCell.getId(), string2);
                Object[] objectArray = new Object[]{longIdNameByNameCell2};
                int n3 = this._groupListModel.getColumnCount();
                for (int i2 = 0; i2 < n3; ++i2) {
                    this._groupListModel.setValueAt(objectArray[i2], n2, i2);
                }
                if (this._monitorDialog != null) {
                    this._monitorDialog.modifyGroups(longIdNameByNameCell.getId(), longIdNameByNameCell2.getId());
                }
            }
            catch (Exception exception) {
                this._logger.error((Object)"modify group name", (Throwable)exception);
            }
        }
    }

    private void enableOperations(boolean bl2) {
        this.getRemoveButton().setEnabled(bl2);
        this.getModifyButton().setEnabled(bl2);
    }

    private boolean isLapped(String string) {
        int n2 = this._groupListTable.getRowCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            LongIdNameByNameCell longIdNameByNameCell = (LongIdNameByNameCell)this._groupListModel.getValueAt(i2, 0);
            String string2 = longIdNameByNameCell.getName();
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    private class GroupListSelection
    implements ListSelectionListener {
        private GroupListSelection() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (!listSelectionModel.isSelectionEmpty()) {
                int n2 = listSelectionModel.getMinSelectionIndex();
                LongIdNameByNameCell longIdNameByNameCell = (LongIdNameByNameCell)ManageGroupDialog.this._groupListModel.getValueAt(n2, 0);
                if (longIdNameByNameCell.getName().equalsIgnoreCase("Default")) {
                    ManageGroupDialog.this.enableOperations(false);
                } else {
                    ManageGroupDialog.this.enableOperations(true);
                }
            }
        }
    }
}

