/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.performance.FlagedRemoteHost;
import com.sysuptime.common.performance.MonitorHelper;
import com.sysuptime.common.performance.TargetFactory;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.DialogProvider;
import com.sysuptime.mainframe.performance.HostDialog;
import com.sysuptime.mainframe.performance.IdNameRenderer;
import com.sysuptime.mainframe.performance.IntIdNameByNameCell;
import com.sysuptime.mainframe.performance.LongIdNameByNameCell;
import com.sysuptime.mainframe.performance.OperationDialog;
import com.sysuptime.mainframe.performance.PerformanceUIUtil;
import com.sysuptime.mainframe.performance.ReadOnlyTableModel;
import com.sysuptime.mainframe.performance.RemoteHostKey;
import com.sysuptime.mainframe.performance.RemoteHostProtocolsViewerDialog;
import com.sysuptime.mainframe.performance.SelectionValidator;
import com.sysuptime.mainframe.performance.SingletonValidator;
import com.sysuptime.mainframe.util.SwingUtil;
import com.sysuptime.mainframe.util.TableSorter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

public class HostManagerDialog
extends OperationDialog {
    private static final String[] COLUMNS = new String[]{DialogConstants.LABEL_HOST, _bundle.getString("protocol"), DialogConstants.LABEL_USER_NAME, DialogConstants.LABEL_IN_USE};
    private static final String TITLE = _bundle.getString("title_hostmanagerdialog");
    private JTable _hostListTable;
    private DefaultTableModel _hostListModel;
    private TableSorter _sorter;
    public static final int COL_HOST = 0;
    public static final int COL_PROTOCOL = 1;
    public static final int COL_USER = 2;
    public static final int COL_IN_USE = 3;
    private Map _keyToFlagRemoteHost = new HashMap();
    private static Map _protocolNameToId;

    public HostManagerDialog(Frame frame, boolean bl2) {
        super(frame, TITLE, bl2);
        this.initComponents();
        this.initUserData();
    }

    private void initComponents() {
        Container container = this.getContentPane();
        container.add((Component)this.getBodyPanel(), "Center");
        container.add((Component)this.getClosePanel(), "South");
        this.pack();
    }

    private JPanel getBodyPanel() {
        FormLayout formLayout = new FormLayout("p:g,5dlu,p", "p,5dlu,p:g");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        this._hostListModel = new ReadOnlyTableModel(null, COLUMNS){

            public Class getColumnClass(int n2) {
                if (n2 == 0) {
                    return LongIdNameByNameCell.class;
                }
                if (n2 == 1) {
                    return IntIdNameByNameCell.class;
                }
                return super.getColumnClass(n2);
            }
        };
        this._sorter = new TableSorter(this._hostListModel);
        this._sorter.setColumnComparator(LongIdNameByNameCell.class, TableSorter.COMPARABLE_COMAPRATOR);
        this._sorter.setColumnComparator(IntIdNameByNameCell.class, TableSorter.COMPARABLE_COMAPRATOR);
        this._hostListTable = SwingUtil.createJTable(this._sorter);
        this._sorter.setTableHeader(this._hostListTable.getTableHeader());
        this._hostListTable.setSelectionMode(0);
        this._hostListTable.setPreferredScrollableViewportSize(new Dimension(350, 250));
        ListSelectionModel listSelectionModel = this._hostListTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new HostListSelection());
        TableColumnModel tableColumnModel = this._hostListTable.getColumnModel();
        tableColumnModel.getColumn(0).setCellRenderer(new IdNameRenderer());
        tableColumnModel.getColumn(1).setCellRenderer(new IdNameRenderer());
        JScrollPane jScrollPane = new JScrollPane(this._hostListTable);
        panelBuilder.add((Component)jScrollPane, cellConstraints.xywh(1, 1, 1, 3));
        panelBuilder.add((Component)this.getOperationPanel(false, true), cellConstraints.xy(3, 1));
        this.getAddButton().setPreferredSize(DialogConstants.LONG_SIZE);
        this.getRemoveButton().setPreferredSize(DialogConstants.LONG_SIZE);
        this.getModifyButton().setPreferredSize(DialogConstants.LONG_SIZE);
        return panelBuilder.getPanel();
    }

    private void initUserData() {
        try {
            List list = ClientProxy.getInstance().getAllFlagedRemoteHosts();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                FlagedRemoteHost flagedRemoteHost = (FlagedRemoteHost)list.get(i2);
                this._keyToFlagRemoteHost.put(new RemoteHostKey(flagedRemoteHost.getHostName(), flagedRemoteHost.getProtocol(), flagedRemoteHost.getUser()), flagedRemoteHost);
                this._hostListModel.addRow(new Object[]{new LongIdNameByNameCell(flagedRemoteHost.getHostId(), flagedRemoteHost.getHostName()), new IntIdNameByNameCell(flagedRemoteHost.getProtocol(), MonitorHelper.getConstantLocaleName(flagedRemoteHost.getProtocol())), flagedRemoteHost.getUser(), flagedRemoteHost.isUsed()});
            }
        }
        catch (Exception exception) {
            this._logger.error((Object)"get all flaged remote hosts", (Throwable)exception);
        }
    }

    @Override
    protected void addItem() {
        RemoteHostProtocolsViewerDialog remoteHostProtocolsViewerDialog = DialogProvider.createRemoteHostProtocolsViewerDialog(this, _protocolNameToId);
        if (remoteHostProtocolsViewerDialog.isPut()) {
            FlagedRemoteHost flagedRemoteHost = TargetFactory.getFlagedRemoteHost();
            flagedRemoteHost.setProtocol(remoteHostProtocolsViewerDialog.getProtocol());
            HostDialog hostDialog = DialogProvider.createHostDialog(this, DialogConstants.BUTTON_NEW, this._keyToFlagRemoteHost.keySet(), true, flagedRemoteHost, ClientProxy.getInstance().getProbe().getId());
            if (hostDialog.isPut()) {
                FlagedRemoteHost flagedRemoteHost2 = hostDialog.getRemoteHost();
                this._keyToFlagRemoteHost.put(new RemoteHostKey(flagedRemoteHost2.getHostName(), flagedRemoteHost2.getProtocol(), flagedRemoteHost2.getUser()), flagedRemoteHost2);
                this._hostListModel.addRow(new Object[]{new LongIdNameByNameCell(flagedRemoteHost2.getHostId(), flagedRemoteHost2.getHostName()), new IntIdNameByNameCell(flagedRemoteHost2.getProtocol(), MonitorHelper.getConstantLocaleName(flagedRemoteHost2.getProtocol())), flagedRemoteHost2.getUser(), flagedRemoteHost2.isUsed()});
            }
        }
    }

    @Override
    protected void removeItem() {
        long l2 = ClientProxy.getInstance().getProbe().getId();
        if (!ClientProxy.getInstance().isActive(l2)) {
            return;
        }
        try {
            int n2;
            Object object;
            int n3 = JOptionPane.showConfirmDialog(this, _bundle.getString("confirm_remove_remotehost"), ICommonBundle.CONFIRM, 0);
            if (n3 == 0 && (object = SingletonValidator.checkAllDialog(this, DialogConstants.MESSAGE_ONE_ROW, n2 = this._hostListTable.getSelectedRow(), SelectionValidator.CLASS)) != null) {
                n2 = this._sorter.modelIndex(n2);
                LongIdNameByNameCell longIdNameByNameCell = (LongIdNameByNameCell)this._hostListModel.getValueAt(n2, 0);
                IntIdNameByNameCell intIdNameByNameCell = (IntIdNameByNameCell)this._hostListModel.getValueAt(n2, 1);
                String string = (String)this._hostListModel.getValueAt(n2, 2);
                if (ClientProxy.getInstance().removeRemoteHost(longIdNameByNameCell.getId())) {
                    this._keyToFlagRemoteHost.remove(new RemoteHostKey(longIdNameByNameCell.getName(), intIdNameByNameCell.getId(), string));
                    PerformanceUIUtil.removeRow(this._hostListTable, this._hostListModel, n2);
                }
            }
        }
        catch (Exception exception) {
            this._logger.error((Object)"remove remote host", (Throwable)exception);
        }
    }

    @Override
    protected void modifyItem() {
        int n2 = this._hostListTable.getSelectedRow();
        Object object = SingletonValidator.checkAllDialog(this, DialogConstants.MESSAGE_ONE_ROW, n2, SelectionValidator.CLASS);
        if (object != null && n2 != -1 && n2 < this._sorter.getRowCount()) {
            int n3 = this._sorter.modelIndex(n2);
            LongIdNameByNameCell longIdNameByNameCell = (LongIdNameByNameCell)this._hostListModel.getValueAt(n3, 0);
            IntIdNameByNameCell intIdNameByNameCell = (IntIdNameByNameCell)this._hostListModel.getValueAt(n3, 1);
            String string = (String)this._hostListModel.getValueAt(n3, 2);
            FlagedRemoteHost flagedRemoteHost = (FlagedRemoteHost)this._keyToFlagRemoteHost.get(new RemoteHostKey(longIdNameByNameCell.getName(), intIdNameByNameCell.getId(), string));
            HostDialog hostDialog = DialogProvider.createHostDialog(this, DialogConstants.BUTTON_NEW, this._keyToFlagRemoteHost.keySet(), false, flagedRemoteHost, ClientProxy.getInstance().getProbe().getId());
            if (hostDialog.isPut()) {
                FlagedRemoteHost flagedRemoteHost2 = hostDialog.getRemoteHost();
                this._keyToFlagRemoteHost.remove(new RemoteHostKey(longIdNameByNameCell.getName(), intIdNameByNameCell.getId(), string));
                this._keyToFlagRemoteHost.put(new RemoteHostKey(flagedRemoteHost2.getHostName(), flagedRemoteHost2.getProtocol(), flagedRemoteHost2.getUser()), flagedRemoteHost2);
                this._hostListModel.setValueAt(new LongIdNameByNameCell(flagedRemoteHost2.getHostId(), flagedRemoteHost2.getHostName()), n3, 0);
                this._hostListModel.setValueAt(flagedRemoteHost2.getUser(), n3, 2);
            }
        }
    }

    static {
        Set set = MonitorHelper.getRemoteHostProtocols();
        _protocolNameToId = new HashMap(set.size());
        for (Number number : set) {
            _protocolNameToId.put(MonitorHelper.getConstantLocaleName(number.intValue()), number);
        }
    }

    private class HostListSelection
    implements ListSelectionListener {
        private HostListSelection() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n2;
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (!listSelectionModel.isSelectionEmpty() && (n2 = listSelectionModel.getMinSelectionIndex()) != -1 && n2 < HostManagerDialog.this._sorter.getRowCount()) {
                int n3 = HostManagerDialog.this._sorter.modelIndex(n2);
                Boolean bl2 = (Boolean)HostManagerDialog.this._hostListModel.getValueAt(n3, 3);
                if (bl2.booleanValue()) {
                    HostManagerDialog.this.getRemoveButton().setEnabled(false);
                } else {
                    HostManagerDialog.this.getRemoveButton().setEnabled(true);
                }
            }
        }
    }
}

