/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.sysuptime.common.performance.FlagedRemoteHost;
import com.sysuptime.common.performance.LdapHost;
import com.sysuptime.common.performance.MonitorHelper;
import com.sysuptime.common.performance.TargetFactory;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.msp.ProxyMBeanInvoker;
import com.sysuptime.mainframe.performance.AbstractProtocolParametersDialog;
import com.sysuptime.mainframe.performance.ComponentElement;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.RemoteHostKey;
import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import org.openide.util.NbBundle;

public class HostDialog
extends AbstractProtocolParametersDialog {
    private Set _hosts;
    private FlagedRemoteHost _newHost;
    private boolean _isAdded;
    private long _probeID;
    private List _parameterList;
    private RemoteHostKey _oldKey;
    private JPasswordField _password;
    private JPasswordField _confirmPassword;
    private static final int HOST_INDEX = 0;
    private static final int USER_INDEX = 1;
    private static final int PASSWORD_INDEX = 2;
    private static final int CONFIRM_PASSWORD_INDEX = 3;

    public HostDialog(JDialog jDialog, String string, boolean bl2, Set set, boolean bl3, FlagedRemoteHost flagedRemoteHost, long l2) {
        super(jDialog, string, bl2);
        this.initXmlData(set, bl3, flagedRemoteHost);
        this.initComponents();
        this.initUserData(flagedRemoteHost);
        this._probeID = l2;
    }

    private void initXmlData(Set set, boolean bl2, FlagedRemoteHost flagedRemoteHost) {
        this._hosts = set;
        this._isAdded = bl2;
        this._newHost = TargetFactory.getFlagedRemoteHost();
        this._newHost.setProtocol(flagedRemoteHost.getProtocol());
        this._parameterList = MonitorHelper.getRemoteHost(flagedRemoteHost.getProtocol()).getParameters();
    }

    private void initComponents() {
        Container container = this.getContentPane();
        container.add((Component)this.getTitlePanel(this._parameterList), "Center");
        container.add((Component)this.getConfirmPanel(), "South");
        this.pack();
    }

    private void initUserData(FlagedRemoteHost flagedRemoteHost) {
        List list = this.getParameterName();
        this._password = (JPasswordField)this.getComponent(list.get(2).toString());
        this._confirmPassword = (JPasswordField)this.getComponent(list.get(3).toString());
        if (!this._isAdded) {
            this._newHost.setHostId(flagedRemoteHost.getHostId());
            this._oldKey = new RemoteHostKey(flagedRemoteHost.getHostName(), flagedRemoteHost.getProtocol(), flagedRemoteHost.getUser());
            Object[] objectArray = this.getParameterValue().toArray();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.putAll(flagedRemoteHost.getProperty());
            hashMap.put(list.get(0).toString(), flagedRemoteHost.getHostName());
            hashMap.put(DialogConstants.LABEL_USER_NAME, flagedRemoteHost.getUser());
            int n2 = objectArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                ComponentElement componentElement = (ComponentElement)objectArray[i2];
                JComponent jComponent = componentElement.getComponent();
                String string = hashMap.get(componentElement.getName()).toString();
                this.getComponentProvider().setInput(jComponent, componentElement.getName(), string);
            }
        }
    }

    @Override
    protected void okDialog() {
        long l2 = ClientProxy.getInstance().getProbe().getId();
        if (!ClientProxy.getInstance().isActive(l2)) {
            return;
        }
        List list = this.getValidatedParametersValues();
        if (list == null) {
            return;
        }
        Object object = list.get(0).toString();
        String string = StringUtil.checkIpAddress((String)object);
        if (string != null) {
            object = string;
        }
        if (this._newHost.getProtocol() == LdapHost.LDAP_ID && ((String)object).indexOf("ldap://") == -1) {
            object = "ldap://" + (String)object + ":389";
        }
        this._newHost.setHostName((String)object);
        String string2 = list.get(1).toString();
        this._newHost.setUser(string2);
        if (!this.checkUserAndPassword(string2)) {
            return;
        }
        if (this.checkHost()) {
            List list2 = this.getParameterName();
            int n2 = list2.size();
            for (int i2 = 1; i2 < n2; ++i2) {
                this._newHost.put(list2.get(i2), list.get(i2));
            }
            if (this.putRemoteHost()) {
                this.dispose();
            }
        }
    }

    private boolean checkUserAndPassword(String string) {
        if (string.trim().length() != 0) {
            if (this._password.getPassword().length == 0) {
                JOptionPane.showMessageDialog(this, NbBundle.getMessage(HostDialog.class, (String)"message_needpassword"));
                return false;
            }
        } else if (this._password.getPassword().length != 0) {
            JOptionPane.showMessageDialog(this, NbBundle.getMessage(HostDialog.class, (String)"message_inputusername"));
            return false;
        }
        return true;
    }

    private boolean checkHost() {
        String string;
        String string2 = String.valueOf(this._password.getPassword());
        if (!string2.equals(string = String.valueOf(this._confirmPassword.getPassword()))) {
            JOptionPane.showMessageDialog(this, DialogConstants.MESSAGE_INVALID_PASSWORD);
            return false;
        }
        if (this.isLapped()) {
            JOptionPane.showMessageDialog(this, DialogConstants.MESSAGE_HOST_EXIST);
            return false;
        }
        return true;
    }

    private boolean isLapped() {
        boolean bl2 = false;
        RemoteHostKey remoteHostKey = new RemoteHostKey(this._newHost.getHostName(), this._newHost.getProtocol(), this._newHost.getUser());
        bl2 = this._isAdded ? this._hosts.contains(remoteHostKey) : !remoteHostKey.equals(this._oldKey) && this._hosts.contains(remoteHostKey);
        return bl2;
    }

    private boolean putRemoteHost() {
        try {
            if (this._isAdded) {
                long l2 = ProxyMBeanInvoker.INSTANCE.storeRemoteHost(this._newHost, this.getProbeID());
                this._newHost.setHostId(l2);
                return l2 != -1L;
            }
            return ProxyMBeanInvoker.INSTANCE.modifyRemoteHost(this._newHost, this.getProbeID());
        }
        catch (Exception exception) {
            this._logger.error((Object)"modify remotehost", (Throwable)exception);
            return false;
        }
    }

    public FlagedRemoteHost getRemoteHost() {
        return this._newHost;
    }

    public long getProbeID() {
        return this._probeID;
    }
}

