/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.ireasoning.app.mibbrowser.SnmpUtil;
import com.ireasoning.protocol.snmp.SnmpOID;
import com.ireasoning.protocol.snmp.SnmpTableModel;
import com.ireasoning.util.AgentProperties;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.performance.SnmpDevicesMonitorPane;
import java.util.HashMap;
import java.util.Map;
import org.openide.util.NbBundle;

public class DiskMonitorPane
extends SnmpDevicesMonitorPane {
    private static final String OS_LINUX = "linux";
    private static final String OS_WINDOWS = "windows";

    public DiskMonitorPane(String string, AgentProperties agentProperties) throws Exception {
        this.initDiskComponent(string, agentProperties);
    }

    private void initDiskComponent(String string, AgentProperties agentProperties) throws Exception {
        SnmpTableModel snmpTableModel = null;
        Map map = null;
        String string2 = SnmpUtil.getTableOID(new SnmpOID(".1.3.6.1.2.1.25.2.3.1"));
        snmpTableModel = ClientProxy.getInstance().snmpGetTable(agentProperties, string2, 30);
        if (snmpTableModel != null && snmpTableModel.getColumnCount() > 0) {
            if (string == null || string.trim().length() == 0) {
                string = OS_LINUX;
                map = this.geStorageIndex2DescrMap(snmpTableModel, 2, string);
                if (map.isEmpty()) {
                    string = OS_WINDOWS;
                    map = this.geStorageIndex2DescrMap(snmpTableModel, 2, string);
                }
            } else {
                map = this.geStorageIndex2DescrMap(snmpTableModel, 2, string);
            }
            if (!map.isEmpty()) {
                this.createComponent(map);
            }
        }
        if (map == null || map.isEmpty()) {
            throw new Exception(NbBundle.getMessage(DiskMonitorPane.class, (String)"MSG_get_data_error"));
        }
    }

    private Map geStorageIndex2DescrMap(SnmpTableModel snmpTableModel, int n2, String string) {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        String string2 = string.equalsIgnoreCase(OS_LINUX) || string.equalsIgnoreCase("MacOS") ? "/" : "\\";
        for (int i2 = 0; i2 < snmpTableModel.getRowCount(); ++i2) {
            String string3 = String.valueOf(snmpTableModel.getValueAt(i2, n2));
            if (string3.indexOf(string2) < 0) continue;
            int n3 = Integer.parseInt(String.valueOf(snmpTableModel.getValueAt(i2, 0)));
            String string4 = String.valueOf(snmpTableModel.getValueAt(i2, n2));
            if (string.equalsIgnoreCase(OS_LINUX) || string.equalsIgnoreCase("MacOS")) {
                hashMap.put(n3, string4);
                continue;
            }
            hashMap.put(n3, string4.substring(0, string4.indexOf(string2) + 1));
        }
        return hashMap;
    }

    @Override
    protected String getTitleBorderText() {
        return DiskMonitorPane.fromBundle("Title_disk");
    }

    private static String fromBundle(String string) {
        return NbBundle.getMessage(DiskMonitorPane.class, (String)string);
    }
}

