/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.sysuptime.common.performance.MonitorHelper;
import com.sysuptime.common.performance.MonitorTestRun;
import com.sysuptime.common.performance.ResultValue;
import com.sysuptime.common.util.monitor.Snippet;
import com.sysuptime.mainframe.performance.ConciseMonitorUtil;
import com.sysuptime.mainframe.performance.ConciseWmiMonitorSecondDialog;
import com.sysuptime.mainframe.performance.DevicesMonitorPane;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.WmiProcessMonitorPane;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.table.DefaultTableModel;
import org.openide.util.NbBundle;

public class ConciseWmiProcessMonitorSecondDialog
extends ConciseWmiMonitorSecondDialog {
    private WmiProcessMonitorPane _processMonitorPane;

    public ConciseWmiProcessMonitorSecondDialog(boolean bl2, DevicesMonitorPane devicesMonitorPane, DefaultTableModel defaultTableModel, long l2, int n2, String string) {
        super(bl2, ConciseWmiProcessMonitorSecondDialog.fromBundle("Title_wmi_process_util"), devicesMonitorPane, defaultTableModel, l2, n2, string);
        this._processMonitorPane = (WmiProcessMonitorPane)devicesMonitorPane;
        this._processMonitorPane.setThresholdCondition(DialogConstants.EXCLUDE);
    }

    @Override
    protected String getFilePath() {
        return ConciseMonitorUtil.PROCESS_FILE_PATH;
    }

    private static String fromBundle(String string) {
        return NbBundle.getMessage(ConciseWmiProcessMonitorSecondDialog.class, (String)string);
    }

    @Override
    protected void formatResult(StringBuffer stringBuffer, MonitorTestRun monitorTestRun) {
        String string = this._processMonitorPane.getThresholdResult();
        for (Map.Entry entry : monitorTestRun.getResultMap().entrySet()) {
            Integer n2 = (Integer)entry.getKey();
            ResultValue resultValue = (ResultValue)entry.getValue();
            String string2 = MonitorHelper.getConstantLocaleName(n2);
            if (resultValue.isError()) {
                stringBuffer.append("<b>").append(Snippet.getBundledString("errormessage")).append(" ( ").append(string2).append(" ) ").append(":").append("</b>").append("<br>");
                stringBuffer.append(resultValue.getErrorUnknownMessage());
            } else {
                stringBuffer.append("<b>").append("Processes state").append(" ").append(string2).append(" :").append("</b>").append("<br>");
                if (resultValue.isNormal()) {
                    stringBuffer.append("<table><tr><td><pre>").append(this.getRunningProcess(resultValue.getValue().toString(), string)).append("</pre></table>");
                } else if (resultValue.isUnknown()) {
                    stringBuffer.append(resultValue.getErrorUnknownMessage());
                }
            }
            stringBuffer.append("<p>");
        }
        stringBuffer.append("<p>").append(monitorTestRun.getErrorText());
        stringBuffer.append("<br>");
    }

    @Override
    protected String getQueryResultString() {
        return ConciseWmiProcessMonitorSecondDialog.fromBundle("process_state_result");
    }

    private String getRunningProcess(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        boolean bl2 = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.indexOf(string2) < 0) continue;
            bl2 = true;
            stringBuffer.append("<b>").append(string3).append(" ");
            stringBuffer.append(ConciseWmiProcessMonitorSecondDialog.fromBundle("MSG_process_is_running")).append("</b>").append("<br>");
        }
        if (!bl2) {
            stringBuffer.append("<b>").append(string2).append(" ");
            stringBuffer.append(ConciseWmiProcessMonitorSecondDialog.fromBundle("MSG_process_stopped")).append("</b>").append("<br>");
        }
        return stringBuffer.toString();
    }

    @Override
    protected int getMonitorType() {
        return this.PROCESS_TYPE;
    }
}

