/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.performance.FlagedRemoteHost;
import com.sysuptime.common.performance.MonitorHelper;
import com.sysuptime.common.performance.ProcessResult;
import com.sysuptime.common.performance.RemoteHost;
import com.sysuptime.common.performance.TargetFactory;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.performance.AddMonitorDialog;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.NonNullValidator;
import com.sysuptime.mainframe.performance.NumberValidator;
import com.sysuptime.mainframe.performance.RemoteHostKey;
import com.sysuptime.mainframe.performance.SingletonValidator;
import com.sysuptime.mainframe.performance.WmiDevicesMonitorPane;
import com.sysuptime.mainframe.util.FormUtils;
import com.sysuptime.mainframe.util.SwingUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public abstract class ConciseWMIMonitorFirstDialog
extends JDialog {
    protected static final String SCRIPTS_PATH = "$appDir" + File.separator + "scripts";
    private static final String WMI = "WMI";
    private static final int WMI_ID = MonitorHelper.getConstantId("WMI");
    private static final String DOMAIN_NAME_LABEL = ConciseWMIMonitorFirstDialog.fromBundle("domain_name_label");
    private static final String TIME_OUT_LABEL = ConciseWMIMonitorFirstDialog.fromBundle("timeout");
    private static final String DEFAULT_TIME_OUT = "30";
    private JPanel _mainPanel;
    private JPanel _advPanel;
    private JTextField _monitorField;
    private JTextField _timeoutField;
    private JTextField _hostTextField;
    private JTextField _userNameField;
    private JPasswordField _passwordField;
    private JPasswordField _confirmPasswordField;
    private JTextField _domainNameField;
    private DefaultComboBoxModel _comboBoxModel;
    private Map _key2Host;
    private DefaultTableModel _tableModel;
    private JComboBox _remoteHostComboBox;
    private static final String LABEL_MONITOR_NAME = ConciseWMIMonitorFirstDialog.fromBundle("Label_monitor_name");
    private static final Logger _logger = Logger.getLogger((String)ConciseWMIMonitorFirstDialog.class.getName());

    public ConciseWMIMonitorFirstDialog(DefaultTableModel defaultTableModel) {
        this();
        this._tableModel = defaultTableModel;
    }

    public ConciseWMIMonitorFirstDialog() {
        super((Dialog)AddMonitorDialog.getAddMonitorDialog(), true);
        this.initComponent();
        this.initData();
        this.showDialog();
    }

    private void initComponent() {
        this.getContentPane().add((Component)this.initRemoteHostPane(), "Center");
        this.getContentPane().add((Component)this.getConfirmPane(), "South");
    }

    private JPanel initRemoteHostPane() {
        this._mainPanel = new JPanel();
        FormLayout formLayout = new FormLayout("FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:134PX:GROW(1.0),FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE", "CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:GROW(1.0),CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE");
        CellConstraints cellConstraints = new CellConstraints();
        this._mainPanel.setLayout((LayoutManager)formLayout);
        JLabel jLabel = new JLabel(LABEL_MONITOR_NAME);
        this._mainPanel.add((Component)jLabel, cellConstraints.xy(2, 2));
        this._monitorField = new JTextField();
        this._mainPanel.add((Component)this._monitorField, cellConstraints.xy(4, 2));
        JLabel jLabel2 = new JLabel(TIME_OUT_LABEL);
        this._mainPanel.add((Component)jLabel2, cellConstraints.xy(2, 4));
        this._timeoutField = new JTextField();
        this._timeoutField.setText(DEFAULT_TIME_OUT);
        this._mainPanel.add((Component)this._timeoutField, cellConstraints.xy(4, 4));
        JLabel jLabel3 = new JLabel(ConciseWMIMonitorFirstDialog.fromBundle("Label_second_unit"));
        this._mainPanel.add((Component)jLabel3, cellConstraints.xy(6, 4));
        JLabel jLabel4 = new JLabel(ConciseWMIMonitorFirstDialog.fromBundle("remote_host"));
        this._mainPanel.add((Component)jLabel4, cellConstraints.xy(2, 6));
        this._remoteHostComboBox = new JComboBox();
        this._mainPanel.add((Component)this._remoteHostComboBox, cellConstraints.xy(4, 6));
        this._advPanel = this.initAdvPane();
        FormUtils.addFillComponents(this._mainPanel, new int[]{1, 2, 3, 4, 5, 6, 7}, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11});
        return this._mainPanel;
    }

    private JPanel initAdvPane() {
        FormLayout formLayout = new FormLayout("FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:134PX:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,", "CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE");
        CellConstraints cellConstraints = new CellConstraints();
        JPanel jPanel = new JPanel((LayoutManager)formLayout);
        JLabel jLabel = new JLabel(DialogConstants.LABEL_HOST);
        this._hostTextField = new JTextField();
        jPanel.add((Component)jLabel, cellConstraints.xy(1, 2));
        jPanel.add((Component)this._hostTextField, cellConstraints.xy(3, 2));
        JLabel jLabel2 = new JLabel(DialogConstants.LABEL_USER_NAME);
        this._userNameField = new JTextField();
        jPanel.add((Component)jLabel2, cellConstraints.xy(1, 4));
        jPanel.add((Component)this._userNameField, cellConstraints.xy(3, 4));
        jPanel.add((Component)new JLabel(DialogConstants.LABEL_ISOPTIONAL), cellConstraints.xy(5, 4));
        JLabel jLabel3 = new JLabel(DialogConstants.LABEL_PASSWORD);
        this._passwordField = new JPasswordField();
        jPanel.add((Component)jLabel3, cellConstraints.xy(1, 6));
        jPanel.add((Component)this._passwordField, cellConstraints.xy(3, 6));
        jPanel.add((Component)new JLabel(DialogConstants.LABEL_ISOPTIONAL), cellConstraints.xy(5, 6));
        JLabel jLabel4 = new JLabel(DialogConstants.LABEL_CONFIRM_PASSWORD);
        this._confirmPasswordField = new JPasswordField();
        jPanel.add((Component)jLabel4, cellConstraints.xy(1, 8));
        jPanel.add((Component)this._confirmPasswordField, cellConstraints.xy(3, 8));
        JLabel jLabel5 = new JLabel(DOMAIN_NAME_LABEL);
        this._domainNameField = new JTextField();
        jPanel.add((Component)jLabel5, cellConstraints.xy(1, 10));
        jPanel.add((Component)this._domainNameField, cellConstraints.xy(3, 10));
        jPanel.add((Component)new JLabel(DialogConstants.LABEL_ISOPTIONAL), cellConstraints.xy(5, 10));
        FormUtils.addFillComponents(jPanel, new int[]{1, 2, 3, 4, 5, 6}, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11});
        return jPanel;
    }

    private void initData() {
        this._key2Host = new HashMap();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list = new ArrayList();
        try {
            list = ClientProxy.getInstance().getRemoteHosts(WMI_ID);
        }
        catch (Exception exception) {
            _logger.error((Object)"get remote hosts Error occurs:", (Throwable)exception);
        }
        arrayList.add(" ");
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            RemoteHost remoteHost = (RemoteHost)list.get(i2);
            RemoteHostKey remoteHostKey = new RemoteHostKey(remoteHost.getHostName(), remoteHost.getProtocol(), remoteHost.getUser());
            this._key2Host.put(remoteHostKey, remoteHost);
            arrayList.add(remoteHostKey);
        }
        arrayList.add(ConciseWMIMonitorFirstDialog.fromBundle("label_newremotehost"));
        this._comboBoxModel = new DefaultComboBoxModel<Object>(arrayList.toArray());
        this._remoteHostComboBox.setModel(this._comboBoxModel);
        this._remoteHostComboBox.setRenderer(new RemoteHostRenderer());
        this._remoteHostComboBox.addItemListener(new HostItem());
    }

    private boolean check() {
        Object object = SingletonValidator.checkAllDialog(this, LABEL_MONITOR_NAME, this._monitorField.getText(), NonNullValidator.CLASS);
        if (object == null) {
            return false;
        }
        Object object2 = SingletonValidator.checkAllDialog(this, TIME_OUT_LABEL, this._timeoutField.getText(), NumberValidator.CLASS);
        if (object2 == null) {
            return false;
        }
        if (this._remoteHostComboBox.getSelectedIndex() <= 0) {
            JOptionPane.showMessageDialog(this, ConciseWMIMonitorFirstDialog.fromBundle("message_selectremotehost"));
            return false;
        }
        Object object3 = SingletonValidator.checkAllDialog(this, DialogConstants.LABEL_HOST, this._hostTextField.getText(), NonNullValidator.CLASS);
        if (object3 == null) {
            return false;
        }
        String string = this._userNameField.getText().trim();
        String string2 = String.valueOf(this._passwordField.getPassword());
        String string3 = String.valueOf(this._confirmPasswordField.getPassword());
        if (string.length() == 0 && string2.length() != 0) {
            JOptionPane.showMessageDialog(this, ConciseWMIMonitorFirstDialog.fromBundle("message_inputusername"));
            return false;
        }
        if (string.length() != 0 && string2.length() == 0) {
            JOptionPane.showMessageDialog(this, ConciseWMIMonitorFirstDialog.fromBundle("message_needpassword"));
            return false;
        }
        if (string.length() != 0 && string2.length() != 0 && !string2.equals(string3)) {
            JOptionPane.showMessageDialog(this, ConciseWMIMonitorFirstDialog.fromBundle("message_invalidpassword"));
            return false;
        }
        return true;
    }

    private JPanel getConfirmPane() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(ICommonBundle.NEXT);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ConciseWMIMonitorFirstDialog.this.check()) {
                    ConciseWMIMonitorFirstDialog.this.doNext();
                }
            }
        });
        JButton jButton2 = new JButton(ICommonBundle.CANCEL);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConciseWMIMonitorFirstDialog.this.dispose();
            }
        });
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.getRootPane().setDefaultButton(jButton);
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNext() {
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        try {
            WMIWaitDialog wMIWaitDialog = new WMIWaitDialog(Startup.getFrame(), true);
            Integer n2 = Integer.parseInt(this._timeoutField.getText().trim()) * 1000;
            SwingUtilities.invokeLater(() -> {
                Long l2 = null;
                ProcessResult processResult = null;
                RemoteHost remoteHost = null;
                try {
                    if (this._remoteHostComboBox.getSelectedIndex() == this._remoteHostComboBox.getItemCount() - 1) {
                        remoteHost = this.createNewRemoteHost();
                    } else if (this._remoteHostComboBox.getSelectedIndex() != 0) {
                        remoteHost = this.modifyRemoteHost();
                    }
                    if (remoteHost == null) {
                        return;
                    }
                    l2 = remoteHost.getHostId();
                    processResult = ClientProxy.getInstance().testConnection(this.getScriptFilePath(), l2, n2, this.getMonitorName());
                }
                catch (Exception exception) {
                    _logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
                finally {
                    wMIWaitDialog.dispose();
                }
                if (this.checkResult(processResult)) {
                    this.dispose();
                    WmiDevicesMonitorPane wmiDevicesMonitorPane = this.initDevicesMonitorPane(processResult.getResult());
                    this.createNextDialog(this._tableModel, wmiDevicesMonitorPane, l2, this.getTimeout(), this.getMonitorName());
                }
            });
            wMIWaitDialog.showCenterOnOwner();
        }
        finally {
            this.setCursor(cursor);
        }
    }

    public abstract WmiDevicesMonitorPane initDevicesMonitorPane(String var1);

    public boolean checkResult(ProcessResult processResult) {
        if (processResult.isException() || processResult.getExit() != 0) {
            JOptionPane.showMessageDialog(this, processResult.getResult());
            return false;
        }
        return true;
    }

    public abstract String getScriptFilePath();

    public abstract void createNextDialog(DefaultTableModel var1, WmiDevicesMonitorPane var2, long var3, int var5, String var6);

    private RemoteHost modifyRemoteHost() {
        try {
            RemoteHostKey remoteHostKey = (RemoteHostKey)this._remoteHostComboBox.getSelectedItem();
            RemoteHost remoteHost = (RemoteHost)this._key2Host.get(remoteHostKey);
            this.setRemoteHostParameter(remoteHost);
            if (!ClientProxy.getInstance().modifyRemoteHost(remoteHost)) {
                this.initData();
                remoteHostKey = new RemoteHostKey(remoteHost.getHostName(), remoteHost.getProtocol(), remoteHost.getUser());
                this._remoteHostComboBox.setSelectedItem(remoteHostKey);
                JOptionPane.showMessageDialog(this, ConciseWMIMonitorFirstDialog.fromBundle("MSG_save_remote_host_error"));
                return null;
            }
            return remoteHost;
        }
        catch (Exception exception) {
            _logger.error((Object)"modify remote host Error:", (Throwable)exception);
            return null;
        }
    }

    private String getRemoteHostName() {
        String string = this._hostTextField.getText().trim();
        String string2 = StringUtil.checkIpAddress(this._hostTextField.getText().trim());
        if (string2 != null) {
            string = string2;
        }
        return string;
    }

    private void setRemoteHostParameter(RemoteHost remoteHost) {
        String string = this.getRemoteHostName();
        remoteHost.setHostName(string);
        remoteHost.setProtocol(WMI_ID);
        remoteHost.setUser(this._userNameField.getText().trim());
        List list = this.getParameterName();
        List list2 = this.getParameter();
        int n2 = list.size();
        for (int i2 = 1; i2 < n2; ++i2) {
            remoteHost.put(list.get(i2), list2.get(i2));
        }
    }

    private RemoteHost createNewRemoteHost() {
        FlagedRemoteHost flagedRemoteHost = TargetFactory.getFlagedRemoteHost();
        this.setRemoteHostParameter(flagedRemoteHost);
        RemoteHostKey remoteHostKey = new RemoteHostKey(flagedRemoteHost.getHostName(), flagedRemoteHost.getProtocol(), flagedRemoteHost.getUser());
        if (this._key2Host.keySet().contains(remoteHostKey)) {
            JOptionPane.showMessageDialog(this, ConciseWMIMonitorFirstDialog.fromBundle("MSG_ADD_REMOTE_HOST_FAILED"));
            return null;
        }
        if (this.putRemoteHost(flagedRemoteHost)) {
            this.initData();
            this._comboBoxModel.setSelectedItem(remoteHostKey);
            return flagedRemoteHost;
        }
        JOptionPane.showMessageDialog(this, ConciseWMIMonitorFirstDialog.fromBundle("MSG_save_remote_host_error"));
        return null;
    }

    private boolean putRemoteHost(FlagedRemoteHost flagedRemoteHost) {
        long l2 = -1L;
        try {
            l2 = ClientProxy.getInstance().storeRemoteHost(flagedRemoteHost);
        }
        catch (Exception exception) {
            _logger.error((Object)"sotre remote host Error:", (Throwable)exception);
        }
        flagedRemoteHost.setHostId(l2);
        return l2 != -1L;
    }

    private List getParameterName() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("host_name");
        arrayList.add("user_name");
        arrayList.add("password");
        arrayList.add("confirm_password");
        arrayList.add("domain_name");
        return arrayList;
    }

    private List getParameter() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(0, this._hostTextField.getText().trim());
        arrayList.add(1, this._userNameField.getText().trim());
        arrayList.add(2, String.valueOf(this._passwordField.getPassword()));
        arrayList.add(3, String.valueOf(this._confirmPasswordField.getPassword()));
        arrayList.add(4, this._domainNameField.getText().trim());
        return arrayList;
    }

    public String getMonitorName() {
        return this._monitorField.getText().trim();
    }

    public int getTimeout() {
        return Integer.parseInt(this._timeoutField.getText().trim()) * 1000;
    }

    private static String fromBundle(String string) {
        return NbBundle.getMessage(ConciseWMIMonitorFirstDialog.class, (String)string);
    }

    private void showDialog() {
        this.pack();
        SwingUtil.centerOnFrame(Startup.getFrame(), this);
    }

    private class RemoteHostRenderer
    extends JLabel
    implements ListCellRenderer {
        public RemoteHostRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            if (object instanceof RemoteHostKey) {
                RemoteHostKey remoteHostKey = (RemoteHostKey)object;
                String string = remoteHostKey.getHost() + " ( " + remoteHostKey.getUser() + " )";
                this.setText(string);
                this.setToolTipText(string);
            } else if (object != null) {
                this.setText(object.toString());
                this.setToolTipText(object.toString());
            }
            if (bl2) {
                this.setForeground(jList.getSelectionForeground());
                this.setBackground(jList.getSelectionBackground());
            } else {
                this.setForeground(jList.getForeground());
                this.setBackground(jList.getBackground());
            }
            return this;
        }
    }

    private class HostItem
    implements ItemListener {
        private HostItem() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                final int n2 = ConciseWMIMonitorFirstDialog.this._remoteHostComboBox.getSelectedIndex();
                ConciseWMIMonitorFirstDialog.this._remoteHostComboBox.setSelectedIndex(n2);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Object object;
                        if (n2 == 0) {
                            ConciseWMIMonitorFirstDialog.this._mainPanel.remove(ConciseWMIMonitorFirstDialog.this._advPanel);
                        } else {
                            object = new CellConstraints();
                            ConciseWMIMonitorFirstDialog.this._mainPanel.add((Component)ConciseWMIMonitorFirstDialog.this._advPanel, object.xywh(2, 8, 5, 1));
                        }
                        ConciseWMIMonitorFirstDialog.this._mainPanel.updateUI();
                        ConciseWMIMonitorFirstDialog.this.pack();
                        if (n2 == ConciseWMIMonitorFirstDialog.this._remoteHostComboBox.getItemCount() - 1) {
                            object = ConciseWMIMonitorFirstDialog.fromBundle("tip_localhost_empty_user");
                            ConciseWMIMonitorFirstDialog.this._hostTextField.setText("");
                            ConciseWMIMonitorFirstDialog.this._hostTextField.setToolTipText((String)object);
                            ConciseWMIMonitorFirstDialog.this._userNameField.setToolTipText((String)object);
                            ConciseWMIMonitorFirstDialog.this._userNameField.setText("");
                            ConciseWMIMonitorFirstDialog.this._passwordField.setText("");
                            ConciseWMIMonitorFirstDialog.this._passwordField.setToolTipText((String)object);
                            ConciseWMIMonitorFirstDialog.this._confirmPasswordField.setText("");
                            ConciseWMIMonitorFirstDialog.this._confirmPasswordField.setToolTipText((String)object);
                            ConciseWMIMonitorFirstDialog.this._domainNameField.setText("");
                        } else if (n2 != 0) {
                            object = (RemoteHostKey)ConciseWMIMonitorFirstDialog.this._remoteHostComboBox.getSelectedItem();
                            RemoteHost remoteHost = (RemoteHost)ConciseWMIMonitorFirstDialog.this._key2Host.get(object);
                            ConciseWMIMonitorFirstDialog.this._hostTextField.setText(remoteHost.getHostName());
                            String string = remoteHost.getUser();
                            if (string != null && string.trim().length() != 0) {
                                ConciseWMIMonitorFirstDialog.this._userNameField.setText(string);
                            } else {
                                ConciseWMIMonitorFirstDialog.this._userNameField.setText("");
                            }
                            String string2 = (String)remoteHost.getValue("password");
                            if (string2 != null && string2.trim().length() != 0) {
                                ConciseWMIMonitorFirstDialog.this._passwordField.setText(string2);
                                ConciseWMIMonitorFirstDialog.this._confirmPasswordField.setText(string2);
                            } else {
                                ConciseWMIMonitorFirstDialog.this._passwordField.setText("");
                                ConciseWMIMonitorFirstDialog.this._confirmPasswordField.setText("");
                            }
                            String string3 = (String)remoteHost.getValue("domain_name");
                            if (string3 != null && string3.trim().length() != 0) {
                                ConciseWMIMonitorFirstDialog.this._domainNameField.setText(string3);
                            } else {
                                ConciseWMIMonitorFirstDialog.this._domainNameField.setText("");
                            }
                        }
                    }
                });
            }
        }
    }

    private class WMIWaitDialog
    extends JDialog
    implements ActionListener {
        public WMIWaitDialog(Frame frame, boolean bl2) {
            super(frame, bl2);
            this.setTitle(ConciseWMIMonitorFirstDialog.fromBundle("Title_Pleaset_Wait"));
            this.init();
        }

        private void init() {
            Container container = this.getContentPane();
            JComponent jComponent = this.createCenterComponent();
            container.add((Component)jComponent, "Center");
            container.add((Component)this.createSouthComponent(), "South");
        }

        private JComponent createCenterComponent() {
            JProgressBar jProgressBar = new JProgressBar();
            jProgressBar.setIndeterminate(true);
            jProgressBar.setPreferredSize(new Dimension(300, 30));
            return jProgressBar;
        }

        private JComponent createSouthComponent() {
            JPanel jPanel = new JPanel();
            JButton jButton = new JButton(ICommonBundle.CLOSE);
            jButton.addActionListener(this);
            jPanel.add(jButton);
            this.getRootPane().setDefaultButton(jButton);
            return jPanel;
        }

        public void showCenterOnOwner() {
            this.pack();
            SwingUtil.centerOnFrame(this.getOwner(), this);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.snmpWaitDialogDispose();
        }

        public void snmpWaitDialogDispose() {
            this.dispose();
        }
    }
}

