/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.sysuptime.common.performance.MonitorHelper;
import com.sysuptime.common.performance.MonitorTestRun;
import com.sysuptime.common.performance.ResultValue;
import com.sysuptime.common.util.NameValuePair;
import com.sysuptime.common.util.monitor.Snippet;
import com.sysuptime.mainframe.performance.ConciseSshMonitorSecondDialog;
import com.sysuptime.mainframe.performance.DevicesMonitorPane;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.WmiProcessMonitorPane;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.swing.table.DefaultTableModel;
import org.openide.util.NbBundle;

public class ConciseSshProcessMonitorSecondDialog
extends ConciseSshMonitorSecondDialog {
    private WmiProcessMonitorPane _processMonitorPane;
    private NameValuePair _monitor2command;

    public ConciseSshProcessMonitorSecondDialog(boolean bl2, DevicesMonitorPane devicesMonitorPane, DefaultTableModel defaultTableModel, long l2, int n2, String string, NameValuePair nameValuePair) {
        super(bl2, ConciseSshProcessMonitorSecondDialog.fromBundle("Title_ssh_process_util"), devicesMonitorPane, defaultTableModel, l2, n2, string, nameValuePair);
        this._monitor2command = nameValuePair;
        this._processMonitorPane = (WmiProcessMonitorPane)devicesMonitorPane;
        this._processMonitorPane.setThresholdCondition(DialogConstants.EXCLUDE);
    }

    private static String fromBundle(String string) {
        return NbBundle.getMessage(ConciseSshProcessMonitorSecondDialog.class, (String)string);
    }

    @Override
    protected String getQueryResultString() {
        return ConciseSshProcessMonitorSecondDialog.fromBundle("process_state_result");
    }

    @Override
    protected void formatResult(StringBuffer stringBuffer, MonitorTestRun monitorTestRun) {
        String string = this._processMonitorPane.getThresholdResult();
        Iterator iterator = monitorTestRun.getResultMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            Integer n2 = (Integer)entry2.getKey();
            ResultValue resultValue = (ResultValue)entry2.getValue();
            String string2 = MonitorHelper.getConstantLocaleName(n2);
            if (resultValue.isError()) {
                stringBuffer.append("<b>").append(Snippet.getBundledString("errormessage")).append(" ( ").append(string2).append(" ) ").append(":").append("</b>").append("<br>");
                stringBuffer.append(resultValue.getErrorUnknownMessage());
            } else {
                stringBuffer.append("<b>").append("Processes state").append(" ").append(string2).append(" :").append("</b>").append("<br>");
                if (resultValue.isNormal()) {
                    stringBuffer.append("<table><tr><td><pre>").append(this.getRunningProcess(resultValue.getValue().toString(), string)).append("</pre></table>");
                } else if (resultValue.isUnknown()) {
                    stringBuffer.append(resultValue.getErrorUnknownMessage());
                }
            }
            stringBuffer.append("<p>");
        }
        stringBuffer.append("<p>").append(monitorTestRun.getErrorText());
        stringBuffer.append("<br>");
    }

    private String getRunningProcess(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        boolean bl2 = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (string3.indexOf(string2) < 0) continue;
            bl2 = true;
            boolean bl3 = Pattern.compile("Linux").matcher((String)this._monitor2command.getName()).find();
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = bl3 ? 10 : 7;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = string3.indexOf(" ");
                String string4 = string3.substring(0, n3);
                arrayList.add(string4);
                string3 = string3.substring(n3).trim();
            }
            arrayList.add(string3);
            stringBuffer.append("<b>").append(string2).append(" ");
            stringBuffer.append(ConciseSshProcessMonitorSecondDialog.fromBundle("MSG_process_is_running")).append("</b>").append("<br>");
            stringBuffer.append("<table style=\" font-size:12pt;\">");
            stringBuffer.append("<tr><td><b>USER:</b></td><td>").append((String)arrayList.get(0)).append("</td></tr>");
            stringBuffer.append("<tr><td><b>PID:</b></td><td>").append((String)arrayList.get(1)).append("</td></tr>");
            if (bl3) {
                stringBuffer.append("<tr><td><b>%CPU:</b></td><td>").append((String)arrayList.get(2)).append("</td></tr>");
                stringBuffer.append("<tr><td><b>%MEM:</b></td><td>").append((String)arrayList.get(3)).append("</td></tr>");
                stringBuffer.append("<tr><td><b>VSZ:</b></td><td>").append((String)arrayList.get(4)).append("</td></tr>");
                stringBuffer.append("<tr><td><b>RSS:</b></td><td>").append((String)arrayList.get(5)).append("</td></tr>");
                stringBuffer.append("<tr><td><b>TTY:</b></td><td>").append((String)arrayList.get(6)).append("</td></tr>");
                stringBuffer.append("<tr><td><b>STAT:</b></td><td>").append((String)arrayList.get(7)).append("</td></tr>");
                stringBuffer.append("<tr><td><b>START:</b></td><td>").append((String)arrayList.get(8)).append("</td></tr>");
                stringBuffer.append("<tr><td><b>TIME:</b></td><td>").append((String)arrayList.get(9)).append("</td></tr>");
                stringBuffer.append("<tr valign=\"top\"><td><b>COMMAND:</b></td><td>").append((String)arrayList.get(10)).append("</td></tr>");
            } else {
                stringBuffer.append("<tr><td><b>PPID:</b></td><td>").append((String)arrayList.get(2)).append("</td></tr>");
                stringBuffer.append("<tr><td><b>C:</b></td><td>").append((String)arrayList.get(3)).append("</td></tr>");
                stringBuffer.append("<tr><td><b>STIME:</b></td><td>").append((String)arrayList.get(4)).append("</td></tr>");
                stringBuffer.append("<tr><td><b>TTY:</b></td><td>").append((String)arrayList.get(5)).append("</td></tr>");
                stringBuffer.append("<tr><td><b>TIME:</b></td><td>").append((String)arrayList.get(6)).append("</td></tr>");
                stringBuffer.append("<tr valign=\"top\"><td><b>COMMAND:</b></td><td>").append((String)arrayList.get(7)).append("</td></tr>");
            }
            stringBuffer.append("</table><br>");
        }
        if (!bl2) {
            stringBuffer.append("<b>").append(string2).append(" ");
            stringBuffer.append(ConciseSshProcessMonitorSecondDialog.fromBundle("MSG_process_stopped")).append("</b>").append("<br>");
        }
        return stringBuffer.toString();
    }

    @Override
    protected int getMonitorType() {
        return this.PROCESS_TYPE;
    }
}

