/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.ireasoning.util.AgentProperties;
import com.sysuptime.common.expression.IExpression;
import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.performance.MonitorHelper;
import com.sysuptime.common.performance.QueryParameter;
import com.sysuptime.common.performance.ServiceNameElement;
import com.sysuptime.common.performance.TargetFactory;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.performance.ConciseMonitorSecondDialog;
import com.sysuptime.mainframe.performance.SnmpDevicesMonitorPane;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public abstract class ConciseSnmpMonitorSecondDialog
extends ConciseMonitorSecondDialog {
    private AgentProperties _agentProp;
    private SnmpDevicesMonitorPane _snmpDevicesMonitorPane;
    private long _timeout = 5000L;
    private int _retries = 1;
    protected static final Logger _logger = Logger.getLogger((String)ConciseSnmpMonitorSecondDialog.class.getName());

    public ConciseSnmpMonitorSecondDialog(boolean bl2, String string, SnmpDevicesMonitorPane snmpDevicesMonitorPane, AgentProperties agentProperties, DefaultTableModel defaultTableModel) {
        super(bl2, string, snmpDevicesMonitorPane, defaultTableModel);
        this._agentProp = agentProperties;
        this._snmpDevicesMonitorPane = snmpDevicesMonitorPane;
    }

    @Override
    protected HashMap getTestRunParameters() {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            IExpression iExpression = this.getExpression();
            List list = this.createMonitors(iExpression);
            String string = this._agentProp.getIpAddress();
            hashMap.put("allMonitors", list);
            hashMap.put("showHost", "true");
            hashMap.put("ipAddress", string);
            return hashMap;
        }
        catch (Exception exception) {
            _logger.error((Object)"get expression Error:", (Throwable)exception);
            return null;
        }
    }

    @Override
    protected boolean selectOneCheck() {
        if (this._snmpDevicesMonitorPane.getAllSelectedCheckBoxIndex2DescrMap() == null || !this._snmpDevicesMonitorPane.getAllSelectedCheckBoxIndex2DescrMap().isEmpty()) {
            return true;
        }
        JOptionPane.showMessageDialog(this, ConciseSnmpMonitorSecondDialog.fromBundle("MSG_select_one_device_error"));
        return false;
    }

    @Override
    protected void doOk() {
        try {
            IExpression iExpression = this.getExpression();
            if (iExpression == null) {
                return;
            }
            List list = this.createMonitors(iExpression);
            super.doOk(list);
        }
        catch (Exception exception) {
            _logger.error((Object)"get expression Error:", (Throwable)exception);
        }
    }

    private IExpression getExpression() throws Exception {
        String string = this.getExpressionName();
        IExpression iExpression = this.getSpecialExpression(string);
        if (iExpression == null) {
            iExpression = this.createNormalExpression(string);
        }
        return iExpression;
    }

    protected abstract IExpression createNormalExpression(String var1);

    protected abstract String getExpressionName();

    public IExpression createSubExpression(IExpression iExpression, int n2) {
        try {
            String string = iExpression.getExpressionName() + "." + n2;
            Vector vector = iExpression.getVars();
            Vector vector2 = new Vector();
            int n3 = vector.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                Vector vector3 = new Vector();
                Vector vector4 = (Vector)vector.get(i2);
                vector3.addElement(vector4.get(0));
                vector3.addElement(String.valueOf(vector4.get(1)) + n2);
                vector2.add(vector3);
            }
            return ClientProxy.getInstance().updateExpression(string, iExpression.getExpression(), iExpression.getDescription(), vector2);
        }
        catch (Exception exception) {
            _logger.error((Object)"create expression Error:", (Throwable)exception);
            return null;
        }
    }

    protected IExpression getSubExpressin(IExpression iExpression, int n2) throws Exception {
        IExpression iExpression2 = this.getSpecialExpression(iExpression.getExpressionName() + "." + n2);
        if (iExpression2 == null) {
            iExpression2 = this.createSubExpression(iExpression, n2);
        }
        return iExpression2;
    }

    private void setV3Parameter(List list) {
        list.add(this._agentProp.getUser());
        if (this._agentProp.getAuth().indexOf("MD5") != -1) {
            list.add("MD5");
        } else {
            list.add("SHA");
        }
        list.add(this._agentProp.getAuthPasswd());
        if (this._agentProp.getPriv() == 0) {
            list.add("DES");
        } else {
            list.add("AES");
        }
        list.add(this._agentProp.getPrivPasswd());
    }

    private void setV2Parameter(List list) {
        list.add(String.valueOf(this._agentProp.getPort()));
        list.add(this._agentProp.getReadCommunity());
        list.add(String.valueOf(this._timeout));
        list.add(String.valueOf(this._retries));
        list.add(String.valueOf(this._agentProp.getVersion()));
    }

    private void setMonitorQueryParameter(Monitor monitor, IExpression iExpression, int n2) {
        short s2 = monitor.getProtocolType();
        QueryParameter queryParameter = null;
        try {
            queryParameter = MonitorHelper.getMetricsParameterClass(s2);
            ArrayList<String> arrayList = new ArrayList<String>();
            IExpression iExpression2 = this.getSubExpressin(iExpression, n2);
            if (iExpression2 != null) {
                arrayList.add(iExpression2.getExpressionName());
                this.setV2Parameter(arrayList);
                if (this._agentProp.isSnmpV3()) {
                    this.setV3Parameter(arrayList);
                }
                queryParameter.addAll(arrayList);
                monitor.setQueryParameters(queryParameter);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
            return;
        }
    }

    protected List createMonitors(IExpression iExpression) {
        ArrayList<Monitor> arrayList = new ArrayList<Monitor>();
        ArrayList<Object> arrayList2 = new ArrayList();
        ArrayList<Object> arrayList3 = new ArrayList();
        if (this._snmpDevicesMonitorPane.getAllSelectedCheckBoxIndex2DescrMap() != null) {
            arrayList2 = new ArrayList(this._snmpDevicesMonitorPane.getAllSelectedCheckBoxIndex2DescrMap().keySet());
            arrayList3 = new ArrayList(this._snmpDevicesMonitorPane.getAllSelectedCheckBoxIndex2DescrMap().values());
        }
        if (arrayList2.size() > 0) {
            int n2 = 1;
            int n3 = arrayList2.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                Integer n4 = (Integer)arrayList2.get(i2);
                String string = (String)arrayList3.get(i2);
                String string2 = this.getMonitorName() + "-" + string;
                int n5 = arrayList3.indexOf(string);
                if (n5 < i2) {
                    arrayList3.set(n5, string + String.valueOf(n2));
                    string2 = string2 + "-" + String.valueOf(++n2);
                }
                Monitor monitor = this.createSingleMonitor(iExpression, string2, n4);
                arrayList.add(monitor);
            }
        } else {
            Monitor monitor = this.createSingleMonitor(iExpression, this.getMonitorName(), 0);
            arrayList.add(monitor);
        }
        return arrayList;
    }

    private Monitor createSingleMonitor(IExpression iExpression, String string, int n2) {
        try {
            Monitor monitor = TargetFactory.getSchedule();
            monitor.setScheduleName(string);
            ServiceNameElement serviceNameElement = new ServiceNameElement("network", "SNMP", "SNMP", "SNMP", "SNMP");
            short s2 = MonitorHelper.getConstantId("SNMP").shortValue();
            this.setMonitorCommonValue(monitor, serviceNameElement, s2);
            this.setMonitorQueryParameter(monitor, iExpression, n2);
            Long l2 = this.getPollingInterval(monitor);
            if (l2 == null) {
                return null;
            }
            monitor.setPeriod(l2);
            String string2 = this._snmpDevicesMonitorPane.getThresholdResult().trim();
            String string3 = "OID_VALUE";
            short s3 = Short.parseShort(this._snmpDevicesMonitorPane.getAlarmBreakText().trim());
            short s4 = this._snmpDevicesMonitorPane.getThresholdConditionIndex();
            this.setFixedThreshold(monitor, string2, string3, null, s3, s4);
            String string4 = this._snmpDevicesMonitorPane.getAction();
            if (string4 != null && string4.trim().length() != 0) {
                monitor.setActions(string4);
            }
            monitor.addScheduleHost(this._agentProp.getIpAddress());
            monitor.setSaved(true);
            return monitor;
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    @Override
    protected List setMetricsParameter() {
        return null;
    }

    protected IExpression getSpecialExpression(String string) {
        try {
            return ClientProxy.getInstance().getSpecialExpression(string);
        }
        catch (Exception exception) {
            _logger.error((Object)"get special experssion Error:", (Throwable)exception);
            return null;
        }
    }

    private static String fromBundle(String string) {
        return NbBundle.getMessage(ConciseSnmpMonitorSecondDialog.class, (String)string);
    }

    protected void setTimeout(long l2) {
        this._timeout = l2;
    }

    protected void setRetries(int n2) {
        this._retries = n2;
    }
}

