/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.performance.Baseline;
import com.sysuptime.common.performance.FixedThreshold;
import com.sysuptime.common.performance.MetricsTimebucket;
import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.performance.MonitorHelper;
import com.sysuptime.common.performance.MonitorTestRun;
import com.sysuptime.common.performance.QueryParameter;
import com.sysuptime.common.performance.ResultValue;
import com.sysuptime.common.performance.ServiceNameElement;
import com.sysuptime.common.performance.TargetFactory;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.common.util.monitor.Snippet;
import com.sysuptime.common.util.schedule.RealSchedule;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.performance.AddMonitorDialog;
import com.sysuptime.mainframe.performance.ConciseSnmpMonitorSecondDialog;
import com.sysuptime.mainframe.performance.DevicesMonitorPane;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.MonitorBroker;
import com.sysuptime.mainframe.performance.MonitorTableModel;
import com.sysuptime.mainframe.performance.NonNullValidator;
import com.sysuptime.mainframe.performance.NumberValidator;
import com.sysuptime.mainframe.performance.PermittedBreaksValidator;
import com.sysuptime.mainframe.performance.PositiveLongValidator;
import com.sysuptime.mainframe.performance.SingletonScheduleBroker;
import com.sysuptime.mainframe.performance.SingletonValidator;
import com.sysuptime.mainframe.util.FormUtils;
import com.sysuptime.mainframe.util.SwingUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public abstract class ConciseMonitorSecondDialog
extends JDialog {
    private JTextField _monitorNameField;
    private JTextField _intervalField;
    private JComboBox _unitBox;
    private DevicesMonitorPane _devicesMonitorPane;
    private DefaultTableModel _scheduleListModel;
    protected static final String LABEL_MONITOR_NAME = ConciseMonitorSecondDialog.fromBundle("Label_monitor_name");
    private static final String LABEL_INTERVAL = ConciseMonitorSecondDialog.fromBundle("Label_interval");
    protected int CPU_TYPE = 100;
    protected int MEMORY_TYPE = 200;
    protected int DISK_TYPE = 300;
    protected int PROCESS_TYPE = 400;
    protected int CPU_OF_PROCESS_TYPE = 101;
    protected int MEMORY_OF_PROCESS_TYPE = 201;
    protected int WINDOWS_SERVICE_TYPE = 401;
    protected int BANDWIDTH_TYPE = 500;
    protected int INPUT_TYPE = 501;
    protected int OUTPUT_TYPE = 502;
    protected int _monitorType = 0;

    public ConciseMonitorSecondDialog(boolean bl2, String string, DevicesMonitorPane devicesMonitorPane, DefaultTableModel defaultTableModel) {
        super(AddMonitorDialog.getAddMonitorDialog(), string, bl2);
        this._devicesMonitorPane = devicesMonitorPane;
        this._scheduleListModel = defaultTableModel;
        this._monitorType = this.getMonitorType();
        this.getContentPane().add((Component)this.initMainComponent(devicesMonitorPane), "Center");
        this.getContentPane().add((Component)this.initConfirmPanel(), "South");
        this.setSize(new Dimension(540, 470));
        SwingUtil.centerOnFrame(Startup.getFrame(), this);
    }

    private JPanel initMainComponent(JComponent jComponent) {
        FormLayout formLayout = new FormLayout("FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:138PX:GROW(1.0),FILL:8PX:NONE,FILL:100PX:NONE,FILL:40PX:NONE,FILL:DEFAULT:NONE", "CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,FILL:10PX:NONE,FILL:DEFAULT:GROW(1.0),FILL:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE");
        JPanel jPanel = new JPanel((LayoutManager)formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        JLabel jLabel = new JLabel();
        jLabel.setText(LABEL_MONITOR_NAME);
        jPanel.add((Component)jLabel, cellConstraints.xy(2, 2));
        this._monitorNameField = new JTextField();
        jPanel.add((Component)this._monitorNameField, cellConstraints.xy(4, 2));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(LABEL_INTERVAL);
        jPanel.add((Component)jLabel2, cellConstraints.xy(2, 4));
        this._intervalField = new JTextField();
        jPanel.add((Component)this._intervalField, cellConstraints.xy(4, 4));
        this._unitBox = new JComboBox<String>(DialogConstants.COMBOBOX_UNIT);
        this._unitBox.setSelectedItem(DialogConstants.LABEL_MINUTE);
        jPanel.add((Component)this._unitBox, cellConstraints.xy(6, 4));
        if (jComponent != null) {
            jPanel.add((Component)jComponent, cellConstraints.xywh(2, 6, 6, 1));
        }
        FormUtils.addFillComponents(jPanel, new int[]{1, 2, 3, 4, 5, 6, 7, 8}, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        return jPanel;
    }

    protected abstract HashMap getTestRunParameters();

    protected abstract boolean selectOneCheck();

    protected JPanel initConfirmPanel() {
        JButton jButton = new JButton(DialogConstants.BUTTON_TEST_RUN);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ConciseMonitorSecondDialog.this.check()) {
                    HashMap hashMap = ConciseMonitorSecondDialog.this.getTestRunParameters();
                    List list = (List)hashMap.get("allMonitors");
                    String string = (String)hashMap.get("showHost");
                    boolean bl2 = false;
                    if (string == "false") {
                        bl2 = false;
                    }
                    if (string == "true") {
                        bl2 = true;
                    }
                    String string2 = (String)hashMap.get("ipAddress");
                    ConciseMonitorSecondDialog.this.testRun(list, bl2, string2);
                }
            }
        });
        JButton jButton2 = new JButton(ICommonBundle.OK);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ConciseMonitorSecondDialog.this.check()) {
                    ConciseMonitorSecondDialog.this.doOk();
                    ConciseMonitorSecondDialog.this.dispose();
                }
            }
        });
        JButton jButton3 = new JButton(ICommonBundle.CANCEL);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConciseMonitorSecondDialog.this.dispose();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        return jPanel;
    }

    protected boolean check() {
        Object object = SingletonValidator.checkAllDialog(this, LABEL_MONITOR_NAME, this._monitorNameField.getText(), NonNullValidator.CLASS);
        if (object == null) {
            return false;
        }
        Object object2 = SingletonValidator.checkAllDialog(this, LABEL_INTERVAL, this._intervalField.getText(), PositiveLongValidator.CLASS);
        if (object2 == null) {
            return false;
        }
        Object object3 = null;
        short s2 = this._devicesMonitorPane.getThresholdConditionIndex();
        if (s2 != 3 && s2 != 6 ? (object3 = SingletonValidator.checkAllDialog(this, DevicesMonitorPane.LABEL_FIXED_THRESHOLD, this._devicesMonitorPane.getThresholdResult(), NumberValidator.CLASS)) == null : (object3 = SingletonValidator.checkAllDialog(this, DevicesMonitorPane.LABEL_FIXED_THRESHOLD, this._devicesMonitorPane.getThresholdResult(), NonNullValidator.CLASS)) == null) {
            return false;
        }
        Short s3 = (Short)SingletonValidator.checkAllDialog(this, DevicesMonitorPane.LABEL_ARM_BREAKS_1, this._devicesMonitorPane.getAlarmBreakText(), PermittedBreaksValidator.CLASS);
        if (s3 == null) {
            return false;
        }
        return this.selectOneCheck();
    }

    protected abstract void doOk();

    protected void doOk(List list) {
        if (list != null && list.size() > 0) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Monitor monitor = (Monitor)list.get(i2);
                if (!this.saveToServer(monitor)) continue;
                this.operateSchedule(monitor);
            }
        }
    }

    protected void setMonitorCommonValue(Monitor monitor, ServiceNameElement serviceNameElement, short s2) {
        monitor.setStartDateTime(new Date().getTime());
        monitor.setEndDateTime(0L);
        monitor.setRepetitions(-1);
        monitor.setSaved(true);
        String string = "7*24";
        Number number = (Number)MonitorBroker.getTimebucketNameToId().get(string);
        monitor.setTimebucketId(number.longValue());
        monitor.setTargetType(serviceNameElement);
        monitor.setProtocolType(s2);
        monitor.setMonitorType(this._monitorType);
    }

    protected abstract List setMetricsParameter();

    protected void setFixedThreshold(Monitor monitor, String string, String string2, QueryParameter queryParameter, short s2, short s3) throws Exception {
        int n2 = MonitorHelper.getConstantId(string2);
        Baseline baseline = ConciseMonitorSecondDialog.setFixedThreshold(monitor, string, n2, s2, s3);
        if (queryParameter != null) {
            queryParameter.addAll(this.setMetricsParameter());
            baseline.setParameters(queryParameter);
            queryParameter.fromText(queryParameter.toText());
        }
    }

    public static Baseline setFixedThreshold(Monitor monitor, String string, int n2, short s2, short s3) throws Exception {
        Baseline baseline = TargetFactory.getBaseline();
        baseline.setThresholdEnabled(true);
        baseline.setFixedStatisticalId((short)0);
        baseline.setResultTypeId(n2);
        baseline.setArmBreaks(s2);
        MetricsTimebucket metricsTimebucket = TargetFactory.getMetricsTimebucket();
        FixedThreshold fixedThreshold = TargetFactory.getFixedThreshold();
        fixedThreshold.setFixedConditionId(s3);
        fixedThreshold.setFixedThreshold(string);
        fixedThreshold.setSeverityId((short)1);
        fixedThreshold.setClearAlarm(false);
        metricsTimebucket.addThreshold(fixedThreshold);
        FixedThreshold fixedThreshold2 = TargetFactory.getFixedThreshold();
        short s4 = (short)(DialogConstants.COMBOBOX_FIXED_CONDITION.length - 1 - s3);
        fixedThreshold2.setFixedConditionId(s4);
        fixedThreshold2.setFixedThreshold(string);
        fixedThreshold2.setClearAlarm(true);
        fixedThreshold2.setSeverityId((short)0);
        metricsTimebucket.addThreshold(fixedThreshold2);
        metricsTimebucket.setTimebucketId(-1L);
        baseline.addMetricsTimebucket(metricsTimebucket);
        monitor.addMetrics(baseline);
        return baseline;
    }

    private void operateSchedule(Monitor monitor) {
        if (this._scheduleListModel != null && this._scheduleListModel instanceof MonitorTableModel) {
            ((MonitorTableModel)this._scheduleListModel).addMonitor(monitor);
        }
    }

    private boolean saveToServer(Monitor monitor) {
        ArrayList arrayList;
        ArrayList<Monitor> arrayList2 = new ArrayList<Monitor>();
        arrayList2.add(monitor);
        ArrayList arrayList3 = arrayList = new ArrayList();
        ArrayList arrayList4 = arrayList;
        boolean bl2 = false;
        try {
            Object object;
            bl2 = ClientProxy.getInstance().putMonitorBulk(arrayList2, arrayList4, arrayList3, arrayList);
            if (!bl2) {
                object = ConciseMonitorSecondDialog.fromBundle("MSG_create_concise_snmp_monitor_error");
                JOptionPane.showMessageDialog(this.getRootPane().getParent(), object);
            }
            if (bl2 && arrayList2 != null) {
                object = MonitorBroker.getScheduleNameToId();
                ArrayList<Monitor> arrayList5 = new ArrayList<Monitor>();
                for (int i2 = 0; i2 < arrayList2.size(); ++i2) {
                    Monitor monitor2 = (Monitor)arrayList2.get(i2);
                    monitor2.setScheduleId(Integer.parseInt(object.get(monitor2.getScheduleName()).toString()));
                    int n2 = -1;
                    if (monitor2.getDirectDependencyName() != null) {
                        String string = monitor2.getDirectDependencyName();
                        n2 = MonitorBroker.getScheduleId(string);
                        monitor2.setDirectDependency(n2);
                        SingletonScheduleBroker.resetDependency(n2);
                        ClientProxy.getInstance().resetDependency(n2);
                    }
                    if (n2 == -1) continue;
                    arrayList5.add(monitor2);
                }
                ClientProxy.getInstance().modifyDirectDependency(arrayList5);
                return true;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass()).error((Object)exception.getMessage(), (Throwable)exception);
        }
        return false;
    }

    protected Long getPollingInterval(Monitor monitor) {
        String string = this.getIntervalUnit();
        long l2 = Integer.parseInt(this.getInterval());
        if (string.equalsIgnoreCase("days")) {
            monitor.setUnit((short)3);
            l2 = l2 * 24L * 60L * 60L;
        } else if (string.equalsIgnoreCase("hours")) {
            monitor.setUnit((short)2);
            l2 = l2 * 60L * 60L;
        } else if (string.equalsIgnoreCase("minutes")) {
            monitor.setUnit((short)1);
            l2 *= 60L;
        } else if (string.equalsIgnoreCase("seconds")) {
            monitor.setUnit((short)0);
        }
        return l2 *= 1000L;
    }

    public void setMonitorName(String string) {
        this._monitorNameField.setText(string);
    }

    public String getMonitorName() {
        return this._monitorNameField.getText().trim();
    }

    public String getInterval() {
        return this._intervalField.getText().trim();
    }

    public String getIntervalUnit() {
        return (String)this._unitBox.getSelectedItem();
    }

    private static String fromBundle(String string) {
        return NbBundle.getMessage(ConciseSnmpMonitorSecondDialog.class, (String)string);
    }

    private String setTestRunResult(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            MonitorTestRun monitorTestRun = (MonitorTestRun)list.get(i2);
            this.formatResult(stringBuffer, monitorTestRun);
        }
        return stringBuffer.toString();
    }

    protected void formatResult(StringBuffer stringBuffer, MonitorTestRun monitorTestRun) {
        Iterator iterator = monitorTestRun.getResultMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            Integer n2 = (Integer)entry2.getKey();
            ResultValue resultValue = (ResultValue)entry2.getValue();
            String string = MonitorHelper.getConstantLocaleName(n2);
            if (resultValue.isError()) {
                stringBuffer.append("<b>").append(Snippet.getBundledString("errormessage")).append(" ( ").append(string).append(" ) ").append(":").append("</b>").append("<br>");
                stringBuffer.append(resultValue.getErrorUnknownMessage());
            } else {
                stringBuffer.append("<b>").append(this.getQueryResultString()).append(" ").append("</b>");
                if (resultValue.isNormal()) {
                    stringBuffer.append("<table><tr><td><pre>").append(ConciseMonitorSecondDialog.getEscapeText(resultValue.getValue().toString())).append("</pre></table>");
                } else if (resultValue.isUnknown()) {
                    stringBuffer.append(resultValue.getErrorUnknownMessage());
                }
            }
            stringBuffer.append("<p>");
        }
        stringBuffer.append("<p>").append(monitorTestRun.getErrorText());
        stringBuffer.append("<br>");
    }

    private static String getEscapeText(String string) {
        return string.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;");
    }

    protected abstract String getQueryResultString();

    protected void testRun(List list, boolean bl2, String string) {
        SwingUtilities.invokeLater(() -> {
            Cursor cursor = this.getCursor();
            this.setCursor(new Cursor(3));
            try {
                Object object;
                Serializable serializable;
                StringBuffer stringBuffer = new StringBuffer();
                if (bl2) {
                    stringBuffer.append("<h2>").append(Snippet.getBundledString("host")).append(": ");
                    stringBuffer.append(string).append("</h2>");
                }
                int n2 = list.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    serializable = (Monitor)list.get(i2);
                    stringBuffer.append("<h3>").append(LABEL_MONITOR_NAME).append(": ");
                    stringBuffer.append(((RealSchedule)serializable).getScheduleName()).append("</h3>").append("<br>");
                    object = ClientProxy.getInstance().getTestRunResults((Monitor)serializable);
                    stringBuffer.append(this.setTestRunResult((List)object));
                }
                JEditorPane jEditorPane = new JEditorPane();
                jEditorPane.setContentType("text/html");
                jEditorPane.setText(stringBuffer.toString());
                jEditorPane.setCaretPosition(0);
                jEditorPane.setEditable(false);
                JScrollPane jScrollPane = new JScrollPane(jEditorPane);
                jScrollPane.setPreferredSize(DialogConstants.VIEW_XLONG_SIZE);
                serializable = new JOptionPane(jScrollPane, 1);
                object = ((JOptionPane)serializable).createDialog(this, DialogConstants.TITLE_TESTRUN);
                ((Dialog)object).setResizable(true);
                ((Dialog)object).setVisible(true);
            }
            finally {
                this.setCursor(cursor);
            }
        });
    }

    protected abstract int getMonitorType();
}

