/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.ireasoning.util.FormUtil;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.performance.QueryParameter;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.common.util.Tokenizer;
import com.sysuptime.mainframe.performance.MonitorBroker;
import com.sysuptime.mainframe.performance.SingletonScheduleBroker;
import com.sysuptime.mainframe.performance.UrlHostHandler;
import com.sysuptime.mainframe.util.ConfirmDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class CloneMonitorDialog
extends ConfirmDialog {
    private static final ResourceBundle _bundle = NbBundle.getBundle(CloneMonitorDialog.class);
    private static final Logger _logger = Logger.getLogger((String)CloneMonitorDialog.class.getName());
    private Monitor _monitor = null;
    private JTextField _nameField;
    private JTextField _hostField;
    private boolean _isOK = false;
    private boolean _isHttp = false;
    private JLabel _notes;
    private JLabel _urlLabel;

    public CloneMonitorDialog(Dialog dialog, String string, boolean bl2) {
        super(dialog, string, bl2);
    }

    public CloneMonitorDialog(Dialog dialog, String string, boolean bl2, Monitor monitor) {
        super(dialog, string, bl2);
        this._monitor = MonitorBroker.getScheduleData(monitor.getScheduleId());
        short s2 = this._monitor.getProtocolType();
        boolean bl3 = this._isHttp = s2 == 300;
        if (this._isHttp) {
            this._urlLabel.setText("URL(s):");
            String string2 = "Input one or more URLs (separated by comma)";
            this._notes.setText("<html><i>" + string2 + "</i></html>");
        }
        this.initData();
    }

    @Override
    protected JPanel getCenterPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(3, 3));
        jPanel.add((Component)this.createWarningPanel(), "North");
        jPanel.add((Component)this.createFieldPanel(), "Center");
        return jPanel;
    }

    private JPanel createWarningPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1, 0, 0));
        JLabel jLabel = new JLabel("<html>" + _bundle.getString("clone_warning") + "</html>");
        jLabel.setForeground(Color.red);
        jPanel.add(jLabel);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Warning");
        titledBorder.setTitleColor(Color.red);
        jPanel.setBorder(titledBorder);
        return jPanel;
    }

    private JPanel createFieldPanel() {
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel = new JPanel();
        FormLayout formLayout = new FormLayout("FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:120DLU:GROW,FILL:DEFAULT:NONE", "CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE");
        CellConstraints cellConstraints = new CellConstraints();
        jPanel.setLayout((LayoutManager)formLayout);
        JLabel jLabel3 = new JLabel("Monitor Base Name:");
        jPanel.add((Component)jLabel3, cellConstraints.xy(2, 2));
        this._urlLabel = jLabel2 = new JLabel(_bundle.getString("col_hostname") + ":");
        jPanel.add((Component)jLabel2, cellConstraints.xy(2, 4));
        this._nameField = new JTextField();
        jPanel.add((Component)this._nameField, cellConstraints.xy(4, 2));
        this._hostField = new JTextField();
        jPanel.add((Component)this._hostField, cellConstraints.xy(4, 4));
        String string = "Input IP addresses (separated by comma) or IP range.<br>Example:<br>192.168.1.100, 192.168.1.110<br>192.168.1.199-192.168.1.201 (IP range)";
        this._notes = jLabel = new JLabel("<html><i>" + string + "</i></html>");
        jLabel3.setForeground(Color.darkGray);
        jPanel.add((Component)jLabel, cellConstraints.xywh(2, 6, 3, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder(""));
        FormUtil.addFillComponents(jPanel, new int[]{1, 2, 3, 4, 5}, new int[]{1, 2, 3, 4, 5, 6, 7});
        return jPanel;
    }

    private void initData() {
        if (this._monitor != null) {
            this._nameField.setText(this._monitor.getScheduleName());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doOK() {
        List<String> list = this.getMonitorNameList();
        String string = this.getMonitorName();
        if (string == null || string.length() == 0) {
            string = this._monitor.getScheduleName();
        }
        String string2 = null;
        String[] stringArray = this.getHosts(this._isHttp);
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (String string3 : stringArray) {
            void object;
            Object object2;
            this._monitor.removeAllHosts();
            if (this._isHttp) {
                object2 = UrlHostHandler.getHostFromUrl(string3);
                if (object2 == null && !string3.toLowerCase().startsWith("http")) {
                    object2 = string3;
                    String string4 = "http://" + string3;
                }
                this._monitor.addScheduleHost((String)object2);
                QueryParameter queryParameter = this._monitor.getQueryParameters();
                List list2 = (List)queryParameter.getList().get(0);
                List list3 = (List)list2.get(0);
                list3.set(0, object);
                List list4 = (List)((List)queryParameter.getList().get(0)).get(0);
                list4.set(0, object);
            } else {
                this._monitor.addScheduleHost(string3);
            }
            object2 = string + " @" + (String)object;
            while (this.monitorExists((String)object2, list)) {
                string2 = this.generateExtName(string2);
                object2 = (String)object2 + "_" + string2;
            }
            this._monitor.setScheduleName((String)object2);
            this._monitor.setScheduleId(-1);
            SingletonScheduleBroker.addSchedule(this._monitor);
        }
        this._isOK = true;
        this.dispose();
    }

    public boolean isOK() {
        return this._isOK;
    }

    private boolean monitorExists(String string, List<String> list) {
        for (String string2 : list) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private List<String> getMonitorNameList() {
        return MonitorBroker.getScheduleNameList();
    }

    private String generateExtName(String string) {
        int n2 = 0;
        try {
            if (string != null) {
                n2 = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            _logger.error((Object)"Numberformat Exception:", (Throwable)numberFormatException);
        }
        return this.converNumToString(++n2);
    }

    private String converNumToString(int n2) {
        Object object = "";
        object = n2 < 10 ? "00" + n2 : (n2 < 100 ? "0" + n2 : (n2 < 1000 ? String.valueOf(n2) : String.valueOf(n2)));
        return object;
    }

    public String getMonitorName() {
        return this._nameField.getText().trim();
    }

    private String getHost() {
        String string = this._hostField.getText().trim();
        if (string == null || string.length() == 0) {
            return "";
        }
        return string;
    }

    private String[] getHosts(boolean bl2) {
        String string;
        String[] stringArray;
        String string2 = this.getHost();
        if (string2 == null || string2.length() == 0) {
            this.showErrorMessage("Host name cannot be blank.");
            return null;
        }
        if (bl2) {
            return Tokenizer.parse(string2, ',', true, true);
        }
        string2 = string2.replaceAll("[-,~,,,;,|,&,#,:]+", "~");
        String[] stringArray2 = stringArray = string2.split("~");
        int n2 = stringArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            string = stringArray2[i2];
            if (this.checkIPAddress(string)) continue;
            return null;
        }
        int n3 = n2 = stringArray.length == 2 && StringUtil.isIp(stringArray[0]) && StringUtil.isIp(stringArray[1]) && this.inSameSubnet(stringArray) && (string2.indexOf("~") > 0 || string2.indexOf("-") > 0) ? 1 : 0;
        if (stringArray.length == 2) {
            if (n2 != 0) {
                String string3 = stringArray[0];
                string = stringArray[1];
                int n4 = Integer.parseInt(string3.substring(string3.lastIndexOf(".") + 1));
                int n5 = Integer.parseInt(string.substring(string.lastIndexOf(".") + 1));
                String string4 = string3.substring(0, string3.lastIndexOf("."));
                if (n4 < n5) {
                    stringArray2 = new String[n5 - n4 + 1];
                    int n6 = 0;
                    for (int i3 = n4; i3 <= n5; ++i3) {
                        stringArray2[n6++] = string4 + "." + i3;
                    }
                    return stringArray2;
                }
            }
            return stringArray;
        }
        return stringArray;
    }

    private boolean inSameSubnet(String[] stringArray) {
        if (stringArray.length != 2) {
            return false;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        if (!this.checkIPAddress(string) || !this.checkIPAddress(string2)) {
            return false;
        }
        String string3 = string.substring(0, string.lastIndexOf("."));
        String string4 = string2.substring(0, string2.lastIndexOf("."));
        return string3.equals(string4);
    }

    private void showErrorMessage(String string) {
        JOptionPane.showMessageDialog(this, string, "Error", 0);
    }

    public boolean checkIPAddress(String string) {
        return string != null && string.trim().length() != 0;
    }
}

