/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.login;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.login.User;
import com.sysuptime.common.util.AppUtil;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.common.util.ParseRoute;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.login.CheckCompatibility;
import com.sysuptime.mainframe.login.LicenseDialog;
import com.sysuptime.mainframe.login.LoginDialog$1;
import com.sysuptime.mainframe.login.LoginDialog$2;
import com.sysuptime.mainframe.login.LoginMBeanInvoker;
import com.sysuptime.mainframe.msp.probe.AuthenticationDialog;
import com.sysuptime.mainframe.util.FormUtils;
import com.sysuptime.mainframe.util.JNDIClient;
import com.sysuptime.mainframe.util.RMIAdaptor;
import com.sysuptime.mainframe.util.SwingUtil;
import com.ultraswing.az;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class LoginDialog
extends JFrame
implements ActionListener {
    private static final Logger _logger = Logger.getLogger((String)LoginDialog.class.getName());
    public static final String CONFIG_PROPERTIES = AppUtil.getClientConfigDirectory() + "/config.properties";
    private User _user;
    private Properties _configProperties = new Properties();
    private JTextField _nameField;
    private JPasswordField _passwordField;
    private JTextField _serverFiled;
    private JLabel _serverLabel;
    private az _okBtn;
    private az _cancelBtn;
    private static final String DEFAULT_USER_PASS = NbBundle.getMessage(LoginDialog.class, (String)"MSG_default_user_pass");
    private int _returnCode = 0;
    private boolean _isLicenseOk = true;
    public static final int PASSWORD_INCORRECT_ERR = 1;
    public static final int LICENSE_INVALID_ERR = 2;
    public static final int SERVER_NOT_READY = 3;

    public LoginDialog() {
        ImageIcon imageIcon = new ImageIcon(AppUtil.getAppHomeDirectory() + "/lib/client.gif");
        if (imageIcon != null) {
            this.setIconImage(imageIcon.getImage());
        }
        this.setTitle(NbBundle.getMessage(LoginDialog.class, (String)"TITLE_login_dialog"));
        this.a();
        this.pack();
    }

    public int getReturnCode() {
        return this._returnCode;
    }

    public boolean isLicenseOk() {
        return this._isLicenseOk;
    }

    public synchronized void wait2() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void notify2() {
        this.notify();
    }

    public Properties getConfigProperties() {
        return this._configProperties;
    }

    private void a() {
        Object object;
        this._configProperties = AppUtil.readPropertiesFile(CONFIG_PROPERTIES);
        this._nameField = new JTextField(10);
        this._nameField.setText(this._configProperties.getProperty("lastLogin"));
        this._passwordField = new JPasswordField(10);
        this._serverLabel = new JLabel();
        this._serverLabel.setText(NbBundle.getMessage(this.getClass(), (String)"LABLE_login_dialog_server"));
        this._serverFiled = new JTextField(10);
        String string = this._configProperties.getProperty("server");
        if (string == null || string.trim().length() == 0) {
            object = ParseRoute.getInstance();
            string = ((ParseRoute)object).getLocalIPAddress();
        }
        this._serverFiled.setText(string);
        this._okBtn = new az(ICommonBundle.OK);
        this._okBtn.setPreferredSize(new Dimension(70, 25));
        this._okBtn.addActionListener(this);
        this._cancelBtn = new az(ICommonBundle.CANCEL);
        this._cancelBtn.setPreferredSize(new Dimension(70, 25));
        this._cancelBtn.addActionListener(this);
        this._okBtn.setBackground(Color.white);
        this._cancelBtn.setBackground(Color.white);
        this._serverLabel.setVisible(true);
        this._serverFiled.setVisible(true);
        object = this.getContentPane();
        ((Container)object).add((Component)this.b(), "Center");
        LoginDialog$1 loginDialog$1 = new LoginDialog$1(this);
        loginDialog$1.setBorder(null);
        loginDialog$1.setBackground(Color.white);
        ((Container)object).add((Component)loginDialog$1, "North");
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.add(this._okBtn);
        jPanel.add(this._cancelBtn);
        ((Container)object).add((Component)jPanel, "South");
        this.getRootPane().setDefaultButton(this._okBtn);
        this.setResizable(false);
        this.addWindowListener(new LoginDialog$2(this));
    }

    private JPanel b() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        FormLayout formLayout = new FormLayout("FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,LEFT:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:160PX:NONE,FILL:12PX:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE", "CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE");
        CellConstraints cellConstraints = new CellConstraints();
        jPanel.setLayout((LayoutManager)formLayout);
        JLabel jLabel = new JLabel();
        jLabel.setText(NbBundle.getMessage(LoginDialog.class, (String)"LABLE_login_dialog_name"));
        jPanel.add((Component)jLabel, cellConstraints.xy(4, 7));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(NbBundle.getMessage(LoginDialog.class, (String)"LABLE_login_dialog_passwd"));
        jPanel.add((Component)jLabel2, cellConstraints.xy(4, 9));
        jPanel.add((Component)this._passwordField, cellConstraints.xy(6, 9));
        this._passwordField.setToolTipText(DEFAULT_USER_PASS);
        jPanel.add((Component)this._nameField, cellConstraints.xy(6, 7));
        this._nameField.setToolTipText(DEFAULT_USER_PASS);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(NbBundle.getBundle(LoginDialog.class).getString("TIP_login_dialog_annotation"));
        jPanel.add((Component)jLabel3, cellConstraints.xywh(4, 3, 4, 3));
        jPanel.add((Component)this._serverLabel, cellConstraints.xy(4, 11));
        jPanel.add((Component)this._serverFiled, cellConstraints.xy(6, 11));
        this._serverFiled.setToolTipText(NbBundle.getMessage(LoginDialog.class, (String)"TIP_login_server"));
        FormUtils.addFillComponents(jPanel, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9}, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        return jPanel;
    }

    private boolean c() {
        this._configProperties.setProperty("lastLogin", this._nameField.getText());
        String string = this._serverFiled.getText();
        this._configProperties.setProperty("server", string);
        if (AppUtil.savePropertiesFile(CONFIG_PROPERTIES, this._configProperties)) {
            if (string.length() != 0) {
                _logger.info((Object)("Server IP address:" + string));
                JNDIClient.setServerIpAddress(string);
            }
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean a(String var1_1, String var2_2, RMIAdaptor var3_3) {
        try {
            block17: {
                block19: {
                    block18: {
                        var4_4 = LoginMBeanInvoker.login(var1_1, var2_2, var3_3);
                        if (var4_4 == null) {
                            JOptionPane.showMessageDialog(this, "Cannot connect to server");
                            return false;
                        }
                        var5_7 = var4_4.getErrorMessage();
                        try {
                            if (var5_7 == null) break block17;
                            if (!"Too many user".equals(var5_7)) break block18;
                        }
                        catch (RemoteException v0) {
                            throw LoginDialog.a(v0);
                        }
                        this.f();
                        this._isLicenseOk = false;
                        return false;
                    }
                    if (LoginMBeanInvoker.isMaster()) ** GOTO lbl24
                    if (LoginMBeanInvoker.isMspEdition()) break block17;
                    break block19;
                    catch (RemoteException v1) {
                        throw LoginDialog.a(v1);
                    }
                }
                try {
                    block20: {
                        if (!"Expired".equals(var5_7)) break block17;
                        break block20;
                        catch (RemoteException v2) {
                            throw LoginDialog.a(v2);
                        }
                    }
                    JOptionPane.showMessageDialog(this, NbBundle.getMessage(LoginDialog.class, (String)"LoginDialog_msg_licenseExpired"));
                }
                catch (RemoteException v3) {
                    throw LoginDialog.a(v3);
                }
                try {
                    while (!LoginDialog.a(this)) {
                    }
                }
                catch (RemoteException v4) {
                    throw LoginDialog.a(v4);
                }
            }
            this._user = (User)var4_4.getValue();
            if (this._user == null) {
                this.d();
                return false;
            }
            if (!this._user.isActive()) {
                this.e();
                return false;
            }
            Startup.setCurrentUser(this._user);
            var6_8 = LoginMBeanInvoker.getLicense("isFree");
            Startup.setFreeEdition(StringUtil.getBool(var6_8));
            return true;
        }
        catch (RemoteException var4_5) {
            JNDIClient.showServerDown();
            System.exit(1);
        }
        catch (Exception var4_6) {
            JOptionPane.showMessageDialog(this, NbBundle.getMessage(LoginDialog.class, (String)"MSG_login_unknown_error"));
            return false;
        }
        return false;
    }

    private void d() {
        JOptionPane.showMessageDialog(this, NbBundle.getMessage(LoginDialog.class, (String)"MSG_login_dialog_1"));
        this._nameField.setText("");
        this._passwordField.setText("");
        this._nameField.requestFocusInWindow();
    }

    private void e() {
        JOptionPane.showMessageDialog(this, NbBundle.getMessage(LoginDialog.class, (String)"MSG_login_dialog_2"));
        this._nameField.requestFocusInWindow();
    }

    private void f() {
        JOptionPane.showMessageDialog(this, NbBundle.getMessage(LoginDialog.class, (String)"LoginDialog_msg_exceedLicense"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block5: {
            block4: {
                int[] nArray = LoginMBeanInvoker.b();
                if (actionEvent.getSource() != this._okBtn) break block4;
                if (!this.g()) break block5;
                this.notify2();
                if (nArray != null) break block5;
            }
            if (actionEvent.getSource() == this._cancelBtn) {
                System.exit(0);
            }
        }
    }

    public static boolean isServerReachable() {
        boolean bl2 = true;
        try {
            RMIAdaptor rMIAdaptor = JNDIClient.getSingletonRMIAdaptor();
            Object object = rMIAdaptor.invoke(LoginMBeanInvoker.getObjectName(), "getDatabaseInitializedValue", null, null);
            if (object == null) {
                return false;
            }
        }
        catch (NamingException namingException) {
            bl2 = false;
        }
        catch (RemoteException remoteException) {
            bl2 = false;
        }
        return bl2;
    }

    private static boolean a(JFrame jFrame) {
        LicenseDialog licenseDialog = new LicenseDialog(jFrame);
        SwingUtil.centerOnScreen(licenseDialog);
        licenseDialog.setVisible(true);
        return licenseDialog.isOk();
    }

    private boolean g() {
        block9: {
            block11: {
                int n2;
                block10: {
                    boolean bl2;
                    String string = this._nameField.getText().trim();
                    String string2 = new String(this._passwordField.getPassword()).trim();
                    int[] nArray = LoginMBeanInvoker.b();
                    if (string.length() == 0) {
                        JOptionPane.showMessageDialog(Startup.getFrame(), "Name cannot be empty", ICommonBundle.ERROR, 0);
                        this._nameField.requestFocus();
                        return false;
                    }
                    if (string2.length() == 0) {
                        JOptionPane.showMessageDialog(Startup.getFrame(), "Password cannot be empty", ICommonBundle.ERROR, 0);
                        this._passwordField.requestFocus();
                        return false;
                    }
                    this.c();
                    String string3 = this._serverFiled.getText().trim();
                    RMIAdaptor rMIAdaptor = null;
                    rMIAdaptor = JNDIClient.getRMIAdaptor(string3);
                    if (!this.a(string, string2, rMIAdaptor)) {
                        this._returnCode = 1;
                        return false;
                    }
                    long l2 = System.currentTimeMillis();
                    if (CheckCompatibility.b() != null) {
                        JOptionPane.showMessageDialog(Startup.getFrame(), "Client is not compatible with server. Please update client.", ICommonBundle.ERROR, 0);
                        System.exit(1);
                    }
                    long l3 = System.currentTimeMillis();
                    boolean bl3 = bl2 = LoginMBeanInvoker.isMspEdition() && !LoginMBeanInvoker.isMaster();
                    if (bl2) break block9;
                    n2 = LoginMBeanInvoker.hasValidLicense();
                    _logger.info((Object)("hasValidLIcense return:" + n2));
                    if (n2 != 0) {
                        this._returnCode = 2;
                    }
                    if (n2 != -2 && n2 != -3 && n2 != -4) break block9;
                    if (n2 != -2) break block10;
                    JOptionPane.showMessageDialog(Startup.getFrame(), NbBundle.getMessage(LoginDialog.class, (String)"LicenseDialog_msg_licenseExpired"), ICommonBundle.ERROR, 0);
                    if (nArray != null) break block11;
                }
                if (n2 == -4) {
                    JOptionPane.showMessageDialog(Startup.getFrame(), NbBundle.getMessage(LoginDialog.class, (String)"LicenseDialog_msg_noLicense"), ICommonBundle.ERROR, 0);
                }
            }
            this._returnCode = LoginDialog.a(this) ? 0 : 2;
        }
        long l4 = System.currentTimeMillis();
        long l5 = System.currentTimeMillis();
        this.h();
        this.dispose();
        return true;
    }

    private void h() {
        boolean bl2;
        String string = LoginMBeanInvoker.getCustomerName();
        long l2 = LoginMBeanInvoker.getProbeID();
        boolean bl3 = bl2 = LoginMBeanInvoker.isMspEdition() && !LoginMBeanInvoker.isMaster();
        if (bl2 && (l2 == -1L || string == null)) {
            AuthenticationDialog authenticationDialog = new AuthenticationDialog(Startup.getFrame(), NbBundle.getMessage(LoginDialog.class, (String)"AuthenticationDialog_title"), true, true);
            SwingUtil.centerOnScreen(authenticationDialog);
            authenticationDialog.setVisible(true);
        }
    }

    public User getLoginUser() {
        return this._user;
    }

    private static RemoteException a(RemoteException remoteException) {
        return remoteException;
    }
}

