/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.discovery;

import com.sysuptime.common.discovery.ReadCommunity;
import com.sysuptime.common.discovery.V3Params;
import com.sysuptime.mainframe.discovery.MediationDialog;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.openide.util.NbBundle;

public class ReadCommunitiesTableModel
extends DefaultTableModel {
    private static final String[] COLUMNS = new String[]{ReadCommunitiesTableModel.a("ReadCommunityTableModel_column_ipAddress"), ReadCommunitiesTableModel.a("ReadCommunityTableModel_column_readCommunity"), ReadCommunitiesTableModel.a("ReadCommunityTableModel_column_version"), ReadCommunitiesTableModel.a("ReadCommunityTableModel_column_userName")};
    private Vector _readCommunities = new Vector();

    public ReadCommunitiesTableModel(ReadCommunity[] readCommunityArray) {
        this.addRows(readCommunityArray);
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public String getColumnName(int n2) {
        return COLUMNS[n2];
    }

    @Override
    public boolean isCellEditable(int n2, int n3) {
        return false;
    }

    public void addRows(ReadCommunity[] readCommunityArray) {
        int n2 = MediationDialog.w();
        if (readCommunityArray != null) {
            for (int i2 = 0; i2 < readCommunityArray.length; ++i2) {
                this.addRow(readCommunityArray[i2]);
                if (n2 != 0) continue;
            }
        }
    }

    public void addRow(ReadCommunity readCommunity) {
        this._readCommunities.add(readCommunity);
        String string = readCommunity.getIpAddress();
        String string2 = readCommunity.getCommunity();
        String string3 = readCommunity.getVersionString();
        String string4 = null;
        if (readCommunity.getVersion() == 3) {
            V3Params v3Params = readCommunity.getV3Params();
            string4 = v3Params.getUserName();
        }
        this.addRow(new Object[]{string, string2, string3, string4});
    }

    @Override
    public void removeRow(int n2) {
        super.removeRow(n2);
        this._readCommunities.remove(n2);
    }

    public void modifyRow(ReadCommunity readCommunity, int n2) {
        this._readCommunities.set(n2, readCommunity);
        String string = readCommunity.getIpAddress();
        String string2 = readCommunity.getCommunity();
        String string3 = readCommunity.getVersionString();
        int n3 = readCommunity.getVersion();
        this.setValueAt(string, n2, 0);
        this.setValueAt(string2, n2, 1);
        this.setValueAt(string3, n2, 2);
        String string4 = null;
        if (n3 == 3) {
            V3Params v3Params = readCommunity.getV3Params();
            string4 = v3Params.getUserName();
        }
        this.setValueAt(string4, n2, 3);
    }

    public ReadCommunity getReadCommunity(int n2) {
        return (ReadCommunity)this._readCommunities.get(n2);
    }

    private static String a(String string) {
        return NbBundle.getMessage(ReadCommunitiesTableModel.class, (String)string);
    }
}

