/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.actions;

import com.sysuptime.common.discovery.DiscoveryOptionsData;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.discovery.DiscoveryOptionsDialog;
import com.sysuptime.mainframe.discovery.PeriodicalDiscoveryDialog;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.util.JNDIClient;
import com.sysuptime.mainframe.util.SwingUtil;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.netbeans.modules.openide.util.AWTBridge;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public class PeriodicalDiscoveryAction
extends SystemAction
implements Presenter.Menu {
    private static final Logger _logger = Logger.getLogger((String)PeriodicalDiscoveryAction.class.getName());

    public PeriodicalDiscoveryAction() {
        if (Startup.isFreeEdition()) {
            this.setEnabled(false);
        }
    }

    public String getName() {
        return NbBundle.getBundle(PeriodicalDiscoveryAction.class).getString("actions_periodical_discovery");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected String iconResource() {
        return SwingUtil.getImageAbsoluteFileName("actions/periodicaldiscovery.gif");
    }

    public JMenuItem getMenuPresenter() {
        return AWTBridge.getDefault().createMenuPresenter((Action)((Object)this));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block13: {
            try {
                if (!JNDIClient.isServerReachable()) {
                    return;
                }
            }
            catch (Exception exception) {
                throw PeriodicalDiscoveryAction.a(exception);
            }
            try {
                if (!ClientProxy.getInstance().resetProbe()) {
                    return;
                }
            }
            catch (Exception exception) {
                throw PeriodicalDiscoveryAction.a(exception);
            }
            PeriodicalDiscoveryDialog periodicalDiscoveryDialog = new PeriodicalDiscoveryDialog();
            try {
                periodicalDiscoveryDialog.show();
                if (!periodicalDiscoveryDialog.isOk() || !periodicalDiscoveryDialog.isScheduleEnable()) break block13;
            }
            catch (Exception exception) {
                throw PeriodicalDiscoveryAction.a(exception);
            }
            try {
                DiscoveryOptionsData discoveryOptionsData = ClientProxy.getInstance().getDiscoveryOptions();
                DiscoveryOptionsDialog discoveryOptionsDialog = new DiscoveryOptionsDialog(discoveryOptionsData);
                discoveryOptionsDialog.showCenterOnOwner();
                if (!discoveryOptionsDialog.isOK()) break block13;
                discoveryOptionsData = discoveryOptionsDialog.getOptions();
                try {
                    if (!ClientProxy.getInstance().saveDiscoveryOptions(discoveryOptionsData)) {
                        JOptionPane.showMessageDialog(Startup.getFrame(), PeriodicalDiscoveryAction.a("msg_saveDiscoveryOptionsFailed"), ICommonBundle.ERROR, 0);
                    }
                }
                catch (Exception exception) {
                    throw PeriodicalDiscoveryAction.a(exception);
                }
            }
            catch (Exception exception) {
                _logger.error((Object)"initializePanel", (Throwable)exception);
            }
        }
    }

    private static String a(String string) {
        return NbBundle.getMessage(PeriodicalDiscoveryAction.class, (String)string);
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

