/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.actions;

import com.sysuptime.common.graph.GraphID;
import com.sysuptime.common.graph.IGraphParameters;
import com.sysuptime.mainframe.ConsoleComponent;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.actions.ExportJpegAction$1;
import com.sysuptime.mainframe.graph.GraphLoader;
import com.sysuptime.mainframe.graph.NetworkGraph;
import com.sysuptime.mainframe.util.SwingUtil;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.jgraph.JGraph;
import org.jgraph.util.JGraphUtilities;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class ExportJpegAction
extends SystemAction {
    private static final Logger _logger = Logger.getLogger((String)ExportJpegAction.class.getName());

    public String getName() {
        return ExportJpegAction.a("actions_export");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected String iconResource() {
        return SwingUtil.getImageAbsoluteFileName("actions/export.gif");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        File file;
        ConsoleComponent consoleComponent = ConsoleComponent.getInstance();
        NetworkGraph networkGraph = consoleComponent.getCurrentGraph();
        try {
            if (networkGraph == null) {
                JOptionPane.showMessageDialog(Startup.getFrame(), ExportJpegAction.a("actions_export_msg_noCurrentMap"));
                return;
            }
        }
        catch (IOException iOException) {
            throw ExportJpegAction.a(iOException);
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new ExportJpegAction$1(this));
        jFileChooser.setSelectedFile(new File(this.a(networkGraph.getGraphID()) + ".jpg"));
        int n2 = jFileChooser.showSaveDialog(Startup.getFrame());
        if (n2 == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            BufferedImage bufferedImage = JGraphUtilities.toImage((JGraph)networkGraph, (Color)networkGraph.getBackground(), (int)5);
            try {
                if (bufferedImage == null) {
                    JOptionPane.showMessageDialog(Startup.getFrame(), ExportJpegAction.a("actions_export_msg_empty"));
                    return;
                }
            }
            catch (IOException iOException) {
                throw ExportJpegAction.a(iOException);
            }
            ImageIO.setUseCache(true);
            try {
                ImageIO.write((RenderedImage)bufferedImage, "jpg", file);
            }
            catch (IOException iOException) {
                _logger.error((Object)iOException.getMessage(), (Throwable)iOException);
            }
        }
    }

    private String a(GraphID graphID) {
        if (IGraphParameters.MASTER_MASTER.equals(graphID)) {
            return "master";
        }
        if ("customer".equals(graphID.getGraphName())) {
            return GraphLoader.getCustomerName(graphID.getCustomerID());
        }
        String string = GraphLoader.getCustomerName(graphID.getCustomerID());
        return string + "_" + graphID.getGraphName();
    }

    private static String a(String string) {
        return NbBundle.getMessage(ExportJpegAction.class, (String)string);
    }

    private static IOException a(IOException iOException) {
        return iOException;
    }
}

