/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.common.util.net;

import com.sysuptime.common.util.AppUtil;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.common.util.Tokenizer;
import com.sysuptime.common.util.net.ByteOrder;
import com.sysuptime.common.util.net.ConnectionSettings;
import com.sysuptime.common.util.net.IP;
import com.sysuptime.common.util.net.IPList;
import com.sysuptime.common.util.net.RouterService;
import com.sysuptime.common.util.net.Setting;
import com.sysuptime.server.msp.Command;
import com.sysuptime.server.util.JPing;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public final class NetworkUtils {
    private static final Logger _logger = Logger.getLogger((String)NetworkUtils.class.getName());
    private static final IPList INVALID_ADDRESSES = new IPList();
    private static final IPList PRIVATE_ADDRESSES = new IPList();
    private static final IPList LOCAL_ADDRESSES = new IPList();

    private NetworkUtils() {
    }

    public static boolean isValidPort(int n2) {
        if ((n2 & 0xFFFF0000) != 0) {
            return false;
        }
        return n2 != 0;
    }

    public static boolean isValidAddress(byte[] byArray) {
        return !INVALID_ADDRESSES.contains(new IP(byArray));
    }

    public static boolean isValidAddress(InetAddress inetAddress) {
        return NetworkUtils.isValidAddress(inetAddress.getAddress());
    }

    public static boolean isValidAddress(String string) {
        try {
            return NetworkUtils.isValidAddress(InetAddress.getByName(string));
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public static boolean isLocalAddress(InetAddress inetAddress) {
        try {
            if (LOCAL_ADDRESSES.contains(new IP(inetAddress.getAddress()))) {
                return true;
            }
            InetAddress inetAddress2 = InetAddress.getLocalHost();
            return Arrays.equals(inetAddress2.getAddress(), inetAddress.getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public static boolean isCloseIP(byte[] byArray, byte[] byArray2) {
        return byArray[0] == byArray2[0];
    }

    public static boolean isVeryCloseIP(byte[] byArray, byte[] byArray2) {
        if (NetworkUtils.isPrivateAddress(byArray)) {
            return false;
        }
        return byArray[0] == byArray2[0] && byArray[1] == byArray2[1];
    }

    public static boolean isVeryCloseIP(byte[] byArray) {
        return NetworkUtils.isVeryCloseIP(RouterService.getAddress(), byArray);
    }

    public static boolean isPrivate() {
        return NetworkUtils.isPrivateAddress(RouterService.getAddress());
    }

    public static boolean isPrivateAddress(byte[] byArray) {
        if (!ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return false;
        }
        return PRIVATE_ADDRESSES.contains(new IP(byArray));
    }

    public static boolean isPrivateAddress(InetAddress inetAddress) {
        return NetworkUtils.isPrivateAddress(inetAddress.getAddress());
    }

    public static boolean isPrivateAddress(String string) {
        try {
            return NetworkUtils.isPrivateAddress(InetAddress.getByName(string));
        }
        catch (UnknownHostException unknownHostException) {
            return true;
        }
    }

    public static final String ip2string(byte[] byArray) {
        return NetworkUtils.ip2string(byArray, 0);
    }

    public static final String ip2string(byte[] byArray, int n2) {
        StringBuffer stringBuffer = new StringBuffer(16);
        boolean bl2 = Setting.c();
        stringBuffer.append(ByteOrder.ubyte2int(byArray[n2]));
        stringBuffer.append('.');
        stringBuffer.append(ByteOrder.ubyte2int(byArray[n2 + 1]));
        stringBuffer.append('.');
        stringBuffer.append(ByteOrder.ubyte2int(byArray[n2 + 2]));
        stringBuffer.append('.');
        stringBuffer.append(ByteOrder.ubyte2int(byArray[n2 + 3]));
        String string = stringBuffer.toString();
        if (bl2) {
            Command.b(new int[3]);
        }
        return string;
    }

    public static boolean isMe(String string, int n2) {
        byte[] byArray;
        try {
            byArray = InetAddress.getByName(string).getAddress();
        }
        catch (IOException iOException) {
            return false;
        }
        return NetworkUtils.isMe(byArray, n2);
    }

    public static boolean isMe(byte[] byArray, int n2) {
        if (byArray[0] == 127) {
            return n2 == RouterService.getPort();
        }
        byte[] byArray2 = RouterService.getAddress();
        return n2 == RouterService.getPort() && Arrays.equals(byArray, byArray2);
    }

    public static boolean isArbitraryAddress(String string) {
        return "0.0.0.0".equals(string);
    }

    public static boolean isLoopbackAddress(String string) {
        return string.startsWith("127.0.0.");
    }

    public static boolean isBroadcastAddress(String string) {
        return string.endsWith(".255");
    }

    public static boolean isMulticastAddress(String string) {
        return "224.0.0.0".equals(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getDefaultGateway() {
        String string = null;
        boolean bl2 = Setting.c();
        Process process = null;
        if (AppUtil.isWindows()) {
            BufferedReader bufferedReader = null;
            try {
                String string2;
                String string3 = System.getenv("WINDIR");
                process = Runtime.getRuntime().exec(string3 + "\\system32\\route print");
                InputStream inputStream = process.getInputStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                while ((string2 = bufferedReader.readLine()) != null) {
                    block62: {
                        try {
                            if (bl2) return string;
                            if (string2.indexOf("0.0.0.0") == -1) continue;
                        }
                        catch (IOException iOException) {
                            throw NetworkUtils.a(iOException);
                        }
                        String[] stringArray = StringUtil.split(string2, " ");
                        try {
                            if (stringArray.length != 5 || !stringArray[0].equals("0.0.0.0")) break block62;
                        }
                        catch (IOException iOException) {
                            throw NetworkUtils.a(iOException);
                        }
                        _logger.info((Object)("gateway(win):" + stringArray[2]));
                        String string4 = stringArray[2];
                        return string4;
                    }
                    if (!bl2) continue;
                    return string;
                }
                return string;
            }
            catch (IOException iOException) {
                _logger.error((Object)"getDefaultGateway upon windows", (Throwable)iOException);
                return string;
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    _logger.error((Object)"", (Throwable)iOException);
                }
            }
        }
        if (AppUtil.isLinux()) {
            BufferedReader bufferedReader = null;
            try {
                String string5;
                process = Runtime.getRuntime().exec("/sbin/route -n");
                InputStream inputStream = process.getInputStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                while ((string5 = bufferedReader.readLine()) != null) {
                    block63: {
                        try {
                            if (bl2) return string;
                            if (!string5.startsWith("0.0.0.0")) continue;
                        }
                        catch (IOException iOException) {
                            throw NetworkUtils.a(iOException);
                        }
                        StringTokenizer stringTokenizer = new StringTokenizer(string5);
                        try {
                            if (!stringTokenizer.hasMoreTokens()) break block63;
                            stringTokenizer.nextToken();
                            if (!stringTokenizer.hasMoreTokens()) break block63;
                        }
                        catch (IOException iOException) {
                            throw NetworkUtils.a(iOException);
                        }
                        String string6 = stringTokenizer.nextToken();
                        _logger.info((Object)("gateway(linux):" + string6));
                        String string7 = string6;
                        return string7;
                    }
                    if (!bl2) continue;
                    return string;
                }
                return string;
            }
            catch (IOException iOException) {
                _logger.error((Object)"getDefaultGateway upon linux", (Throwable)iOException);
                return string;
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    _logger.error((Object)"", (Throwable)iOException);
                }
            }
        }
        if (!AppUtil.isOsX()) return string;
        BufferedReader bufferedReader = null;
        try {
            String string8;
            process = Runtime.getRuntime().exec("/usr/sbin/netstat -rn");
            InputStream inputStream = process.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((string8 = bufferedReader.readLine()) != null) {
                block64: {
                    String[] stringArray = Tokenizer.parse(string8, ' ', true, true);
                    if (bl2) return string;
                    try {
                        block65: {
                            if (stringArray.length != 4) break block64;
                            break block65;
                            catch (IOException iOException) {
                                throw NetworkUtils.a(iOException);
                            }
                        }
                        if (!StringUtil.isIp(stringArray[1])) break block64;
                    }
                    catch (IOException iOException) {
                        throw NetworkUtils.a(iOException);
                    }
                    _logger.info((Object)("gateway(mac):" + stringArray[1]));
                    String string9 = stringArray[1];
                    return string9;
                }
                if (!bl2) continue;
                return string;
            }
            return string;
        }
        catch (IOException iOException) {
            _logger.error((Object)"getDefaultGateway upon linux", (Throwable)iOException);
            return string;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                _logger.error((Object)"", (Throwable)iOException);
            }
        }
    }

    public static boolean isInSubnet(String string, String string2, String string3) {
        try {
            int n2 = InetAddress.getByName(string).hashCode();
            int n3 = InetAddress.getByName(string2).hashCode();
            int n4 = InetAddress.getByName(string3).hashCode();
            return (n2 & n3) == n4;
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public static boolean isLegalIpOrHostname(String string) {
        return StringUtil.isIp(string) || NetworkUtils.isValidAddress(string);
    }

    /*
     * Loose catch block
     */
    public static boolean isActiveIp(String string) {
        block9: {
            block8: {
                if (!StringUtil.isIp(string)) break block8;
                try {
                    block10: {
                        if (JPing.getRtt(string) <= -1) break block9;
                        break block10;
                        catch (Exception exception) {
                            throw NetworkUtils.a(exception);
                        }
                    }
                    return true;
                }
                catch (Exception exception) {
                    throw NetworkUtils.a(exception);
                }
            }
            if (NetworkUtils.isValidAddress(string)) {
                try {
                    InetAddress inetAddress = InetAddress.getByName(string);
                    if (JPing.getRtt(inetAddress.getHostAddress()) > -1) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }
        return false;
    }

    public static String getSubnet(String string) {
        if (!NetworkUtils.isValidAddress(string)) {
            return null;
        }
        return string.substring(0, string.lastIndexOf(".") + 1) + "0";
    }

    public static String getLocalHostName() {
        String string = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getHostName();
            int n2 = string.indexOf(".");
            if (n2 > 0) {
                string = string.substring(0, n2);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"getLocalHostName", (Throwable)exception);
        }
        return string;
    }

    public static String getLocalHostIp() {
        String string = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getHostAddress();
        }
        catch (Exception exception) {
            _logger.error((Object)"getLocalhostIp", (Throwable)exception);
        }
        return string;
    }

    public static String int2IP(int n2) {
        byte[] byArray = new byte[]{(byte)(n2 >>> 24 & 0xFF), (byte)(n2 >>> 16 & 0xFF), (byte)(n2 >>> 8 & 0xFF), (byte)(n2 & 0xFF)};
        try {
            return InetAddress.getByAddress(byArray).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean scanPort(String string, int n2, int n3) {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n2);
        Socket socket = new Socket();
        try {
            socket.connect(inetSocketAddress, n3);
        }
        catch (IOException iOException) {
            _logger.debug((Object)("Cannot connect to " + string + ":" + n2));
            boolean bl2 = false;
            return bl2;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    _logger.warn((Object)"close socket", (Throwable)iOException);
                }
            }
        }
        return true;
    }

    public static boolean isValidMac(String string) {
        return (string.split(":").length == 6 || string.split("-").length == 6) && !"00-00-00-00-00-00".equals(string) && !"00:00:00:00:00:00".equals(string);
    }

    static {
        INVALID_ADDRESSES.add("0.*/8");
        INVALID_ADDRESSES.add("255.*/8");
        PRIVATE_ADDRESSES.add("0.*/8");
        PRIVATE_ADDRESSES.add("127.*/8");
        PRIVATE_ADDRESSES.add("255.*/8");
        PRIVATE_ADDRESSES.add("10.*/8");
        PRIVATE_ADDRESSES.add("172.16.*/12");
        PRIVATE_ADDRESSES.add("169.254.*/16");
        PRIVATE_ADDRESSES.add("192.168.*/16");
        LOCAL_ADDRESSES.add("127.*/8");
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

