/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.common.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.EncodedKeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.log4j.Logger;
import util.Base64;

class KeyUtil {
    private static Logger _logger = Logger.getLogger((String)KeyUtil.class.getName());
    public static final String ISO = "ISO-8859-1";
    public static final String DELIMITER_STR = "<!--NEXT-->";
    public static byte[] DELIMITER;

    KeyUtil() {
    }

    public static Key loadKey(String string, boolean bl2) {
        try {
            byte[] byArray = null;
            if (bl2) {
                byArray = "MIIBuDCCASwGByqGSM44BAEwggEfAoGBAP1/U4EddRIpUt9KnC7s5Of2EbdSPO9EAMMeP4C2USZp\nRV1AIlH7WT2NWPq/xfW6MPbLm1Vs14E7gB00b/JmYLdrmVClpJ+f6AR7ECLCT7up1/63xhv4O1fn\nxqimFQ8E+4P208UewwI1VBNaFpEy9nXzrith1yrv8iIDGZ3RSAHHAhUAl2BQjxUjC8yykrmCouuE\nC/BYHPUCgYEA9+GghdabPd7LvKtcNrhXuXmUr7v6OuqC+VdMCz0HgmdRWVeOutRZT+ZxBxCBgLRJ\nFnEj6EwoFhO3zwkyjMim4TwWeotUfI0o4KOuHiuzpnWRbqN/C/ohNWLx+2J6ASQ7zKTxvqhRkImo\ng9/hWuWfBpKLZl6Ae1UlZAFMO/7PSSoDgYUAAoGBAMa+Ssk5NkWwEi60xSuMOwR/UVo6GcE+fLYk\n8IZmN3clIZ45RY50zYBdrDp5SeFzSEo4qNG8Ii13JeOK65LtmG6HduyYdoxbWV7EyH5/KRdwEnf5\nf2xxWuw5qtM2LXa0cEKerJRnWPsuH3ex6HExQ3vm9oxKFYzmiDuUDiwckQQg".getBytes(ISO);
                byArray = KeyUtil.base64Decode(byArray);
            } else {
                byArray = KeyUtil.loadBinFile(string);
            }
            return KeyUtil.loadKey(byArray, bl2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Key loadKey(byte[] byArray, boolean bl2) {
        try {
            EncodedKeySpec encodedKeySpec = null;
            encodedKeySpec = bl2 ? new X509EncodedKeySpec(byArray) : new PKCS8EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA", "SUN");
            Key key = null;
            key = bl2 ? keyFactory.generatePublic(encodedKeySpec) : keyFactory.generatePrivate(encodedKeySpec);
            return key;
        }
        catch (Exception exception) {
            _logger.error((Object)"", (Throwable)exception);
            return null;
        }
    }

    public static KeyPair generateKeys() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DSA", "SUN");
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG", "SUN");
            keyPairGenerator.initialize(1024, secureRandom);
            return keyPairGenerator.generateKeyPair();
        }
        catch (Exception exception) {
            _logger.error((Object)"", (Throwable)exception);
            return null;
        }
    }

    public static byte[] base64Encode(byte[] byArray) {
        return Base64.encodeToByte((byte[])byArray, (boolean)true);
    }

    public static byte[] base64Decode(byte[] byArray) {
        return Base64.decode((byte[])byArray);
    }

    public static void saveBinFile(String string, byte[] byArray) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        byte[] byArray2 = KeyUtil.base64Encode(byArray);
        fileOutputStream.write(byArray2, 0, byArray2.length);
        fileOutputStream.close();
    }

    public static byte[] loadBinFile(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[fileInputStream.available()];
        fileInputStream.read(byArray);
        fileInputStream.close();
        return KeyUtil.base64Decode(byArray);
    }

    public static void saveKey(Key key, String string) throws IOException {
        byte[] byArray = key.getEncoded();
        KeyUtil.saveBinFile(string, byArray);
    }

    static {
        try {
            DELIMITER = "<!--NEXT-->\n".getBytes(ISO);
        }
        catch (Exception exception) {
            DELIMITER = null;
        }
    }
}

