/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.common.util;

import com.sysuptime.common.util.ComparablePair;
import com.sysuptime.common.util.StringUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class CompactProperties
implements Serializable {
    private LinkedList _pairs = new LinkedList();
    private boolean _isSorted = true;
    private static final Logger _logger = Logger.getLogger((String)CompactProperties.class.getName());

    public synchronized Object put(ComparablePair comparablePair) {
        return this.put(comparablePair.name, comparablePair.value);
    }

    public synchronized Object put(Comparable comparable, Object object) {
        ComparablePair comparablePair;
        if (comparable == null) {
            _logger.error((Object)"ERROR! The key work can not be null!");
            return null;
        }
        if (object == null) {
            object = "";
        }
        if ((comparablePair = this.getPropertyPair(comparable)) != null) {
            ComparablePair comparablePair2 = new ComparablePair(comparablePair);
            comparablePair.value = object;
            comparablePair.name = comparable;
            return comparablePair2.value;
        }
        this._isSorted = false;
        this._pairs.add(new ComparablePair(comparable, object));
        return null;
    }

    public synchronized void putAll(CompactProperties compactProperties) {
        Iterator iterator = compactProperties._pairs.iterator();
        String[] stringArray = StringUtil.b();
        while (iterator.hasNext()) {
            ComparablePair comparablePair = (ComparablePair)iterator.next();
            this.put(comparablePair);
            if (stringArray != null) continue;
        }
    }

    public synchronized ComparablePair getPropertyPair(Comparable comparable) {
        return (ComparablePair)this.a(comparable);
    }

    public synchronized Object getProperty(Comparable comparable) {
        ComparablePair comparablePair = (ComparablePair)this.a(comparable);
        if (comparablePair == null) {
            return null;
        }
        return comparablePair.value;
    }

    public synchronized LinkedList getProperties() {
        return this._pairs;
    }

    public synchronized Object remove(Comparable comparable) {
        Object object = this.a(comparable);
        if (object == null) {
            return null;
        }
        boolean bl2 = this._pairs.remove(object);
        if (!bl2) {
            return null;
        }
        return ((ComparablePair)object).value;
    }

    public synchronized void clear() {
        this._pairs.clear();
    }

    public synchronized int size() {
        return this._pairs.size();
    }

    private synchronized Object a(Comparable comparable) {
        int n2;
        if (!this._isSorted) {
            Collections.sort(this._pairs);
            this._isSorted = true;
        }
        if ((n2 = Collections.binarySearch(this._pairs, comparable)) < 0) {
            return null;
        }
        return this._pairs.get(n2);
    }
}

