/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.common.graph;

import com.sysuptime.common.graph.TypedNumber;
import com.sysuptime.common.graph.ValueRelatedRenderer$ErrorToolTipGenerator;
import java.awt.Shape;
import java.io.Serializable;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.util.ShapeUtilities;

public class ValueRelatedRenderer
extends StandardXYItemRenderer
implements Serializable {
    private static final Shape NORMAL_SHAPE = ShapeUtilities.createDiamond((float)3.0f);
    private static final Shape UNKNOWN_SHAPE = ShapeUtilities.createDownTriangle((float)3.0f);
    private static final Shape ERROR_SHAPE = ShapeUtilities.createDiagonalCross((float)3.0f, (float)1.0f);
    private TimeSeriesCollection _dataset;

    public ValueRelatedRenderer(TimeSeriesCollection timeSeriesCollection) {
        this._dataset = timeSeriesCollection;
        this.setPlotLines(true);
        this.setBaseShapesVisible(true);
        this.setToolTipGenerator((XYToolTipGenerator)new ValueRelatedRenderer$ErrorToolTipGenerator());
    }

    public Shape getItemShape(int n2, int n3) {
        TimeSeries timeSeries = this._dataset.getSeries(n2);
        TypedNumber typedNumber = (TypedNumber)timeSeries.getValue(n3);
        if (typedNumber.isUnavailable()) {
            return UNKNOWN_SHAPE;
        }
        if (typedNumber.isError()) {
            return ERROR_SHAPE;
        }
        return NORMAL_SHAPE;
    }
}

