/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.common.expression;

import java.io.Serializable;

public interface NormalExpressionConstants
extends Serializable {
    public static final String PORT_UTILIZATION_EXPRESSION_NAME = "Network Interface Utilization";
    public static final String BANDWIDTH_UTILIZATION_EXPRESSION = "(ifInOctets + ifOutOctets) * 8 / ifSpeed * 100";
    public static final String BANDWIDTH_UTILIZATION_EXPR_DESCRIPTION = "Network interface utilization. Valid if SNMP agent supports ifTable.";
    public static final String INPUT_UTILIZATION_EXPRESSION_NAME = "Network Interface Input Utilization";
    public static final String INPUT_UTILIZATION_EXPR_EXPRESSION = "ifInOctets * 8 / ifSpeed * 100";
    public static final String INPUT_UTILIZATION_EXPR_DESCRIPTION = "Network interface input utilization. Valid if SNMP agent supports ifTable.";
    public static final String OUTPUT_UTILIZATION_EXPRESSION_NAME = "Network Interface Output Utilization";
    public static final String OUTPUT_UTILIZATION_EXPR_EXPRESSION = "ifOutOctets * 8 / ifSpeed * 100";
    public static final String OUTPUT_UTILIZATION_EXPR_DESCRIPTION = "Network interface output utilization. Valid if SNMP agent supports ifTable.";
    public static final String PORT_UTILIZATION_IF_IN_OCTETS = "ifInOctets";
    public static final String PORT_UTILIZATION_IF_OUT_OCTETS = "ifOutOctets";
    public static final String PORT_UTILIZATION_IF_SPEED = "ifSpeed";
    public static final String PORT_UTILIZATION_IF_IN_OCTETS_OID = ".1.3.6.1.2.1.2.2.1.10.";
    public static final String PORT_UTILIZATION_IF_OUT_OCTETS_OID = ".1.3.6.1.2.1.2.2.1.16.";
    public static final String PORT_UTILIZATION_IF_SPEED_OID = ".1.3.6.1.2.1.2.2.1.5.";
    public static final String CPU_UTILIZATION_FROM_NET_SNMP_EXPRESSION_NAME = "CPU Utilization from NET-SNMP agent";
    public static final String CPU_UTILIZATION_FROM_NET_SNMP_EXPRESSION = "(user + sys + nice ) * 100 / (user + sys + nice + idle)";
    public static final String CPU_UTILIZATION_FROM_NET_SNMP_EXPRESSION_DESCRITION = "CPU utilization. Valid if SNMP agent is NET-SNMP agent.";
    public static final String CPU_UTILIZATION_FROM_NET_SNMP_USER = "user";
    public static final String CPU_UTILIZATION_FROM_NET_SNMP_SYS = "sys";
    public static final String CPU_UTILIZATION_FROM_NET_SNMP_NICE = "nice";
    public static final String CPU_UTILIZATION_FROM_NET_SNMP_IDLE = "idle";
    public static final String CPU_UTILIZATION_FROM_NET_SNMP_USER_OID = ".1.3.6.1.4.1.2021.11.50.0";
    public static final String CPU_UTILIZATION_FROM_NET_SNMP_SYS_OID = ".1.3.6.1.4.1.2021.11.52.0";
    public static final String CPU_UTILIZATION_FROM_NET_SNMP_NICE_OID = ".1.3.6.1.4.1.2021.11.51.0";
    public static final String CPU_UTILIZATION_FROM_NET_SNMP_IDLE_OID = ".1.3.6.1.4.1.2021.11.53.0";
    public static final String CPU_UTILIZATION_FROM_MS_WINDOW_EXPRESSION_NAME = "CPU load from MS Windows agent";
    public static final String CPU_UTILIZATION_FROM_MS_WINDOW_EXPRESSION = "cpuLoad";
    public static final String CPU_UTILIZATION_FROM_MS_WINDOW_EXPRESSION_DESCRIPTION = "Valid if the SNMP agent supports HOST-RESOURCES-MIB. The average, over the last minute, of the percentage of time that this processor was not idle.";
    public static final String CPU_UTILIZATION_FROM_MS_WINDOW_CPULOAD = "cpuLoad";
    public static final String CPU_UTILIZATION_FROM_MS_WINDOW_CPULOAD_OID = ".1.3.6.1.2.1.25.3.3.1.2.";
    public static final String MEMORY_UTILIZATION_EXPRESSION_NAME = "Memory Utilization";
    public static final String MEMORY_UTILIZATION_EXPRESSION = "100*used/total";
    public static final String MEMORY_UTILIZATION_EXPRESSION_DESCRIPTION = "Valid if the SNMP agent supports HOST-RESOURCES-MIB.";
    public static final String MEMORY_UTILIZATION_USED = "used";
    public static final String MEMORY_UTILIZATION_TOTAL = "total";
    public static final String MEMORY_UTILIZATION_USED_OID = ".1.3.6.1.2.1.25.2.3.1.6.";
    public static final String MEMORY_UTILIZATION_TOTAL_OID = ".1.3.6.1.2.1.25.2.3.1.5.";
    public static final String DISK_UTILIZATION_EXPRESSION_NAME = "Disk Utilization";
    public static final String DISK_UTILIZATION_EXPRESSION = "100*used/total";
    public static final String DISK_UTILIZATION_EXPRESSION_DESCRIPTION = "Valid if the SNMP agent supports HOST-RESOURCES-MIB.";
    public static final String DISK_UTILIZATION_USED = "used";
    public static final String DISK_UTILIZATION_TOTAL = "total";
    public static final String DISK_UTILIZATION_USED_OID = ".1.3.6.1.2.1.25.2.3.1.6.";
    public static final String DISK_UTILIZATION_TOTAL_OID = ".1.3.6.1.2.1.25.2.3.1.5.";
    public static final String CHECK_PROCESS_STATE_EXPRESSION_NAME = "Check Process State";
    public static final String CHECK_PROCESS_STATE_EXPRESSION = "Processes";
    public static final String CHECK_PROCESS_STATE_EXPRESSION_DESCRIPTION = "Check if a process is running. Enter the name of the process in the threshod screen and its condition is `Excludes`. Valid if the SNMP agent supports HOST-RESOURCES-MIB.";
    public static final String CHECK_PROCESS_STATE_PROCESSES = "Processes";
    public static final String CHECK_PROCESS_STATE_PROCESSES_OID = ".1.3.6.1.2.1.25.4.2.1.2.s";
    public static final String PROCESS_SEPARATE_CHAR = "<>";
    public static final String CHECK_PROCESS_STATE_FROM_NET_SNMP_AGENT_EXPRESSION_NAME = "Check Process State from NET-SNMP agent";
    public static final String CHECK_PROCESS_STATE_FROM_NET_SNMP_AGENT_EXPRESSION = "prNames+prErrorFlag";
    public static final String CHECK_PROCESS_STATE_FROM_NET_SNMP_AGENT_EXPRESSION_DESCRPTION = "Check if a process is running. Enter the name of the process (in processName<>0 format, where 0 means the process is running) in the threshod screen and its condition is `Excludes`. Valid if the SNMP agent is NET-SNMP agent and prTable is not empty.";
    public static final String CHECK_PROCESS_STATE_FROM_NET_SNMP_AGENT_PRNAMES = "prNames";
    public static final String CHECK_PROCESS_STATE_FROM_NET_SNMP_AGENT_PRERRORFLAG = "prErrorFlag";
    public static final String CHECK_PROCESS_STATE_FROM_NET_SNMP_AGENT_PRNAMES_OID = ".1.3.6.1.4.1.2021.2.1.2.s";
    public static final String CHECK_PROCESS_STATE_FROM_NET_SNMP_AGENT_PRERRORFLAG_OID = ".1.3.6.1.4.1.2021.2.1.100.s";
    public static final String PAGES_PRINTED_OF_PRINTER_EXPRESSION_NAME = "Pages printed";
    public static final String STATUS_OF_PRINTER_EXPRESSION_NAME = "Status of printer";
    public static final String CISCO_ACTIVE_CONNECTIONS_EXPRESSION_NAME = "Cisco PIX firewall: activeConnections";
    public static final String CISCO_MEMORY_EXPRESSION_NAME = "Cisco PIX firewall: memory utilization";
    public static final String CISCO_CPU_1MIN_EXPRESSION_NAME = "Cisco device: avgBusy1";
    public static final String CISCO_CPU_5MIN_EXPRESSION_NAME = "Cisco device: avgBusy5";
    public static final String CISCO_CPM_CPU_TOTAL_1MIN_REV_EXPRESSION_NAME = "Cisco device: cpmCPUTotal1minRev@1";
    public static final String CISCO_CPM_CPU_TOTAL_5MIN_REV_EXPRESSION_NAME = "Cisco device: cpmCPUTotal5minRev@1";
    public static final String CISCO_CPM_CPU_TOTAL_1MIN_EXPRESSION_NAME = "Cisco device: cpmCPUTotal1min@1";
    public static final String CISCO_CPM_CPU_TOTAL_5MIN_EXPRESSION_NAME = "Cisco device: cpmCPUTotal5min@1";
    public static final String CISCO_TEMPERATURE_STATUS_VALUE_EXPERSSION_NAME = "Cisco device: temperatureStatusValue@";
    public static final String CISCO_CENSOR_VALUE_EXPRESSION_NAME = "Cisco device: censorValue@";
}

