/*
 * Decompiled with CFR 0.152.
 */
package com.ireasoning.util;

import com.ireasoning.app.mibbrowser.al;
import com.ireasoning.protocol.snmp.SnmpDataType;
import com.ireasoning.protocol.snmp.SnmpPdu;
import com.ireasoning.protocol.snmp.SnmpSession;
import com.ireasoning.protocol.snmp.SnmpVarBind;
import com.ireasoning.protocol.snmp.W;
import com.ireasoning.protocol.snmp.ac;
import com.ireasoning.protocol.snmp.at;
import com.ireasoning.protocol.snmp.av;
import com.ireasoning.util.AgentProperties;
import com.ireasoning.util.Q;
import com.ireasoning.util.R;
import com.ireasoning.util.aU;
import com.ireasoning.util.au;
import com.ireasoning.util.bk;
import com.sysuptime.server.msp.Command;
import com.ultraswing.aE;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class MibBrowserUtil {
    private static String _appHomeDirectory;
    private static URI _appHomeUri;
    private static Properties _i18nMap;
    public static final boolean IS_CHINESE;
    public static final String CONNECT_ERROR_MSG;
    public static final String CONNECT_TIME_OUT_MSG;
    public static final String NO_DATA_AVAILABLE;
    public static final String GETTING_DATA;
    public static final String MIB_SUB = ".imibrowser";
    public static final String APP_ID = "com.ireasoning.mibpro";
    public static final String MAC_DIR_PREFIX;
    private static boolean _isResourcesLoaded;
    public static final String IF_HIGH_SPEED_OID = ".1.3.6.1.2.1.31.1.1.1.15";
    private static Command[] a;

    static String a() {
        try {
            String string = MibBrowserUtil.class.getProtectionDomain().getCodeSource().getLocation().getFile();
            string = URLDecoder.decode(string, "UTF-8");
            return string;
        }
        catch (Exception exception) {
            au.error(exception);
            return null;
        }
    }

    public static URI getAppHomeURI() {
        if (_appHomeUri == null) {
            try {
                String string = MibBrowserUtil.a();
                int n2 = string.lastIndexOf("/");
                n2 = string.lastIndexOf("/", n2 - 1);
                string = string.substring(0, n2);
                string = aU.replaceString(string, " ", "%20");
                _appHomeUri = new URI("file://" + string);
            }
            catch (Exception exception) {
                au.error(exception);
            }
        }
        return _appHomeUri;
    }

    public static void resetConfigFile(String string, String string2, boolean bl2) {
        try {
            File file;
            block4: {
                file = new File(string + File.separator + string2);
                try {
                    if (!file.exists() || bl2) break block4;
                }
                catch (IOException iOException) {
                    throw MibBrowserUtil.a(iOException);
                }
                return;
            }
            String string3 = Q.readFile(MibBrowserUtil.getAppHomeDirectory() + File.separator + "config" + File.separator + string2);
            Q.writeFile(file.getAbsolutePath(), string3);
        }
        catch (IOException iOException) {
            au.error(iOException);
        }
    }

    private static String b() {
        try {
            if (al.IS_MAC) {
                return MAC_DIR_PREFIX;
            }
        }
        catch (Exception exception) {
            throw MibBrowserUtil.a(exception);
        }
        String string = System.getProperty("netbeans.user");
        if (string == null) {
            Object object = System.getProperty("user.home");
            if (object != null) {
                block9: {
                    object = (String)object + "/.imibrowser";
                    try {
                        File file = new File((String)object);
                        try {
                            if (file.exists() || file.mkdirs()) break block9;
                        }
                        catch (Exception exception) {
                            throw MibBrowserUtil.a(exception);
                        }
                        return MibBrowserUtil.getAppHomeDirectory();
                    }
                    catch (Exception exception) {
                        return MibBrowserUtil.getAppHomeDirectory();
                    }
                }
                return object;
            }
            return MibBrowserUtil.getAppHomeDirectory();
        }
        return string;
    }

    public static String getConfigDirectory() {
        String string = System.getProperty("netbeans.user");
        if (string == null) {
            String string2 = System.getProperty("user.home");
            if (string2 != null) {
                String string3 = null;
                string3 = string2 + File.separator + MIB_SUB;
                try {
                    block6: {
                        File file = new File(string3);
                        try {
                            if (file.exists() || file.mkdir()) break block6;
                        }
                        catch (Exception exception) {
                            throw MibBrowserUtil.a(exception);
                        }
                        return MibBrowserUtil.getAppHomeDirectory() + File.separator + "config";
                    }
                    MibBrowserUtil.resetConfigFile(string3, "mibbrowser.xml", false);
                    MibBrowserUtil.resetConfigFile(string3, "trapd.xml", false);
                }
                catch (Exception exception) {
                    return MibBrowserUtil.getAppHomeDirectory() + File.separator + "config";
                }
                return string3;
            }
            return MibBrowserUtil.getAppHomeDirectory() + File.separator + "config";
        }
        return string + File.separator + "config";
    }

    public static String getAppHomeDirectory() {
        if (_appHomeDirectory == null) {
            try {
                String string = MibBrowserUtil.a();
                File file = new File(string);
                File file2 = bk.getParentFile(file).getParentFile();
                _appHomeDirectory = file2.getCanonicalPath();
            }
            catch (Exception exception) {
                au.error(exception);
            }
        }
        return _appHomeDirectory;
    }

    public static String getMacConfigDirectory() {
        String string = MAC_DIR_PREFIX + "/config";
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        return string;
    }

    public static String getLogDirectory() {
        if (al.IS_MAC) {
            String string = MAC_DIR_PREFIX + "/log/";
            File file = new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
            return string;
        }
        return MibBrowserUtil.getAppHomeDirectory() + "/log/";
    }

    public static String getDbDirectory() {
        Object object = MibBrowserUtil.b();
        object = (String)object + "/database";
        au.info("Database dir:" + (String)object);
        return object;
    }

    public static String getTempDirectory() {
        if (al.IS_MAC) {
            String string = MAC_DIR_PREFIX + "/temp";
            File file = new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
            return string;
        }
        return MibBrowserUtil.getAppHomeDirectory() + File.separator + "temp";
    }

    public static ImageIcon getImage(String string) {
        if (string == null) {
            return null;
        }
        return new ImageIcon(MibBrowserUtil.class.getResource("/images/" + string));
    }

    public static String getString(String string, String string2) {
        String string3 = _i18nMap.getProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public static String getString(String string) {
        String string2 = _i18nMap.getProperty(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    private static void a(Font font) {
        FontUIResource fontUIResource = new FontUIResource(font);
        Enumeration enumeration = UIManager.getDefaults().keys();
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            Object object = UIManager.get(k2);
            if (!(object instanceof FontUIResource)) continue;
            UIManager.put(k2, fontUIResource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadResources() {
        try {
            if (_isResourcesLoaded) {
                return;
            }
        }
        catch (Exception exception) {
            throw MibBrowserUtil.a(exception);
        }
        try {
            _isResourcesLoaded = true;
            if (!IS_CHINESE) {
                return;
            }
        }
        catch (Exception exception) {
            throw MibBrowserUtil.a(exception);
        }
        String string = MibBrowserUtil.getAppHomeDirectory() + File.separator + "config" + File.separator + "Bundle.properties";
        File file = new File(string);
        try {
            if (!file.exists()) {
                return;
            }
        }
        catch (Exception exception) {
            throw MibBrowserUtil.a(exception);
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            Set<Map.Entry<Object, Object>> set = properties.entrySet();
            for (Map.Entry<Object, Object> entry : set) {
                String string2 = (String)entry.getKey();
                String string3 = (String)entry.getValue();
                try {
                    if (string3.trim().length() == 0) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    throw MibBrowserUtil.a(exception);
                }
                string2 = string2.replace('_', ' ');
                string2 = string2.replace('`', ':');
                _i18nMap.put(string2, string3);
            }
        }
        catch (Exception exception) {
            au.error(exception);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                au.error(exception);
            }
        }
    }

    public static boolean show(String string) {
        String string2 = System.getProperty(string);
        if (string2 == null || "yes".equalsIgnoreCase(string2)) {
            return true;
        }
        return aU.getBool(string2);
    }

    public static void addToAddressCombo(JComboBox jComboBox, AgentProperties[] agentPropertiesArray) {
        block4: {
            Command[] commandArray = MibBrowserUtil.c();
            if (agentPropertiesArray == null) {
                return;
            }
            for (int i2 = 0; i2 < agentPropertiesArray.length; ++i2) {
                MibBrowserUtil.addToAddressCombo(jComboBox, agentPropertiesArray[i2]);
                if (commandArray != null) {
                    if (commandArray != null) continue;
                }
                break block4;
            }
            if (R.isOptions()) {
                AgentProperties agentProperties = new AgentProperties(R.getHost(), R.getPort(), R.getVersion(), R.getCommunity(), null);
                MibBrowserUtil.addToAddressCombo(jComboBox, agentProperties);
            }
        }
    }

    public static AgentProperties addToAddressCombo(JComboBox jComboBox, AgentProperties agentProperties) {
        block2: {
            int n2 = jComboBox.getItemCount();
            Command[] commandArray = MibBrowserUtil.c();
            for (int i2 = 0; i2 < n2; ++i2) {
                Object e10 = jComboBox.getItemAt(i2);
                if (commandArray != null) {
                    if (!(e10 instanceof AgentProperties)) continue;
                    AgentProperties agentProperties2 = (AgentProperties)e10;
                    if (agentProperties == null || !agentProperties.equals(agentProperties2)) continue;
                    jComboBox.removeItem(agentProperties2);
                    if (commandArray != null) break;
                    if (commandArray != null) continue;
                }
                break block2;
            }
            jComboBox.addItem(agentProperties);
        }
        return agentProperties;
    }

    public static JLabel createErrorMessageLabel(String string) {
        aE aE2 = new aE("<HTML><H1><FONT COLOR=\"#666666\">&nbsp;&nbsp;&nbsp;&nbsp;" + string + "</FONT></H1>");
        aE2.setAntiAlias(true);
        return aE2;
    }

    public static void showErrorMessage(JPanel jPanel, String string) {
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)MibBrowserUtil.createErrorMessageLabel(string), "North");
        jPanel.add((Component)jPanel2, "Center");
        jPanel.validate();
    }

    public static int getIfHighSpeed(int n2, SnmpSession snmpSession) {
        block5: {
            try {
                int n3;
                SnmpDataType snmpDataType;
                block6: {
                    SnmpPdu snmpPdu = snmpSession.snmpGetRequest(".1.3.6.1.2.1.31.1.1.1.15." + n2);
                    if (snmpPdu.getErrorStatus() != 0) break block5;
                    snmpDataType = snmpPdu.getFirstVarBind().getValue();
                    n3 = snmpDataType.getType();
                    try {
                        if (n3 != 66 && n3 != 65) break block6;
                    }
                    catch (IOException iOException) {
                        throw MibBrowserUtil.a(iOException);
                    }
                    return (int)((at)snmpDataType).getValue();
                }
                if (n3 == 2) {
                    return ((ac)snmpDataType).getValue();
                }
                au.error("ifHighSpeed. Unkown data type:" + n3);
            }
            catch (IOException iOException) {
                au.error("Can't get high speed");
            }
        }
        return -1;
    }

    /*
     * Loose catch block
     */
    public static void getIfHighSpeed(SnmpVarBind[] snmpVarBindArray, SnmpVarBind[] snmpVarBindArray2, SnmpSession snmpSession) {
        int n2;
        int n3;
        Command[] commandArray;
        ArrayList<String> arrayList;
        int n4;
        block10: {
            n4 = snmpVarBindArray.length;
            arrayList = new ArrayList<String>();
            commandArray = MibBrowserUtil.c();
            int n5 = 0;
            for (int i2 = 0; i2 < n4; ++i2) {
                long l2 = Long.parseLong(snmpVarBindArray[i2].getValue().toString());
                n3 = Integer.valueOf(snmpVarBindArray2[i2].getValue().toString());
                long l3 = l2 - av.MAX_VALUE.getValue();
                n2 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
                if (commandArray == null) break block10;
                try {
                    block11: {
                        if (n2 != 0) continue;
                        break block11;
                        catch (IOException iOException) {
                            throw MibBrowserUtil.a(iOException);
                        }
                    }
                    arrayList.add(String.valueOf(n3));
                    ++n5;
                    continue;
                }
                catch (IOException iOException) {
                    throw MibBrowserUtil.a(iOException);
                }
            }
            n2 = n5;
        }
        String[] stringArray = new String[n2];
        int n6 = arrayList.size();
        for (n3 = 0; n3 < n6; ++n3) {
            stringArray[n3] = ".1.3.6.1.2.1.31.1.1.1.15." + arrayList.get(n3);
            if (commandArray != null) continue;
        }
        SnmpPdu snmpPdu = null;
        if (n6 > 0) {
            try {
                snmpPdu = snmpSession.snmpGetRequest(stringArray);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                au.error("Can't get high speed");
            }
            int n7 = 0;
            for (int i3 = 0; i3 < n4; ++i3) {
                long l4 = Long.parseLong(snmpVarBindArray[i3].getValue().toString());
                if (l4 != av.MAX_VALUE.getValue()) continue;
                int n8 = MibBrowserUtil.a(snmpPdu.getVarBind(n7));
                ++n7;
                if (n8 <= 0) continue;
                W w2 = new W(l4 *= 1000000L);
                snmpVarBindArray[i3].setValue(w2);
                if (commandArray != null) continue;
            }
        }
    }

    private static int a(SnmpVarBind snmpVarBind) {
        SnmpDataType snmpDataType = snmpVarBind.getValue();
        int n2 = snmpDataType.getType();
        if (n2 == 66 || n2 == 65) {
            return (int)((at)snmpDataType).getValue();
        }
        if (n2 == 2) {
            return ((ac)snmpDataType).getValue();
        }
        au.error("ifHighSpeed. Unkown data type:" + n2);
        return -1;
    }

    public static boolean copyDirectory(File file, File file2) throws IOException {
        block13: {
            block14: {
                try {
                    try {
                        if (!file.isDirectory()) break block13;
                        if (file2.exists()) break block14;
                    }
                    catch (IOException iOException) {
                        throw MibBrowserUtil.a(iOException);
                    }
                    file2.mkdir();
                }
                catch (IOException iOException) {
                    throw MibBrowserUtil.a(iOException);
                }
            }
            String[] stringArray = file.list();
            try {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    MibBrowserUtil.copyDirectory(new File(file, stringArray[i2]), new File(file2, stringArray[i2]));
                }
            }
            catch (IOException iOException) {
                throw MibBrowserUtil.a(iOException);
            }
        }
        try {
            if (!file.exists()) {
                return false;
            }
        }
        catch (IOException iOException) {
            throw MibBrowserUtil.a(iOException);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[1024];
        while (true) {
            int n2 = ((InputStream)fileInputStream).read(byArray);
            try {
                if (n2 <= 0) break;
                ((OutputStream)fileOutputStream).write(byArray, 0, n2);
            }
            catch (IOException iOException) {
                throw MibBrowserUtil.a(iOException);
            }
        }
        ((InputStream)fileInputStream).close();
        ((OutputStream)fileOutputStream).close();
        return true;
    }

    static {
        _i18nMap = new Properties();
        IS_CHINESE = "chinese".equals(System.getProperty("edition"));
        CONNECT_ERROR_MSG = MibBrowserUtil.getString("Failed to connect to the SNMP agent.");
        CONNECT_TIME_OUT_MSG = MibBrowserUtil.getString("Time out");
        NO_DATA_AVAILABLE = MibBrowserUtil.getString("noDataAvailable", "No data available.");
        GETTING_DATA = MibBrowserUtil.getString("gettingData", "Getting Data...");
        MAC_DIR_PREFIX = System.getProperty("user.home") + "/Library/Containers/com.ireasoning.mibpro/Data/Documents";
        MibBrowserUtil.b(new Command[1]);
        _isResourcesLoaded = false;
        if (IS_CHINESE) {
            FontUIResource fontUIResource = new FontUIResource("\ufffd\ufffd\ufffd\ufffd", 0, 12);
            MibBrowserUtil.a(fontUIResource);
            UIManager.put("controlFont", fontUIResource);
            UIManager.put("Button.font", fontUIResource);
            UIManager.put("ToggleButton.font", fontUIResource);
            UIManager.put("RadioButton.font", fontUIResource);
            UIManager.put("CheckBox.font", fontUIResource);
            UIManager.put("ColorChooser.font", fontUIResource);
            UIManager.put("ComboBox.font", fontUIResource);
            UIManager.put("Label.font", fontUIResource);
            UIManager.put("List.font", fontUIResource);
            UIManager.put("MenuBar.font", fontUIResource);
            UIManager.put("MenuItem.font", fontUIResource);
            UIManager.put("MenuItem.acceleratorFont", fontUIResource);
            UIManager.put("RadioButtonMenuItem.font", fontUIResource);
            UIManager.put("CheckBoxMenuItem.font", fontUIResource);
            UIManager.put("Menu.font", fontUIResource);
            UIManager.put("PopupMenu.font", fontUIResource);
            UIManager.put("OptionPane.font", fontUIResource);
            UIManager.put("OptionPane.messageFont", fontUIResource);
            UIManager.put("Panel.font", fontUIResource);
            UIManager.put("ProgressBar.font", fontUIResource);
            UIManager.put("ScrollPane.font", fontUIResource);
            UIManager.put("Viewport.font", fontUIResource);
            UIManager.put("TabbedPane.font", fontUIResource);
            UIManager.put("Table.font", fontUIResource);
            UIManager.put("TableHeader.font", fontUIResource);
            UIManager.put("TextField.font", fontUIResource);
            UIManager.put("PasswordField.font", fontUIResource);
            UIManager.put("TextArea.font", fontUIResource);
            UIManager.put("TextPane.font", fontUIResource);
            UIManager.put("EditorPane.font", fontUIResource);
            UIManager.put("TitledBorder.font", fontUIResource);
            UIManager.put("ToolBar.font", fontUIResource);
            UIManager.put("ToolTip.font", fontUIResource);
            UIManager.put("Tree.font", fontUIResource);
            UIManager.put("InternalFrame.titleFont", fontUIResource);
            UIManager.put("windowTitleFont", fontUIResource);
        }
    }

    public static void b(Command[] commandArray) {
        a = commandArray;
    }

    public static Command[] c() {
        return a;
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

