/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.ExperimentalApi;
import io.grpc.Metadata;
import io.grpc.StreamTracer;
import javax.annotation.concurrent.ThreadSafe;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2861")
@ThreadSafe
public abstract class ClientStreamTracer
extends StreamTracer {
    public void outboundHeaders() {
    }

    public void inboundHeaders() {
    }

    public void inboundTrailers(Metadata trailers) {
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2861")
    public static final class StreamInfo {
        private final Attributes transportAttrs;
        private final CallOptions callOptions;

        StreamInfo(Attributes transportAttrs, CallOptions callOptions) {
            this.transportAttrs = (Attributes)Preconditions.checkNotNull((Object)transportAttrs, (Object)"transportAttrs");
            this.callOptions = (CallOptions)Preconditions.checkNotNull((Object)callOptions, (Object)"callOptions");
        }

        public Attributes getTransportAttrs() {
            return this.transportAttrs;
        }

        public CallOptions getCallOptions() {
            return this.callOptions;
        }

        public Builder toBuilder() {
            Builder builder = new Builder();
            builder.setTransportAttrs(this.transportAttrs);
            builder.setCallOptions(this.callOptions);
            return builder;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("transportAttrs", (Object)this.transportAttrs).add("callOptions", (Object)this.callOptions).toString();
        }

        public static final class Builder {
            private Attributes transportAttrs = Attributes.EMPTY;
            private CallOptions callOptions = CallOptions.DEFAULT;

            Builder() {
            }

            public Builder setTransportAttrs(Attributes transportAttrs) {
                this.transportAttrs = (Attributes)Preconditions.checkNotNull((Object)transportAttrs, (Object)"transportAttrs cannot be null");
                return this;
            }

            public Builder setCallOptions(CallOptions callOptions) {
                this.callOptions = (CallOptions)Preconditions.checkNotNull((Object)callOptions, (Object)"callOptions cannot be null");
                return this;
            }

            public StreamInfo build() {
                return new StreamInfo(this.transportAttrs, this.callOptions);
            }
        }
    }

    public static abstract class Factory {
        @Deprecated
        public ClientStreamTracer newClientStreamTracer(CallOptions callOptions, Metadata headers) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public ClientStreamTracer newClientStreamTracer(StreamInfo info, Metadata headers) {
            return this.newClientStreamTracer(info.getCallOptions(), headers);
        }
    }
}

