/*
 * Decompiled with CFR 0.152.
 */
package org.jboss;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.jboss.Tokenizer;

public class ParseRoute {
    private String _gateway;
    private String _ip;
    private static ParseRoute _instance;

    public static void main(String[] args) {
        try {
            ParseRoute pr = ParseRoute.getInstance();
            System.out.println("Gateway: " + pr.getGateway());
            System.out.println("IP: " + pr.getLocalIPAddress());
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    private ParseRoute() {
        this.parse();
    }

    private static boolean isWindows() {
        String os = System.getProperty("os.name").toUpperCase();
        return os.contains("WINDOWS");
    }

    private static boolean isLinux() {
        String os = System.getProperty("os.name").toUpperCase();
        return os.contains("LINUX");
    }

    public String getLocalIPAddress() {
        return this._ip;
    }

    public String getGateway() {
        return this._gateway;
    }

    public static ParseRoute getInstance() {
        if (_instance == null) {
            _instance = new ParseRoute();
        }
        return _instance;
    }

    private void parse() {
        if (ParseRoute.isWindows()) {
            this.parseWindows();
        } else if (ParseRoute.isLinux()) {
            this.parseLinux();
        }
    }

    private void parseWindows() {
        try {
            String line;
            Process pro = Runtime.getRuntime().exec("cmd.exe /c route print");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(pro.getInputStream()));
            while ((line = bufferedReader.readLine()) != null) {
                String[] tokens = Tokenizer.parse(line = line.trim(), ' ', true, true);
                if (tokens.length != 5 || !tokens[0].equals("0.0.0.0")) continue;
                this._gateway = tokens[2];
                this._ip = tokens[3];
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void parseLinux() {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader("/proc/net/route"));
            while ((line = reader.readLine()) != null) {
                String[] tokens = Tokenizer.parse(line = line.trim(), '\t', true, true);
                if (tokens.length <= 1 || !tokens[1].equals("00000000")) continue;
                String gateway = tokens[2];
                if (gateway.length() == 8) {
                    String[] s4 = new String[4];
                    s4[3] = String.valueOf(Integer.parseInt(gateway.substring(0, 2), 16));
                    s4[2] = String.valueOf(Integer.parseInt(gateway.substring(2, 4), 16));
                    s4[1] = String.valueOf(Integer.parseInt(gateway.substring(4, 6), 16));
                    s4[0] = String.valueOf(Integer.parseInt(gateway.substring(6, 8), 16));
                    this._gateway = s4[0] + "." + s4[1] + "." + s4[2] + "." + s4[3];
                }
                String iface = tokens[0];
                NetworkInterface nif = NetworkInterface.getByName(iface);
                Enumeration<InetAddress> addrs = nif.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress obj = addrs.nextElement();
                    if (!(obj instanceof Inet4Address)) continue;
                    this._ip = ((Object)obj).toString();
                    if (this._ip.startsWith("/")) {
                        this._ip = this._ip.substring(1);
                    }
                    return;
                }
                return;
            }
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

