/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.OverlayTextField;
import com.jidesoft.swing.SelectAllUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LabeledTextField
extends JPanel {
    protected JTextField _textField;
    protected JLabel _label;
    protected AbstractButton _button;
    protected String _labelText;
    protected Icon _icon;
    protected String _hintText;
    protected JLabel _hintLabel;
    protected PopupMenuCustomizer _customizer;
    protected KeyStroke _contextMenuKeyStroke;

    public LabeledTextField() {
        this(null, null);
    }

    public LabeledTextField(Icon icon) {
        this(icon, null);
    }

    public LabeledTextField(Icon icon, String string) {
        this._icon = icon;
        this._labelText = string;
        this.initComponent();
    }

    protected void initComponent() {
        this._label = this.createLabel();
        if (this._label != null) {
            this._label.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    LabeledTextField.this.showContextMenu();
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }
            });
        }
        this._button = this.createButton();
        this._textField = this.createTextField();
        this.initLayout(this._label, this._textField, this._button);
        this.setContextMenuKeyStroke(KeyStroke.getKeyStroke(40, 512));
        this.registerContextMenuKeyStroke(this.getContextMenuKeyStroke());
        this.updateUI();
    }

    private void registerContextMenuKeyStroke(KeyStroke keyStroke) {
        if (keyStroke != null) {
            this.registerKeyboardAction(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    LabeledTextField.this.showContextMenu();
                }
            }, keyStroke, 1);
        }
    }

    private void unregisterContextMenuKeyStroke(KeyStroke keyStroke) {
        if (keyStroke != null) {
            this.unregisterKeyboardAction(keyStroke);
        }
    }

    protected void showContextMenu() {
        if (this.isEnabled()) {
            JidePopupMenu jidePopupMenu = this.createContextMenu();
            PopupMenuCustomizer popupMenuCustomizer = this.getPopupMenuCustomizer();
            if (popupMenuCustomizer != null && jidePopupMenu != null) {
                popupMenuCustomizer.customize(this, jidePopupMenu);
            }
            if (jidePopupMenu != null && jidePopupMenu.getComponentCount() > 0) {
                Point point = this._label.getLocation();
                ((JPopupMenu)jidePopupMenu).show(this, point.x + (this._label.getIcon() == null ? 1 : this._label.getIcon().getIconWidth() / 2), point.y + this._label.getHeight() + 1);
            }
        }
    }

    protected void initLayout(JLabel jLabel, final JTextField jTextField, AbstractButton abstractButton) {
        this.setLayout(new BorderLayout(3, 3));
        if (jLabel != null) {
            this.add((Component)jLabel, "Before");
        }
        this._hintLabel = new JLabel(this.getHintText());
        this._hintLabel.setOpaque(false);
        Color color = UIDefaultsLookup.getColor("Label.disabledForeground");
        if (color == null) {
            color = Color.GRAY;
        }
        this._hintLabel.setForeground(color);
        final DefaultOverlayable defaultOverlayable = new DefaultOverlayable(jTextField, this._hintLabel, 7);
        defaultOverlayable.setOpaque(false);
        jTextField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent focusEvent) {
                LabeledTextField.this.adjustOverlay(jTextField, defaultOverlayable);
            }

            public void focusGained(FocusEvent focusEvent) {
                LabeledTextField.this.adjustOverlay(jTextField, defaultOverlayable);
            }
        });
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                LabeledTextField.this.adjustOverlay(jTextField, defaultOverlayable);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                LabeledTextField.this.adjustOverlay(jTextField, defaultOverlayable);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                LabeledTextField.this.adjustOverlay(jTextField, defaultOverlayable);
            }
        });
        this.add(defaultOverlayable);
        if (abstractButton != null) {
            this.add((Component)abstractButton, "After");
        }
    }

    private void adjustOverlay(JTextField jTextField, DefaultOverlayable defaultOverlayable) {
        if (jTextField.hasFocus()) {
            defaultOverlayable.setOverlayVisible(false);
        } else {
            String string = jTextField.getText();
            if (string != null && string.length() != 0) {
                defaultOverlayable.setOverlayVisible(false);
            } else {
                defaultOverlayable.setOverlayVisible(true);
            }
        }
    }

    protected JTextField createTextField() {
        OverlayTextField overlayTextField = new OverlayTextField();
        SelectAllUtils.install(overlayTextField);
        JideSwingUtilities.setComponentTransparent(overlayTextField);
        overlayTextField.setColumns(20);
        return overlayTextField;
    }

    protected JidePopupMenu createContextMenu() {
        return new JidePopupMenu();
    }

    public void updateUI() {
        super.updateUI();
        Border border = UIDefaultsLookup.getBorder("TextField.border");
        if (border != null) {
            boolean bl;
            boolean bl2 = bl = border.getBorderInsets((Component)this).top >= 2;
            if (bl) {
                this.setBorder(border);
            } else {
                this.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            }
        } else {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        }
        if (this.isEnabled()) {
            LookAndFeel.installColors(this, "TextField.background", "TextField.foreground");
        } else {
            LookAndFeel.installColors(this, "TextField.disableBackground", "TextField.inactiveForeground");
        }
        if (border != null && this._textField != null) {
            this._textField.setBorder(BorderFactory.createEmptyBorder());
        }
        this.setEnabled(this.isEnabled());
    }

    protected AbstractButton createButton() {
        return null;
    }

    protected JLabel createLabel() {
        JLabel jLabel = new JLabel(this._icon);
        jLabel.setText(this._labelText);
        return jLabel;
    }

    public void setLabelText(String string) {
        this._labelText = string;
        if (this._label != null) {
            this._label.setText(string);
        }
    }

    public String getLabelText() {
        if (this._label != null) {
            return this._label.getText();
        }
        return this._labelText;
    }

    public void setIcon(Icon icon) {
        this._icon = icon;
        if (this._label != null) {
            this._label.setIcon(icon);
        }
    }

    public Icon getIcon() {
        if (this._label != null) {
            return this._label.getIcon();
        }
        return this._icon;
    }

    public JLabel getLabel() {
        return this._label;
    }

    public AbstractButton getButton() {
        return this._button;
    }

    public void setColumns(int n) {
        if (this.getTextField() != null) {
            this.getTextField().setColumns(n);
        }
    }

    public void setText(String string) {
        if (this.getTextField() != null) {
            this.getTextField().setText(string);
        }
    }

    public String getText() {
        if (this.getTextField() != null) {
            return this.getTextField().getText();
        }
        return null;
    }

    public JTextField getTextField() {
        return this._textField;
    }

    public void setEnabled(boolean bl) {
        JTextField jTextField;
        super.setEnabled(bl);
        if (bl) {
            if (this.getTextField() != null) {
                this.getTextField().setEnabled(true);
            }
            if (this.getLabel() != null) {
                this.getLabel().setEnabled(true);
            }
            if (this.getButton() != null) {
                this.getButton().setEnabled(true);
            }
        } else {
            if (this.getTextField() != null) {
                this.getTextField().setEnabled(false);
            }
            if (this.getLabel() != null) {
                this.getLabel().setEnabled(false);
            }
            if (this.getButton() != null) {
                this.getButton().setEnabled(false);
            }
            this.setBackground(UIDefaultsLookup.getColor("control"));
        }
        if (this._hintLabel != null) {
            boolean bl2 = true;
            if (this.getTextField() != null) {
                bl2 = this.getTextField().getText() == null || this.getTextField().getText().length() == 0;
            }
            this._hintLabel.setVisible(this.isEnabled() && bl2);
        }
        if ((jTextField = this.getTextField()) != null) {
            this.setBackground(jTextField.getBackground());
            this.setForeground(jTextField.getForeground());
        } else if (bl) {
            this.setBackground(UIDefaultsLookup.getColor("TextField.background"));
            this.setForeground(UIDefaultsLookup.getColor("TextField.foreground"));
        } else {
            Color color = UIDefaultsLookup.getColor("TextField.disabledBackground");
            if (color == null) {
                color = UIDefaultsLookup.getColor("TextField.inactiveBackground");
            }
            this.setBackground(color);
            this.setForeground(UIDefaultsLookup.getColor("TextField.inactiveForeground"));
        }
    }

    public int getBaseline(int n, int n2) {
        if (SystemInfo.isJdk6Above()) {
            try {
                Method method = Component.class.getMethod("getBaseline", Integer.TYPE, Integer.TYPE);
                Object object = method.invoke((Object)this._textField, n, n2);
                if (object instanceof Integer) {
                    return (Integer)object;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return -1;
    }

    public String getHintText() {
        return this._hintText;
    }

    public void setHintText(String string) {
        this._hintText = string;
        if (this._hintLabel != null) {
            this._hintLabel.setText(this._hintText);
        }
    }

    public PopupMenuCustomizer getPopupMenuCustomizer() {
        return this._customizer;
    }

    public void setPopupMenuCustomizer(PopupMenuCustomizer popupMenuCustomizer) {
        this._customizer = popupMenuCustomizer;
    }

    public KeyStroke getContextMenuKeyStroke() {
        if (this._contextMenuKeyStroke == null) {
            this._contextMenuKeyStroke = !SystemInfo.isMacOSX() ? KeyStroke.getKeyStroke(121, 1) : null;
        }
        return this._contextMenuKeyStroke;
    }

    public void setContextMenuKeyStroke(KeyStroke keyStroke) {
        if (this._contextMenuKeyStroke != null) {
            this.unregisterContextMenuKeyStroke(this._contextMenuKeyStroke);
        }
        this._contextMenuKeyStroke = keyStroke;
        if (this._contextMenuKeyStroke != null) {
            this.registerContextMenuKeyStroke(this._contextMenuKeyStroke);
        }
    }

    public static interface PopupMenuCustomizer {
        public void customize(LabeledTextField var1, JPopupMenu var2);
    }
}

