/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.RegistrationEvent;
import com.jidesoft.converter.RegistrationListener;
import com.jidesoft.utils.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheMap<T, K> {
    private HashMap<Class<?>, Cache<K, T>> _cache = new HashMap();
    private K _defaultContext;
    protected EventListenerList listenerList = new EventListenerList();

    public CacheMap(K k) {
        this._defaultContext = k;
    }

    protected Cache<K, T> getCache(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Clazz cannot be null");
        }
        return this._cache.get(clazz);
    }

    public K[] getKeys(Class<?> clazz, K[] KArray) {
        Cache<K, T> cache = this.getCache(clazz);
        if (cache != null) {
            Set set = cache.keySet();
            return set.toArray(KArray);
        }
        return KArray;
    }

    protected Cache<K, T> initCache(Class<?> clazz) {
        Cache<K, T> cache = this.getCache(clazz);
        if (cache != null) {
            return cache;
        }
        cache = new Cache();
        this._cache.put(clazz, cache);
        return cache;
    }

    public void register(Class<?> clazz, T t, K k) {
        if (clazz == null) {
            throw new IllegalArgumentException("Parameter clazz cannot be null");
        }
        Cache<K, T> cache = this.initCache(clazz);
        cache.setObject(k, t);
        this.fireRegistrationChanged(new RegistrationEvent(this, 3399, t, clazz, k));
    }

    public void unregister(Class<?> clazz, K k) {
        Cache<K, T> cache = this.getCache(clazz);
        if (cache != null) {
            T t = cache.getObject(k);
            cache.setObject(k, null);
            this.fireRegistrationChanged(new RegistrationEvent(this, 3400, t, clazz, k));
            if (cache.size() == 0) {
                this._cache.remove(clazz);
            }
        }
    }

    public T getRegisteredObject(Class<?> clazz, K k) {
        ArrayList<Class<Object>> arrayList;
        if (clazz == null) {
            return null;
        }
        Cache<K, T> cache = this.getCache(clazz);
        if (cache == null || !cache.containsKey(k)) {
            T t;
            Cache<K, T> cache2;
            arrayList = new ArrayList();
            arrayList.add(clazz);
            if (TypeUtils.isPrimitive(clazz)) {
                arrayList.add(TypeUtils.convertPrimitiveToWrapperType(clazz));
            } else if (TypeUtils.isPrimitiveWrapper(clazz)) {
                arrayList.add(TypeUtils.convertWrapperToPrimitiveType(clazz));
            }
            Class<?>[] classArray = clazz.getInterfaces();
            arrayList.addAll(Arrays.asList(classArray));
            Class<?> clazz2 = clazz;
            while (!clazz2.isInterface() && (clazz2 = clazz2.getSuperclass()) != null) {
                arrayList.add(clazz2);
                classArray = clazz2.getInterfaces();
                arrayList.addAll(Arrays.asList(classArray));
            }
            if (!arrayList.contains(Object.class)) {
                arrayList.add(Object.class);
            }
            for (Class clazz3 : arrayList) {
                cache2 = this.getCache(clazz3);
                if (cache2 == null || (t = cache2.getObject(k)) == null) continue;
                return t;
            }
            if (!this._defaultContext.equals(k)) {
                for (Class clazz3 : arrayList) {
                    cache2 = this.getCache(clazz3);
                    if (cache2 == null || (t = cache2.getObject(this._defaultContext)) == null) continue;
                    return t;
                }
            }
        }
        if (cache != null) {
            arrayList = cache.getObject(k);
            if (arrayList == null && !this._defaultContext.equals(k)) {
                return this.getRegisteredObject(clazz, this._defaultContext);
            }
            if (arrayList != null) {
                return (T)arrayList;
            }
        }
        return null;
    }

    public T getMatchRegisteredObject(Class<?> clazz, K k) {
        T t;
        Cache<K, T> cache;
        if (clazz == null) {
            return null;
        }
        if (k == null) {
            k = this._defaultContext;
        }
        if ((cache = this.getCache(clazz)) != null && (t = cache.getObject(k)) != null) {
            return t;
        }
        return null;
    }

    public List<T> getValues() {
        ArrayList arrayList = new ArrayList();
        Collection<Cache<K, T>> collection = this._cache.values();
        for (Cache<K, T> cache : collection) {
            Collection collection2 = cache.values();
            for (Object v : collection2) {
                if (arrayList.contains(v)) continue;
                arrayList.add(v);
            }
        }
        return arrayList;
    }

    public void remove(Class<?> clazz) {
        Cache<Object, T> cache = this.getCache(clazz);
        if (cache != null) {
            Object[] objectArray;
            for (Object object : objectArray = cache.keySet().toArray()) {
                T t = cache.getObject(object);
                cache.setObject(object, null);
                this.fireRegistrationChanged(new RegistrationEvent(this, 3400, t, clazz, object));
            }
        }
        this._cache.remove(clazz);
    }

    public void clear() {
        this._cache.clear();
        this.fireRegistrationChanged(new RegistrationEvent(this, 3401));
    }

    public void addRegistrationListener(RegistrationListener registrationListener) {
        this.listenerList.add(RegistrationListener.class, registrationListener);
    }

    public void removeRegistrationListener(RegistrationListener registrationListener) {
        this.listenerList.remove(RegistrationListener.class, registrationListener);
    }

    public RegistrationListener[] getRegistrationListeners() {
        return (RegistrationListener[])this.listenerList.getListeners(RegistrationListener.class);
    }

    public void fireRegistrationChanged(RegistrationEvent registrationEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != RegistrationListener.class) continue;
            ((RegistrationListener)objectArray[i + 1]).registrationChanged(registrationEvent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Cache<K, T>
    extends HashMap<K, T> {
        private static final long serialVersionUID = 7764545350468551102L;

        Cache() {
        }

        public T getObject(K k) {
            return (T)this.get(k);
        }

        public void setObject(K k, T t) {
            if (t == null) {
                this.remove(k);
            } else {
                this.put(k, t);
            }
        }
    }
}

