/*
 * Decompiled with CFR 0.152.
 */
package org.jboss;

import org.jboss.StringArray;

public class Tokenizer {
    private Tokenizer() {
    }

    public static String[] parse(String text, char delimiter, boolean trimEachToken, String left, String right) {
        String str;
        if (text == null) {
            return null;
        }
        int len = text.length();
        StringArray tokens = new StringArray();
        int pos1 = -1;
        int pos2 = -1;
        int firstPos = -1;
        while (true) {
            if ((pos2 = text.indexOf(delimiter, firstPos + 1)) < 0) {
                str = text.substring(pos1 + 1);
                if (trimEachToken) {
                    str = str.trim();
                }
                break;
            }
            if (pos2 == pos1 + 1) {
                tokens.add("");
            } else {
                int tagPos2;
                int tagPos1 = text.indexOf(left, firstPos + 1);
                if (tagPos1 > 0 && tagPos1 < pos2 && (tagPos2 = text.indexOf(right, tagPos1 + 1)) > 0) {
                    firstPos = tagPos2;
                    continue;
                }
                String str2 = text.substring(pos1 + 1, pos2);
                if (trimEachToken) {
                    str2 = str2.trim();
                }
                tokens.add(str2);
            }
            firstPos = pos1 = pos2;
        }
        tokens.add(str);
        String[] ret = tokens.toArray();
        return ret;
    }

    public static String[] parse(String text, char delimiter, boolean trimEachToken) {
        return Tokenizer.parse(text, delimiter, trimEachToken, false);
    }

    public static String[] parse(String text, char delimiter, boolean trimEachToken, boolean ignoreEmptyToken) {
        if (text == null) {
            return null;
        }
        int len = text.length();
        StringArray tokens = new StringArray();
        int pos1 = -1;
        int pos2 = -1;
        while (true) {
            String str;
            if ((pos2 = text.indexOf(delimiter, pos1 + 1)) < 0) {
                str = text.substring(pos1 + 1);
                if (trimEachToken) {
                    str = str.trim();
                }
                if (ignoreEmptyToken) {
                    if (str.length() == 0) break;
                    tokens.add(str);
                    break;
                }
                tokens.add(str);
                break;
            }
            if (pos2 == pos1 + 1) {
                if (!ignoreEmptyToken) {
                    tokens.add("");
                }
            } else {
                str = text.substring(pos1 + 1, pos2);
                if (trimEachToken) {
                    str = str.trim();
                }
                if (ignoreEmptyToken) {
                    if (str.length() != 0) {
                        tokens.add(str);
                    }
                } else {
                    tokens.add(str);
                }
            }
            pos1 = pos2;
        }
        String[] ret = tokens.toArray();
        return ret;
    }

    public static String[] parse(String text, char delimiter) {
        return Tokenizer.parse(text, delimiter, false);
    }

    public static void main(String[] args) {
        String str = "1,\"2,\"ab\",ttt1,\"3,,a\"222\",4";
        if (args.length > 0) {
            str = args[0];
        }
    }
}

