/*
 * Decompiled with CFR 0.152.
 */
package org.jboss;

import java.io.Serializable;

public class StringArray
implements Serializable {
    public static final int DEFAULT_CAPACITY = 10;
    protected String[] _strings = null;
    protected int _upperBound = 0;
    protected int _capacity;
    protected int _initialSize = this._capacity = 10;
    protected float _loadFactory = 1.5f;

    public StringArray() {
        this(10);
    }

    public StringArray(int size) {
        this._capacity = size;
        this._initialSize = size;
        this._strings = new String[size];
    }

    public synchronized void ensureCapacity(int capacity) {
        if (this._capacity < capacity) {
            this._capacity = this._capacity * 3 / 2 + 1;
            if (this._capacity < capacity) {
                this._capacity = capacity;
            }
            String[] oldData = this._strings;
            this._strings = new String[this._capacity];
            System.arraycopy(oldData, 0, this._strings, 0, this._upperBound);
        }
    }

    public synchronized void add(String s) {
        if (this._upperBound == this._capacity) {
            this.resize((int)((float)this._capacity * this._loadFactory));
        }
        this._strings[this._upperBound++] = s;
    }

    public synchronized void add(StringArray sa) {
        for (int i = 0; i < sa.size(); ++i) {
            this.add(sa.get(i));
        }
    }

    public synchronized String get(int index) {
        return this._strings[index];
    }

    public synchronized void set(int index, String newVal) {
        this._strings[index] = newVal;
    }

    public synchronized void add(String[] strs) {
        for (int i = 0; i < strs.length; ++i) {
            this.add(strs[i]);
        }
    }

    public synchronized void clear() {
        this._capacity = this._initialSize;
        this._strings = new String[this._capacity];
        this._upperBound = 0;
    }

    public synchronized String remove(int index) {
        if (index >= this._upperBound) {
            throw new IndexOutOfBoundsException();
        }
        String s = this._strings[index];
        for (int i = index; i < this._upperBound - 1; ++i) {
            this._strings[i] = this._strings[i + 1];
        }
        --this._upperBound;
        return s;
    }

    public synchronized String remove(String str) {
        for (int i = 0; i < this._upperBound; ++i) {
            if (!this._strings[i].equals(str)) continue;
            return this.remove(i);
        }
        return null;
    }

    public synchronized int size() {
        return this._upperBound;
    }

    public synchronized boolean isEmpty() {
        return this._upperBound == 0;
    }

    public synchronized String[] toArray() {
        String[] ret = new String[this._upperBound];
        for (int i = 0; i < this._upperBound; ++i) {
            ret[i] = this._strings[i];
        }
        return ret;
    }

    protected synchronized void resize(int newCapacity) {
        String[] as = new String[newCapacity];
        for (int i = 0; i < this._strings.length; ++i) {
            as[i] = this._strings[i];
        }
        this._strings = as;
        this._capacity = newCapacity;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this._upperBound; ++i) {
            buf.append(this._strings[i] + "\n");
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        int i;
        StringArray as = new StringArray();
        String[] ss = null;
        ss = as.toArray();
        for (i = 0; i < 10; ++i) {
            as.add("" + i);
        }
        ss = as.toArray();
        for (i = 0; i < ss.length; ++i) {
        }
        as.remove(5);
        ss = as.toArray();
        for (i = 0; i < ss.length; ++i) {
        }
    }
}

