/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.extras.api.watermarkpack.flamefractal;

import java.awt.geom.Point2D;
import org.pushingpixels.substance.extras.api.watermarkpack.flamefractal.AffineFunction;
import org.pushingpixels.substance.extras.api.watermarkpack.flamefractal.IteratedFunction;

public class Functions {

    public static class Rotation240Function
    implements IteratedFunction {
        private double c = Math.cos(Math.toRadians(240.0));
        private double s = Math.sin(Math.toRadians(240.0));

        @Override
        public void apply(Point2D coord) {
            double nx = coord.getX() * this.c + coord.getY() * this.s;
            double ny = -coord.getX() * this.s + coord.getY() * this.c;
            coord.setLocation(nx, ny);
        }
    }

    public static class Rotation120Function
    implements IteratedFunction {
        private double c = Math.cos(Math.toRadians(120.0));
        private double s = Math.sin(Math.toRadians(120.0));

        @Override
        public void apply(Point2D coord) {
            double nx = coord.getX() * this.c + coord.getY() * this.s;
            double ny = -coord.getX() * this.s + coord.getY() * this.c;
            coord.setLocation(nx, ny);
        }
    }

    public static class Rotation270Function
    implements IteratedFunction {
        @Override
        public void apply(Point2D coord) {
            double nx = -coord.getY();
            double ny = coord.getX();
            coord.setLocation(nx, ny);
        }
    }

    public static class Rotation180Function
    implements IteratedFunction {
        @Override
        public void apply(Point2D coord) {
            coord.setLocation(-coord.getX(), -coord.getY());
        }
    }

    public static class Rotation90Function
    implements IteratedFunction {
        @Override
        public void apply(Point2D coord) {
            double nx = coord.getY();
            double ny = -coord.getX();
            coord.setLocation(nx, ny);
        }
    }

    public static class Rotation0Function
    implements IteratedFunction {
        @Override
        public void apply(Point2D coord) {
        }
    }

    public static class RotationFunction
    implements IteratedFunction {
        private double theta;
        private double c;
        private double s;

        public RotationFunction(double theta) {
            this.theta = theta;
            this.c = Math.cos(this.theta);
            this.s = Math.sin(this.theta);
        }

        @Override
        public void apply(Point2D coord) {
            if (this.theta == 0.0) {
                return;
            }
            double nx = coord.getX() * this.c + coord.getY() * this.s;
            double ny = -coord.getX() * this.s + coord.getY() * this.c;
            coord.setLocation(nx, ny);
        }
    }

    public static class SpiralFunction
    extends AffineFunction {
        public SpiralFunction(double a, double b, double c, double d, double e, double f) {
            super(coord -> {
                double r2 = coord.getX() * coord.getX() + coord.getY() * coord.getY();
                double r = Math.min(1.0, Math.sqrt(r2));
                double theta = Math.atan2(coord.getY(), coord.getX());
                coord.setLocation((Math.cos(theta) + Math.sin(r)) / r, (Math.sin(theta) - Math.cos(r)) / r);
            }, a, b, c, d, e, f);
        }
    }

    public static class SwirlFunction
    extends AffineFunction {
        public SwirlFunction(double a, double b, double c, double d, double e, double f) {
            super(coord -> {
                double r2 = coord.getX() * coord.getX() + coord.getY() * coord.getY();
                double r = Math.min(1.0, Math.sqrt(r2));
                double theta = Math.atan2(coord.getY(), coord.getX());
                coord.setLocation(r * Math.cos(theta + r), r * Math.sin(theta + r));
            }, a, b, c, d, e, f);
        }
    }

    public static class ExFunction
    extends AffineFunction {
        public ExFunction(double a, double b, double c, double d, double e, double f) {
            super(coord -> {
                double r2 = coord.getX() * coord.getX() + coord.getY() * coord.getY();
                double r = Math.min(1.0, Math.sqrt(r2));
                double theta = Math.atan2(coord.getY(), coord.getX());
                double s = Math.sin(theta + r);
                double c1 = Math.cos(theta - r);
                coord.setLocation(r * s * s * s, r * c1 * c1 * c1);
            }, a, b, c, d, e, f);
        }
    }

    public static class HorseShoeFunction
    extends AffineFunction {
        public HorseShoeFunction(double a, double b, double c, double d, double e, double f) {
            super(coord -> {
                double r2 = Math.min(1.0, coord.getX() * coord.getX() + coord.getY() * coord.getY());
                double r = Math.sqrt(r2);
                double nx = (coord.getX() * coord.getX() - coord.getY() * coord.getY()) / r;
                double ny = 2.0 * coord.getX() * coord.getY() / r;
                coord.setLocation(nx, ny);
            }, a, b, c, d, e, f);
        }
    }

    public static class SphericalFunction
    extends AffineFunction {
        public SphericalFunction(double a, double b, double c, double d, double e, double f) {
            super(coord -> {
                double r2 = coord.getX() * coord.getX() + coord.getY() * coord.getY();
                coord.setLocation(coord.getX() / r2, coord.getY() / r2);
            }, a, b, c, d, e, f);
        }
    }

    public static class LinearFunction
    extends AffineFunction {
        public LinearFunction(double a, double b, double c, double d, double e, double f) {
            super(new IteratedFunction(){

                @Override
                public void apply(Point2D coord) {
                }
            }, a, b, c, d, e, f);
        }
    }
}

