/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.extras.api.painterpack.noise;

import java.util.LinkedList;
import org.pushingpixels.substance.extras.api.painterpack.noise.BaseNoiseFilter;
import org.pushingpixels.substance.extras.api.painterpack.noise.NoiseFilter;

public class FabricFilter
implements NoiseFilter {
    protected LinkedList<FabricFilterLink> links = new LinkedList();

    public FabricFilter(FabricFilterLink ... links) {
        for (FabricFilterLink link : links) {
            this.links.add(link);
        }
    }

    @Override
    public double apply(double x, double y, double z, double origValue) {
        double val = 1.0;
        for (FabricFilterLink link : this.links) {
            val *= link.apply(x, y, z, origValue);
        }
        return 0.5 + 0.5 * val;
    }

    public static class FabricFilterLink
    extends BaseNoiseFilter {
        public FabricFilterLink(double xFactor, double yFactor, double zFactor, double valueFactor, NoiseFilter.TrigKind trigKind) {
            super(xFactor, yFactor, zFactor, valueFactor, trigKind);
        }

        public static FabricFilterLink getXLink(double xFactor, double valueFactor, NoiseFilter.TrigKind trigKind) {
            return new FabricFilterLink(xFactor, 0.0, 0.0, valueFactor, trigKind);
        }

        public static FabricFilterLink getYLink(double yFactor, double valueFactor, NoiseFilter.TrigKind trigKind) {
            return new FabricFilterLink(0.0, yFactor, 0.0, valueFactor, trigKind);
        }

        public static FabricFilterLink getZLink(double zFactor, double valueFactor, NoiseFilter.TrigKind trigKind) {
            return new FabricFilterLink(0.0, 0.0, zFactor, valueFactor, trigKind);
        }

        @Override
        public double apply(double x, double y, double z, double origValue) {
            double trans = this.xFactor * x + this.yFactor * y + this.zFactor * z + this.valueFactor * origValue;
            double trig = this.trigKind == NoiseFilter.TrigKind.COSINE ? Math.cos(trans) : Math.sin(trans);
            return trig;
        }
    }
}

