/*
 * Decompiled with CFR 0.152.
 */
package org.bounce;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarClassLoader
extends SecureClassLoader {
    private boolean DEBUG = false;
    private static final String JAR_SCHEME = "jar";
    private static final String JAR_SEPARATOR = "!/";
    private static final String CLASS_EXTENSION = ".class";
    private static final char WINDOWS_SLASH = '\\';
    private static final char UNIX_SLASH = '/';
    private static final char DOT = '.';
    private Hashtable contents;
    private URL url;

    public JarClassLoader(URL url) throws IOException {
        this(ClassLoader.getSystemClassLoader(), url);
    }

    public JarClassLoader(ClassLoader parent, URL url) throws IOException {
        super(parent);
        if (this.DEBUG) {
            System.out.println("[" + this + "] JarClassLoader( " + parent + ", " + url + ")");
        }
        Hashtable<String, Integer> sizes = new Hashtable<String, Integer>();
        this.url = url;
        ZipFile zf = new ZipFile(url.getFile());
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            int size = (int)entry.getSize();
            String name = entry.getName();
            sizes.put(this.getEntryKey(name), new Integer(size));
        }
        zf.close();
        this.contents = new Hashtable();
        FileInputStream fis = new FileInputStream(url.getFile());
        BufferedInputStream bis = new BufferedInputStream(fis);
        JarInputStream jar = new JarInputStream(bis);
        JarEntry entry = jar.getNextJarEntry();
        while (entry != null) {
            String name = this.getEntryKey(entry.getName());
            int size = (int)entry.getSize();
            if (size < 0) {
                size = (Integer)sizes.get(name);
            }
            byte[] buffer = new byte[size];
            int totalRead = 0;
            while (totalRead != size) {
                int read = jar.read(buffer, totalRead, size - totalRead);
                if (read < 0) break;
                totalRead += read;
            }
            if (totalRead != size) {
                throw new IOException("Cannot read entry: " + name);
            }
            this.contents.put(name, buffer);
            entry = jar.getNextJarEntry();
        }
        jar.close();
    }

    public synchronized Class findClass(String name) throws ClassNotFoundException {
        Class<?> result;
        if (this.DEBUG) {
            System.out.println("[" + this + "] JarClassLoader.findClass( " + name + ")");
        }
        if ((result = super.findLoadedClass(name)) == null) {
            String key = name.replace('.', '/') + CLASS_EXTENSION;
            byte[] bytes = (byte[])this.contents.get(key);
            if (bytes == null) {
                throw new ClassNotFoundException();
            }
            if (this.DEBUG) {
                System.out.println("[" + this + "] defineClass( " + name + ", " + bytes + ", 0, " + bytes.length + ")");
            }
            result = this.defineClass(name, bytes, 0, bytes.length, (ProtectionDomain)null);
        }
        return result;
    }

    public URL findResource(String name) {
        if (this.DEBUG) {
            System.out.println("[" + this + "] JarClassLoader.findResource( " + name + ")");
        }
        URL resource = null;
        if (this.contents.containsKey(name)) {
            try {
                StringBuffer buffer = new StringBuffer(this.url.toExternalForm());
                buffer.append(JAR_SEPARATOR);
                buffer.append(name);
                resource = new URL(JAR_SCHEME, null, buffer.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.DEBUG) {
            System.out.println("[" + this + "] JarClassLoader.findResource( " + name + ") [" + resource + "]");
        }
        return resource;
    }

    private String getEntryKey(String name) {
        return name.replace('\\', '/');
    }

    static {
        JAR_SCHEME = JAR_SCHEME;
        JAR_SEPARATOR = JAR_SEPARATOR;
        CLASS_EXTENSION = CLASS_EXTENSION;
        WINDOWS_SLASH = (char)92;
        UNIX_SLASH = (char)47;
        DOT = (char)46;
    }
}

