/*
 * Decompiled with CFR 0.152.
 */
package org.bounce;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.Hashtable;
import org.bounce.FormConstraints;

public class FormLayout
implements LayoutManager2 {
    private static final int MINIMUM = 0;
    private static final int PREFERRED = 1;
    private static final int MAXIMUM = 2;
    public static final FormConstraints LEFT;
    public static final FormConstraints RIGHT;
    public static final FormConstraints RIGHT_FILL;
    public static final FormConstraints FULL;
    public static final FormConstraints FULL_FILL;
    private int horizontalGap;
    private int verticalGap;
    private Hashtable constraints;

    public FormLayout() {
        this(0, 0);
    }

    public FormLayout(int hGap, int vGap) {
        this.horizontalGap = hGap;
        this.verticalGap = vGap;
        this.constraints = new Hashtable();
    }

    public int getHgap() {
        return this.horizontalGap;
    }

    public void setHgap(int hGap) {
        this.horizontalGap = hGap;
    }

    public int getVgap() {
        return this.verticalGap;
    }

    public void setVgap(int vGap) {
        this.verticalGap = vGap;
    }

    public void setConstraints(Component component, Object constraint) {
        if (constraint == null || !(constraint instanceof FormConstraints)) {
            throw new IllegalArgumentException("cannot add to layout: constraint must be of type FormConstraints");
        }
        this.constraints.put(component, new FormConstraints((FormConstraints)constraint));
    }

    public void removeLayoutComponent(Component component) {
        this.constraints.remove(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension dimension = this.getSize(1, parent);
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension dimension = this.getSize(0, parent);
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int totalComponents = parent.getComponentCount();
            Dimension size = parent.getSize();
            int leftWidth = this.getWidth(0, 1, parent);
            int totalWidth = size.width - (insets.left + insets.right);
            int totalHeight = size.height - (insets.top + insets.bottom);
            int top = insets.top;
            int componentCounter = 0;
            while (componentCounter < totalComponents) {
                Component component = parent.getComponent(componentCounter);
                if (component.isVisible()) {
                    FormConstraints constraint = (FormConstraints)this.constraints.get(component);
                    int height = component.getPreferredSize().height;
                    if (constraint.getPosition() == 0) {
                        Component rightComponent = parent.getComponent(++componentCounter);
                        FormConstraints rightConstraint = (FormConstraints)this.constraints.get(rightComponent);
                        if (component.isVisible()) {
                            height = rightComponent.getPreferredSize().height > component.getPreferredSize().height ? rightComponent.getPreferredSize().height : component.getPreferredSize().height;
                            if (rightConstraint.getPosition() == 2) {
                                this.align(rightConstraint, new Rectangle(insets.left + leftWidth + this.horizontalGap, top, totalWidth - leftWidth - this.horizontalGap, height), rightComponent);
                            } else {
                                --componentCounter;
                            }
                        } else {
                            --componentCounter;
                        }
                        this.align(constraint, new Rectangle(insets.left, top, leftWidth, height), component);
                    } else if (constraint.getPosition() == 2) {
                        this.align(constraint, new Rectangle(insets.left + leftWidth + this.horizontalGap, top, totalWidth - leftWidth - this.horizontalGap, height), component);
                    } else if (constraint.getPosition() == 5) {
                        this.align(constraint, new Rectangle(insets.left, top, totalWidth, height), component);
                    }
                    top += this.verticalGap + height;
                }
                ++componentCounter;
            }
        }
    }

    public void addLayoutComponent(Component component, Object constraints) {
        this.setConstraints(component, constraints);
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    private int getHeight(int type, Container parent) {
        boolean rowComplete = true;
        int height = 0;
        int leftHeight = 0;
        int rowHeight = 0;
        int rowCounter = 0;
        int i = 0;
        while (i < parent.getComponentCount()) {
            Component component = parent.getComponent(i);
            if (component.isVisible()) {
                rowHeight = this.getSize((int)type, (Component)component).height;
                FormConstraints constraint = (FormConstraints)this.constraints.get(component);
                if (constraint.getPosition() == 0) {
                    if (!rowComplete) {
                        height += leftHeight;
                        ++rowCounter;
                    }
                    leftHeight = rowHeight;
                    rowComplete = false;
                } else if (constraint.getPosition() == 2) {
                    if (!rowComplete) {
                        if (rowHeight < leftHeight) {
                            rowHeight = leftHeight;
                        }
                        rowComplete = true;
                    }
                } else if (constraint.getPosition() == 5 && !rowComplete) {
                    rowHeight += leftHeight;
                    rowComplete = true;
                }
                if (rowComplete) {
                    height += rowHeight;
                    ++rowCounter;
                }
            }
            ++i;
        }
        if (!rowComplete) {
            height += rowHeight;
            ++rowCounter;
        }
        return height + this.verticalGap * (rowCounter - 1);
    }

    private Dimension getSize(int type, Component component) {
        Dimension size = null;
        switch (type) {
            case 0: {
                size = component.getMinimumSize();
                break;
            }
            case 1: {
                size = component.getPreferredSize();
                break;
            }
            case 2: {
                size = component.getMaximumSize();
            }
        }
        return size;
    }

    private Dimension getSize(int type, Container parent) {
        Dimension size = new Dimension(0, 0);
        int height = this.getHeight(type, parent);
        Insets insets = parent.getInsets();
        int leftWidth = this.getWidth(0, type, parent);
        int rightWidth = this.getWidth(2, type, parent);
        int fullWidth = this.getWidth(5, type, parent);
        size.width = fullWidth < leftWidth + rightWidth + this.horizontalGap ? leftWidth + rightWidth + this.horizontalGap + insets.left + insets.right : fullWidth + insets.left + insets.right;
        size.height = height + insets.top + insets.bottom;
        return size;
    }

    private int getWidth(int position, int sizeType, Container parent) {
        int width = 0;
        int i = 0;
        while (i < parent.getComponentCount()) {
            FormConstraints constraint;
            Component component = parent.getComponent(i);
            if (component.isVisible() && (constraint = (FormConstraints)this.constraints.get(component)).getPosition() == position && !constraint.isFilled()) {
                Dimension size = this.getSize(sizeType, component);
                if (size.width > width) {
                    width = size.width;
                }
            }
            ++i;
        }
        return width;
    }

    private void align(FormConstraints constraint, Rectangle bounds, Component component) {
        if (!constraint.isFilled()) {
            int x;
            if (constraint.getHorizontalAlignment() == 4) {
                x = bounds.x + (bounds.width - component.getPreferredSize().width) / 2;
                if (x > bounds.x) {
                    bounds.x = x;
                }
            } else if (constraint.getHorizontalAlignment() == 2 && (x = bounds.width + bounds.x - component.getPreferredSize().width) > bounds.x) {
                bounds.x = x;
            }
            if (component.getPreferredSize().height != bounds.height) {
                int y;
                if (constraint.getVerticalAlignment() == 4) {
                    y = bounds.y + (bounds.height - component.getPreferredSize().height) / 2;
                    if (y > bounds.y) {
                        bounds.y = y;
                    }
                } else if (constraint.getVerticalAlignment() == 1 && (y = bounds.height + bounds.y - component.getPreferredSize().height) > bounds.y) {
                    bounds.y = y;
                }
                bounds.height = component.getPreferredSize().height;
            }
            bounds.width = component.getPreferredSize().width;
        }
        component.setBounds(bounds);
    }

    static {
        MINIMUM = 0;
        PREFERRED = 1;
        MAXIMUM = 2;
        LEFT = new FormConstraints(0);
        RIGHT = new FormConstraints(2);
        RIGHT_FILL = new FormConstraints(2, true);
        FULL = new FormConstraints(5);
        FULL_FILL = new FormConstraints(5, true);
    }
}

